/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class S3BrowserBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(S3BrowserBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "com.s3browser";
    }

    public String getName() {
        return "S3Browser";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.s3browser.location"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(Local file) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream()));
            try {
                String line;
                Host current = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("[account_")) {
                        current = new Host(Protocol.S3_SSL, Protocol.S3_SSL.getDefaultHostname(), Protocol.S3_SSL.getDefaultPort());
                        continue;
                    }
                    if (StringUtils.isBlank((String)line)) {
                        this.add(current);
                        current = null;
                        continue;
                    }
                    if (null == current) {
                        log.warn((Object)"Failed to detect start of bookmark");
                        continue;
                    }
                    Scanner scanner = new Scanner(line);
                    scanner.useDelimiter(" = ");
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing key in line:" + line));
                        continue;
                    }
                    String name = scanner.next().toLowerCase();
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing value in line:" + line));
                        continue;
                    }
                    String value = scanner.next();
                    if ("name".equals(name)) {
                        current.setNickname(value);
                        continue;
                    }
                    if ("comment".equals(name)) {
                        current.setComment(value);
                        continue;
                    }
                    if ("access_key".equals(name)) {
                        current.getCredentials().setUsername(value);
                        continue;
                    }
                    if (!"secret_key".equals(name)) continue;
                    current.getCredentials().setPassword(value);
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                IOUtils.closeQuietly((Reader)in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
            {
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }
}

