/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.KeychainFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class ThirdpartyBookmarkCollection
extends AbstractHostCollection {
    private static Logger log = Logger.getLogger(ThirdpartyBookmarkCollection.class);

    protected void load(Local file) {
        if (file.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Found Bookmarks file: " + file.getAbsolute()));
            }
            this.parse(file);
        }
    }

    public void load() {
        this.load(this.getFile());
    }

    public abstract Local getFile();

    protected abstract void parse(Local var1);

    public String getName() {
        return EditorFactory.getApplicationName((String)this.getBundleIdentifier());
    }

    public boolean isInstalled() {
        return StringUtils.isNotBlank((String)this.getName());
    }

    public abstract String getBundleIdentifier();

    public String getConfiguration() {
        return "bookmark.import." + this.getBundleIdentifier();
    }

    public boolean add(Host bookmark) {
        if (null == bookmark) {
            log.warn((Object)"Parsing bookmark failed.");
            return false;
        }
        StringBuilder comment = new StringBuilder();
        if (StringUtils.isNotBlank((String)bookmark.getComment())) {
            comment.append(bookmark.getComment());
            if (!comment.toString().endsWith(".")) {
                comment.append(".");
            }
            comment.append(" ");
        }
        comment.append(MessageFormat.format(Locale.localizedString("Imported from {0}", "Configuration"), this.getName()));
        bookmark.setComment(comment.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create new bookmark from import: " + bookmark));
        }
        KeychainFactory.instance().save(bookmark);
        bookmark.getCredentials().setPassword(null);
        return super.add(bookmark);
    }
}

