/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSData;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSKeyedUnarchiver;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public class TransmitBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(TransmitBookmarkCollection.class);

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.transmit.location"));
    }

    public String getBundleIdentifier() {
        return "com.panic.Transmit";
    }

    protected void parse(Local file) {
        NSObject next;
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        TransmitFavoriteCollection c = (TransmitFavoriteCollection)Rococoa.createClass((String)"CDTransmitImportFavoriteCollection", TransmitFavoriteCollection.class);
        NSKeyedUnarchiver.setClass_forClassName((ObjCClass)c, (String)"FavoriteCollection");
        NSKeyedUnarchiver.setClass_forClassName((ObjCClass)c, (String)"HistoryCollection");
        TransmitFavorite f = (TransmitFavorite)Rococoa.createClass((String)"CDTransmitImportFavorite", TransmitFavorite.class);
        NSKeyedUnarchiver.setClass_forClassName((ObjCClass)f, (String)"Favorite");
        NSKeyedUnarchiver.setClass_forClassName((ObjCClass)f, (String)"DotMacFavorite");
        NSData collectionsData = (NSData)Rococoa.cast((ObjCObject)serialized.objectForKey("FavoriteCollections"), NSData.class);
        TransmitFavoriteCollection rootCollection = (TransmitFavoriteCollection)Rococoa.cast((ObjCObject)NSKeyedUnarchiver.unarchiveObjectWithData((NSData)collectionsData), TransmitFavoriteCollection.class);
        NSArray collections = rootCollection.favorites();
        NSEnumerator collectionsEnumerator = collections.objectEnumerator();
        while ((next = collectionsEnumerator.nextObject()) != null) {
            NSObject favorite;
            TransmitFavoriteCollection collection = (TransmitFavoriteCollection)Rococoa.cast((ObjCObject)next, TransmitFavoriteCollection.class);
            if ("History".equals(collection.name())) continue;
            NSArray favorites = collection.favorites();
            NSEnumerator favoritesEnumerator = favorites.objectEnumerator();
            while ((favorite = favoritesEnumerator.nextObject()) != null) {
                this.parse((TransmitFavorite)Rococoa.cast((ObjCObject)favorite, TransmitFavorite.class));
            }
        }
    }

    private void parse(TransmitFavorite favorite) {
        String user;
        Protocol protocol;
        String protocolstring;
        String server = favorite.server();
        if (StringUtils.isBlank((String)server)) {
            log.warn((Object)("No server name:" + server));
            return;
        }
        int port = favorite.port();
        if (0 == port) {
            port = -1;
        }
        if (StringUtils.isBlank((String)(protocolstring = favorite.protocol()))) {
            log.warn((Object)("Unknown protocol:" + protocolstring));
            return;
        }
        if ("FTP".equals(protocolstring)) {
            protocol = Protocol.FTP;
        } else if ("SFTP".equals(protocolstring)) {
            protocol = Protocol.SFTP;
        } else if ("FTPTLS".equals(protocolstring)) {
            protocol = Protocol.FTP_TLS;
        } else if ("FTPSSL".equals(protocolstring)) {
            protocol = Protocol.FTP_TLS;
        } else if ("S3".equals(protocolstring)) {
            protocol = Protocol.S3_SSL;
        } else if ("WebDAV".equals(protocolstring)) {
            protocol = Protocol.WEBDAV;
        } else if ("WebDAVS".equals(protocolstring)) {
            protocol = Protocol.WEBDAV_SSL;
        } else {
            log.warn((Object)("Unknown protocol:" + protocolstring));
            return;
        }
        Host bookmark = new Host(protocol, server, port);
        String nickname = favorite.nickname();
        if (StringUtils.isNotBlank((String)nickname)) {
            bookmark.setNickname(nickname);
        }
        if (StringUtils.isNotBlank((String)(user = favorite.username()))) {
            bookmark.setCredentials(user, null);
        } else {
            bookmark.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
        }
        String path = favorite.path();
        if (StringUtils.isNotBlank((String)path)) {
            bookmark.setDefaultPath(path);
        }
        this.add(bookmark);
    }

    public static interface TransmitFavorite
    extends ObjCClass {
        public String server();

        public String nickname();

        public String username();

        public String protocol();

        public String path();

        public int port();
    }

    public static interface TransmitFavoriteCollection
    extends ObjCClass {
        public String name();

        public NSArray favorites();
    }
}

