/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XmlBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(XmlBookmarkCollection.class);

    protected abstract AbstractHandler getHandler();

    protected void read(Local child) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(child.getInputStream(), Charset.forName("UTF-8")));
            AbstractHandler handler = this.getHandler();
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            xr.parse(new InputSource(in));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error reading " + this.getFile() + ":" + e.getMessage()));
        }
        catch (SAXException e) {
            log.error((Object)("Error reading " + this.getFile() + ":" + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("Error reading " + this.getFile() + ":" + e.getMessage()));
        }
    }

    protected static abstract class AbstractHandler
    extends DefaultHandler {
        private StringBuilder currentText = null;

        protected AbstractHandler() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            this.currentText = new StringBuilder();
            this.startElement(name);
        }

        public abstract void startElement(String var1);

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currentText.toString();
            this.endElement(name, elementText);
        }

        public abstract void endElement(String var1, String var2);

        public void characters(char[] ch, int start, int length) {
            this.currentText.append(ch, start, length);
        }
    }
}

