/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.sftp.HostKeyController;
import ch.ethz.ssh2.KnownHosts;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class MemoryHostKeyVerifier
extends HostKeyController {
    protected static Logger log = Logger.getLogger(MemoryHostKeyVerifier.class);
    protected KnownHosts database;

    protected KnownHosts getDatabase() {
        if (null == this.database) {
            this.database = new KnownHosts();
        }
        return this.database;
    }

    protected boolean isHostKeyDatabaseWritable() {
        return false;
    }

    public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
        int result = this.getDatabase().verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
        if (0 == result) {
            return true;
        }
        if (1 == result) {
            return this.isUnknownKeyAccepted(hostname, port, serverHostKeyAlgorithm, serverHostKey);
        }
        if (2 == result) {
            return this.isChangedKeyAccepted(hostname, port, serverHostKeyAlgorithm, serverHostKey);
        }
        return false;
    }

    protected void allow(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey, boolean always) {
        String hashedHostname = KnownHosts.createHashedHostname(hostname);
        try {
            this.getDatabase().addHostkey(new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        if (always && this.isHostKeyDatabaseWritable()) {
            this.save(hostname, serverHostKeyAlgorithm, serverHostKey);
        }
    }

    protected void save(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey) {
        throw new UnsupportedOperationException();
    }
}

