/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyControllerFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Resolver;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.i18n.Locale;
import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.ConnectionMonitor;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.StreamGobbler;
import ch.ethz.ssh2.channel.ChannelClosedException;
import ch.ethz.ssh2.crypto.PEMDecoder;
import ch.ethz.ssh2.crypto.PEMDecryptException;
import ch.ethz.ssh2.sftp.SFTPv3Client;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kohsuke.putty.PuTTYKey;
import org.spearce.jgit.transport.OpenSshConfig;

public class SFTPSession
extends Session {
    private static Logger log = Logger.getLogger(SFTPSession.class);
    private Connection SSH;
    private SFTPv3Client SFTP;

    public static SessionFactory factory() {
        return new Factory();
    }

    public SFTPSession(Host h) {
        super(h);
    }

    protected Connection getClient() throws ConnectionCanceledException {
        if (null == this.SSH) {
            throw new ConnectionCanceledException();
        }
        return this.SSH;
    }

    public boolean isSecure() {
        if (super.isSecure()) {
            try {
                return this.getClient().isAuthenticationComplete();
            }
            catch (ConnectionCanceledException e) {
                return false;
            }
        }
        return false;
    }

    protected SFTPv3Client sftp() throws IOException {
        if (null == this.SFTP) {
            if (!this.isConnected()) {
                throw new ConnectionCanceledException();
            }
            if (!this.getClient().isAuthenticationComplete()) {
                throw new LoginCanceledException();
            }
            this.message(Locale.localizedString("Starting SFTP subsystem", "Status"));
            this.SFTP = new SFTPv3Client(this.getClient());
            this.message(Locale.localizedString("SFTP subsystem ready", "Status"));
            this.SFTP.setCharset(this.getEncoding());
        }
        return this.SFTP;
    }

    protected SCPClient openScp() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (!this.getClient().isAuthenticationComplete()) {
            throw new LoginCanceledException();
        }
        SCPClient client = new SCPClient(this.getClient());
        client.setCharset(this.getEncoding());
        return client;
    }

    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.SSH = new Connection(this.getHostname(), this.host.getPort(), this.getUserAgent());
        this.SSH.addConnectionMonitor(new ConnectionMonitor(){

            public void connectionLost(Throwable reason) {
                log.warn((Object)("Connection lost:" + (null == reason ? "Unknown" : reason.getMessage())));
                SFTPSession.this.interrupt();
            }
        });
        int timeout = this.timeout();
        this.getClient().connect(HostKeyControllerFactory.instance(this), timeout, timeout);
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.login();
        if (!this.getClient().isAuthenticationComplete()) {
            throw new LoginCanceledException();
        }
        this.fireConnectionDidOpenEvent();
    }

    private String getHostname() {
        String alias = OpenSshConfig.create().lookup(this.host.getHostname()).getHostName();
        if (this.host.getHostname().equals(alias)) {
            return this.host.getHostname(true);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Using hostname alias from ~/.ssh/config:" + alias));
        }
        return alias;
    }

    protected Resolver getResolver() {
        return new Resolver(this.getHostname());
    }

    protected void login(LoginController controller, final Credentials credentials) throws IOException {
        if (this.getClient().isAuthenticationComplete()) {
            this.message(Locale.localizedString("Login successful", "Credentials"));
            return;
        }
        if (credentials.isPublicKeyAuthentication()) {
            if (this.loginUsingPublicKeyAuthentication(controller, credentials)) {
                this.message(Locale.localizedString("Login successful", "Credentials"));
                return;
            }
        } else {
            if (this.loginUsingKBIAuthentication(controller, credentials)) {
                this.message(Locale.localizedString("Login successful", "Credentials"));
                return;
            }
            if (this.loginUsingPasswordAuthentication(controller, credentials)) {
                this.message(Locale.localizedString("Login successful", "Credentials"));
                return;
            }
        }
        if (this.getClient().isAuthenticationPartialSuccess()) {
            Credentials additional = new Credentials(credentials.getUsername(), null, false){

                public String getUsernamePlaceholder() {
                    return credentials.getUsernamePlaceholder();
                }

                public String getPasswordPlaceholder() {
                    return Locale.localizedString("One-time passcode", "Credentials");
                }
            };
            controller.prompt(this.host.getProtocol(), additional, Locale.localizedString("Partial authentication success", "Credentials"), Locale.localizedString("Provide additional login credentials", "Credentials") + ".", false, false, false);
            if (this.loginUsingKBIAuthentication(controller, additional)) {
                this.message(Locale.localizedString("Login successful", "Credentials"));
                return;
            }
        }
        this.message(Locale.localizedString("Login failed", "Credentials"));
        controller.fail(this.host.getProtocol(), credentials);
        this.login();
    }

    private boolean loginUsingPublicKeyAuthentication(LoginController controller, Credentials credentials) throws IOException {
        log.debug((Object)("loginUsingPublicKeyAuthentication:" + credentials));
        if (this.getClient().isAuthMethodAvailable(credentials.getUsername(), "publickey") && credentials.isPublicKeyAuthentication()) {
            Local identity = credentials.getIdentity();
            CharArrayWriter privatekey = new CharArrayWriter();
            if (PuTTYKey.isPuTTYKeyFile(identity.getInputStream())) {
                PuTTYKey putty = new PuTTYKey(identity.getInputStream());
                if (putty.isEncrypted() && StringUtils.isEmpty((String)credentials.getPassword())) {
                    controller.prompt(this.host.getProtocol(), credentials, Locale.localizedString("Private key password protected", "Credentials"), Locale.localizedString("Enter the passphrase for the private key file", "Credentials") + " (" + identity + ")");
                }
                try {
                    IOUtils.copy((Reader)new StringReader(putty.toOpenSSH(credentials.getPassword())), (Writer)privatekey);
                }
                catch (PEMDecryptException e) {
                    this.message(Locale.localizedString("Invalid passphrase", "Credentials"));
                    controller.prompt(this.host.getProtocol(), credentials, Locale.localizedString("Invalid passphrase", "Credentials"), Locale.localizedString("Enter the passphrase for the private key file", "Credentials") + " (" + identity + ")");
                    return this.loginUsingPublicKeyAuthentication(controller, credentials);
                }
            }
            IOUtils.copy((Reader)new FileReader(identity.getAbsolute()), (Writer)privatekey);
            if (PEMDecoder.isPEMEncrypted(privatekey.toCharArray()) && StringUtils.isEmpty((String)credentials.getPassword())) {
                controller.prompt(this.host.getProtocol(), credentials, Locale.localizedString("Private key password protected", "Credentials"), Locale.localizedString("Enter the passphrase for the private key file", "Credentials") + " (" + identity + ")");
            }
            try {
                PEMDecoder.decode(privatekey.toCharArray(), credentials.getPassword());
            }
            catch (PEMDecryptException e) {
                this.message(Locale.localizedString("Invalid passphrase", "Credentials"));
                controller.prompt(this.host.getProtocol(), credentials, Locale.localizedString("Invalid passphrase", "Credentials"), Locale.localizedString("Enter the passphrase for the private key file", "Credentials") + " (" + identity + ")");
                return this.loginUsingPublicKeyAuthentication(controller, credentials);
            }
            return this.getClient().authenticateWithPublicKey(credentials.getUsername(), privatekey.toCharArray(), credentials.getPassword());
        }
        return false;
    }

    private boolean loginUsingPasswordAuthentication(LoginController controller, Credentials credentials) throws IOException {
        log.debug((Object)("loginUsingPasswordAuthentication:" + credentials));
        if (this.getClient().isAuthMethodAvailable(credentials.getUsername(), "password")) {
            return this.getClient().authenticateWithPassword(credentials.getUsername(), credentials.getPassword());
        }
        return false;
    }

    private boolean loginUsingKBIAuthentication(final LoginController controller, Credentials credentials) throws IOException {
        log.debug((Object)("loginUsingKBIAuthenticationmake:" + credentials));
        if (this.getClient().isAuthMethodAvailable(credentials.getUsername(), "keyboard-interactive")) {
            return this.getClient().authenticateWithKeyboardInteractive(credentials.getUsername(), new InteractiveCallback(){
                private int promptCount = 0;

                public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws IOException {
                    log.debug((Object)("replyToChallenge:" + name));
                    if (0 == this.promptCount) {
                        log.debug((Object)"First callback returning provided credentials");
                        ++this.promptCount;
                        return new String[]{SFTPSession.this.host.getCredentials().getPassword()};
                    }
                    String[] response = new String[numPrompts];
                    for (int i = 0; i < numPrompts; ++i) {
                        Credentials credentials = new Credentials(SFTPSession.this.host.getCredentials().getUsername(), null, false){

                            public String getUsernamePlaceholder() {
                                return SFTPSession.this.host.getProtocol().getUsernamePlaceholder();
                            }

                            public String getPasswordPlaceholder() {
                                return Locale.localizedString("One-time passcode", "Credentials");
                            }
                        };
                        controller.prompt(SFTPSession.this.host.getProtocol(), credentials, Locale.localizedString("Provide additional login credentials", "Credentials"), prompt[i], false, false, false);
                        response[i] = credentials.getPassword();
                        ++this.promptCount;
                    }
                    return response;
                }
            });
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            try {
                this.fireConnectionWillCloseEvent();
                if (this.SFTP != null) {
                    this.SFTP.close();
                }
                this.getClient().close();
            }
            catch (ConnectionCanceledException e) {
                log.warn((Object)e.getMessage());
                Object var3_2 = null;
                this.SFTP = null;
                this.SSH = null;
                this.fireConnectionDidCloseEvent();
                return;
            }
            Object var3_1 = null;
            this.SFTP = null;
            this.SSH = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.SFTP = null;
            this.SSH = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void interrupt() {
        log.debug((Object)"interrupt");
        try {
            try {
                this.fireConnectionWillCloseEvent();
                this.getClient().close(null, true);
            }
            catch (ConnectionCanceledException e) {
                log.warn((Object)e.getMessage());
                Object var3_2 = null;
                this.SFTP = null;
                this.SSH = null;
                this.fireConnectionDidCloseEvent();
                return;
            }
            Object var3_1 = null;
            this.SFTP = null;
            this.SSH = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.SFTP = null;
            this.SSH = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    public void check() throws IOException {
        this.check(true);
    }

    private void check(boolean sftp) throws IOException {
        try {
            super.check();
        }
        catch (ChannelClosedException e) {
            log.warn((Object)e.getMessage());
            this.interrupt();
            this.connect();
        }
        if (sftp) {
            if (!this.sftp().isConnected()) {
                this.interrupt();
                this.connect();
            } else {
                try {
                    this.sftp().canonicalPath(".");
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage());
                    this.interrupt();
                    this.connect();
                }
            }
        }
    }

    public Path workdir() throws ConnectionCanceledException {
        if (null == this.workdir) {
            if (!this.isConnected()) {
                throw new ConnectionCanceledException();
            }
            try {
                this.workdir = PathFactory.createPath((Session)this, this.sftp().canonicalPath("."), 2);
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
                throw new ConnectionCanceledException(e.getMessage());
            }
        }
        return this.workdir;
    }

    protected void noop() throws IOException {
        if (this.isConnected()) {
            try {
                this.getClient().sendIgnorePacket();
            }
            catch (IllegalStateException e) {
                throw new ConnectionCanceledException();
            }
        }
    }

    public boolean isSendCommandSupported() {
        return true;
    }

    public boolean isArchiveSupported() {
        return true;
    }

    public boolean isUnarchiveSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(String command) throws IOException {
        ch.ethz.ssh2.Session sess = this.getClient().openSession();
        try {
            String line;
            String line2;
            this.message(command);
            sess.execCommand(command, this.host.getEncoding());
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(new StreamGobbler(sess.getStdout())));
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader(new StreamGobbler(sess.getStderr())));
            while (null != (line2 = stdoutReader.readLine())) {
                this.log(false, line2);
            }
            StringBuilder error = new StringBuilder();
            while (null != (line = stderrReader.readLine())) {
                this.log(false, line);
                if (StringUtils.isNotBlank((String)error.toString())) {
                    error.append(" ");
                }
                error.append(line).append(".");
            }
            if (StringUtils.isNotBlank((String)error.toString())) {
                this.error(error.toString(), null);
            }
            Object var8_7 = null;
            sess.close();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            sess.close();
            throw throwable;
        }
    }

    public boolean isDownloadResumable() {
        return this.isTransferResumable();
    }

    public boolean isUploadResumable() {
        return this.isTransferResumable();
    }

    public boolean isCreateSymlinkSupported() {
        return true;
    }

    private boolean isTransferResumable() {
        return Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SFTP.getIdentifier());
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new SFTPSession(h);
        }
    }
}

