/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public abstract class AbstractX509TrustManager
implements X509TrustManager,
X509KeyManager {
    protected static Logger log = Logger.getLogger(AbstractX509TrustManager.class);
    private Set<X509Certificate> accepted = new HashSet<X509Certificate>();
    private static X509KeyManager manager;

    protected void acceptCertificate(X509Certificate[] certs) {
        if (log.isDebugEnabled()) {
            for (X509Certificate cert : certs) {
                log.debug((Object)("Certificate trusted:" + cert.toString()));
            }
        }
        this.accepted.addAll(Arrays.asList(certs));
    }

    protected void acceptCertificate(X509Certificate cert) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Certificate trusted:" + cert.toString()));
        }
        this.accepted.add(cert);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.accepted.toArray(new X509Certificate[this.accepted.size()]);
    }

    private X509KeyManager init() {
        if (null == manager) {
            try {
                KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
                store.load(null);
                factory.init(store, null);
                for (KeyManager keyManager : factory.getKeyManagers()) {
                    if (!(keyManager instanceof X509KeyManager)) continue;
                    manager = (X509KeyManager)keyManager;
                    break;
                }
                if (null == manager) {
                    throw new NoSuchAlgorithmException("The default algorithm :" + KeyManagerFactory.getDefaultAlgorithm() + " did not produce a X509 Key manager");
                }
            }
            catch (CertificateException e) {
                log.error((Object)e.getMessage());
            }
            catch (UnrecoverableKeyException e) {
                log.error((Object)e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)e.getMessage());
            }
            catch (KeyStoreException e) {
                log.error((Object)e.getMessage());
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
        return manager;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.init().getClientAliases(keyType, issuers);
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.init().chooseClientAlias(keyType, issuers, socket);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.init().getServerAliases(keyType, issuers);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.init().chooseServerAlias(keyType, issuers, socket);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.init().getCertificateChain(alias);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.init().getPrivateKey(alias);
    }
}

