/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSLSession
extends Session {
    protected Map<String, AbstractX509TrustManager> trust = new HashMap<String, AbstractX509TrustManager>();

    protected SSLSession(Host h) {
        super(h);
    }

    public AbstractX509TrustManager getTrustManager() {
        return this.getTrustManager(this.host.getHostname());
    }

    public AbstractX509TrustManager getTrustManager(final String hostname) {
        if (!this.trust.containsKey(hostname)) {
            this.trust.put(hostname, new KeychainX509TrustManager(){

                public String getHostname() {
                    return hostname;
                }
            });
        }
        return this.trust.get(hostname);
    }

    public List<X509Certificate> getAcceptedIssuers() {
        ArrayList<X509Certificate> accepted = new ArrayList<X509Certificate>();
        for (AbstractX509TrustManager m : this.trust.values()) {
            accepted.addAll(Arrays.asList(m.getAcceptedIssuers()));
        }
        return accepted;
    }

    @Override
    protected void fireConnectionDidCloseEvent() {
        this.trust.clear();
        super.fireConnectionDidCloseEvent();
    }
}

