/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.i18n.Locale;
import ch.ethz.ssh2.sftp.SFTPException;
import com.rackspacecloud.client.cloudfiles.FilesException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.http.StatusLine;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.HttpException;
import org.soyatec.windows.azure.error.StorageServerException;

public class BackgroundException
extends Exception {
    private String message;
    private Path path;
    private Session session;

    public BackgroundException(Session session, Path path, String message, Throwable cause) {
        super(cause);
        this.session = session;
        this.path = path;
        this.message = null == message ? Locale.localizedString("Unknown") : (null == path ? StringUtils.chomp((String)message) : MessageFormat.format(StringUtils.chomp((String)message), path.getName()));
    }

    public String getMessage() {
        return Locale.localizedString(this.message, "Error");
    }

    public Throwable getCause() {
        Throwable cause = super.getCause();
        if (null == cause) {
            return this;
        }
        while (cause.getCause() != null && StringUtils.isNotBlank((String)cause.getCause().getMessage())) {
            cause = cause.getCause();
        }
        return cause;
    }

    public String getReadableTitle() {
        Throwable cause = this.getCause();
        if (cause instanceof FTPException) {
            return "FTP " + Locale.localizedString("Error");
        }
        if (cause instanceof SFTPException) {
            return "SSH " + Locale.localizedString("Error");
        }
        if (cause instanceof ServiceException) {
            return "S3 " + Locale.localizedString("Error");
        }
        if (cause instanceof CloudFrontServiceException) {
            return "CloudFront " + Locale.localizedString("Error");
        }
        if (cause instanceof org.apache.commons.httpclient.HttpException) {
            return "HTTP " + Locale.localizedString("Error");
        }
        if (cause instanceof org.apache.http.HttpException) {
            return "HTTP " + Locale.localizedString("Error");
        }
        if (cause instanceof SocketException) {
            return "Network " + Locale.localizedString("Error");
        }
        if (cause instanceof UnknownHostException) {
            return "DNS " + Locale.localizedString("Error");
        }
        if (cause instanceof IOException) {
            return "I/O " + Locale.localizedString("Error");
        }
        return Locale.localizedString("Error");
    }

    public String getDetailedCauseMessage() {
        String message;
        Throwable cause = this.getCause();
        StringBuilder buffer = new StringBuilder();
        if (null != cause) {
            Throwable cf;
            if (StringUtils.isNotBlank((String)cause.getMessage())) {
                String m = StringUtils.chomp((String)cause.getMessage());
                buffer.append(m);
                if (!m.endsWith(".")) {
                    buffer.append(".");
                }
            }
            if (cause instanceof SFTPException) {
                // empty if block
            }
            if (cause instanceof ServiceException) {
                ServiceException s3 = (ServiceException)cause;
                if (StringUtils.isNotBlank((String)s3.getResponseStatus())) {
                    buffer.append(" ").append(s3.getResponseStatus()).append(".");
                }
                if (StringUtils.isNotBlank((String)s3.getErrorMessage())) {
                    buffer.append(" ").append(s3.getErrorMessage());
                }
            } else if (cause instanceof HttpException) {
                HttpException http = (HttpException)cause;
                buffer.append(" ").append(http.getResponseCode());
                if (StringUtils.isNotBlank((String)http.getResponseMessage())) {
                    buffer.append(" ").append(http.getResponseMessage());
                }
            } else if (cause instanceof CloudFrontServiceException) {
                cf = (CloudFrontServiceException)cause;
                if (StringUtils.isNotBlank((String)cf.getErrorMessage())) {
                    buffer.append(" ").append(cf.getErrorMessage());
                }
                if (StringUtils.isNotBlank((String)cf.getErrorDetail())) {
                    buffer.append(" ").append(cf.getErrorDetail());
                }
            } else if (cause instanceof FilesException) {
                cf = (FilesException)cause;
                StatusLine status = cf.getHttpStatusLine();
                if (null != status && StringUtils.isNotBlank((String)status.getReasonPhrase())) {
                    buffer.append(" ").append(status.getReasonPhrase());
                }
            } else if (cause instanceof StorageServerException) {
                buffer.delete(buffer.indexOf("\r\n"), buffer.length());
            }
        }
        if (!StringUtils.isEmpty((String)(message = buffer.toString())) && Character.isLetter(message.charAt(message.length() - 1))) {
            message = message + ".";
        }
        return Locale.localizedString(message, "Error");
    }

    public Path getPath() {
        return this.path;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BackgroundException) {
            BackgroundException other = (BackgroundException)obj;
            if (!this.getSession().equals(other.getSession())) {
                return false;
            }
            if (null == this.getPath() || null == other.getPath()) {
                return this.getCause().getMessage().equals(other.getCause().getMessage());
            }
            if (!this.getPath().equals(other.getPath())) {
                return false;
            }
            return this.getCause().getMessage().equals(other.getCause().getMessage());
        }
        return super.equals(obj);
    }
}

