/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPool {
    private static ThreadPool instance;
    private static final Object lock;
    private final ThreadFactory threadFactory = new ThreadFactory(){
        private int threadCount = 1;

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("background-" + this.threadCount++);
            return thread;
        }
    };
    private static ExecutorService pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPool instance() {
        Object object = lock;
        synchronized (object) {
            if (null == instance) {
                instance = new ThreadPool();
            }
            return instance;
        }
    }

    private ExecutorService getExecutorService() {
        if (null == pool || pool.isShutdown()) {
            pool = Executors.newCachedThreadPool(this.threadFactory);
        }
        return pool;
    }

    private ExecutorService getExecutor() {
        return this.getExecutorService();
    }

    public void shutdown() {
        this.getExecutorService().shutdownNow();
    }

    public void execute(Runnable command) {
        this.getExecutor().execute(command);
    }

    public <T> T execute(Callable<T> command) throws ExecutionException, InterruptedException {
        Future<T> future = this.getExecutor().submit(command);
        return future.get();
    }

    static {
        lock = new Object();
    }
}

