/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.sftp;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import ch.ethz.ssh2.sftp.ErrorCodes;
import ch.ethz.ssh2.sftp.SFTPException;
import ch.ethz.ssh2.sftp.SFTPv3DirectoryEntry;
import ch.ethz.ssh2.sftp.SFTPv3FileAttributes;
import ch.ethz.ssh2.sftp.SFTPv3FileHandle;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SFTPv3Client {
    private static final Logger log = Logger.getLogger(SFTPv3Client.class);
    private final Connection conn;
    private final Session sess;
    private boolean flag_closed = false;
    private InputStream is;
    private OutputStream os;
    private int protocol_version = 0;
    private int next_request_id = 1000;
    private String charsetName = null;
    public static final int SSH_FXF_READ = 1;
    public static final int SSH_FXF_WRITE = 2;
    public static final int SSH_FXF_APPEND = 4;
    public static final int SSH_FXF_CREAT = 8;
    public static final int SSH_FXF_TRUNC = 16;
    public static final int SSH_FXF_EXCL = 32;
    private static final int DEFAULT_MAX_PARALLELISM = 64;
    private int parallelism = 64;
    Map<Integer, OutstandingReadRequest> pendingReadQueue = new HashMap<Integer, OutstandingReadRequest>();
    Map<Integer, OutstandingStatusRequest> pendingStatusQueue = new HashMap<Integer, OutstandingStatusRequest>();

    public SFTPv3Client(Connection conn) throws IOException {
        if (conn == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.conn = conn;
        log.log("Opening session and starting SFTP subsystem.");
        this.sess = conn.openSession();
        this.sess.startSubSystem("sftp");
        this.is = this.sess.getStdout();
        this.os = new BufferedOutputStream(this.sess.getStdin(), 2048);
        if (this.is == null) {
            throw new IOException("There is a problem with the streams of the underlying channel.");
        }
        this.init();
    }

    public void setCharset(String charset) throws IOException {
        if (charset == null) {
            this.charsetName = charset;
            return;
        }
        try {
            Charset.forName(charset);
        }
        catch (UnsupportedCharsetException e) {
            throw (IOException)new IOException("This charset is not supported").initCause(e);
        }
        this.charsetName = charset;
    }

    public String getCharset() {
        return this.charsetName;
    }

    private void checkHandleValidAndOpen(SFTPv3FileHandle handle) throws IOException {
        if (handle.client != this) {
            throw new IOException("The file handle was created with another SFTPv3FileHandle instance.");
        }
        if (handle.isClosed) {
            throw new IOException("The file handle is closed.");
        }
    }

    private void sendMessage(int type, int requestId, byte[] msg, int off, int len) throws IOException {
        int msglen = len + 1;
        if (type != 1) {
            msglen += 4;
        }
        this.os.write(msglen >> 24);
        this.os.write(msglen >> 16);
        this.os.write(msglen >> 8);
        this.os.write(msglen);
        this.os.write(type);
        if (type != 1) {
            this.os.write(requestId >> 24);
            this.os.write(requestId >> 16);
            this.os.write(requestId >> 8);
            this.os.write(requestId);
        }
        this.os.write(msg, off, len);
        this.os.flush();
    }

    private void sendMessage(int type, int requestId, byte[] msg) throws IOException {
        this.sendMessage(type, requestId, msg, 0, msg.length);
    }

    private void readBytes(byte[] buff, int pos, int len) throws IOException {
        while (len > 0) {
            int count = this.is.read(buff, pos, len);
            if (count < 0) {
                throw new IOException("Unexpected end of sftp stream.");
            }
            if (count == 0 || count > len) {
                throw new IOException("Underlying stream implementation is bogus!");
            }
            len -= count;
            pos += count;
        }
    }

    private byte[] receiveMessage(int maxlen) throws IOException {
        byte[] msglen = new byte[4];
        this.readBytes(msglen, 0, 4);
        int len = (msglen[0] & 0xFF) << 24 | (msglen[1] & 0xFF) << 16 | (msglen[2] & 0xFF) << 8 | msglen[3] & 0xFF;
        if (len > maxlen || len <= 0) {
            throw new IOException("Illegal sftp packet len: " + len);
        }
        byte[] msg = new byte[len];
        this.readBytes(msg, 0, len);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateNextRequestID() {
        SFTPv3Client sFTPv3Client = this;
        synchronized (sFTPv3Client) {
            return this.next_request_id++;
        }
    }

    private void closeHandle(byte[] handle) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(handle, 0, handle.length);
        this.sendMessage(4, req_id, tw.getBytes());
        this.expectStatusOKMessage(req_id);
    }

    private SFTPv3FileAttributes readAttrs(TypesReader tr) throws IOException {
        SFTPv3FileAttributes fa = new SFTPv3FileAttributes();
        int flags = tr.readUINT32();
        if ((flags & 1) != 0) {
            log.log("SSH_FILEXFER_ATTR_SIZE");
            fa.size = tr.readUINT64();
        }
        if ((flags & 2) != 0) {
            log.log("SSH_FILEXFER_ATTR_V3_UIDGID");
            fa.uid = tr.readUINT32();
            fa.gid = tr.readUINT32();
        }
        if ((flags & 4) != 0) {
            log.log("SSH_FILEXFER_ATTR_PERMISSIONS");
            fa.permissions = tr.readUINT32();
        }
        if ((flags & 8) != 0) {
            log.log("SSH_FILEXFER_ATTR_V3_ACMODTIME");
            fa.atime = tr.readUINT32();
            fa.mtime = tr.readUINT32();
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            int count;
            log.log("SSH_FILEXFER_ATTR_EXTENDED (" + count + ")");
            for (count = tr.readUINT32(); count > 0; --count) {
                tr.readByteString();
                tr.readByteString();
            }
        }
        return fa;
    }

    public SFTPv3FileAttributes fstat(SFTPv3FileHandle handle) throws IOException {
        this.checkHandleValidAndOpen(handle);
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(handle.fileHandle, 0, handle.fileHandle.length);
        log.log("Sending SSH_FXP_FSTAT...");
        this.sendMessage(8, req_id, tw.getBytes());
        byte[] resp = this.receiveMessage(34000);
        TypesReader tr = new TypesReader(resp);
        int t = tr.readByte();
        int rep_id = tr.readUINT32();
        if (rep_id != req_id) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (t == 105) {
            return this.readAttrs(tr);
        }
        if (t != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + t + ")");
        }
        int errorCode = tr.readUINT32();
        throw new SFTPException(tr.readString(), errorCode);
    }

    private SFTPv3FileAttributes statBoth(String path, int statMethod) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(path, this.charsetName);
        log.log("Sending SSH_FXP_STAT/SSH_FXP_LSTAT...");
        this.sendMessage(statMethod, req_id, tw.getBytes());
        byte[] resp = this.receiveMessage(34000);
        TypesReader tr = new TypesReader(resp);
        int t = tr.readByte();
        int rep_id = tr.readUINT32();
        if (rep_id != req_id) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (t == 105) {
            return this.readAttrs(tr);
        }
        if (t != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + t + ")");
        }
        int errorCode = tr.readUINT32();
        throw new SFTPException(tr.readString(), errorCode);
    }

    public SFTPv3FileAttributes stat(String path) throws IOException {
        return this.statBoth(path, 17);
    }

    public SFTPv3FileAttributes lstat(String path) throws IOException {
        return this.statBoth(path, 7);
    }

    public String readLink(String path) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(path, this.charsetName);
        log.log("Sending SSH_FXP_READLINK...");
        this.sendMessage(19, req_id, tw.getBytes());
        byte[] resp = this.receiveMessage(34000);
        TypesReader tr = new TypesReader(resp);
        int t = tr.readByte();
        int rep_id = tr.readUINT32();
        if (rep_id != req_id) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (t == 104) {
            int count = tr.readUINT32();
            if (count != 1) {
                throw new IOException("The server sent an invalid SSH_FXP_NAME packet.");
            }
            return tr.readString(this.charsetName);
        }
        if (t != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + t + ")");
        }
        int errorCode = tr.readUINT32();
        throw new SFTPException(tr.readString(), errorCode);
    }

    private void expectStatusOKMessage(int id) throws IOException {
        byte[] resp = this.receiveMessage(34000);
        TypesReader tr = new TypesReader(resp);
        int t = tr.readByte();
        int rep_id = tr.readUINT32();
        if (rep_id != id) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (t != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + t + ")");
        }
        int errorCode = tr.readUINT32();
        if (errorCode == 0) {
            return;
        }
        throw new SFTPException(tr.readString(), errorCode);
    }

    public void setstat(String path, SFTPv3FileAttributes attr) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(path, this.charsetName);
        tw.writeBytes(this.createAttrs(attr));
        log.log("Sending SSH_FXP_SETSTAT...");
        this.sendMessage(9, req_id, tw.getBytes());
        this.expectStatusOKMessage(req_id);
    }

    public void fsetstat(SFTPv3FileHandle handle, SFTPv3FileAttributes attr) throws IOException {
        this.checkHandleValidAndOpen(handle);
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(handle.fileHandle, 0, handle.fileHandle.length);
        tw.writeBytes(this.createAttrs(attr));
        log.log("Sending SSH_FXP_FSETSTAT...");
        this.sendMessage(10, req_id, tw.getBytes());
        this.expectStatusOKMessage(req_id);
    }

    public void createSymlink(String src, String target) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(target, this.charsetName);
        tw.writeString(src, this.charsetName);
        log.log("Sending SSH_FXP_SYMLINK...");
        this.sendMessage(20, req_id, tw.getBytes());
        this.expectStatusOKMessage(req_id);
    }

    public String canonicalPath(String path) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(path, this.charsetName);
        log.log("Sending SSH_FXP_REALPATH...");
        this.sendMessage(16, req_id, tw.getBytes());
        byte[] resp = this.receiveMessage(34000);
        TypesReader tr = new TypesReader(resp);
        int t = tr.readByte();
        int rep_id = tr.readUINT32();
        if (rep_id != req_id) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (t == 104) {
            int count = tr.readUINT32();
            if (count != 1) {
                throw new IOException("The server sent an invalid SSH_FXP_NAME packet.");
            }
            return tr.readString(this.charsetName);
        }
        if (t != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + t + ")");
        }
        int errorCode = tr.readUINT32();
        throw new SFTPException(tr.readString(), errorCode);
    }

    private List scanDirectory(byte[] handle) throws IOException {
        int t;
        TypesReader tr;
        Vector<SFTPv3DirectoryEntry> files = new Vector<SFTPv3DirectoryEntry>();
        block0: while (true) {
            int req_id = this.generateNextRequestID();
            TypesWriter tw = new TypesWriter();
            tw.writeString(handle, 0, handle.length);
            log.log("Sending SSH_FXP_READDIR...");
            this.sendMessage(12, req_id, tw.getBytes());
            byte[] resp = this.receiveMessage(34000);
            tr = new TypesReader(resp);
            t = tr.readByte();
            int rep_id = tr.readUINT32();
            if (rep_id != req_id) {
                throw new IOException("The server sent an invalid id field.");
            }
            if (t != 104) break;
            int count = tr.readUINT32();
            log.log("Parsing " + count + " name entries...");
            while (true) {
                if (count <= 0) continue block0;
                SFTPv3DirectoryEntry dirEnt = new SFTPv3DirectoryEntry();
                dirEnt.filename = tr.readString(this.charsetName);
                dirEnt.longEntry = tr.readString(this.charsetName);
                dirEnt.attributes = this.readAttrs(tr);
                files.add(dirEnt);
                log.log("File: '" + dirEnt.filename + "'");
                --count;
            }
            break;
        }
        if (t != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + t + ")");
        }
        int errorCode = tr.readUINT32();
        if (errorCode == 1) {
            return files;
        }
        throw new SFTPException(tr.readString(), errorCode);
    }

    public final SFTPv3FileHandle openDirectory(String path) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(path, this.charsetName);
        log.log("Sending SSH_FXP_OPENDIR...");
        this.sendMessage(11, req_id, tw.getBytes());
        byte[] resp = this.receiveMessage(34000);
        TypesReader tr = new TypesReader(resp);
        int t = tr.readByte();
        int rep_id = tr.readUINT32();
        if (rep_id != req_id) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (t == 102) {
            log.log("Got SSH_FXP_HANDLE.");
            return new SFTPv3FileHandle(this, tr.readByteString());
        }
        if (t != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + t + ")");
        }
        int errorCode = tr.readUINT32();
        String errorMessage = tr.readString();
        throw new SFTPException(errorMessage, errorCode);
    }

    private String expandString(byte[] b, int off, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int c = b[off + i] & 0xFF;
            if (c >= 32 && c <= 126) {
                sb.append((char)c);
                continue;
            }
            sb.append("{0x" + Integer.toHexString(c) + "}");
        }
        return sb.toString();
    }

    private void init() throws IOException {
        int client_version = 3;
        log.log("Sending SSH_FXP_INIT (3)...");
        TypesWriter tw = new TypesWriter();
        tw.writeUINT32(3);
        this.sendMessage(1, 0, tw.getBytes());
        log.log("Waiting for SSH_FXP_VERSION...");
        TypesReader tr = new TypesReader(this.receiveMessage(34000));
        int type = tr.readByte();
        if (type != 2) {
            throw new IOException("The server did not send a SSH_FXP_VERSION packet (got " + type + ")");
        }
        this.protocol_version = tr.readUINT32();
        log.log("SSH_FXP_VERSION: protocol_version = " + this.protocol_version);
        if (this.protocol_version != 3) {
            throw new IOException("Server version " + this.protocol_version + " is currently not supported");
        }
        while (tr.remain() != 0) {
            String name = tr.readString();
            byte[] value = tr.readByteString();
            log.log("SSH_FXP_VERSION: extension: " + name + " = '" + this.expandString(value, 0, value.length) + "'");
        }
    }

    public int getProtocolVersion() {
        return this.protocol_version;
    }

    public boolean isConnected() {
        return this.sess.getState() == 2;
    }

    public void close() {
        this.sess.close();
    }

    public List ls(String dirName) throws IOException {
        byte[] handle = this.openDirectory((String)dirName).fileHandle;
        List result = this.scanDirectory(handle);
        this.closeHandle(handle);
        return result;
    }

    public void mkdir(String dirName, int posixPermissions) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(dirName, this.charsetName);
        tw.writeUINT32(4);
        tw.writeUINT32(posixPermissions);
        this.sendMessage(14, req_id, tw.getBytes());
        this.expectStatusOKMessage(req_id);
    }

    public void rm(String fileName) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(fileName, this.charsetName);
        this.sendMessage(13, req_id, tw.getBytes());
        this.expectStatusOKMessage(req_id);
    }

    public void rmdir(String dirName) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(dirName, this.charsetName);
        this.sendMessage(15, req_id, tw.getBytes());
        this.expectStatusOKMessage(req_id);
    }

    public void mv(String oldPath, String newPath) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(oldPath, this.charsetName);
        tw.writeString(newPath, this.charsetName);
        this.sendMessage(18, req_id, tw.getBytes());
        this.expectStatusOKMessage(req_id);
    }

    public SFTPv3FileHandle openFileRO(String fileName) throws IOException {
        return this.openFile(fileName, 1, null);
    }

    public SFTPv3FileHandle openFileRW(String fileName) throws IOException {
        return this.openFile(fileName, 3, null);
    }

    public SFTPv3FileHandle openFileRWAppend(String fileName) throws IOException {
        return this.openFile(fileName, 7, null);
    }

    public SFTPv3FileHandle openFileWAppend(String fileName) throws IOException {
        return this.openFile(fileName, 6, null);
    }

    public SFTPv3FileHandle createFile(String fileName) throws IOException {
        return this.createFile(fileName, null);
    }

    public SFTPv3FileHandle createFile(String fileName, SFTPv3FileAttributes attr) throws IOException {
        return this.openFile(fileName, 11, attr);
    }

    public SFTPv3FileHandle createFileTruncate(String fileName) throws IOException {
        return this.createFileTruncate(fileName, null);
    }

    public SFTPv3FileHandle createFileTruncate(String fileName, SFTPv3FileAttributes attr) throws IOException {
        return this.openFile(fileName, 26, attr);
    }

    private byte[] createAttrs(SFTPv3FileAttributes attr) {
        TypesWriter tw = new TypesWriter();
        int attrFlags = 0;
        if (attr == null) {
            tw.writeUINT32(0);
        } else {
            if (attr.size != null) {
                attrFlags |= 1;
            }
            if (attr.uid != null && attr.gid != null) {
                attrFlags |= 2;
            }
            if (attr.permissions != null) {
                attrFlags |= 4;
            }
            if (attr.atime != null && attr.mtime != null) {
                attrFlags |= 8;
            }
            tw.writeUINT32(attrFlags);
            if (attr.size != null) {
                tw.writeUINT64(attr.size);
            }
            if (attr.uid != null && attr.gid != null) {
                tw.writeUINT32(attr.uid);
                tw.writeUINT32(attr.gid);
            }
            if (attr.permissions != null) {
                tw.writeUINT32(attr.permissions);
            }
            if (attr.atime != null && attr.mtime != null) {
                tw.writeUINT32(attr.atime);
                tw.writeUINT32(attr.mtime);
            }
        }
        return tw.getBytes();
    }

    public SFTPv3FileHandle openFile(String fileName, int flags, SFTPv3FileAttributes attr) throws IOException {
        int req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(fileName, this.charsetName);
        tw.writeUINT32(flags);
        tw.writeBytes(this.createAttrs(attr));
        log.log("Sending SSH_FXP_OPEN...");
        this.sendMessage(3, req_id, tw.getBytes());
        byte[] resp = this.receiveMessage(34000);
        TypesReader tr = new TypesReader(resp);
        int t = tr.readByte();
        int rep_id = tr.readUINT32();
        if (rep_id != req_id) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (t == 102) {
            log.log("Got SSH_FXP_HANDLE.");
            return new SFTPv3FileHandle(this, tr.readByteString());
        }
        if (t != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + t + ")");
        }
        int errorCode = tr.readUINT32();
        String errorMessage = tr.readString();
        throw new SFTPException(errorMessage, errorCode);
    }

    private void sendReadRequest(int id, SFTPv3FileHandle handle, long offset, int len) throws IOException {
        TypesWriter tw = new TypesWriter();
        tw.writeString(handle.fileHandle, 0, handle.fileHandle.length);
        tw.writeUINT64(offset);
        tw.writeUINT32(len);
        log.log("Sending SSH_FXP_READ (" + id + ") " + offset + "/" + len);
        this.sendMessage(5, id, tw.getBytes());
    }

    public void setRequestParallelism(int parallelism) {
        this.parallelism = Math.min(parallelism, 64);
        log.log("setDownloadRequestParallelism:" + this.parallelism);
    }

    public int download(SFTPv3FileHandle handle, long fileOffset, byte[] dst, int dstoff, int len) throws IOException {
        boolean errorOccured = false;
        this.checkHandleValidAndOpen(handle);
        int remaining = len * this.parallelism;
        int clientOffset = dstoff;
        long serverOffset = fileOffset;
        for (OutstandingReadRequest r : this.pendingReadQueue.values()) {
            serverOffset += (long)r.len;
        }
        while (this.pendingReadQueue.size() != 0 || !errorOccured) {
            while (this.pendingReadQueue.size() < this.parallelism && !errorOccured) {
                OutstandingReadRequest req = new OutstandingReadRequest();
                req.req_id = this.generateNextRequestID();
                req.serverOffset = serverOffset;
                req.len = remaining > len ? len : remaining;
                req.buffer = dst;
                req.dstOffset = dstoff;
                serverOffset += (long)req.len;
                clientOffset += req.len;
                remaining -= req.len;
                this.sendReadRequest(req.req_id, handle, req.serverOffset, req.len);
                this.pendingReadQueue.put(req.req_id, req);
            }
            if (this.pendingReadQueue.size() == 0) break;
            byte[] resp = this.receiveMessage(34000);
            TypesReader tr = new TypesReader(resp);
            int type = tr.readByte();
            OutstandingReadRequest req = this.pendingReadQueue.remove(tr.readUINT32());
            if (null == req) {
                throw new IOException("The server sent an invalid id field.");
            }
            if (type == 101) {
                int code = tr.readUINT32();
                String msg = tr.readString();
                if (log.isEnabled()) {
                    String[] desc = ErrorCodes.getDescription(code);
                    log.log("Got SSH_FXP_STATUS (" + req.req_id + ") (" + (desc != null ? desc[0] : "UNKNOWN") + ")");
                }
                errorOccured = true;
                if (!this.pendingReadQueue.isEmpty()) continue;
                if (1 == code) {
                    return -1;
                }
                throw new SFTPException(msg, code);
            }
            if (type == 103) {
                int readLen = tr.readUINT32();
                if (readLen < 0 || readLen > req.len) {
                    throw new IOException("The server sent an invalid length field in a SSH_FXP_DATA packet.");
                }
                if (log.isEnabled()) {
                    log.log("Got SSH_FXP_DATA (" + req.req_id + ") " + req.serverOffset + "/" + readLen + " (requested: " + req.len + ")");
                }
                tr.readBytes(req.buffer, req.dstOffset, readLen);
                if (readLen < req.len) {
                    req.req_id = this.generateNextRequestID();
                    req.serverOffset += (long)readLen;
                    req.len -= readLen;
                    log.log("Requesting again: " + req.serverOffset + "/" + req.len);
                    this.sendReadRequest(req.req_id, handle, req.serverOffset, req.len);
                    this.pendingReadQueue.put(req.req_id, req);
                }
                return readLen;
            }
            throw new IOException("The SFTP server sent an unexpected packet type (" + type + ")");
        }
        throw new SFTPException("No EOF reached", -1);
    }

    public void upload(SFTPv3FileHandle handle, long fileOffset, byte[] src, int srcoff, int len) throws IOException {
        this.checkHandleValidAndOpen(handle);
        OutstandingStatusRequest req = new OutstandingStatusRequest();
        req.req_id = this.generateNextRequestID();
        TypesWriter tw = new TypesWriter();
        tw.writeString(handle.fileHandle, 0, handle.fileHandle.length);
        tw.writeUINT64(fileOffset);
        tw.writeString(src, srcoff, len);
        log.log("Sending SSH_FXP_WRITE...");
        this.sendMessage(6, req.req_id, tw.getBytes());
        this.pendingStatusQueue.put(req.req_id, req);
        while (this.pendingStatusQueue.size() >= this.parallelism) {
            this.readStatus();
        }
    }

    private void readStatus() throws IOException {
        byte[] resp = this.receiveMessage(34000);
        TypesReader tr = new TypesReader(resp);
        int type = tr.readByte();
        OutstandingStatusRequest status = this.pendingStatusQueue.remove(tr.readUINT32());
        if (null == status) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (type == 101) {
            int code = tr.readUINT32();
            if (log.isEnabled()) {
                String[] desc = ErrorCodes.getDescription(code);
                log.log("Got SSH_FXP_STATUS (" + status.req_id + ") (" + (desc != null ? desc[0] : "UNKNOWN") + ")");
            }
            if (code == 0) {
                return;
            }
            String msg = tr.readString();
            throw new SFTPException(msg, code);
        }
        throw new IOException("The SFTP server sent an unexpected packet type (" + type + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile(SFTPv3FileHandle handle) throws IOException {
        try {
            while (!this.pendingStatusQueue.isEmpty()) {
                this.readStatus();
            }
            if (!handle.isClosed) {
                this.closeHandle(handle.fileHandle);
            }
        }
        finally {
            handle.isClosed = true;
        }
    }

    private static class OutstandingStatusRequest {
        int req_id;

        private OutstandingStatusRequest() {
        }
    }

    private static class OutstandingReadRequest {
        int req_id;
        long serverOffset;
        int len;
        int dstOffset;
        byte[] buffer;

        private OutstandingReadRequest() {
        }
    }
}

