/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.putty;

import ch.ethz.ssh2.crypto.PEMDecryptException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class KeyReader {
    private final DataInput di;

    public KeyReader(byte[] key) {
        this.di = new DataInputStream(new ByteArrayInputStream(key));
    }

    public void skip() {
        try {
            this.di.skipBytes(this.di.readInt());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] read() throws PEMDecryptException {
        try {
            int len = this.di.readInt();
            if (len <= 0 || len > 512) {
                throw new PEMDecryptException();
            }
            byte[] r = new byte[len];
            this.di.readFully(r);
            return r;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public BigInteger readInt() throws PEMDecryptException {
        return new BigInteger(this.read());
    }
}

