/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.authenticate;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestAccessor {
    private static final String SCHEME_DELIMITER = "://";

    public static List<String> getHeaderValues(NameValueCollection header, String headerName) {
        ArrayList<String> arrayOfValues = new ArrayList<String>();
        Collection collection = header.getCollection(headerName);
        if (collection != null) {
            for (String object : collection) {
                arrayOfValues.add(object);
            }
        }
        return arrayOfValues;
    }

    public static URI constructResourceUri(URI endPoint, ResourceUriComponents uriComponents, boolean pathStyleUri) {
        return pathStyleUri ? HttpRequestAccessor.constructPathStyleResourceUri(endPoint, uriComponents) : HttpRequestAccessor.constructHostStyleResourceUri(endPoint, uriComponents);
    }

    private static URI constructHostStyleResourceUri(URI hostSuffix, ResourceUriComponents uriComponents) {
        if (uriComponents.getAccountName() == null) {
            return hostSuffix;
        }
        URI accountUri = HttpRequestAccessor.constructHostStyleAccountUri(hostSuffix, uriComponents.getAccountName());
        StringBuilder path = new StringBuilder();
        if (uriComponents.getContainerName() != null) {
            if (uriComponents.getContainerName().length() > 0) {
                path.append(uriComponents.getContainerName());
            }
            if (uriComponents.getRemainingPart() != null) {
                path.append("/");
                path.append(uriComponents.getRemainingPart());
            }
        }
        String str = path.toString();
        return HttpRequestAccessor.constructUriFromUriAndString(accountUri, str);
    }

    private static URI constructPathStyleResourceUri(URI endPoint, ResourceUriComponents uriComponents) {
        StringBuilder path = new StringBuilder();
        if (uriComponents.getAccountName() != null) {
            path.append(uriComponents.getAccountName());
            if (uriComponents.getContainerName() != null) {
                if (uriComponents.getContainerName().length() > 0) {
                    path.append("/");
                    path.append(uriComponents.getContainerName());
                }
                if (uriComponents.getRemainingPart() != null) {
                    path.append("/");
                    path.append(uriComponents.getRemainingPart());
                }
            }
        }
        String str = path.toString();
        return HttpRequestAccessor.constructUriFromUriAndString(endPoint, str);
    }

    private static URI constructHostStyleAccountUri(URI hostSuffix, String accountName) {
        URI serviceUri = hostSuffix;
        String hostString = hostSuffix.toString();
        if (!hostString.startsWith("http")) {
            hostString = "http://" + hostString;
            serviceUri = URI.create(hostString);
        }
        String accountUriString = null;
        accountUriString = serviceUri.getPort() == -1 ? MessageFormat.format("{0}{1}{2}.{3}/", Utilities.isNullOrEmpty(serviceUri.getScheme()) ? "http" : serviceUri.getScheme(), SCHEME_DELIMITER, accountName, serviceUri.getHost()) : MessageFormat.format("{0}{1}{2}.{3}:{4}/", Utilities.isNullOrEmpty(serviceUri.getScheme()) ? "http" : serviceUri.getScheme(), SCHEME_DELIMITER, accountName, serviceUri.getHost(), serviceUri.getPort());
        return URI.create(accountUriString);
    }

    private static URI constructUriFromUriAndString(URI endPoint, String path) {
        String encodedPath = Utilities.encode(path);
        if (!Utilities.isNullOrEmpty(encodedPath) && encodedPath.charAt(0) != "/".charAt(0)) {
            encodedPath = "/" + encodedPath;
        }
        try {
            return new URI(endPoint.getScheme(), null, endPoint.getHost(), endPoint.getPort(), encodedPath.replaceAll("%20", " "), endPoint.getQuery(), endPoint.getFragment());
        }
        catch (URISyntaxException e) {
            Logger.error("Can not new URI", e);
            return null;
        }
    }
}

