/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.authenticate;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.internal.MessageCanonicalizer;
import org.soyatec.windows.azure.internal.MessageCanonicalizer2;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.Utilities;

public class SharedKeyCredentials {
    private static final String HMACSHA256 = "HmacSHA256";
    private static final String UTF8_CHARSET = "UTF-8";
    private String accountName;
    private byte[] key;

    protected SharedKeyCredentials() {
    }

    public SharedKeyCredentials(String accountName, byte[] key) {
        this.accountName = accountName;
        this.key = key;
    }

    private String getApiVersion(HttpRequest request) {
        Header header = request.getFirstHeader("x-ms-version");
        if (header == null) {
            return "";
        }
        return header.getValue();
    }

    public void signRequest(HttpRequest request, ResourceUriComponents uriComponents) {
        if (request == null) {
            throw new IllegalArgumentException("request is null.");
        }
        String version = this.getApiVersion(request);
        String message = version.equalsIgnoreCase("2009-09-19") ? MessageCanonicalizer2.canonicalizeHttpRequest(request, uriComponents) : MessageCanonicalizer.canonicalizeHttpRequest(request, uriComponents);
        String computedBase64Signature = this.computeMacSha(message);
        request.addHeader("Authorization", MessageFormat.format("{0} {1}:{2}", "SharedKey", this.getAccountName(), computedBase64Signature));
    }

    public void signRequestForSharedKeyLite(HttpRequest request, ResourceUriComponents uriComponents) {
        if (request == null) {
            throw new IllegalArgumentException("request is null.");
        }
        String dateString = Utilities.getUTCTime();
        request.addHeader("x-ms-date", dateString);
        String message = MessageCanonicalizer.canonicalizeHttpRequestForSharedKeyLite(request, uriComponents, dateString);
        String computedBase64Signature = this.computeMacSha(message);
        request.addHeader("Authorization", MessageFormat.format("{0} {1}:{2}", "SharedKeyLite", this.accountName, computedBase64Signature));
    }

    public String signSharedAccessUrl(String permissions, String start, String expiry, String canonicalizedResource, String identifier) {
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(this.trimToEmpty(permissions)).append('\n');
        stringToSign.append(this.trimToEmpty(start)).append('\n');
        stringToSign.append(this.trimToEmpty(expiry)).append('\n');
        stringToSign.append(this.trimToEmpty(canonicalizedResource)).append('\n');
        stringToSign.append(this.trimToEmpty(identifier));
        return this.computeMacSha(stringToSign.toString());
    }

    private String trimToEmpty(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    private String computeMacSha(String canonicalizedString) {
        try {
            Mac mac = Mac.getInstance(HMACSHA256);
            mac.init(new SecretKeySpec(this.getKey(), mac.getAlgorithm()));
            byte[] dataToMAC = canonicalizedString.getBytes(UTF8_CHARSET);
            mac.update(dataToMAC);
            byte[] result = mac.doFinal();
            return Base64.encode(result);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error("NoSuchAlgorithmException", e);
        }
        catch (InvalidKeyException e) {
            Logger.error("InvalidKeyException", e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("UnsupportedEncodingException", e);
        }
        return null;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public byte[] getKey() {
        return this.key;
    }
}

