/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTime {
    private String timeString;
    private static final SimpleDateFormat YYYY_MM_DD_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat YYYY_MMT_DD_T_HH_MM_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
    private static final SimpleDateFormat YYYY_MMT_DD_T_HH_MM_SS_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public String getTimeString() {
        return this.timeString;
    }

    public DateTime(Date date) {
        this.timeString = YYYY_MMT_DD_T_HH_MM_SS_FORMATTER.format(date);
    }

    public DateTime(String string) {
        SimpleDateFormat[] formats;
        for (SimpleDateFormat format : formats = new SimpleDateFormat[]{YYYY_MM_DD_FORMATTER, YYYY_MMT_DD_T_HH_MM_FORMATTER, YYYY_MMT_DD_T_HH_MM_SS_FORMATTER}) {
            try {
                format.parse(string);
                this.timeString = string;
                return;
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalArgumentException();
    }

    public DateTime(int year, int month, int date) {
        Calendar calendar = DateTime.createCalendar(year, month, date);
        this.timeString = YYYY_MM_DD_FORMATTER.format(calendar.getTime());
    }

    public DateTime(int year, int month, int date, int hour, int minute) {
        Calendar calendar = DateTime.createCalendar(year, month, date, hour, minute);
        this.timeString = YYYY_MMT_DD_T_HH_MM_FORMATTER.format(calendar.getTime());
    }

    public DateTime(int year, int month, int date, int hour, int minute, int second) {
        Calendar calendar = DateTime.createCalendar(year, month, date, hour, minute, second);
        this.timeString = YYYY_MMT_DD_T_HH_MM_SS_FORMATTER.format(calendar.getTime());
    }

    public static String create(int year, int month, int date) {
        Calendar dateTime = DateTime.createCalendar(year, month, date);
        return YYYY_MM_DD_FORMATTER.format(dateTime.getTime());
    }

    public static String create(int year, int month, int date, int hour, int minute) {
        Calendar dateTime = DateTime.createCalendar(year, month, date, hour, minute);
        return YYYY_MMT_DD_T_HH_MM_FORMATTER.format(dateTime.getTime());
    }

    public static String create(int year, int month, int date, int hour, int minute, int second) {
        Calendar dateTime = DateTime.createCalendar(year, month, date, hour, minute, second);
        return YYYY_MMT_DD_T_HH_MM_SS_FORMATTER.format(dateTime.getTime());
    }

    private static Calendar createCalendar(int year, int month, int date, int hour, int minute, int second) {
        Calendar calendar = DateTime.createCalendar(year, month, date, hour, minute);
        calendar.set(13, second);
        return calendar;
    }

    private static Calendar createCalendar(int year, int month, int date, int hour, int minute) {
        Calendar calendar = DateTime.createCalendar(year, month, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        return calendar;
    }

    private static Calendar createCalendar(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, date);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(13, 0);
        return calendar;
    }

    public Calendar toCalendar() {
        SimpleDateFormat[] formats;
        for (SimpleDateFormat format : formats = new SimpleDateFormat[]{YYYY_MM_DD_FORMATTER, YYYY_MMT_DD_T_HH_MM_FORMATTER, YYYY_MMT_DD_T_HH_MM_SS_FORMATTER}) {
            try {
                Date date = format.parse(this.timeString);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException e) {
            }
        }
        return null;
    }

    public String toString() {
        return this.timeString;
    }
}

