/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob;

import java.net.URI;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import org.soyatec.windows.azure.blob.IBlob;
import org.soyatec.windows.azure.blob.IBlobConstraints;
import org.soyatec.windows.azure.blob.IBlobContents;
import org.soyatec.windows.azure.blob.IBlobProperties;
import org.soyatec.windows.azure.blob.IContainerAccessControl;
import org.soyatec.windows.azure.blob.IContainerProperties;
import org.soyatec.windows.azure.blob.IPageRange;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.blob.ISharedAccessUrl;
import org.soyatec.windows.azure.blob.LeaseMode;
import org.soyatec.windows.azure.blob.internal.BlobProperties;
import org.soyatec.windows.azure.blob.internal.ContainerAccessControl;
import org.soyatec.windows.azure.blob.internal.PageRange;
import org.soyatec.windows.azure.blob.io.BlobStream;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.TimeSpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IBlobContainer {
    public static final String ROOT_CONTAINER = "$root";

    public void useSharedAccessUrl(ISharedAccessUrl var1);

    public void clearSharedAccessUrl();

    public String getURL();

    public boolean createBlob(IBlobProperties var1, IBlobContents var2, boolean var3) throws StorageException;

    public boolean updateBlobIfNotModified(IBlobProperties var1, IBlobContents var2) throws StorageException;

    public void updateBlobMetadata(IBlobProperties var1) throws StorageException;

    public boolean updateBlobMetadataIfNotModified(IBlobProperties var1) throws StorageException;

    public void setContainerMetadata(NameValueCollection var1) throws StorageException;

    public IBlob getBlob(String var1, BlobStream var2, boolean var3) throws StorageException;

    public boolean isBlobIfModified(BlobProperties var1, IBlobContents var2, boolean var3) throws StorageException;

    public IBlobProperties getBlobProperties(String var1) throws StorageException;

    public boolean isContainerExist() throws StorageException;

    public boolean isBlobExist(String var1) throws StorageException;

    public Iterator<IBlobProperties> listBlobs() throws StorageException;

    public Iterator<IBlobProperties> listBlobs(String var1, boolean var2) throws StorageException;

    public Iterator<IBlobProperties> listBlobs(String var1, boolean var2, int var3) throws StorageException;

    public void setContainerAccessControl(IContainerAccessControl var1) throws StorageException;

    public ContainerAccessControl getContainerAccessControl() throws StorageException;

    public IContainerProperties getContainerProperties() throws StorageException;

    public boolean copyBlob(String var1, String var2, String var3) throws StorageException;

    public boolean copyBlob(String var1, String var2, String var3, NameValueCollection var4, IBlobConstraints var5) throws StorageException;

    public boolean deleteBlob(String var1) throws StorageException;

    public boolean deleteBlobIfNotModified(IBlobProperties var1) throws StorageException;

    public String leaseBlob(IBlobProperties var1, LeaseMode var2, NameValueCollection var3) throws StorageException;

    public Timestamp createSnapshot(IBlobProperties var1, NameValueCollection var2) throws StorageException;

    public void createPage(IBlobProperties var1, int var2, NameValueCollection var3) throws StorageException;

    public List<PageRange> getPageRegions(IBlobProperties var1, NameValueCollection var2) throws StorageException;

    public void writePages(IBlobProperties var1, BlobStream var2, IPageRange var3, NameValueCollection var4) throws StorageException;

    public URI getBaseUri();

    public String getAccountName();

    public String getContainerName();

    public boolean isUsePathStyleUris();

    public URI getContainerUri();

    public Timestamp getLastModifiedTime();

    public TimeSpan getTimeout();

    public IRetryPolicy getRetryPolicy();

    public void setTimeout(TimeSpan var1);

    public void setRetryPolicy(IRetryPolicy var1);

    public void setContainerUri(URI var1);

    public void stopFetchProgress(boolean var1);

    public boolean isStopped();

    public long getBlockSize();

    public void setBlockSize(long var1);

    public String getLastStatus();
}

