/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.internal;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.http.message.BasicHeader;
import org.soyatec.windows.azure.blob.IBlobConstraints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobConstraints
implements IBlobConstraints {
    private List<BasicHeader> constraints = new ArrayList<BasicHeader>();

    private BlobConstraints() {
    }

    public static IBlobConstraints newInstance() {
        return new BlobConstraints();
    }

    @Override
    public List<BasicHeader> getConstraints() {
        return this.constraints;
    }

    @Override
    public void setConstraints(List<BasicHeader> constraints) {
        this.constraints = constraints;
    }

    @Override
    public IBlobConstraints isSourceModifiedSince(Timestamp time) {
        this.constraints.add(new BasicHeader("x-ms-source-if-modified-since", this.formatTime(time)));
        return this;
    }

    @Override
    public IBlobConstraints isSourceUnmodifiedSince(Timestamp time) {
        this.constraints.add(new BasicHeader("x-ms-source-if-unmodified-since", this.formatTime(time)));
        return this;
    }

    @Override
    public IBlobConstraints isSourceMatch(String etag) {
        this.constraints.add(new BasicHeader("x-ms-source-if-match", etag));
        return this;
    }

    @Override
    public IBlobConstraints isSourceNoneMatch(String etag) {
        this.constraints.add(new BasicHeader("x-ms-source-if-none-match", etag));
        return this;
    }

    @Override
    public IBlobConstraints isDestinationModifiedSince(Timestamp time) {
        this.constraints.add(new BasicHeader("If-Modified-Since", this.formatTime(time)));
        return this;
    }

    @Override
    public IBlobConstraints isDestinationUnmodifiedSince(Timestamp time) {
        this.constraints.add(new BasicHeader("If-Unmodified-Since", this.formatTime(time)));
        return this;
    }

    @Override
    public IBlobConstraints isDestinationMatch(String etag) {
        this.constraints.add(new BasicHeader("If-Match", etag));
        return this;
    }

    @Override
    public IBlobConstraints isDestinationNoneMatch(String etag) {
        this.constraints.add(new BasicHeader("If-None-Match", etag));
        return this;
    }

    private String formatTime(Timestamp time) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        return formatter.format(time) + " GMT";
    }
}

