/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.authenticate.HttpRequestAccessor;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentialsWrapper;
import org.soyatec.windows.azure.blob.BlobType;
import org.soyatec.windows.azure.blob.DateTime;
import org.soyatec.windows.azure.blob.IBlob;
import org.soyatec.windows.azure.blob.IBlobConstraints;
import org.soyatec.windows.azure.blob.IBlobContents;
import org.soyatec.windows.azure.blob.IBlobProperties;
import org.soyatec.windows.azure.blob.IContainerAccessControl;
import org.soyatec.windows.azure.blob.IContainerProperties;
import org.soyatec.windows.azure.blob.IPageRange;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.blob.ISharedAccessUrl;
import org.soyatec.windows.azure.blob.LeaseMode;
import org.soyatec.windows.azure.blob.LeaseStatus;
import org.soyatec.windows.azure.blob.SharedAccessPermissions;
import org.soyatec.windows.azure.blob.internal.Blob;
import org.soyatec.windows.azure.blob.internal.BlobContainer;
import org.soyatec.windows.azure.blob.internal.BlobContents;
import org.soyatec.windows.azure.blob.internal.BlobProperties;
import org.soyatec.windows.azure.blob.internal.ContainerAccessControl;
import org.soyatec.windows.azure.blob.internal.ContainerProperties;
import org.soyatec.windows.azure.blob.internal.ListBlobsResult;
import org.soyatec.windows.azure.blob.internal.PageRange;
import org.soyatec.windows.azure.blob.internal.RetryPolicies;
import org.soyatec.windows.azure.blob.io.BlobMemoryStream;
import org.soyatec.windows.azure.blob.io.BlobStream;
import org.soyatec.windows.azure.error.StorageErrorCode;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.error.StorageServerException;
import org.soyatec.windows.azure.internal.AccessPolicy;
import org.soyatec.windows.azure.internal.OutParameter;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.internal.SignedIdentifier;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.TimeSpan;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.AtomUtil;
import org.soyatec.windows.azure.util.xml.XPathQueryHelper;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobContainerRest
extends BlobContainer {
    private byte[] key;
    private SharedKeyCredentials credentials;
    private ISharedAccessUrl shareAccessUrl;
    private String lastStatus;

    public BlobContainerRest(URI baseUri, boolean usePathStyleUris, String accountName, String containerName, String base64Key, Timestamp lastModified, TimeSpan timeOut, IRetryPolicy retryPolicy) {
        super(baseUri, usePathStyleUris, accountName, containerName, lastModified);
        ResourceUriComponents uriComponents = new ResourceUriComponents(accountName, containerName, null);
        URI containerUri = HttpRequestAccessor.constructResourceUri(baseUri, uriComponents, usePathStyleUris);
        this.setContainerUri(containerUri);
        if (base64Key != null) {
            this.key = Base64.decode(base64Key);
        }
        this.credentials = new SharedKeyCredentials(accountName, this.key);
        this.setTimeout(timeOut);
        this.setRetryPolicy(retryPolicy);
    }

    @Override
    public boolean createBlob(IBlobProperties blobProperties, IBlobContents blobContents, boolean overwrite) throws StorageException {
        String blobName = blobProperties.getName();
        if (blobName == null || blobName.equals("")) {
            throw new IllegalArgumentException("Blob name is empty.");
        }
        if (blobName.lastIndexOf(46) == blobName.length() - 1) {
            throw new IllegalArgumentException(MessageFormat.format("The specified blob name \"{0}\" is not valid!\nPlease choose a name that conforms to the naming conventions for blob!\nSee <a>http://msdn.microsoft.com/en-us/library/dd135715.aspx</a> for more information.", blobName));
        }
        try {
            return this.putBlobImpl(blobProperties, blobContents.getStream(), overwrite, null);
        }
        catch (Exception e) {
            throw HttpUtilities.translateWebException(e);
        }
    }

    @Override
    public boolean updateBlobIfNotModified(IBlobProperties blobProperties, IBlobContents contents) throws StorageException {
        try {
            return this.putBlobImpl(blobProperties, contents.getStream(), true, blobProperties.getETag());
        }
        catch (Exception e) {
            throw HttpUtilities.translateWebException(e);
        }
    }

    private boolean putBlobImpl(final IBlobProperties blobProperties, final BlobStream stream, final boolean overwrite, final String eTag) throws Exception {
        if (blobProperties == null) {
            throw new IllegalArgumentException("Blob properties cannot be null or empty!");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Stream cannot be null or empty!");
        }
        if (this.getContainerName().equals("$root") && blobProperties.getName().indexOf(47) > -1) {
            throw new IllegalArgumentException("Blobs stored in the root container can not have a name containing a forward slash (/).");
        }
        final long originalPosition = stream.getPosition();
        final long length = stream.length() - stream.getPosition();
        if (length > 0x200000L) {
            return this.putLargeBlobImpl(blobProperties, stream, overwrite, eTag);
        }
        boolean retval = false;
        IRetryPolicy policy = stream.canSeek() ? this.getRetryPolicy() : RetryPolicies.noRetry();
        retval = (Boolean)policy.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (stream.canSeek()) {
                    stream.setPosition(originalPosition);
                }
                return BlobContainerRest.this.uploadData(blobProperties, stream, length, overwrite, eTag, new NameValueCollection());
            }
        });
        return retval;
    }

    private boolean uploadData(IBlobProperties blobProperties, BlobStream stream, long length, boolean overwrite, String eTag, NameValueCollection queryParameters) throws Exception {
        boolean isRoot = this.getContainerName().equals("$root");
        String containerName = isRoot ? "" : this.getContainerName();
        ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), containerName, blobProperties.getName());
        URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), containerName, blobProperties.getName(), this.getTimeout(), queryParameters, uriComponents);
        HttpRequest request = this.createHttpRequestForPutBlob(blobUri, "PUT", blobProperties, length, overwrite, eTag);
        if (isRoot) {
            request.addHeader("x-ms-version", "2009-07-17");
        }
        this.credentials.signRequest(request, uriComponents);
        boolean retval = false;
        BlobMemoryStream requestStream = new BlobMemoryStream();
        Utilities.copyStream(stream, requestStream, (int)length);
        ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(requestStream.getBytes()));
        HttpWebResponse response = HttpUtilities.getResponse(request);
        if (response.getStatusCode() == 201) {
            retval = true;
        } else if (!(overwrite || response.getStatusCode() != 412 && response.getStatusCode() != 304)) {
            retval = false;
        } else {
            retval = false;
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        blobProperties.setLastModifiedTime(response.getLastModified());
        blobProperties.setETag(response.getHeader("ETag"));
        requestStream.close();
        return retval;
    }

    private HttpRequest createHttpRequestForPutBlob(URI blobUri, String httpMethod, IBlobProperties blobProperties, long contentLength, boolean overwrite, String eTag) {
        HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, httpMethod, this.getTimeout());
        if (blobProperties.getContentEncoding() != null) {
            request.addHeader("Content-Encoding", blobProperties.getContentEncoding());
        }
        if (blobProperties.getContentLanguage() != null) {
            request.addHeader("Content-Language", blobProperties.getContentLanguage());
        }
        if (blobProperties.getContentType() != null) {
            request.addHeader("Content-Type", blobProperties.getContentType());
        }
        if (eTag != null) {
            request.addHeader("If-Match", eTag);
        }
        if (blobProperties.getMetadata() != null && blobProperties.getMetadata().size() > 0) {
            HttpUtilities.addMetadataHeaders(request, blobProperties.getMetadata());
        }
        if (!overwrite) {
            request.addHeader("If-None-Match", "*");
        }
        return request;
    }

    private boolean putLargeBlobImpl(final IBlobProperties blobProperties, final BlobStream stream, final boolean overwrite, final String eTag) throws Exception {
        boolean retval = false;
        long blockSize = 0x100000L;
        final long startPosition = stream.getPosition();
        final long length = stream.length() - startPosition;
        int numBlocks = (int)Math.ceil((double)length / 1048576.0);
        String[] blockIds = new String[numBlocks];
        IRetryPolicy policy = stream.canSeek() ? this.getRetryPolicy() : RetryPolicies.noRetry();
        int i = 0;
        while (i < numBlocks) {
            String blockId;
            String generateBlockId = this.generateBlockId(i);
            blockIds[i] = blockId = Base64.encode(generateBlockId.getBytes("UTF-8"));
            Logger.debug("Block Id:" + blockIds[i]);
            final int index = i++;
            retval = (Boolean)policy.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (stream.canSeek()) {
                        stream.setPosition(startPosition + (long)index * 0x100000L);
                    }
                    NameValueCollection params = new NameValueCollection();
                    params.put("comp", "block");
                    params.put("blockid", blockId);
                    long blockLength = Math.min(0x100000L, length - stream.getPosition());
                    return BlobContainerRest.this.uploadData(blobProperties, stream, blockLength, overwrite, eTag, params);
                }
            });
        }
        Document doc = DocumentHelper.createDocument();
        Element blockListElement = doc.addElement("BlockList");
        for (String id : blockIds) {
            blockListElement.addElement("Block").setText(id);
        }
        NameValueCollection params = new NameValueCollection();
        params.put("comp", "blocklist");
        BlobMemoryStream buffer = new BlobMemoryStream(doc.asXML().getBytes());
        retval = this.uploadData(blobProperties, buffer, buffer.length(), overwrite, eTag, params);
        return retval;
    }

    protected String generateBlockId(int i) {
        String value = String.valueOf(i);
        while (value.length() < 64) {
            value = "0" + value;
        }
        return value;
    }

    @Override
    public boolean isContainerExist() throws StorageException {
        boolean result = false;
        result = (Boolean)this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null);
                NameValueCollection queryParams = new NameValueCollection();
                queryParams.put("restype", "container");
                URI uri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null, BlobContainerRest.this.getTimeout(), queryParams, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "GET", BlobContainerRest.this.getTimeout());
                request.addHeader("x-ms-version", "2009-07-17");
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200) {
                        return true;
                    }
                    if (response.getStatusCode() == 410 || response.getStatusCode() == 404) {
                        return false;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    @Override
    public boolean isBlobExist(String blobName) throws StorageException {
        try {
            return this.getBlobProperties(blobName) != null;
        }
        catch (Exception e) {
            if (e instanceof StorageException) {
                StorageException se = (StorageException)e;
                if (se.getStatusCode() == 404) {
                    return false;
                }
                throw se;
            }
            return false;
        }
    }

    @Override
    public IContainerProperties getContainerProperties() throws StorageException {
        IContainerProperties result = null;
        try {
            result = (IContainerProperties)this.getRetryPolicy().execute(new Callable<ContainerProperties>(){

                @Override
                public ContainerProperties call() throws Exception {
                    ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null);
                    NameValueCollection queryParams = new NameValueCollection();
                    queryParams.put("restype", "container");
                    URI uri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null, BlobContainerRest.this.getTimeout(), queryParams, uriComponents);
                    HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "GET", BlobContainerRest.this.getTimeout());
                    request.addHeader("x-ms-version", "2009-07-17");
                    BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200) {
                        return BlobContainerRest.this.containerPropertiesFromResponse(response);
                    }
                    if (response.getStatusCode() == 410 || response.getStatusCode() == 404) {
                        return null;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return null;
                }
            });
        }
        catch (StorageException e) {
            throw HttpUtilities.translateWebException(e);
        }
        return result;
    }

    private ContainerProperties containerPropertiesFromResponse(HttpWebResponse response) {
        ContainerProperties prop = new ContainerProperties(this.getContainerName());
        prop.setLastModifiedTime(response.getLastModified());
        prop.setETag(response.getHeader("ETag"));
        prop.setUri(this.getContainerUri());
        prop.setMetadata(this.metadataFromHeaders(response.getHeaders()));
        return prop;
    }

    private NameValueCollection metadataFromHeaders(NameValueCollection headers) {
        int prefixLength = "x-ms-meta-".length();
        NameValueCollection metadataEntries = new NameValueCollection();
        for (Object key : headers.keySet()) {
            String headerName = (String)key;
            if (!headerName.toLowerCase().startsWith("x-ms-meta-")) continue;
            metadataEntries.putAll(headerName.substring(prefixLength), headers.getCollection(headerName));
        }
        return metadataEntries;
    }

    @Override
    public void setContainerAccessControl(final IContainerAccessControl acl) throws StorageException {
        try {
            this.getRetryPolicy().execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    NameValueCollection queryParams = new NameValueCollection();
                    queryParams.put("restype", "container");
                    queryParams.put("comp", "acl");
                    ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null);
                    URI uri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null, BlobContainerRest.this.getTimeout(), queryParams, uriComponents);
                    HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "PUT", BlobContainerRest.this.getTimeout());
                    request.addHeader("x-ms-prop-publicaccess", String.valueOf(acl.isPublic()));
                    BlobContainerRest.this.addVerisonHeader(request);
                    this.attachBody(acl, request);
                    BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() != 200) {
                        HttpUtilities.processUnexpectedStatusCode(response);
                    }
                    return true;
                }

                private void attachBody(IContainerAccessControl acl2, HttpRequest request) {
                    String atom = AtomUtil.convertACLToXml(acl2);
                    ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(atom.getBytes()));
                }
            });
        }
        catch (StorageException e) {
            throw HttpUtilities.translateWebException(e);
        }
    }

    private void addVerisonHeader(HttpRequest request) {
        request.addHeader("x-ms-version", "2009-07-17");
    }

    @Override
    public ContainerAccessControl getContainerAccessControl() throws StorageException {
        ContainerAccessControl accessControl = IContainerAccessControl.Private;
        try {
            accessControl = (ContainerAccessControl)this.getRetryPolicy().execute(new Callable<ContainerAccessControl>(){

                @Override
                public ContainerAccessControl call() throws Exception {
                    NameValueCollection queryParams = new NameValueCollection();
                    queryParams.put("comp", "acl");
                    queryParams.put("restype", "container");
                    ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null);
                    URI uri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null, BlobContainerRest.this.getTimeout(), queryParams, uriComponents);
                    HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "GET", BlobContainerRest.this.getTimeout());
                    request.addHeader("x-ms-version", "2009-07-17");
                    BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200) {
                        String acl = response.getHeader("x-ms-prop-publicaccess");
                        boolean publicAcl = false;
                        if (acl != null) {
                            publicAcl = Boolean.parseBoolean(acl);
                            List identifiers = BlobContainerRest.this.getSignedIdentifiersFromResponse(response);
                            ContainerAccessControl aclEntity = null;
                            if (identifiers != null && identifiers.size() > 0) {
                                aclEntity = new ContainerAccessControl(publicAcl);
                                aclEntity.setSigendIdentifiers(identifiers);
                            } else {
                                aclEntity = publicAcl ? IContainerAccessControl.Public : IContainerAccessControl.Private;
                            }
                            return aclEntity;
                        }
                        throw new StorageServerException(StorageErrorCode.ServiceBadResponse, "The server did not respond with expected container access control header", response.getStatusCode(), null);
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw HttpUtilities.translateWebException(e);
        }
        return accessControl;
    }

    private List<SignedIdentifier> getSignedIdentifiersFromResponse(HttpWebResponse response) {
        InputStream stream = response.getStream();
        if (stream == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            Document doc = XmlUtil.load(stream, "Container access control parsed error.");
            List selectNodes = doc.selectNodes(XPathQueryHelper.SignedIdentifierListQuery);
            ArrayList<SignedIdentifier> result = new ArrayList<SignedIdentifier>();
            if (selectNodes.size() > 0) {
                for (Element element : selectNodes) {
                    SignedIdentifier identifier = new SignedIdentifier();
                    identifier.setId(XPathQueryHelper.loadSingleChildStringValue(element, "Id", true));
                    AccessPolicy policy = new AccessPolicy();
                    Element accesPlocy = (Element)element.selectSingleNode("AccessPolicy");
                    if (accesPlocy != null && accesPlocy.hasContent()) {
                        policy.setStart(new DateTime(XPathQueryHelper.loadSingleChildStringValue(accesPlocy, "Start", true)));
                        policy.setExpiry(new DateTime(XPathQueryHelper.loadSingleChildStringValue(accesPlocy, "Expiry", true)));
                        policy.setPermission(SharedAccessPermissions.valueOf(XPathQueryHelper.loadSingleChildStringValue(accesPlocy, "Permission", true)));
                        identifier.setPolicy(policy);
                    }
                    result.add(identifier);
                }
            }
            return result;
        }
        catch (Exception e) {
            Logger.error("Parse container accesss control error", e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public boolean deleteBlob(String name) throws StorageException {
        return this.deleteBlobImpl(name, null, new OutParameter<Boolean>(false));
    }

    @Override
    public boolean deleteBlobIfNotModified(IBlobProperties blob) throws StorageException {
        OutParameter<Boolean> modified = new OutParameter<Boolean>(false);
        boolean result = this.deleteBlobImpl(blob.getName(), blob.getETag(), modified);
        if (modified.getValue().booleanValue()) {
            throw new StorageException("The blob was not deleted because it was modified.");
        }
        return result;
    }

    private boolean deleteBlobImpl(final String name, final String eTag, OutParameter<Boolean> unused) throws StorageException {
        if (Utilities.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("Blob name cannot be null or empty!");
        }
        final OutParameter<Boolean> retval = new OutParameter<Boolean>(false);
        final OutParameter<Boolean> localModified = new OutParameter<Boolean>(false);
        this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String container = BlobContainerRest.this.getContainerName();
                if (container.equals("$root")) {
                    container = "";
                }
                ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), container, name);
                URI blobUri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), container, name, BlobContainerRest.this.getTimeout(), new NameValueCollection(), uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, "DELETE", BlobContainerRest.this.getTimeout());
                request.addHeader("x-ms-version", "2009-07-17");
                if (!Utilities.isNullOrEmpty(eTag)) {
                    request.addHeader("If-Match", eTag);
                }
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    int status = response.getStatusCode();
                    if (status == 200 || status == 202) {
                        retval.setValue(true);
                    } else if (status == 404 || status == 410) {
                        localModified.setValue(true);
                        HttpUtilities.processUnexpectedStatusCode(response);
                    } else if (status == 412 || status == 304) {
                        localModified.setValue(true);
                        HttpUtilities.processUnexpectedStatusCode(response);
                    } else {
                        HttpUtilities.processUnexpectedStatusCode(response);
                    }
                }
                catch (StorageException ioe) {
                    HttpUtilities.translateWebException(ioe);
                }
                return null;
            }
        });
        unused.setValue(localModified.getValue());
        return retval.getValue();
    }

    private IBlobProperties getBlobProperties(String name, BlobStream stream, boolean transferAsChunks) throws StorageException {
        Boolean notModified = false;
        try {
            return this.getBlobPropertiesImpl(name, stream, null, transferAsChunks, new OutParameter<Boolean>(notModified));
        }
        catch (Exception e) {
            throw HttpUtilities.translateWebException(e);
        }
    }

    private BlobProperties getBlobPropertiesImpl(final String blobName, final BlobStream stream, final String oldETag, boolean transferAsChunks, OutParameter<Boolean> modified) throws Exception {
        long originalPosition;
        if (Utilities.isNullOrEmpty(blobName)) {
            throw new IllegalArgumentException("Blob name cannot be null or empty!");
        }
        final BlobProperties[] blobProperties = new BlobProperties[1];
        final OutParameter<Boolean> localModified = new OutParameter<Boolean>(true);
        this.stopFetchProgress(Boolean.FALSE);
        if (stream == null || transferAsChunks) {
            this.getRetryPolicy().execute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    BlobProperties blob;
                    blobProperties[0] = blob = BlobContainerRest.this.downloadData(blobName, null, oldETag, null, 0L, 0L, new NameValueCollection(), localModified);
                    return blob;
                }
            });
            modified.setValue(localModified.getValue());
            if (stream == null) {
                return blobProperties[0];
            }
        }
        IRetryPolicy rp = stream.canSeek() ? this.getRetryPolicy() : RetryPolicies.noRetry();
        long l = originalPosition = stream.canSeek() ? stream.getPosition() : 0L;
        if (transferAsChunks && blobProperties != null && blobProperties[0].getContentLength() > 0L) {
            final long[] location = new long[]{0L};
            while (location[0] < blobProperties[0].getContentLength()) {
                if (this.isStopped()) {
                    throw new IOException("Download blob progress is terminated.");
                }
                final long nBytes = Math.min(blobProperties[0].getContentLength() - location[0], this.getBlockSize());
                rp.execute(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        if (stream.canSeek()) {
                            stream.setPosition(originalPosition + location[0]);
                        }
                        BlobContainerRest.this.downloadData(blobName, stream, oldETag, blobProperties[0].getETag(), location[0], nBytes, new NameValueCollection(), localModified);
                        return null;
                    }
                });
                location[0] = location[0] + nBytes;
            }
        } else {
            rp.execute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    BlobProperties blob;
                    if (stream.canSeek()) {
                        stream.setPosition(originalPosition);
                    }
                    blobProperties[0] = blob = BlobContainerRest.this.downloadData(blobName, stream, oldETag, null, 0L, 0L, new NameValueCollection(), localModified);
                    return blob;
                }
            });
        }
        modified.setValue(localModified.getValue());
        return blobProperties[0];
    }

    private BlobProperties downloadData(String blobName, BlobStream stream, String eTagIfNoneMatch, String eTagIfMatch, long offset, long length, NameValueCollection nvc, OutParameter<Boolean> localModified) throws StorageException {
        String container = this.getContainerName();
        if (container.equals("$root")) {
            container = "";
        }
        ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), container, blobName);
        URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), container, blobName, this.getTimeout(), nvc, uriComponents);
        String httpMethod = stream == null ? "HEAD" : "GET";
        HttpRequest request = this.createHttpRequestForGetBlob(blobUri, httpMethod, eTagIfNoneMatch, eTagIfMatch);
        if (offset != 0L || length != 0L) {
            String rangeHeaderValue = MessageFormat.format("bytes={0,number,#}-{1,number,#}", offset, offset + length - 1L);
            request.addHeader("x-ms-range", rangeHeaderValue);
        }
        request.addHeader("x-ms-version", "2009-09-19");
        this.credentials.signRequest(request, uriComponents);
        try {
            BlobProperties blobProperties;
            HttpWebResponse response = HttpUtilities.getResponse(request);
            if (response.getStatusCode() == 200 || response.getStatusCode() == 206) {
                blobProperties = this.blobPropertiesFromResponse(blobName, blobUri, response);
                if (stream != null) {
                    InputStream responseStream = response.getStream();
                    long byteCopied = Utilities.copyStream(responseStream, stream);
                    if (blobProperties.getContentLength() > 0L && byteCopied < blobProperties.getContentLength()) {
                        throw new StorageServerException(StorageErrorCode.ServiceTimeout, "Unable to read complete data from server", 408, null);
                    }
                }
            } else {
                HttpUtilities.processUnexpectedStatusCode(response);
                return null;
            }
            return blobProperties;
        }
        catch (Exception we) {
            throw HttpUtilities.translateWebException(we);
        }
    }

    private BlobProperties blobPropertiesFromResponse(String blobName, URI blobUri, HttpWebResponse response) throws URISyntaxException {
        BlobProperties blobProperties = new BlobProperties(blobName);
        blobProperties.setUri(this.constructBlobUri(blobName));
        blobProperties.setContentEncoding(response.getHeader("Content-Encoding"));
        blobProperties.setLastModifiedTime(response.getLastModified());
        blobProperties.setETag(response.getHeader("ETag"));
        blobProperties.setContentLanguage(response.getHeader("Content-Language"));
        blobProperties.setContentLength(response.getContentLength());
        blobProperties.setContentType(response.getContentType());
        NameValueCollection metadataEntries = this.metadataFromHeaders(response.getHeaders());
        if (metadataEntries.size() > 0) {
            blobProperties.setMetadata(metadataEntries);
        }
        return blobProperties;
    }

    private URI constructBlobUri(String blobName) {
        ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), this.getContainerName(), blobName);
        return HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), this.getContainerName(), blobName, null, new NameValueCollection(), uriComponents);
    }

    private URI removeQueryParams(URI blobUri) throws URISyntaxException {
        String uri = blobUri.toString();
        int pos = uri.indexOf(63);
        if (pos < 0) {
            return blobUri;
        }
        return new URI(uri.substring(0, pos));
    }

    private HttpRequest createHttpRequestForGetBlob(URI blobUri, String httpMethod, String tagIfNoneMatch, String tagIfMatch) {
        HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, httpMethod, this.getTimeout());
        if (tagIfNoneMatch != null) {
            request.addHeader("If-None-Match", tagIfNoneMatch);
        }
        if (tagIfMatch != null) {
            request.addHeader("If-Match", tagIfMatch);
        }
        return request;
    }

    @Override
    public Iterator<IBlobProperties> listBlobs() {
        return this.listBlobs(null, false);
    }

    @Override
    public Iterator<IBlobProperties> listBlobs(String prefix, boolean combineCommonPrefixes, int maxResults) throws StorageException {
        if (maxResults <= 0) {
            throw new IllegalArgumentException("maxResults should be positive value.");
        }
        ListBlobsResult all = new ListBlobsResult(new ArrayList<IBlobProperties>(), new ArrayList<String>(), "");
        String marker = "";
        String delimiter = combineCommonPrefixes ? "/" : Utilities.emptyString();
        List<IBlobProperties> blobs = all.getBlobsProperties();
        do {
            ListBlobsResult partResult = this.listBlobsImpl(prefix, marker, delimiter, maxResults);
            marker = partResult.getNextMarker();
            blobs.addAll(partResult.getBlobsProperties());
            all.getCommonPrefixs().addAll(partResult.getCommonPrefixs());
        } while (marker != null);
        if (blobs != null) {
            return blobs.iterator();
        }
        return null;
    }

    @Override
    public Iterator<IBlobProperties> listBlobs(String prefix, boolean combineCommonPrefixes) throws StorageException {
        int maxResults = 100;
        try {
            return this.listBlobs(prefix, combineCommonPrefixes, 100);
        }
        catch (StorageException se) {
            throw HttpUtilities.translateWebException(se);
        }
    }

    private ListBlobsResult listBlobsImpl(final String prefix, final String fromMarker, final String delimiter, final int maxResults) throws StorageException {
        final OutParameter result = new OutParameter();
        this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                NameValueCollection queryParameters = BlobContainerRest.this.createRequestUriForListing(prefix, fromMarker, delimiter, maxResults);
                ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null);
                queryParameters.put("restype", "container");
                URI uri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null, BlobContainerRest.this.getTimeout(), queryParameters, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "GET", BlobContainerRest.this.getTimeout());
                request.addHeader("x-ms-version", "2009-09-19");
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse(request);
                if (response.getStatusCode() == 200) {
                    result.setValue(BlobContainerRest.this.parseBlobFromResponse(response.getStream()));
                } else {
                    XmlUtil.load(response.getStream());
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                return null;
            }
        });
        return (ListBlobsResult)result.getValue();
    }

    private ListBlobsResult parseBlobFromResponse(InputStream stream) throws StorageServerException {
        ArrayList<IBlobProperties> blobs = new ArrayList<IBlobProperties>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        String nextMarker = null;
        Document document = XmlUtil.load(stream);
        List xmlNodes = document.selectNodes(XPathQueryHelper.CommonPrefixQuery);
        for (Element element : xmlNodes) {
            String blobPrefix = XPathQueryHelper.loadSingleChildStringValue(element, "Name", false);
            commonPrefixes.add(blobPrefix);
        }
        xmlNodes = document.selectNodes(XPathQueryHelper.BlobQuery);
        for (Element blobNode : xmlNodes) {
            Element propNode = blobNode.element("Properties");
            if (propNode == null) {
                blobs.add(this.parseBlobInfo(blobNode));
                continue;
            }
            blobs.add(this.parseBlobInfo2(blobNode, propNode));
        }
        Element nextMarkerNode = (Element)document.selectSingleNode(XPathQueryHelper.NextMarkerQuery);
        if (nextMarkerNode != null && nextMarkerNode.hasContent()) {
            nextMarker = nextMarkerNode.getStringValue();
        }
        return new ListBlobsResult(blobs, commonPrefixes, nextMarker);
    }

    private BlobProperties parseBlobInfo(Element blobNode) {
        String blobUrl = XPathQueryHelper.loadSingleChildStringValue(blobNode, "Url", true);
        String blobName = XPathQueryHelper.loadSingleChildStringValue(blobNode, "Name", true);
        Timestamp lastModified = XPathQueryHelper.loadSingleChildDateTimeValue(blobNode, "LastModified", false);
        String eTag = XPathQueryHelper.loadSingleChildStringValue(blobNode, "Etag", false);
        String contentType = XPathQueryHelper.loadSingleChildStringValue(blobNode, "ContentType", false);
        String contentEncoding = XPathQueryHelper.loadSingleChildStringValue(blobNode, "ContentEncoding", false);
        String contentLanguage = XPathQueryHelper.loadSingleChildStringValue(blobNode, "ContentLanguage", false);
        Long blobSize = XPathQueryHelper.loadSingleChildLongValue(blobNode, "Size", false);
        BlobProperties properties = new BlobProperties(blobName);
        if (lastModified != null) {
            properties.setLastModifiedTime(lastModified);
        }
        properties.setContentType(contentType);
        properties.setContentEncoding(contentEncoding);
        properties.setContentLanguage(contentLanguage);
        properties.setETag(eTag);
        properties.setContentLength(blobSize);
        blobUrl = Utilities.fixRootContainer(blobUrl);
        blobUrl = blobUrl.replaceAll(" ", "%20");
        properties.setUri(URI.create(blobUrl));
        return properties;
    }

    private BlobProperties parseBlobInfo2(Element blobNode, Element propNode) {
        String blobUrl = XPathQueryHelper.loadSingleChildStringValue(blobNode, "Url", true);
        String blobName = XPathQueryHelper.loadSingleChildStringValue(blobNode, "Name", true);
        String snapshot = XPathQueryHelper.loadSingleChildStringValue(blobNode, "Snapshot", false);
        String blobType = XPathQueryHelper.loadSingleChildStringValue(propNode, "BlobType", false);
        String leaseStatus = XPathQueryHelper.loadSingleChildStringValue(propNode, "LeaseStatus", false);
        Timestamp lastModified = XPathQueryHelper.loadSingleChildDateTimeValue(propNode, "Last-Modified", false);
        String eTag = XPathQueryHelper.loadSingleChildStringValue(propNode, "Etag", false);
        String contentType = XPathQueryHelper.loadSingleChildStringValue(propNode, "Content-Type", false);
        String contentEncoding = XPathQueryHelper.loadSingleChildStringValue(propNode, "Content-Encoding", false);
        String contentLanguage = XPathQueryHelper.loadSingleChildStringValue(propNode, "Content-Language", false);
        Long blobSize = XPathQueryHelper.loadSingleChildLongValue(propNode, "Content-Length", false);
        BlobProperties properties = new BlobProperties(blobName);
        if (lastModified != null) {
            properties.setLastModifiedTime(lastModified);
        }
        properties.setContentType(contentType);
        properties.setContentEncoding(contentEncoding);
        properties.setContentLanguage(contentLanguage);
        properties.setETag(eTag);
        if (blobSize != null) {
            properties.setContentLength(blobSize);
        }
        blobUrl = Utilities.fixRootContainer(blobUrl);
        blobUrl = blobUrl.replaceAll(" ", "%20");
        properties.setUri(URI.create(blobUrl));
        properties.setBlobType(BlobType.parse(blobType));
        properties.setLeaseStatus(LeaseStatus.parse(leaseStatus));
        if (snapshot != null) {
            try {
                properties.setSnapshot(Utilities.tryGetDateTimeFromTableEntry(snapshot));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return properties;
    }

    private NameValueCollection createRequestUriForListing(String prefix, String fromMarker, String delimiter, int maxResults) {
        NameValueCollection queryParams = new NameValueCollection();
        queryParams.put("comp", "list");
        if (!Utilities.isNullOrEmpty(prefix)) {
            queryParams.put("prefix", prefix);
        }
        if (!Utilities.isNullOrEmpty(fromMarker)) {
            queryParams.put("marker", fromMarker);
        }
        if (!Utilities.isNullOrEmpty(delimiter)) {
            queryParams.put("delimiter", delimiter);
        }
        queryParams.put("maxresults", Integer.toString(maxResults));
        return queryParams;
    }

    @Override
    public boolean isBlobIfModified(BlobProperties blobProperties, IBlobContents blobContents, boolean transferAsChunks) throws StorageException {
        try {
            OutParameter<Boolean> modified = new OutParameter<Boolean>(true);
            BlobProperties newBlob = this.getBlobPropertiesImpl(blobProperties.getName(), blobContents.getStream(), blobProperties.getETag(), transferAsChunks, modified);
            if (modified.getValue().booleanValue()) {
                blobProperties.assign(newBlob);
            }
            return modified.getValue();
        }
        catch (Exception e) {
            throw HttpUtilities.translateWebException(e);
        }
    }

    @Override
    public IBlob getBlob(String name, BlobStream blobContentsStream, boolean transferAsChunks) throws StorageException {
        IBlobProperties blobProperties = this.getBlobProperties(name, blobContentsStream, transferAsChunks);
        BlobContents blobContents = new BlobContents(blobContentsStream);
        return new Blob(blobContents, blobProperties);
    }

    @Override
    public IBlobProperties getBlobProperties(String name) throws StorageException {
        try {
            boolean modified = false;
            return this.getBlobPropertiesImpl(name, null, null, false, new OutParameter<Boolean>(modified));
        }
        catch (Exception e) {
            throw HttpUtilities.translateWebException(e);
        }
    }

    @Override
    public void updateBlobMetadata(IBlobProperties blobProperties) throws StorageException {
        this.setBlobMetadataImpl(blobProperties, null);
    }

    private boolean setBlobMetadataImpl(final IBlobProperties blobProperties, final String eTag) {
        if (blobProperties == null) {
            throw new IllegalArgumentException("Blob properties cannot be null or empty!");
        }
        final OutParameter<Boolean> retval = new OutParameter<Boolean>(false);
        this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                NameValueCollection queryParams = new NameValueCollection();
                queryParams.put("comp", "metadata");
                ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), blobProperties.getName());
                URI uri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), blobProperties.getName(), BlobContainerRest.this.getTimeout(), queryParams, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "PUT", BlobContainerRest.this.getTimeout());
                if (blobProperties.getMetadata() != null) {
                    HttpUtilities.addMetadataHeaders(request, blobProperties.getMetadata());
                }
                if (!Utilities.isNullOrEmpty(eTag)) {
                    request.addHeader("If-Match", eTag);
                }
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse(request);
                int statusCode = response.getStatusCode();
                if (statusCode == 200) {
                    retval.setValue(true);
                    blobProperties.setLastModifiedTime(response.getLastModified());
                    blobProperties.setETag(response.getHeader("ETag"));
                } else if (statusCode == 412 || statusCode == 304) {
                    retval.setValue(false);
                } else {
                    retval.setValue(false);
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                return null;
            }
        });
        return retval.getValue();
    }

    @Override
    public boolean copyBlob(String destContainer, String destBlobName, String sourceBlobName) throws StorageException {
        return this.copyBlobImpl(destContainer, destBlobName, sourceBlobName, null, null);
    }

    @Override
    public boolean copyBlob(String destContainer, String destBlobName, String sourceBlobName, NameValueCollection metadata, IBlobConstraints constraints) throws StorageException {
        return this.copyBlobImpl(destContainer, destBlobName, sourceBlobName, metadata, constraints);
    }

    private boolean copyBlobImpl(String destContainer, String destBlobName, final String sourceBlobName, final NameValueCollection metadata, final IBlobConstraints constraints) throws StorageException {
        String blob;
        if (Utilities.isNullOrEmpty(sourceBlobName)) {
            throw new IllegalArgumentException("Source blob name cannot be null or empty!");
        }
        final String container = Utilities.isNullOrEmpty(destContainer) ? this.getContainerName() : destContainer;
        String string = blob = Utilities.isNullOrEmpty(destBlobName) ? sourceBlobName : destBlobName;
        if (container.equals(this.getContainerName()) && blob.equals(sourceBlobName)) {
            throw new IllegalArgumentException("Destnation blob and source blob could not be the same.");
        }
        final OutParameter<Boolean> retval = new OutParameter<Boolean>(false);
        this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), container, blob);
                URI uri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), container, blob, BlobContainerRest.this.getTimeout(), null, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "PUT", BlobContainerRest.this.getTimeout());
                request.addHeader("x-ms-version", "2009-07-17");
                String blobName = BlobContainerRest.this.createCopySourceHeaderValue(sourceBlobName).replaceAll(" ", "%20");
                request.addHeader("x-ms-copy-source", blobName);
                BlobContainerRest.this.addMoreConstraints(constraints, request);
                if (metadata != null) {
                    HttpUtilities.addMetadataHeaders(request, metadata);
                }
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse(request);
                int statusCode = response.getStatusCode();
                if (statusCode == 201) {
                    retval.setValue(true);
                } else {
                    retval.setValue(false);
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                return retval;
            }
        });
        return retval.getValue();
    }

    private void addMoreConstraints(IBlobConstraints constraints, HttpRequest request) {
        List<BasicHeader> headers;
        if (constraints != null && (headers = constraints.getConstraints()) != null && !headers.isEmpty()) {
            for (BasicHeader header : headers) {
                request.addHeader((Header)header);
            }
        }
    }

    private String createCopySourceHeaderValue(String sourceBlobName) {
        return String.format("/%s/%s/%s", this.getAccountName(), this.getContainerName(), sourceBlobName);
    }

    @Override
    public boolean updateBlobMetadataIfNotModified(IBlobProperties blobProperties) throws StorageException {
        return this.setBlobMetadataImpl(blobProperties, blobProperties.getETag());
    }

    @Override
    public void clearSharedAccessUrl() {
        this.shareAccessUrl = null;
        if (this.credentials instanceof SharedKeyCredentialsWrapper) {
            SharedKeyCredentialsWrapper warpper = (SharedKeyCredentialsWrapper)this.credentials;
            this.credentials = warpper.getCredentials();
        }
    }

    @Override
    public void useSharedAccessUrl(ISharedAccessUrl url) {
        if (url == null) {
            throw new IllegalArgumentException("Share access url invalid");
        }
        this.shareAccessUrl = url;
        this.credentials = new SharedKeyCredentialsWrapper(this.credentials, this.shareAccessUrl, this);
    }

    public ISharedAccessUrl getShareAccessUrl() {
        return this.shareAccessUrl;
    }

    @Override
    public Timestamp createSnapshot(IBlobProperties blobProperties, final NameValueCollection headerParameters) throws StorageException {
        String container = this.getContainerName();
        if (container.equals("$root")) {
            container = "";
        }
        String blobName = blobProperties.getName();
        NameValueCollection queryParams = new NameValueCollection();
        queryParams.put("comp", "snapshot");
        final ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), container, blobName);
        final URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), container, blobName, this.getTimeout(), queryParams, uriComponents);
        Timestamp result = (Timestamp)this.getRetryPolicy().execute(new Callable<Timestamp>(){

            @Override
            public Timestamp call() throws Exception {
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, "PUT", BlobContainerRest.this.getTimeout());
                request.addHeader("x-ms-version", "2009-09-19");
                BlobContainerRest.this.appendHeaders(request, headerParameters);
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    int status = response.getStatusCode();
                    if (status == 201) {
                        String snapshot = response.getHeader("x-ms-snapshot");
                        return Utilities.tryGetDateTimeFromTableEntry(snapshot);
                    }
                }
                catch (Exception ioe) {
                    HttpUtilities.translateWebException(ioe);
                }
                return null;
            }
        });
        return result;
    }

    @Override
    public String leaseBlob(IBlobProperties blobProperties, final LeaseMode mode, final NameValueCollection headerParameters) throws StorageException {
        String container = this.getContainerName();
        if (container.equals("$root")) {
            container = "";
        }
        String blobName = blobProperties.getName();
        NameValueCollection queryParams = new NameValueCollection();
        queryParams.put("comp", "lease");
        final ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), container, blobName);
        final URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), container, blobName, null, queryParams, uriComponents);
        String id = (String)this.getRetryPolicy().execute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, "PUT", null);
                request.addHeader("x-ms-version", "2009-09-19");
                request.addHeader("x-ms-lease-action", mode.getLiteral());
                BlobContainerRest.this.appendHeaders(request, headerParameters);
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    int status = response.getStatusCode();
                    if (status == 201 || status == 200 || status == 202) {
                        return response.getHeader("x-ms-lease-id");
                    }
                }
                catch (Exception ioe) {
                    HttpUtilities.translateWebException(ioe);
                }
                return null;
            }
        });
        return id;
    }

    private void appendHeaders(HttpRequest request, NameValueCollection headerParameters) {
        if (headerParameters == null || headerParameters.size() == 0) {
            return;
        }
        for (Object key : headerParameters.keySet()) {
            String value = headerParameters.getMultipleValuesAsString((String)key);
            if (value == null) continue;
            request.addHeader(key.toString(), value);
        }
    }

    @Override
    public void createPage(IBlobProperties blobProperties, final int size, final NameValueCollection headerParameters) throws StorageException {
        String blobName = blobProperties.getName();
        if (blobName == null || blobName.equals("")) {
            throw new IllegalArgumentException("Blob name is empty.");
        }
        String container = this.getContainerName();
        if (container.equals("$root")) {
            container = "";
        }
        final ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), container, blobName);
        final URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), container, blobName, null, new NameValueCollection(), uriComponents);
        this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, "PUT", null);
                request.addHeader("x-ms-version", "2009-09-19");
                request.addHeader("x-ms-blob-type", BlobType.PageBlob.getLiteral());
                request.addHeader("x-ms-blob-content-length", String.valueOf(size));
                BlobContainerRest.this.appendHeaders(request, headerParameters);
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    int status = response.getStatusCode();
                    if (status == 201) {
                        return Boolean.TRUE;
                    }
                }
                catch (Exception ioe) {
                    HttpUtilities.translateWebException(ioe);
                }
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public List<PageRange> getPageRegions(IBlobProperties blobProperties, final NameValueCollection headerParameters) throws StorageException {
        String blobName = blobProperties.getName();
        if (blobName == null || blobName.equals("")) {
            throw new IllegalArgumentException("Blob name is empty.");
        }
        String container = this.getContainerName();
        if (container.equals("$root")) {
            container = "";
        }
        NameValueCollection queryParams = new NameValueCollection();
        queryParams.put("comp", "pagelist");
        final ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), container, blobName);
        final URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), container, blobName, null, queryParams, uriComponents);
        List result = (List)this.getRetryPolicy().execute(new Callable<List<PageRange>>(){

            @Override
            public List<PageRange> call() throws Exception {
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, "GET", null);
                request.addHeader("x-ms-version", "2009-09-19");
                BlobContainerRest.this.appendHeaders(request, headerParameters);
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200) {
                        return BlobContainerRest.this.parsePageRegions(response.getStream());
                    }
                    XmlUtil.load(response.getStream());
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        return result;
    }

    private List<PageRange> parsePageRegions(InputStream stream) {
        ArrayList<PageRange> ranges = new ArrayList<PageRange>();
        Document document = XmlUtil.load(stream);
        List xmlNodes = document.selectNodes(XPathQueryHelper.PageRangeQuery);
        for (Element node : xmlNodes) {
            String start = XPathQueryHelper.loadSingleChildStringValue(node, "Start", true);
            String end = XPathQueryHelper.loadSingleChildStringValue(node, "End", true);
            ranges.add(new PageRange(Integer.parseInt(start), Integer.parseInt(end)));
        }
        return ranges;
    }

    @Override
    public void writePages(IBlobProperties blobProperties, final BlobStream pageData, final IPageRange range, final NameValueCollection headerParameters) throws StorageException {
        String blobName = blobProperties.getName();
        if (blobName == null || blobName.equals("")) {
            throw new IllegalArgumentException("Blob name is empty.");
        }
        String container = this.getContainerName();
        if (container.equals("$root")) {
            container = "";
        }
        NameValueCollection queryParams = new NameValueCollection();
        queryParams.put("comp", "page");
        final ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), container, blobName);
        final URI blobUri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), container, blobName, this.getTimeout(), queryParams, uriComponents);
        this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(blobUri, "PUT", BlobContainerRest.this.getTimeout());
                request.addHeader("x-ms-version", "2009-09-19");
                request.addHeader("Range", range.toString());
                BlobContainerRest.this.appendHeaders(request, headerParameters);
                try {
                    if (pageData == null) {
                        request.addHeader("x-ms-page-write", "clear");
                        BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                    } else {
                        request.addHeader("x-ms-page-write", "update");
                        request.addHeader("Content-Length", String.valueOf(range.length()));
                        BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                        BlobMemoryStream requestStream = new BlobMemoryStream();
                        Utilities.copyStream(pageData, requestStream, range.length());
                        ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(requestStream.getBytes()));
                    }
                    request.removeHeaders("Content-Length");
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 201) {
                        return Boolean.TRUE;
                    }
                    XmlUtil.load(response.getStream());
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public void setContainerMetadata(final NameValueCollection metadata) {
        this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null);
                NameValueCollection queryParams = new NameValueCollection();
                queryParams.put("comp", "metadata");
                queryParams.put("restype", "container");
                URI uri = HttpUtilities.createRequestUri(BlobContainerRest.this.getBaseUri(), BlobContainerRest.this.isUsePathStyleUris(), BlobContainerRest.this.getAccountName(), BlobContainerRest.this.getContainerName(), null, BlobContainerRest.this.getTimeout(), queryParams, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "PUT", BlobContainerRest.this.getTimeout());
                if (metadata != null) {
                    HttpUtilities.addMetadataHeaders(request, metadata);
                }
                request.addHeader("x-ms-version", "2009-07-17");
                BlobContainerRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200) {
                        return true;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
    }

    @Override
    public String getLastStatus() {
        return this.lastStatus;
    }
}

