/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.internal;

import java.net.URI;
import java.sql.Timestamp;
import java.util.Map;
import org.soyatec.windows.azure.blob.BlobType;
import org.soyatec.windows.azure.blob.IBlobProperties;
import org.soyatec.windows.azure.blob.LeaseStatus;
import org.soyatec.windows.azure.util.NameValueCollection;

public class BlobProperties
implements IBlobProperties {
    private String name;
    private URI uri;
    private String contentEncoding;
    private String contentType;
    private String contentLanguage;
    private long contentLength;
    private NameValueCollection metadata;
    private Timestamp lastModifiedTime;
    private String eTag;
    private Timestamp snapshot;
    private BlobType blobType;
    private LeaseStatus leaseStatus;

    public BlobProperties(String name) {
        this.name = name;
    }

    void assign(BlobProperties other) {
        this.name = other.name;
        this.uri = other.uri;
        this.contentEncoding = other.contentEncoding;
        this.contentLength = other.contentLength;
        this.contentType = other.contentType;
        this.eTag = other.eTag;
        this.lastModifiedTime = other.lastModifiedTime;
        if (other.metadata != null) {
            this.metadata = new NameValueCollection();
            this.metadata.putAll((Map)((Object)other.metadata));
        }
    }

    public String getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public NameValueCollection getMetadata() {
        return this.metadata;
    }

    public Timestamp getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getETag() {
        return this.eTag;
    }

    void setName(String name) {
        this.name = name;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setMetadata(NameValueCollection metadata) {
        this.metadata = metadata;
    }

    public void setLastModifiedTime(Timestamp lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public void setETag(String tag) {
        this.eTag = tag;
    }

    public Timestamp getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Timestamp snapshot) {
        this.snapshot = snapshot;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public void setBlobType(BlobType blobType) {
        this.blobType = blobType;
    }

    public LeaseStatus getLeaseStatus() {
        return this.leaseStatus;
    }

    public void setLeaseStatus(LeaseStatus leaseStatus) {
        this.leaseStatus = leaseStatus;
    }
}

