/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.internal;

import java.util.ArrayList;
import java.util.List;
import org.soyatec.windows.azure.authenticate.ISignedIdentifier;
import org.soyatec.windows.azure.blob.IContainerAccessControl;
import org.soyatec.windows.azure.internal.SignedIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerAccessControl
implements IContainerAccessControl {
    private boolean isPublic;
    private boolean isMutable;
    private List<SignedIdentifier> sigendIdentifiers;

    public ContainerAccessControl(boolean isPublic) {
        this(isPublic, true);
    }

    public ContainerAccessControl(boolean isPublic, boolean isMutable) {
        this.isPublic = isPublic;
        this.isMutable = isMutable;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public IContainerAccessControl addSignedIdentifier(SignedIdentifier id) {
        if (!this.isMutable) {
            throw new IllegalStateException("The built-in instance is not mutable! Please create a new instance by yourself.");
        }
        this.getSigendIdentifiers().add(id);
        return this;
    }

    @Override
    public int getSize() {
        return this.getSigendIdentifiers().size();
    }

    @Override
    public ISignedIdentifier getSignedIdentifier(int index) {
        List<SignedIdentifier> list = this.getSigendIdentifiers();
        if (index > list.size()) {
            return null;
        }
        return list.get(index);
    }

    @Override
    public List<SignedIdentifier> getSigendIdentifiers() {
        if (this.sigendIdentifiers == null) {
            this.sigendIdentifiers = new ArrayList<SignedIdentifier>();
        }
        return this.sigendIdentifiers;
    }

    @Override
    public void setSigendIdentifiers(List<SignedIdentifier> sigendIdentifiers) {
        if (!this.isMutable) {
            throw new IllegalStateException("The built-in instance is not mutable! Please create a new instance by yourself.");
        }
        this.sigendIdentifiers = sigendIdentifiers;
    }
}

