/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.internal;

import java.util.Random;
import java.util.concurrent.Callable;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.TimeSpan;

public class RetryPolicies {
    public static final TimeSpan StandardMinBackoff = TimeSpan.fromMilliseconds(100L);
    public static final TimeSpan StandardMaxBackoff = TimeSpan.fromSeconds(30L);
    private static final Random Random = new Random();

    public static IRetryPolicy noRetry() {
        return new NoRetry();
    }

    public static IRetryPolicy retryN(int numberOfRetries, TimeSpan intervalBetweenRetries) {
        return new RetryN(numberOfRetries, intervalBetweenRetries);
    }

    public static IRetryPolicy retryExponentialN(int numberOfRetries, TimeSpan deltaBackoff) {
        return new RetryExponentialN(numberOfRetries, StandardMinBackoff, StandardMaxBackoff, deltaBackoff);
    }

    public static IRetryPolicy retryExponentialN(int numberOfRetries, TimeSpan minBackoff, TimeSpan maxBackoff, TimeSpan deltaBackoff) {
        if (minBackoff.compareTo(maxBackoff) > 0L) {
            throw new IllegalArgumentException("The minimum backoff must not be larger than the maximum backoff period.");
        }
        if (minBackoff.compareTo(TimeSpan.ZERO) < 0L) {
            throw new IllegalArgumentException("The minimum backoff period must not be negative.");
        }
        return new RetryExponentialN(numberOfRetries, minBackoff, maxBackoff, deltaBackoff);
    }

    static class RetryExponentialN
    implements IRetryPolicy {
        private int numberOfRetries;
        private TimeSpan minBackoff;
        private TimeSpan maxBackoff;
        private TimeSpan deltaBackoff;

        public RetryExponentialN(int numberOfRetries, TimeSpan minBackoff, TimeSpan maxBackoff, TimeSpan deltaBackoff) {
            this.numberOfRetries = numberOfRetries;
            this.minBackoff = minBackoff;
            this.maxBackoff = maxBackoff;
            this.deltaBackoff = deltaBackoff;
        }

        public Object execute(Callable action) throws StorageException {
            int totalNumberOfRetries = this.numberOfRetries;
            if (this.minBackoff.compareTo(this.maxBackoff) > 0L) {
                throw new IllegalArgumentException("The minimum backoff must not be larger than the maximum backoff period.");
            }
            if (this.minBackoff.compareTo(TimeSpan.ZERO) < 0L) {
                throw new IllegalArgumentException("The minimum backoff period must not be negative.");
            }
            while (true) {
                try {
                    return action.call();
                }
                catch (Exception e) {
                    if (this.numberOfRetries == 0) {
                        throw HttpUtilities.translateWebException(e);
                    }
                    TimeSpan backoff = this.calculateCurrentBackoff(this.minBackoff, this.maxBackoff, this.deltaBackoff, totalNumberOfRetries - this.numberOfRetries);
                    if (backoff.compareTo(TimeSpan.ZERO) <= 0L) continue;
                    try {
                        Thread.sleep(backoff.toMilliseconds());
                        continue;
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (this.numberOfRetries-- > 0) continue;
                    return null;
                }
                break;
            }
        }

        private TimeSpan calculateCurrentBackoff(TimeSpan minBackoff, TimeSpan maxBackoff, TimeSpan deltaBackoff, int curRetry) {
            TimeSpan backoff;
            if (curRetry > 30) {
                backoff = maxBackoff;
            } else {
                try {
                    long delay = Random.nextInt((1 << curRetry) + 1);
                    delay *= deltaBackoff.toMilliseconds();
                    backoff = TimeSpan.fromMilliseconds(delay += minBackoff.toMilliseconds());
                }
                catch (ArithmeticException e) {
                    backoff = maxBackoff;
                }
                if (backoff.compareTo(maxBackoff) > 0L) {
                    backoff = maxBackoff;
                }
            }
            return backoff;
        }
    }

    static class RetryN
    implements IRetryPolicy {
        private int numberOfRetries;
        private TimeSpan intervalBetweenRetries;

        public RetryN(int numberOfRetries, TimeSpan intervalBetweenRetries) {
            this.numberOfRetries = numberOfRetries;
            this.intervalBetweenRetries = intervalBetweenRetries;
        }

        public Object execute(Callable action) throws StorageException {
            while (true) {
                try {
                    return action.call();
                }
                catch (Exception e) {
                    if (this.numberOfRetries == 0) {
                        throw HttpUtilities.translateWebException(e);
                    }
                    if (this.intervalBetweenRetries.compareTo(TimeSpan.ZERO) <= 0L) continue;
                    try {
                        Thread.sleep(this.intervalBetweenRetries.toMilliseconds());
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.numberOfRetries-- > 0) continue;
                    return null;
                }
                break;
            }
        }
    }

    static class NoRetry
    implements IRetryPolicy {
        NoRetry() {
        }

        public Object execute(Callable action) throws StorageException {
            try {
                return action.call();
            }
            catch (Exception e) {
                throw HttpUtilities.translateWebException(e);
            }
        }
    }
}

