/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.internal;

import org.soyatec.windows.azure.blob.ISharedAccessUrl;

public class SharedAccessUrl
implements ISharedAccessUrl {
    private String accountName;
    private String blobName;
    private String containerName;
    private String signedResource;
    private String signedStart;
    private String signedExpiry;
    private String signedPermissions;
    private String signedIdentifier;
    private String signature;
    private String restUrl;
    private String signedString;

    public static ISharedAccessUrl parse(String url) {
        String[] params;
        SharedAccessUrl share = new SharedAccessUrl();
        String[] parts = url.split("\\?");
        share.restUrl = parts[0];
        share.signedString = parts[1];
        int pos = url.indexOf(".blob.core.windows.net");
        if (pos > -1) {
            share.accountName = url.substring("http://".length(), pos);
            url = url.substring(pos + ".blob.core.windows.net/".length(), url.indexOf(63));
        } else {
            pos = url.indexOf("blob.core.windows.net/") + "blob.core.windows.net/".length();
            share.accountName = url.substring(pos, url.indexOf(47, pos));
            url = url.substring(url.indexOf(47, pos) + 1, url.indexOf(63, pos));
        }
        parts = url.split("/");
        share.containerName = parts[0];
        if (parts.length > 1) {
            share.blobName = parts[1];
        }
        for (String param : params = share.signedString.split("&")) {
            if (param.indexOf("st=") > -1) {
                share.signedStart = param.substring(3);
                continue;
            }
            if (param.indexOf("sr=") > -1) {
                share.signedResource = param.substring(3);
                continue;
            }
            if (param.indexOf("se=") > -1) {
                share.signedExpiry = param.substring(3);
                continue;
            }
            if (param.indexOf("sp=") > -1) {
                share.signedPermissions = param.substring(3);
                continue;
            }
            if (param.indexOf("si=") > -1) {
                share.signedIdentifier = param.substring(3);
                continue;
            }
            if (param.indexOf("sig=") <= -1) continue;
            share.signature = param.substring(4);
        }
        return share;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public void setBlobName(String blobName) {
        this.blobName = blobName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getSignedResource() {
        return this.signedResource;
    }

    public void setSignedResource(String signedResource) {
        this.signedResource = signedResource;
    }

    public String getSignedStart() {
        return this.signedStart;
    }

    public void setSignedStart(String signedStart) {
        this.signedStart = signedStart;
    }

    public String getSignedExpiry() {
        return this.signedExpiry;
    }

    public void setSignedExpiry(String signedExpiry) {
        this.signedExpiry = signedExpiry;
    }

    public String getSignedPermissions() {
        return this.signedPermissions;
    }

    public void setSignedPermissions(String signedPermissions) {
        this.signedPermissions = signedPermissions;
    }

    public String getSignedIdentifier() {
        return this.signedIdentifier;
    }

    public void setSignedIdentifier(String signedIdentifier) {
        this.signedIdentifier = signedIdentifier;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getRestUrl() {
        return this.restUrl;
    }

    public void setRestUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    public String getSignedString() {
        return this.signedString;
    }

    public void setSignedString(String signedString) {
        this.signedString = signedString;
    }

    public String toString() {
        return "ShareAccessUrl [accountName=" + this.accountName + ", blobName=" + this.blobName + ", containerName=" + this.containerName + ", restUrl=" + this.restUrl + ", signature=" + this.signature + ", signedExpiry=" + this.signedExpiry + ", signedIdentifier=" + this.signedIdentifier + ", signedPermissions=" + this.signedPermissions + ", signedResource=" + this.signedResource + ", signedStart=" + this.signedStart + ", signedString=" + this.signedString + "]";
    }
}

