/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.soyatec.windows.azure.blob.io.BlobStream;

public class BlobFileStream
implements BlobStream {
    private RandomAccessFile file;

    public BlobFileStream(File file) throws IOException {
        this.file = new RandomAccessFile(file, "rw");
    }

    public BlobFileStream(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        this.file = new RandomAccessFile(file, "rw");
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public long getPosition() throws IOException {
        return this.file.getFilePointer();
    }

    public int read(byte[] b) throws IOException {
        return this.file.read(b);
    }

    public void write(byte[] buffer, int off, int len) throws IOException {
        this.file.write(buffer, off, len);
    }

    public boolean canSeek() {
        return true;
    }

    public byte[] getBytes() throws IOException {
        byte[] buf = new byte[(int)this.file.length()];
        this.file.readFully(buf);
        return buf;
    }

    public void setPosition(long position) throws IOException {
        this.file.seek(position);
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        return this.file.read(buffer, offset, len);
    }
}

