/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.soyatec.windows.azure.blob.io.BlobStream;

public class BlobMemoryStream
implements BlobStream {
    private ByteBuffer bytes;
    private ByteArrayOutputStream stream;

    public BlobMemoryStream(byte[] buf) {
        this.bytes = ByteBuffer.wrap(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobMemoryStream(InputStream input) throws IOException {
        byte[] block = new byte[1024];
        try {
            int length;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(input.available());
            while ((length = input.read(block)) >= 0) {
                buf.write(block, 0, length);
            }
            this.bytes = ByteBuffer.wrap(buf.toByteArray());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            input.close();
            throw throwable;
        }
        input.close();
    }

    public BlobMemoryStream() {
        this.stream = new ByteArrayOutputStream();
    }

    public BlobMemoryStream(byte[] buf, int offset, int length) {
        this.bytes = ByteBuffer.wrap(buf, offset, length);
    }

    public void close() throws IOException {
        if (this.bytes != null) {
            this.bytes.clear();
        }
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public long length() throws IOException {
        if (this.bytes != null) {
            return this.bytes.limit();
        }
        return this.stream.size();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.bytes != null) {
            int length = this.bytes.remaining();
            if (length > len) {
                length = len;
            }
            this.bytes.get(buffer, offset, length);
            return length;
        }
        throw new IOException("The stream is not readable.");
    }

    public void write(byte[] buffer, int offset, int len) throws IOException {
        if (this.stream == null) {
            throw new IOException("The stream is not writable.");
        }
        this.stream.write(buffer, offset, len);
    }

    public boolean canSeek() {
        return this.bytes != null;
    }

    public byte[] getBytes() throws IOException {
        if (this.stream != null) {
            return this.stream.toByteArray();
        }
        return this.bytes.array();
    }

    public long getPosition() throws IOException {
        if (this.bytes != null) {
            return this.bytes.position();
        }
        throw new IOException("The stream is seekable.");
    }

    public void setPosition(long position) throws IOException {
        if (this.bytes == null) {
            throw new IOException("The stream is seekable.");
        }
        this.bytes.position((int)position);
    }
}

