/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.internal;

import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.soyatec.windows.azure.authenticate.HttpRequestAccessor;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.Utilities;

public class MessageCanonicalizer2 {
    public static String canonicalizeHttpRequest(HttpRequest request, ResourceUriComponents uriComponents) {
        if (!(request instanceof HttpUriRequest)) {
            throw new IllegalArgumentException("Request should be a URI http request");
        }
        HttpUriRequest rq = (HttpUriRequest)request;
        return MessageCanonicalizer2.canonicalizeHttpRequest(rq.getURI(), uriComponents, rq.getMethod(), HttpUtilities.parseRequestContentType((HttpRequest)rq), Utilities.emptyString(), HttpUtilities.parseHttpHeaders((HttpRequest)rq));
    }

    public static String canonicalizeHttpRequestForSharedKeyLite(HttpRequest request, ResourceUriComponents uriComponents, String date) {
        if (!(request instanceof HttpUriRequest)) {
            throw new IllegalArgumentException("Request should be a URI http request");
        }
        StringBuilder canonicalizedString = new StringBuilder(date);
        MessageCanonicalizer2.appendStringToCanonicalizedString(canonicalizedString, MessageCanonicalizer2.getCanonicalizedResource(((HttpUriRequest)request).getURI(), uriComponents));
        return canonicalizedString.toString();
    }

    private static String appendStringToCanonicalizedString(StringBuilder canonicalizedString, String stringToAppend) {
        canonicalizedString.append("\n");
        canonicalizedString.append(stringToAppend);
        return canonicalizedString.toString();
    }

    private static String extractHeader(NameValueCollection headers, String headerName) {
        String value = Utilities.emptyString();
        List<String> httpContentMD5Values = HttpRequestAccessor.getHeaderValues(headers, headerName);
        if (httpContentMD5Values != null && httpContentMD5Values.size() == 1) {
            value = httpContentMD5Values.get(0);
        }
        return value;
    }

    public static String canonicalizeHttpRequest(URI address, ResourceUriComponents uriComponents, String method, String contentType, String date, NameValueCollection headers) {
        CanonicalizedString canonicalizedString = new CanonicalizedString(method);
        canonicalizedString.appendCanonicalizedElement(MessageCanonicalizer2.extractHeader(headers, "Content-Encoding"));
        canonicalizedString.appendCanonicalizedElement(MessageCanonicalizer2.extractHeader(headers, "Content-Language"));
        String length = MessageCanonicalizer2.extractHeader(headers, "Content-Length");
        if (length.equals("")) {
            length = "0";
        }
        canonicalizedString.appendCanonicalizedElement(length);
        canonicalizedString.appendCanonicalizedElement(MessageCanonicalizer2.extractHeader(headers, "Content-MD5"));
        canonicalizedString.appendCanonicalizedElement(contentType);
        List<String> httpStorageDateValues = HttpRequestAccessor.getHeaderValues(headers, "x-ms-date");
        if (httpStorageDateValues != null && httpStorageDateValues.size() > 0) {
            date = "";
        }
        if (date != null) {
            canonicalizedString.appendCanonicalizedElement(date);
        }
        canonicalizedString.appendCanonicalizedElement(MessageCanonicalizer2.extractHeader(headers, "If-Modified-Since"));
        canonicalizedString.appendCanonicalizedElement(MessageCanonicalizer2.extractHeader(headers, "If-Match"));
        canonicalizedString.appendCanonicalizedElement(MessageCanonicalizer2.extractHeader(headers, "If-None-Match"));
        canonicalizedString.appendCanonicalizedElement(MessageCanonicalizer2.extractHeader(headers, "If-Unmodified-Since"));
        canonicalizedString.appendCanonicalizedElement(MessageCanonicalizer2.extractHeader(headers, "Range"));
        ArrayList<String> httpStorageHeaderNameArray = new ArrayList<String>();
        for (Object keyObj : headers.keySet()) {
            String key = (String)keyObj;
            if (!key.toLowerCase().startsWith("x-ms-")) continue;
            httpStorageHeaderNameArray.add(key.toLowerCase());
        }
        Collections.sort(httpStorageHeaderNameArray, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (String key : httpStorageHeaderNameArray) {
            StringBuilder canonicalizedElement = new StringBuilder(key);
            String delimiter = ":";
            List<String> values = HttpRequestAccessor.getHeaderValues(headers, key);
            for (String headerValue : values) {
                String unfoldedValue = headerValue.replaceAll("\r\n", Utilities.emptyString());
                canonicalizedElement.append(delimiter);
                canonicalizedElement.append(unfoldedValue);
                delimiter = ",";
            }
            canonicalizedString.appendCanonicalizedElement(canonicalizedElement.toString());
        }
        String canonicalizedResource = MessageCanonicalizer2.getCanonicalizedResource(address, uriComponents);
        canonicalizedString.appendCanonicalizedElement(canonicalizedResource);
        return canonicalizedString.getValue();
    }

    private static String getCanonicalizedResource(URI address, ResourceUriComponents uriComponents) {
        StringBuilder canonicalizedResource = new StringBuilder("/");
        canonicalizedResource.append(uriComponents.getAccountName());
        String path = address.getRawPath();
        canonicalizedResource.append(path);
        NameValueCollection query = HttpUtilities.parseQueryString(address.getQuery());
        ArrayList paramNames = new ArrayList();
        paramNames.addAll(query.keySet());
        Collections.sort(paramNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (String key : paramNames) {
            StringBuilder canonicalizedElement = new StringBuilder(URLDecoder.decode(key));
            canonicalizedElement.append(":");
            String value = query.getMultipleValuesAsString(key);
            canonicalizedElement.append(URLDecoder.decode(value));
            canonicalizedResource.append("\n");
            canonicalizedResource.append(canonicalizedElement.toString());
        }
        return canonicalizedResource.toString();
    }

    private static class CanonicalizedString {
        private StringBuilder canonicalizedString = new StringBuilder();

        public String getValue() {
            return this.canonicalizedString.toString();
        }

        public CanonicalizedString(String initialElement) {
            this.canonicalizedString.append(initialElement);
        }

        public void appendCanonicalizedElement(String element) {
            this.canonicalizedString.append("\n");
            this.canonicalizedString.append(element);
        }
    }
}

