/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.internal.constants;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.Utilities;

public class HttpWebResponse {
    private HttpResponse response;
    private NameValueCollection headers;
    private int statusCode;
    private Timestamp lastModified;
    private String contentType;
    private long contentLength;
    private InputStream inputStream;

    public HttpWebResponse(HttpResponse response) {
        this.response = response;
        this.parseResponse();
    }

    private void parseResponse() {
        this.statusCode = this.response.getStatusLine().getStatusCode();
        this.headers = new NameValueCollection();
        for (Header header : this.response.getAllHeaders()) {
            this.headers.put(header.getName(), header.getValue());
        }
        String time = this.headers.getSingleValue("Last-Modified");
        if (time != null) {
            this.lastModified = Utilities.convertTime(time);
        }
        this.contentType = this.headers.getSingleValue("Content-Type");
        this.contentLength = 0L;
        String length = this.headers.getSingleValue("Content-Length");
        if (length != null) {
            this.contentLength = Long.parseLong(length);
        }
    }

    public NameValueCollection getHeaders() {
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusDescription() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public String getHeader(String name) {
        return this.headers.getSingleValue(name);
    }

    public Timestamp getLastModified() {
        return this.lastModified;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        try {
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                this.inputStream = entity.getContent();
                return this.inputStream;
            }
        }
        catch (IllegalStateException e) {
            Logger.error("IllegalStateException", e);
        }
        catch (IOException e) {
            Logger.error("IOException", e);
        }
        return null;
    }

    public void close() {
    }
}

