/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.management;

import java.io.File;
import java.io.IOException;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.util.Utilities;

public abstract class Configuration {
    protected String packageBlobUrl;
    protected String configurationFileUrl;
    private String base64ConfigurationFile;

    protected boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public String getPackageBlobUrl() {
        return this.packageBlobUrl;
    }

    public void setPackageBlobUrl(String packageBlobUrl) {
        this.packageBlobUrl = packageBlobUrl;
    }

    public String getConfigurationFileUrl() {
        return this.configurationFileUrl;
    }

    public void setConfigurationFileUrl(String configurationFileUrl) {
        this.configurationFileUrl = configurationFileUrl;
    }

    public String getBase64ConfigurationFile() {
        if (this.base64ConfigurationFile == null) {
            this.readConfigurationContent();
        }
        return this.base64ConfigurationFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readConfigurationContent() {
        File file = new File(this.configurationFileUrl);
        if (!file.exists() || !file.isFile() || !file.canRead()) throw new IllegalStateException("Configuration file is invalid");
        try {
            byte[] bytes = Utilities.getBytesFromFile(file);
            if (this.base64ConfigurationFile != null) return;
            this.base64ConfigurationFile = Base64.encode(bytes);
            return;
        }
        catch (IOException e) {
            throw new IllegalStateException("Configuration file is invalid");
        }
    }
}

