/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.management;

import java.util.List;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.soyatec.windows.azure.management.AffinityGroup;
import org.soyatec.windows.azure.management.AffinityGroupProperties;
import org.soyatec.windows.azure.management.AsyncResultCallback;
import org.soyatec.windows.azure.management.Certificate;
import org.soyatec.windows.azure.management.CertificateFormat;
import org.soyatec.windows.azure.management.Deployment;
import org.soyatec.windows.azure.management.DeploymentConfiguration;
import org.soyatec.windows.azure.management.DeploymentSlotType;
import org.soyatec.windows.azure.management.HostedService;
import org.soyatec.windows.azure.management.HostedServiceProperties;
import org.soyatec.windows.azure.management.KeyType;
import org.soyatec.windows.azure.management.OperatingSystem;
import org.soyatec.windows.azure.management.OperationStatus;
import org.soyatec.windows.azure.management.StorageAccount;
import org.soyatec.windows.azure.management.StorageAccountKey;
import org.soyatec.windows.azure.management.StorageAccountProperties;
import org.soyatec.windows.azure.management.UpdateStatus;
import org.soyatec.windows.azure.management.UpgradeConfiguration;
import org.soyatec.windows.azure.util.ssl.SslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceManagement {
    private final String subscriptionId;
    private final SSLSocketFactory sslSocketFactory;
    private boolean blocking = false;

    public ServiceManagement(String subscriptionId, String keyStoreFile, String keyStorePassword, String trustStoreFile, String trustStorePassword, String certificateAlias) throws Exception {
        this.subscriptionId = subscriptionId;
        this.sslSocketFactory = SslUtil.createSSLSocketFactory(keyStoreFile, keyStorePassword, trustStoreFile, trustStorePassword, certificateAlias);
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    String getBaseUrl() {
        return "https://management.core.windows.net:443/" + this.subscriptionId;
    }

    public abstract List<HostedService> listHostedServices();

    public abstract String createDeployment(String var1, DeploymentSlotType var2, DeploymentConfiguration var3, AsyncResultCallback var4);

    public abstract Deployment getDeployment(String var1, DeploymentSlotType var2);

    public abstract Deployment getDeployment(String var1, String var2);

    public abstract String deleteDeployment(String var1, DeploymentSlotType var2, AsyncResultCallback var3);

    public abstract String deleteDeployment(String var1, String var2, AsyncResultCallback var3);

    public abstract HostedServiceProperties getHostedServiceProperties(String var1, boolean var2);

    public abstract OperationStatus getOperationStatus(String var1);

    public abstract List<StorageAccount> listStorageAccounts();

    public abstract List<AffinityGroup> listAffinityGroups();

    public abstract StorageAccountKey getStorageAccountKeys(String var1);

    public abstract StorageAccountKey regenerateKeys(String var1, KeyType var2);

    public abstract StorageAccountProperties getStorageAccountProperties(String var1);

    public abstract AffinityGroupProperties getAffinityGroupProperties(String var1);

    public abstract String updateDeplymentStatus(String var1, DeploymentSlotType var2, UpdateStatus var3, AsyncResultCallback var4);

    public abstract String updateDeplymentStatus(String var1, String var2, UpdateStatus var3, AsyncResultCallback var4);

    public abstract String upgradeDeployment(String var1, DeploymentSlotType var2, UpgradeConfiguration var3, AsyncResultCallback var4);

    public abstract String upgradeDeployment(String var1, String var2, UpgradeConfiguration var3, AsyncResultCallback var4);

    public abstract String walkUpgradeDomain(String var1, String var2, String var3, AsyncResultCallback var4);

    public abstract String walkUpgradeDomain(String var1, DeploymentSlotType var2, String var3, AsyncResultCallback var4);

    public abstract String changeDeploymentConfiguration(String var1, DeploymentSlotType var2, String var3, AsyncResultCallback var4);

    public abstract String changeDeploymentConfiguration(String var1, String var2, String var3, AsyncResultCallback var4);

    public abstract String swapDeployment(String var1, String var2, String var3, AsyncResultCallback var4);

    public abstract List<Certificate> listCertificates(String var1);

    public abstract Certificate getCertificate(String var1, String var2, String var3);

    public abstract void deleteCertificate(String var1, String var2, String var3);

    public abstract void addCertificate(String var1, byte[] var2, CertificateFormat var3, String var4);

    public abstract List<OperatingSystem> listOSVersions();
}

