/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.queue;

import java.net.URI;
import java.util.List;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.authenticate.StorageAccountInfo;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.blob.internal.RetryPolicies;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.queue.ICloudQueue;
import org.soyatec.windows.azure.queue.IMessage;
import org.soyatec.windows.azure.queue.internal.Message;
import org.soyatec.windows.azure.queue.internal.QueueStorageRest;
import org.soyatec.windows.azure.util.TimeSpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueStorage {
    private boolean usePathStyleUris;
    private URI baseUri;
    private String accountName;
    protected String base64Key;
    private TimeSpan timeout;
    private IRetryPolicy retryPolicy;
    public static final TimeSpan DefaultTimeout = TimeSpan.fromSeconds(30L);
    public static final IRetryPolicy DefaultRetryPolicy = RetryPolicies.noRetry();
    private StorageAccountInfo accountInfo;
    private SharedKeyCredentials credentials;

    public static QueueStorage create(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        return new QueueStorageRest(baseUri, usePathStyleUris, accountName, base64Key);
    }

    public static QueueStorage create(boolean usePathStyleUris, String accountName, String base64Key) {
        URI hostUri = null;
        hostUri = usePathStyleUris ? URI.create("http://127.0.0.1:10001") : URI.create("http://queue.core.windows.net");
        return new QueueStorageRest(hostUri, usePathStyleUris, accountName, base64Key);
    }

    public static QueueStorage create(StorageAccountInfo accountInfo) {
        return new QueueStorageRest(accountInfo.getBaseUri(), accountInfo.isUsePathStyleUris(), accountInfo.getAccountName(), accountInfo.getBase64Key());
    }

    public static IMessage createMessage() {
        return new Message();
    }

    public static IMessage createMessage(String content) {
        return new Message(content);
    }

    public static IMessage createMessage(byte[] content) {
        return new Message(content);
    }

    protected QueueStorage(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        this.baseUri = baseUri;
        this.usePathStyleUris = usePathStyleUris;
        this.accountName = accountName;
        this.base64Key = base64Key;
        this.timeout = DefaultTimeout;
        this.retryPolicy = DefaultRetryPolicy;
        this.accountInfo = new StorageAccountInfo(baseUri, usePathStyleUris, accountName, base64Key);
    }

    public abstract ICloudQueue getQueue(String var1) throws StorageException;

    public List<String> listQueues() throws StorageException {
        return this.listQueues(null);
    }

    public abstract List<String> listQueues(String var1) throws StorageException;

    public TimeSpan getTimeout() {
        return this.timeout;
    }

    public boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    public void setUsePathStyleUris(boolean usePathStyleUris) {
        this.usePathStyleUris = usePathStyleUris;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getBase64Key() {
        return this.base64Key;
    }

    public IRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(IRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public StorageAccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public void setAccountInfo(StorageAccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public SharedKeyCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(SharedKeyCredentials credentials) {
        this.credentials = credentials;
    }

    public void setTimeout(TimeSpan timeout) {
        this.timeout = timeout;
    }
}

