/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.queue.internal;

import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.authenticate.HttpRequestAccessor;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.authenticate.StorageAccountInfo;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.blob.io.BlobMemoryStream;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.internal.OutParameter;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.queue.IMessage;
import org.soyatec.windows.azure.queue.IQueueProperties;
import org.soyatec.windows.azure.queue.MessageReceivedEvent;
import org.soyatec.windows.azure.queue.internal.CloudQueue;
import org.soyatec.windows.azure.queue.internal.Message;
import org.soyatec.windows.azure.queue.internal.QueueProperties;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.TimeSpan;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.XPathQueryHelper;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudQueueRest
extends CloudQueue {
    private SharedKeyCredentials credentials;
    private int pollInterval = 5000;
    protected String lastStatus;
    private boolean _run = Boolean.FALSE;
    private Thread _receiveThread;
    private int _internalPollInterval;
    private final Lock lock = new ReentrantLock();
    private Condition _evStarted = null;
    private Condition _evStopped = null;
    private Condition _evQuit = null;

    CloudQueueRest(String name, StorageAccountInfo account, TimeSpan timeout, IRetryPolicy retryPolicy) {
        super(name, account);
        byte[] key = null;
        if (this.getAccount().getBase64Key() != null) {
            key = Base64.decode(this.getAccount().getBase64Key());
        }
        ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccount().getAccountName(), name, null);
        this.credentials = new SharedKeyCredentials(this.getAccount().getAccountName(), key);
        this.setQueueUri(HttpRequestAccessor.constructResourceUri(this.getAccount().getBaseUri(), uriComponents, this.getAccount().isUsePathStyleUris()));
        this.setTimeout(timeout);
        this.setRetryPolicy(retryPolicy);
    }

    @Override
    public int getPollInterval() {
        return this.pollInterval;
    }

    @Override
    public void setPollInterval(int pollInterval) {
        if (pollInterval <= 0) {
            throw new IllegalArgumentException("poll interval must be positive!");
        }
        this.pollInterval = pollInterval;
    }

    @Override
    public int getApproximateCount() throws StorageException {
        IQueueProperties props = this.getProperties();
        return props.getApproximateMessageCount();
    }

    @Override
    public boolean clear() throws StorageException {
        boolean result = false;
        result = (Boolean)this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudQueueRest.this.getAccount().getAccountName(), CloudQueueRest.this.getName(), "messages");
                URI uri = CloudQueueRest.this.createRequestUri("messages", new NameValueCollection(), false, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "DELETE", CloudQueueRest.this.getTimeout());
                CloudQueueRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 204) {
                        return true;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    @Override
    public String getLastStatus() {
        return this.lastStatus;
    }

    @Override
    public boolean createQueue() throws StorageException {
        boolean result = false;
        final boolean[] exists = new boolean[]{false};
        result = (Boolean)this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudQueueRest.this.getAccount().getAccountName(), CloudQueueRest.this.getName(), null);
                URI uri = CloudQueueRest.this.createRequestUri(null, new NameValueCollection(), false, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "PUT", CloudQueueRest.this.getTimeout());
                CloudQueueRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 201) {
                        exists[0] = false;
                        return true;
                    }
                    if (response.getStatusCode() == 204 || response.getStatusCode() == 409) {
                        exists[0] = true;
                        CloudQueueRest.this.lastStatus = HttpUtilities.convertStreamToString(response.getStream());
                        return false;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    @Override
    public boolean deleteMessage(final IMessage msg) throws StorageException {
        if (msg == null) {
            throw new IllegalArgumentException("Message cannot be null!");
        }
        if (msg.getPopReceipt() == null) {
            throw new IllegalArgumentException("No PopReceipt for the given message!");
        }
        boolean result = false;
        result = (Boolean)this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                NameValueCollection col = new NameValueCollection();
                col.put("popreceipt", msg.getPopReceipt().toString());
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudQueueRest.this.getAccount().getAccountName(), CloudQueueRest.this.getName(), "messages/" + msg.getId());
                URI uri = CloudQueueRest.this.createRequestUri("messages/" + msg.getId(), col, false, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "DELETE", CloudQueueRest.this.getTimeout());
                CloudQueueRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 204) {
                        return true;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    @Override
    public boolean deleteQueue() throws StorageException {
        boolean result = false;
        result = (Boolean)this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudQueueRest.this.getAccount().getAccountName(), CloudQueueRest.this.getName(), null);
                URI uri = CloudQueueRest.this.createRequestUri(null, new NameValueCollection(), false, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "DELETE", CloudQueueRest.this.getTimeout());
                CloudQueueRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 204) {
                        return true;
                    }
                    if (response.getStatusCode() == 404 || response.getStatusCode() == 412 || response.getStatusCode() == 409) {
                        return false;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    @Override
    public Message getMessage() throws StorageException {
        List<Message> result = this.getMessages(1);
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public IMessage getMessage(int visibilityTimeoutInSeconds) throws StorageException {
        List<Message> result = this.getMessages(1, visibilityTimeoutInSeconds);
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<Message> getMessages(int numberOfMessages) throws StorageException {
        return this.getMessages(numberOfMessages, -1);
    }

    @Override
    public List<Message> getMessages(int numberOfMessages, int visibilityTimeoutInSeconds) throws StorageException {
        return this.internalGet(numberOfMessages, visibilityTimeoutInSeconds, false);
    }

    private List<Message> internalGet(final int numberOfMessages, final int visibilityTimeout, final boolean peekOnly) {
        if (peekOnly && visibilityTimeout != -1) {
            throw new IllegalArgumentException("A peek operation does not change the visibility of messages");
        }
        if (numberOfMessages < 1) {
            throw new IllegalArgumentException("numberOfMessages must be a positive integer");
        }
        if (visibilityTimeout < -1) {
            throw new IllegalArgumentException("Visibility Timeout must be 0 or a positive integer");
        }
        List result = (List)this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                NameValueCollection col = new NameValueCollection();
                col.put("numofmessages", String.valueOf(numberOfMessages));
                if (visibilityTimeout != -1) {
                    col.put("visibilitytimeout", String.valueOf(visibilityTimeout));
                }
                if (peekOnly) {
                    col.put("peekonly", String.valueOf(peekOnly));
                }
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudQueueRest.this.getAccount().getAccountName(), CloudQueueRest.this.getName(), "messages");
                URI uri = CloudQueueRest.this.createRequestUri("messages", col, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "GET", CloudQueueRest.this.getTimeout());
                CloudQueueRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200) {
                        InputStream stream = response.getStream();
                        List result = CloudQueueRest.this.getMessagesFromResponse(stream);
                        stream.close();
                        return result;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return null;
                }
                catch (Exception e) {
                    throw HttpUtilities.translateWebException(e);
                }
            }
        });
        return result;
    }

    @Override
    public IQueueProperties getProperties() throws StorageException {
        IQueueProperties result = null;
        result = (IQueueProperties)this.getRetryPolicy().execute(new Callable<IQueueProperties>(){

            @Override
            public IQueueProperties call() throws Exception {
                NameValueCollection col = new NameValueCollection();
                col.put("comp", "metadata");
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudQueueRest.this.getAccount().getAccountName(), CloudQueueRest.this.getName(), null);
                URI uri = CloudQueueRest.this.createRequestUri(null, col, false, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "GET", CloudQueueRest.this.getTimeout());
                CloudQueueRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200) {
                        return CloudQueueRest.this.getPropertiesFromHeaders(response);
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return null;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    private IQueueProperties getPropertiesFromHeaders(HttpWebResponse response) {
        QueueProperties properties = new QueueProperties();
        properties.setMetadata(new NameValueCollection());
        int prefixLength = "x-ms-meta-".length();
        for (Object o : response.getHeaders().keySet()) {
            String key = (String)o;
            if (key.equalsIgnoreCase("x-ms-approximate-messages-count")) {
                properties.setApproximateMessageCount(Integer.parseInt(response.getHeader(key)));
                continue;
            }
            if (key.length() <= prefixLength || !key.substring(0, prefixLength).equalsIgnoreCase("x-ms-meta-")) continue;
            properties.getMetadata().put(key.substring(prefixLength), response.getHeader(key));
        }
        return properties;
    }

    @Override
    public IMessage peekMessage() throws StorageException {
        List<Message> result = this.peekMessages(1);
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<Message> peekMessages(int numberOfMessages) throws StorageException {
        return this.internalGet(numberOfMessages, -1, true);
    }

    @Override
    public boolean putMessage(IMessage msg) throws StorageException {
        return this.putMessage(msg, -1);
    }

    byte[] encodeMessage(IMessage message) {
        byte[] ret = null;
        Document doc = DocumentHelper.createDocument();
        Element element = doc.addElement("QueueMessage");
        element.addElement("MessageText").setText(Base64.encode(message.getContentAsBytes()));
        ret = doc.asXML().getBytes();
        return ret;
    }

    @Override
    public boolean putMessage(final IMessage msg, final int timeToLiveInSeconds) throws StorageException {
        if (timeToLiveInSeconds < -1) {
            throw new IllegalArgumentException("ttl parameter must be equal or larger than 0.");
        }
        if (timeToLiveInSeconds > 604800) {
            throw new IllegalArgumentException(MessageFormat.format("timeToLiveHours parameter must be smaller or equal than {0}, which is 7 days in hours.", 604800));
        }
        if (msg == null || msg.getContentAsBytes() == null) {
            throw new IllegalArgumentException("Message cannot be null!");
        }
        if (Base64.encode(msg.getContentAsBytes()).length() > 8192) {
            throw new IllegalArgumentException(MessageFormat.format("Messages cannot be larger than {0} bytes.", 8192));
        }
        final OutParameter<Boolean> result = new OutParameter<Boolean>(false);
        this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                NameValueCollection col = new NameValueCollection();
                if (timeToLiveInSeconds != -1) {
                    col.put("messagettl", Integer.toString(timeToLiveInSeconds));
                }
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudQueueRest.this.getAccount().getAccountName(), CloudQueueRest.this.getName(), "messages");
                URI uri = CloudQueueRest.this.createRequestUri("messages", col, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "POST", CloudQueueRest.this.getTimeout());
                int len = 0;
                byte[] body = CloudQueueRest.this.encodeMessage(msg);
                len = body.length;
                CloudQueueRest.this.credentials.signRequest(request, uriComponents);
                BlobMemoryStream requestStream = new BlobMemoryStream();
                Utilities.copyStream(new BlobMemoryStream(body), requestStream, len);
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(requestStream.getBytes()));
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 201) {
                        result.setValue(true);
                    } else {
                        HttpUtilities.processUnexpectedStatusCode(response);
                        result.setValue(false);
                    }
                }
                catch (Exception e) {
                    throw HttpUtilities.translateWebException(e);
                }
                return null;
            }
        });
        return result.getValue();
    }

    @Override
    public boolean setProperties(final IQueueProperties properties) throws StorageException {
        if (properties == null) {
            throw new IllegalArgumentException("Properties cannot be null!");
        }
        if (properties.getMetadata() == null) {
            throw new IllegalArgumentException("Metadata cannot be null!");
        }
        boolean result = false;
        result = (Boolean)this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                NameValueCollection col = new NameValueCollection();
                col.put("comp", "metadata");
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudQueueRest.this.getAccount().getAccountName(), CloudQueueRest.this.getName(), null);
                URI uri = CloudQueueRest.this.createRequestUri(null, col, false, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "PUT", CloudQueueRest.this.getTimeout());
                HttpUtilities.addMetadataHeaders(request, properties.getMetadata());
                CloudQueueRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 204) {
                        return true;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    private URI createRequestUri(String uriSuffix, NameValueCollection queryParameters, boolean accountOperation, ResourceUriComponents uriComponents) {
        return HttpUtilities.createRequestUri(this.getAccount().getBaseUri(), this.getAccount().isUsePathStyleUris(), this.getAccount().getAccountName(), accountOperation ? null : this.getName(), uriSuffix, this.getTimeout(), queryParameters, uriComponents);
    }

    private URI createRequestUri(String uriSuffix, NameValueCollection queryParameters, ResourceUriComponents uriComponents) {
        return this.createRequestUri(uriSuffix, queryParameters, false, uriComponents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean startReceiving() {
        CloudQueueRest cloudQueueRest = this;
        synchronized (cloudQueueRest) {
            if (this._run) {
                return true;
            }
            this._run = true;
        }
        if (this._evStarted == null) {
            this._evStarted = this.lock.newCondition();
        }
        if (this._evQuit == null) {
            this._evQuit = this.lock.newCondition();
        }
        if (this._evStopped == null) {
            this._evStopped = this.lock.newCondition();
        }
        this._receiveThread = new Thread(new PeriodicReceive());
        this._receiveThread.start();
        try {
            try {
                this.lock.lock();
                if (!this._evStarted.await(10000L, TimeUnit.MILLISECONDS)) {
                    boolean bl = this.terminateReceiveThread();
                    Object var4_6 = null;
                    this.lock.unlock();
                    return bl;
                }
                Object var4_7 = null;
                this.lock.unlock();
            }
            catch (InterruptedException e) {
                boolean bl = this.terminateReceiveThread();
                Object var4_8 = null;
                this.lock.unlock();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.lock.unlock();
            throw throwable;
        }
        return true;
    }

    private boolean terminateReceiveThread() {
        this.forceTerminateReceiveThread();
        this.clearConditions();
        this._run = false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopReceiving() {
        this.lock.lock();
        this._evQuit.signal();
        try {
            block4: {
                try {
                    if (!this.timeoutForTerminating()) break block4;
                    this.forceTerminateReceiveThread();
                }
                catch (InterruptedException e) {
                    this.forceTerminateReceiveThread();
                    Object var3_2 = null;
                    this.lock.unlock();
                }
            }
            Object var3_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        this.clearConditions();
        this._run = false;
    }

    private void forceTerminateReceiveThread() {
        this._receiveThread.interrupt();
    }

    private boolean timeoutForTerminating() throws InterruptedException {
        return !this._evStopped.await(10000L, TimeUnit.MILLISECONDS);
    }

    private void clearConditions() {
        this._evStarted = null;
        this._evQuit = null;
        this._evStopped = null;
    }

    private List<Message> getMessagesFromResponse(InputStream stream) {
        if (stream == null) {
            return Collections.EMPTY_LIST;
        }
        Document doc = XmlUtil.load(stream, "The result of a get message opertation could not be parsed");
        List messagesNodes = doc.selectNodes(XPathQueryHelper.MessagesListQuery);
        ArrayList<Message> result = null;
        if (messagesNodes.size() > 0) {
            result = new ArrayList<Message>();
        }
        for (Element messageNode : messagesNodes) {
            Message msg = new Message();
            msg.setId(messageNode.selectSingleNode("MessageId").getStringValue().trim());
            assert (msg.getId() != null);
            if (messageNode.selectSingleNode("PopReceipt") != null) {
                msg.setPopReceipt(messageNode.selectSingleNode("PopReceipt").getStringValue().trim());
                assert (msg.getPopReceipt() != null);
            }
            msg.setInsertTime(XPathQueryHelper.loadSingleChildDateTimeValue(messageNode, "InsertionTime", false));
            msg.setExpirationTime(XPathQueryHelper.loadSingleChildDateTimeValue(messageNode, "ExpirationTime", false));
            if (XPathQueryHelper.loadSingleChildDateTimeValue(messageNode, "TimeNextVisible", false) != null) {
                msg.setNextVisibleTime(XPathQueryHelper.loadSingleChildDateTimeValue(messageNode, "TimeNextVisible", false));
            }
            msg.setContentFromBase64String(XPathQueryHelper.loadSingleChildStringValue(messageNode, "MessageText", false));
            result.add(msg);
        }
        return result;
    }

    private class PeriodicReceive
    implements Runnable {
        private PeriodicReceive() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CloudQueueRest.this.lock.lock();
            try {
                try {
                    CloudQueueRest.this._evStarted.signal();
                    CloudQueueRest.this._internalPollInterval = CloudQueueRest.this.getPollInterval();
                    while (this.timeoutForReceiving()) {
                        Message msg = CloudQueueRest.this.getMessage();
                        if (msg != null) {
                            this.receiveMessage(this, new MessageReceivedEvent(CloudQueueRest.this, msg));
                            CloudQueueRest.this._internalPollInterval = 10;
                            continue;
                        }
                        CloudQueueRest.this._internalPollInterval = CloudQueueRest.this.getPollInterval();
                    }
                    CloudQueueRest.this._evStopped.signal();
                }
                catch (InterruptedException interruptedException) {
                    Object var4_3 = null;
                    CloudQueueRest.this.lock.unlock();
                }
                Object var4_2 = null;
                CloudQueueRest.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                CloudQueueRest.this.lock.unlock();
                throw throwable;
            }
        }

        private boolean timeoutForReceiving() throws InterruptedException {
            return !CloudQueueRest.this._evQuit.await(CloudQueueRest.this._internalPollInterval, TimeUnit.MILLISECONDS);
        }

        private synchronized void receiveMessage(PeriodicReceive periodicReceive, MessageReceivedEvent messageReceivedEvent) {
            CloudQueueRest.this.changeSupport.notifyAll(messageReceivedEvent);
        }
    }
}

