/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.queue.internal;

import java.sql.Timestamp;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.queue.IMessage;
import org.soyatec.windows.azure.util.Utilities;

public class Message
implements IMessage {
    private String id;
    private String popReceipt;
    private Timestamp insertTime;
    private Timestamp expirationTime;
    private Timestamp nextVisibleTime;
    private byte[] content;

    public Message() {
    }

    public Message(String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null!");
        }
        this.content = content.getBytes();
    }

    public Message(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null!");
        }
        if (Base64.encode(content).length() > 8192) {
            throw new IllegalArgumentException("Message body is too big!");
        }
        this.content = content;
    }

    public String getContentAsString() {
        return new String(this.content);
    }

    public byte[] getContentAsBytes() {
        return this.content;
    }

    void setContentFromBase64String(String str) {
        this.content = Utilities.isNullOrEmpty(str) ? Utilities.emptyString().getBytes() : Base64.decode(str);
    }

    public String getId() {
        return this.id;
    }

    public String getPopReceipt() {
        return this.popReceipt;
    }

    public Timestamp getInsertTime() {
        return this.insertTime;
    }

    public Timestamp getExpirationTime() {
        return this.expirationTime;
    }

    public Timestamp getNextVisibleTime() {
        return this.nextVisibleTime;
    }

    void setId(String id) {
        this.id = id;
    }

    void setPopReceipt(String popReceipt) {
        this.popReceipt = popReceipt;
    }

    void setInsertTime(Timestamp insertTime) {
        this.insertTime = insertTime;
    }

    void setExpirationTime(Timestamp expirationTime) {
        this.expirationTime = expirationTime;
    }

    void setNextVisibleTime(Timestamp nextVisibleTime) {
        this.nextVisibleTime = nextVisibleTime;
    }
}

