/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.table;

import org.soyatec.windows.azure.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ETableColumnType {
    TYPE_BINARY("Edm.Binary", "varbinary(max)"),
    TYPE_BOOL("Edm.Boolean", "bit"),
    TYPE_DATE_TIME("Edm.DateTime", "datetime"),
    TYPE_DOUBLE("Edm.Double", "real"),
    TYPE_GUID("Edm.Guid", "uniqueidentifier"),
    TYPE_INT("Edm.Int32", "int"),
    TYPE_LONG("Edm.Int64", "bigint"),
    TYPE_STRING("Edm.String", "nvarchar(1000)");

    private String literal;
    private String sqlType;

    private ETableColumnType(String literal, String sqlType) {
        this.literal = literal;
        this.sqlType = sqlType;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public static ETableColumnType getTypebyLiteral(String literal) {
        if (Utilities.isNullOrEmpty(literal)) {
            return TYPE_STRING;
        }
        for (ETableColumnType type : ETableColumnType.values()) {
            if (!type.getLiteral().equalsIgnoreCase(literal)) continue;
            return type;
        }
        return null;
    }
}

