/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.table;

import java.net.URI;
import java.sql.Timestamp;
import java.util.List;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.authenticate.StorageAccountInfo;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.blob.internal.RetryPolicies;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.table.ETableColumnType;
import org.soyatec.windows.azure.table.ICloudTable;
import org.soyatec.windows.azure.table.ICloudTableColumn;
import org.soyatec.windows.azure.table.ITableStorageEntity;
import org.soyatec.windows.azure.table.internal.CloudTableColumn;
import org.soyatec.windows.azure.table.internal.SimpleTableStorageEntity;
import org.soyatec.windows.azure.table.internal.TableStorageRest;
import org.soyatec.windows.azure.util.TimeSpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableStorage {
    private boolean usePathStyleUris;
    private URI baseUri;
    private String accountName;
    private String base64Key;
    private IRetryPolicy retryPolicy;
    private TimeSpan timeout;
    private SharedKeyCredentials credentials;
    public static final IRetryPolicy DefaultRetryPolicy = RetryPolicies.noRetry();
    public static final TimeSpan DefaultTimeout = TimeSpan.fromSeconds(30L);

    protected TableStorage(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        this.baseUri = baseUri;
        this.usePathStyleUris = usePathStyleUris;
        this.accountName = accountName;
        this.base64Key = base64Key;
        this.retryPolicy = DefaultRetryPolicy;
        this.timeout = DefaultTimeout;
    }

    public static TableStorage create(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        return new TableStorageRest(baseUri, usePathStyleUris, accountName, base64Key);
    }

    public static TableStorage create(boolean usePathStyleUris, String accountName, String base64Key) {
        URI hostUri = null;
        hostUri = usePathStyleUris ? URI.create("http://127.0.0.1:10002") : URI.create("http://table.core.windows.net");
        return new TableStorageRest(hostUri, usePathStyleUris, accountName, base64Key);
    }

    public static TableStorage create(StorageAccountInfo info) {
        return TableStorage.create(info.getBaseUri(), info.isUsePathStyleUris(), info.getAccountName(), info.getBase64Key());
    }

    public static ICloudTableColumn createCloudTableColumn(String name, String value, ETableColumnType type) {
        return new CloudTableColumn(name, value, type);
    }

    public static ITableStorageEntity createTableStorageEntity(String partitionKey, String rowKey, List<ICloudTableColumn> values) {
        SimpleTableStorageEntity entity = new SimpleTableStorageEntity(partitionKey, rowKey);
        entity.setPartitionKey(partitionKey);
        entity.setRowKey(rowKey);
        entity.setValues(values);
        return entity;
    }

    public static ITableStorageEntity createTableStorageEntity(String partitionKey, String rowKey, Timestamp timestamp) {
        return new SimpleTableStorageEntity(partitionKey, rowKey, timestamp);
    }

    public abstract List<String> listTables() throws StorageException;

    public abstract ICloudTable getWindowsAzureTable(String var1);

    public boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getBase64Key() {
        return this.base64Key;
    }

    public void setBase64Key(String base64Key) {
        this.base64Key = base64Key;
    }

    public IRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(IRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public TimeSpan getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeSpan timeout) {
        this.timeout = timeout;
    }

    public SharedKeyCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(SharedKeyCredentials credentials) {
        this.credentials = credentials;
    }
}

