/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.table.internal;

import java.net.URI;
import java.util.List;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.table.ICloudTable;
import org.soyatec.windows.azure.table.ITableStorageEntity;
import org.soyatec.windows.azure.table.internal.CloudTableQuery;
import org.soyatec.windows.azure.util.TimeSpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloudTable
implements ICloudTable {
    private URI baseUri;
    private String accountName;
    protected String tableName;
    private boolean usePathStyleUris;
    TimeSpan timeout;
    private IRetryPolicy retryPolicy;
    private Class<? extends ITableStorageEntity> modelClass;

    protected CloudTable(URI baseUri, boolean usePathStyleUris, String accountName, String tableName, String base64Key, TimeSpan timeout, IRetryPolicy retryPolicy) {
        this.baseUri = baseUri;
        this.usePathStyleUris = usePathStyleUris;
        this.accountName = accountName;
        this.tableName = tableName;
        this.timeout = timeout;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public abstract boolean createTable();

    @Override
    public abstract boolean isTableExist();

    @Override
    public abstract boolean deleteTable();

    @Override
    public abstract void insertEntity(ITableStorageEntity var1) throws StorageException;

    @Override
    public abstract void updateEntity(ITableStorageEntity var1) throws StorageException;

    @Override
    public abstract void updateEntityIfNotModified(ITableStorageEntity var1) throws StorageException;

    @Override
    public abstract void mergeEntity(ITableStorageEntity var1) throws StorageException;

    @Override
    public abstract void deleteEntity(ITableStorageEntity var1) throws StorageException;

    @Override
    public abstract void deleteEntityIfNotModified(ITableStorageEntity var1) throws StorageException;

    @Override
    public abstract <T extends ITableStorageEntity> T loadEntity(T var1) throws StorageException;

    @Override
    public abstract List<ITableStorageEntity> retrieveEntities(String var1) throws StorageException;

    @Override
    public abstract List<ITableStorageEntity> retrieveEntities(CloudTableQuery var1) throws StorageException;

    @Override
    public abstract List<ITableStorageEntity> retrieveEntities() throws StorageException;

    @Override
    public abstract List<ITableStorageEntity> retrieveEntitiesByKey(String var1, String var2) throws StorageException;

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    @Override
    public TimeSpan getTimeout() {
        return this.timeout;
    }

    @Override
    public IRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public void setTimeout(TimeSpan timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setRetryPolicy(IRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Override
    public Class<? extends ITableStorageEntity> getModelClass() {
        return this.modelClass;
    }

    @Override
    public void setModelClass(Class<? extends ITableStorageEntity> modelClass) {
        this.modelClass = modelClass;
    }

    @Override
    public abstract String getLastStatus();
}

