/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.table.internal;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.dom4j.Document;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.error.StorageErrorCode;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.error.StorageServerException;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.table.AbstractTableStorageEntity;
import org.soyatec.windows.azure.table.ETableColumnType;
import org.soyatec.windows.azure.table.Guid;
import org.soyatec.windows.azure.table.ICloudTableColumn;
import org.soyatec.windows.azure.table.ITableStorageEntity;
import org.soyatec.windows.azure.table.internal.BatchOperation;
import org.soyatec.windows.azure.table.internal.CloudTable;
import org.soyatec.windows.azure.table.internal.CloudTableColumn;
import org.soyatec.windows.azure.table.internal.CloudTableQuery;
import org.soyatec.windows.azure.table.internal.SimpleTableStorageEntity;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.TimeSpan;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.AtomUtil;
import org.soyatec.windows.azure.util.xml.XPathQueryHelper;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudTableRest
extends CloudTable {
    private SharedKeyCredentials credentials;
    protected List<BatchOperation> batch = null;
    protected String lastStatus;

    public CloudTableRest(URI baseUri, boolean usePathStyleUris, String accountName, String tableName, String base64Key, TimeSpan timeout, IRetryPolicy retryPolicy) {
        super(baseUri, usePathStyleUris, accountName, tableName, base64Key, timeout, retryPolicy);
        byte[] key = null;
        if (base64Key != null) {
            key = Base64.decode(base64Key);
        }
        this.credentials = new SharedKeyCredentials(accountName, key);
    }

    @Override
    public String getLastStatus() {
        return this.lastStatus;
    }

    @Override
    public boolean createTable() {
        boolean result = (Boolean)this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), "Tables", null);
                URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), "Tables", null, null, new NameValueCollection(), uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "POST");
                request.addHeader("Content-Type", "application/atom+xml");
                request.addHeader("Date", Utilities.getUTCTime());
                String atom = AtomUtil.createTableXml(CloudTableRest.this.tableName);
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(atom.getBytes()));
                CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                if (response.getStatusCode() == 201) {
                    return true;
                }
                if (response.getStatusCode() == 409) {
                    CloudTableRest.this.lastStatus = HttpUtilities.convertStreamToString(response.getStream());
                    return false;
                }
                HttpUtilities.processUnexpectedStatusCode(response);
                return false;
            }
        });
        return result;
    }

    @Override
    public boolean deleteTable() {
        boolean result = (Boolean)this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), CloudTableRest.this.getTableNameURI(CloudTableRest.this.tableName), null);
                URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), "Tables", null, null, new NameValueCollection(), uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "DELETE");
                request.addHeader("Content-Type", "application/atom+xml");
                request.addHeader("Date", Utilities.getUTCTime());
                CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                if (response.getStatusCode() == 204) {
                    return true;
                }
                if (response.getStatusCode() == 404) {
                    return false;
                }
                HttpUtilities.processUnexpectedStatusCode(response);
                return true;
            }
        });
        return result;
    }

    @Override
    public boolean isTableExist() {
        boolean result = false;
        result = (Boolean)this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), CloudTableRest.this.getTableNameURI(CloudTableRest.this.tableName), null);
                URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), CloudTableRest.this.tableName, null, CloudTableRest.this.getTimeout(), new NameValueCollection(), uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "GET");
                request.addHeader("Content-Type", "application/atom+xml");
                request.addHeader("Date", Utilities.getUTCTime());
                CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                    if (response.getStatusCode() == 200) {
                        return true;
                    }
                    if (response.getStatusCode() == 410 || response.getStatusCode() == 404) {
                        return false;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    String getTableNameURI(String tableName) {
        return "Tables('" + tableName + "'" + ")";
    }

    @Override
    public void insertEntity(final ITableStorageEntity obj) throws StorageException {
        this.checkEntityKey(obj);
        this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), CloudTableRest.this.tableName, null);
                URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), CloudTableRest.this.tableName, null, null, new NameValueCollection(), uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "POST");
                request.addHeader("Content-Type", "application/atom+xml");
                String atom = AtomUtil.tableEntityXml(CloudTableRest.this.tableName, obj);
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(atom.getBytes()));
                if (CloudTableRest.this.isInBatch()) {
                    CloudTableRest.this.batch.add(new BatchOperation(CloudTableRest.this.tableName, null, "POST", request.getAllHeaders(), atom));
                    return true;
                }
                CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                if (response.getStatusCode() == 201) {
                    return true;
                }
                HttpUtilities.processUnexpectedStatusCode(response);
                return false;
            }
        });
    }

    @Override
    public void updateEntity(ITableStorageEntity obj) throws StorageException {
        this.changeEntity(obj, "*", "PUT");
    }

    @Override
    public void updateEntityIfNotModified(ITableStorageEntity obj) throws StorageException {
        this.changeEntity(obj, obj.getETag(), "PUT");
    }

    @Override
    public void mergeEntity(ITableStorageEntity obj) {
        this.changeEntity(obj, "*", "MERGE");
    }

    private void changeEntity(final ITableStorageEntity obj, final String etag, final String method) throws StorageException {
        this.checkEntityKey(obj);
        if (etag == null) {
            throw new IllegalArgumentException("Etag is required to change a table entity.");
        }
        this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String id = CloudTableRest.this.getEntityId(obj);
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), id, null);
                URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), id, null, null, new NameValueCollection(), uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, method);
                request.addHeader("Content-Type", "application/atom+xml");
                request.addHeader("If-Match", etag);
                String atom = AtomUtil.tableEntityXml(CloudTableRest.this.tableName, obj);
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(atom.getBytes()));
                if (CloudTableRest.this.isInBatch()) {
                    CloudTableRest.this.batch.add(new BatchOperation(id, null, "PUT", request.getAllHeaders(), atom));
                    return true;
                }
                CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                if (response.getStatusCode() == 204) {
                    return true;
                }
                HttpUtilities.processUnexpectedStatusCode(response);
                return false;
            }
        });
    }

    private void checkEntityKey(ITableStorageEntity obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Table entity cannot be null.");
        }
        if (obj.getPartitionKey() == null) {
            throw new IllegalArgumentException("PartitionKey cannot be null.");
        }
        if (obj.getRowKey() == null) {
            throw new IllegalArgumentException("RowKey cannot be null.");
        }
    }

    private String getEntityId(ITableStorageEntity obj) {
        return MessageFormat.format("{0}(PartitionKey=''{1}'',RowKey=''{2}'')", this.tableName, obj.getPartitionKey(), obj.getRowKey());
    }

    @Override
    public void deleteEntity(ITableStorageEntity obj) throws StorageException {
        this.deleteEntity(obj, "*");
    }

    @Override
    public void deleteEntityIfNotModified(ITableStorageEntity obj) throws StorageException {
        this.deleteEntity(obj, obj.getETag());
    }

    private void deleteEntity(final ITableStorageEntity obj, final String etag) throws StorageException {
        this.checkEntityKey(obj);
        if (etag == null) {
            throw new IllegalArgumentException("Etag is required to delete a table entity.");
        }
        this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String id = CloudTableRest.this.getEntityId(obj);
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), id, null);
                URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), id, null, null, new NameValueCollection(), uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "DELETE");
                request.addHeader("If-Match", etag);
                if (CloudTableRest.this.isInBatch()) {
                    CloudTableRest.this.batch.add(new BatchOperation(id, null, "DELETE", request.getAllHeaders(), null));
                    return true;
                }
                CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                if (response.getStatusCode() == 204) {
                    return true;
                }
                HttpUtilities.processUnexpectedStatusCode(response);
                return false;
            }
        });
    }

    @Override
    public <T extends ITableStorageEntity> T loadEntity(final T obj) throws StorageException {
        this.checkEntityKey(obj);
        ITableStorageEntity result = (ITableStorageEntity)this.getRetryPolicy().execute(new Callable<AbstractTableStorageEntity>(){

            @Override
            public AbstractTableStorageEntity call() throws Exception {
                String id = CloudTableRest.this.getEntityId(obj);
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), id, null);
                URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), id, null, null, new NameValueCollection(), uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "GET");
                CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                if (response.getStatusCode() == 200) {
                    CloudTableRest.this.setModelClass(obj.getClass());
                    List entities = CloudTableRest.this.getTableEntitiesFromResponse(response.getStream());
                    if (entities != null && entities.size() > 0) {
                        return (AbstractTableStorageEntity)entities.get(0);
                    }
                } else {
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                return null;
            }
        });
        return (T)result;
    }

    @Override
    public List<ITableStorageEntity> retrieveEntities(final String queryExpression) throws StorageException {
        final ArrayList<ITableStorageEntity> result = new ArrayList<ITableStorageEntity>();
        if (queryExpression != null) {
            this.getRetryPolicy().execute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String query = queryExpression.trim();
                    if (query.indexOf("%25") == -1) {
                        query = query.replaceAll("%", "%25");
                    }
                    ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), CloudTableRest.this.getTableNameToQuery(CloudTableRest.this.tableName), null);
                    NameValueCollection queryFliter = new NameValueCollection();
                    URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), CloudTableRest.this.tableName, null, CloudTableRest.this.getTimeout(), queryFliter, uriComponents, query);
                    HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "GET");
                    CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                    try {
                        HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                        Logger.log("Request URI:" + uri.toString());
                        if (response.getStatusCode() == 200) {
                            result.addAll(CloudTableRest.this.getTableEntitiesFromResponse(response.getStream()));
                            return null;
                        }
                        HttpUtilities.processUnexpectedStatusCode(response);
                        return null;
                    }
                    catch (StorageException we) {
                        throw HttpUtilities.translateWebException(we);
                    }
                }
            });
        }
        return result;
    }

    @Override
    public List<ITableStorageEntity> retrieveEntities(CloudTableQuery query) throws StorageException {
        if (query == null) {
            throw new IllegalArgumentException("Query is empty");
        }
        return this.retrieveEntities(query.toAzureQuery());
    }

    private String getTableNameToQuery(String tableName) {
        return tableName + "(" + ")";
    }

    private List<AbstractTableStorageEntity> getTableEntitiesFromResponse(InputStream stream) {
        ArrayList<AbstractTableStorageEntity> result = new ArrayList<AbstractTableStorageEntity>();
        Document document = XmlUtil.load(stream, "The result of a ListTableEntities operation could not be parsed");
        List xmlNodes = XPathQueryHelper.parseEntryFromFeed(document);
        for (Element tableEntryNode : xmlNodes) {
            String partitionKey = XPathQueryHelper.loadTableEntryPropertyValue(tableEntryNode, "PartitionKey");
            String rowKey = XPathQueryHelper.loadTableEntryPropertyValue(tableEntryNode, "RowKey");
            String eTag = XPathQueryHelper.loadTableEntryValueFromAttribute(tableEntryNode, "etag");
            String timestamp = XPathQueryHelper.loadTableEntryPropertyValue(tableEntryNode, "Timestamp");
            Element element = XPathQueryHelper.loadTableEntryProperties(tableEntryNode);
            ArrayList<ICloudTableColumn> values = new ArrayList<ICloudTableColumn>();
            Iterator iter = element.elementIterator();
            while (iter.hasNext()) {
                Element next = (Element)iter.next();
                String xmlNodeName = next.getName();
                String xmlType = next.attributeValue("type");
                String stringValue = AtomUtil.unescapeXml(next.getStringValue().trim());
                CloudTableColumn column = new CloudTableColumn();
                column.setName(xmlNodeName);
                column.setValue(stringValue);
                column.setType(ETableColumnType.getTypebyLiteral(xmlType));
                values.add(column);
            }
            if (this.getModelClass() != null) {
                try {
                    AbstractTableStorageEntity targetObject = (AbstractTableStorageEntity)this.createObjectByModelClass(partitionKey, rowKey, eTag, timestamp, values);
                    if (targetObject == null) continue;
                    result.add(targetObject);
                }
                catch (Exception e) {
                    Logger.error("Compose table entity error!", e);
                }
                continue;
            }
            SimpleTableStorageEntity entity = null;
            try {
                entity = new SimpleTableStorageEntity(partitionKey, rowKey, Utilities.tryGetDateTimeFromTableEntry(timestamp));
                entity.setValues(values);
                result.add(entity);
            }
            catch (ParseException e) {
                Logger.error("Parse timestamp error!", e);
            }
        }
        return result;
    }

    private ITableStorageEntity createObjectByModelClass(String partitionKey, String rowKey, String eTag, String timestamp, List<ICloudTableColumn> values) {
        ITableStorageEntity newInstance = this.instanceModel(partitionKey, rowKey, eTag, timestamp, values);
        if (newInstance == null) {
            return null;
        }
        if (values != null && !values.isEmpty()) {
            for (ICloudTableColumn column : values) {
                Field field = null;
                try {
                    field = newInstance.getClass().getDeclaredField(column.getName());
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                if (field == null) continue;
                int modifier = field.getModifiers();
                if (Modifier.isPrivate(modifier) && Modifier.isFinal(modifier) && Modifier.isStatic(modifier)) {
                    if (this.getModelClass() == null) continue;
                    Logger.debug(MessageFormat.format("{0} class {1} is a static final field. Can not set data to it.", this.getModelClass().getClass(), field.getName()));
                    continue;
                }
                boolean accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                ETableColumnType type = column.getType();
                String value = column.getValue();
                if (value == null) continue;
                try {
                    if (type == null) {
                        this.setStringOrObjectField(newInstance, column, field, value);
                    } else if (type.equals((Object)ETableColumnType.TYPE_BINARY)) {
                        field.set(newInstance, Base64.decode(value));
                    } else if (type.equals((Object)ETableColumnType.TYPE_BOOL)) {
                        field.setBoolean(newInstance, Boolean.parseBoolean(value));
                    } else if (type.equals((Object)ETableColumnType.TYPE_DATE_TIME)) {
                        field.set(newInstance, Utilities.tryGetDateTimeFromTableEntry(value));
                    } else if (type.equals((Object)ETableColumnType.TYPE_DOUBLE)) {
                        field.setDouble(newInstance, Double.parseDouble(value));
                    } else if (type.equals((Object)ETableColumnType.TYPE_GUID)) {
                        Guid guid = new Guid();
                        try {
                            Field valueField = guid.getClass().getDeclaredField("value");
                            boolean accessiable = valueField.isAccessible();
                            if (!accessible) {
                                valueField.setAccessible(true);
                            }
                            valueField.set(guid, value);
                            valueField.setAccessible(accessiable);
                            field.set(newInstance, guid);
                        }
                        catch (NoSuchFieldException e) {
                            Logger.error(e.getMessage(), e);
                        }
                    } else if (type.equals((Object)ETableColumnType.TYPE_INT)) {
                        try {
                            field.setInt(newInstance, Integer.parseInt(value));
                        }
                        catch (Exception e) {
                            field.setByte(newInstance, Byte.parseByte(value));
                        }
                    } else if (type.equals((Object)ETableColumnType.TYPE_LONG)) {
                        field.setLong(newInstance, Long.parseLong(value));
                    } else if (type.equals((Object)ETableColumnType.TYPE_STRING)) {
                        this.setStringOrObjectField(newInstance, column, field, value);
                    }
                }
                catch (Exception e) {
                    Logger.error(MessageFormat.format("{0} class filed {1} set failed.", this.getModelClass(), value), e);
                }
                field.setAccessible(accessible);
            }
        }
        return newInstance;
    }

    private void setStringOrObjectField(ITableStorageEntity newInstance, ICloudTableColumn column, Field field, String value) {
        Object object = null;
        try {
            field.set(newInstance, value);
        }
        catch (Exception e) {
            try {
                object = Utilities.convertStringToObject(value);
                field.set(newInstance, object);
            }
            catch (Exception e1) {
                Logger.error(MessageFormat.format("Fail to set {0} field value", column), e);
            }
        }
    }

    private ITableStorageEntity instanceModel(String partitionKey, String rowKey, String eTag, String timestamp, List<ICloudTableColumn> values) {
        AbstractTableStorageEntity newInstance = null;
        try {
            newInstance = (AbstractTableStorageEntity)this.getModelClass().getDeclaredConstructor(String.class, String.class).newInstance(partitionKey, rowKey);
            newInstance.setETag(eTag);
            try {
                newInstance.setTimestamp(Utilities.tryGetDateTimeFromTableEntry(timestamp));
            }
            catch (ParseException e) {
                Logger.error(MessageFormat.format("{0} class Timestamp field retrieve time from {2} failed.", this.getModelClass(), timestamp), e);
            }
            newInstance.setValues(values);
        }
        catch (Exception e) {
            Logger.error(MessageFormat.format("Can't instance for class {0}", this.getModelClass()), e);
            throw new StorageException(MessageFormat.format("Can't instance model class. Please check your class {0}. Make sure it has a public constructor method with partitionKey and rowKey as parameters!", this.getModelClass().toString()));
        }
        return newInstance;
    }

    @Override
    public List<ITableStorageEntity> retrieveEntities() throws StorageException {
        return this.retrieveEntities("");
    }

    private String escapeQueryString(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("'", "''");
    }

    @Override
    public List<ITableStorageEntity> retrieveEntitiesByKey(String partitionKey, String rowKey) throws StorageException {
        partitionKey = this.escapeQueryString(partitionKey);
        rowKey = this.escapeQueryString(rowKey);
        StringBuffer buffer = new StringBuffer();
        if (partitionKey != null && rowKey != null) {
            if (this.isInBatch() && this.batch.size() == 0) {
                String id = MessageFormat.format("{0}(PartitionKey=''{1}'',RowKey=''{2}'')", this.tableName, partitionKey, rowKey);
                this.batch.add(new BatchOperation(id, null, "GET", null, null));
                return null;
            }
            buffer.append("PartitionKey").append(" ").append("eq").append(" ").append("'").append(partitionKey).append("'");
            buffer.append(" ").append("and").append(" ");
            buffer.append("RowKey").append(" ").append("eq").append(" ").append("'").append(rowKey).append("'");
        } else if (partitionKey != null) {
            buffer.append("PartitionKey").append(" ").append("eq").append(" ").append("'").append(partitionKey).append("'");
        } else if (rowKey != null) {
            buffer.append("RowKey").append(" ").append("eq").append(" ").append("'").append(rowKey).append("'");
        } else {
            throw new IllegalArgumentException("Query partitionKey or rowKey");
        }
        return this.retrieveEntities("$filter=" + buffer.toString());
    }

    private void performBatch() {
        this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String path = "$batch";
                String queryString = "";
                ResourceUriComponents uriComponents = new ResourceUriComponents(CloudTableRest.this.getAccountName(), path, queryString);
                String batchBoundary = "batch_" + Utilities.computeMD5(String.valueOf(new Date().getTime()));
                String changesetBoundary = "changeset_" + Utilities.computeMD5(String.valueOf(new Date().getTime()));
                URI uri = HttpUtilities.createRequestUri(CloudTableRest.this.getBaseUri(), CloudTableRest.this.isUsePathStyleUris(), CloudTableRest.this.getAccountName(), path, null, CloudTableRest.this.getTimeout(), null, uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "POST");
                request.addHeader("x-ms-version", "2009-07-17");
                request.addHeader("Content-Type", "multipart/mixed; boundary=" + batchBoundary);
                String body = CloudTableRest.this.assambleBatchOperationBody(CloudTableRest.this.batch, batchBoundary, changesetBoundary);
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(body.getBytes()));
                CloudTableRest.this.credentials.signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                    if (response.getStatusCode() == 202) {
                        StringBuilder buf = new StringBuilder(1024);
                        Scanner in = new Scanner(response.getStream());
                        while (in.hasNext()) {
                            buf.append(in.nextLine()).append("\n");
                        }
                        String errorMessage = Utilities.retrieveErrorMessages(buf.toString());
                        if (errorMessage != null) {
                            throw new StorageServerException(StorageErrorCode.BatchOperationError, errorMessage, response.getStatusCode(), null);
                        }
                        Logger.log(buf.toString());
                    } else {
                        HttpUtilities.processUnexpectedStatusCode(response);
                    }
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
                return null;
            }
        });
    }

    private String assambleBatchOperationBody(List<BatchOperation> operations, String batchBoundary, String changesetBoundary) {
        StringBuffer rawData = new StringBuffer();
        rawData.append("--").append(batchBoundary).append("\n");
        if (operations.size() == 1 && operations.get(0).getMethod().equals("GET")) {
            rawData.append("Content-Type: application/http").append("\n");
            rawData.append("Content-Transfer-Encoding: binary").append("\n\n");
            rawData.append(this.getBatchOperationRequest(operations.get(0), 0));
            rawData.append("\n");
        } else {
            rawData.append("Content-Type: multipart/mixed; boundary=" + changesetBoundary + "\n\n");
            int index = 0;
            for (BatchOperation operation : operations) {
                rawData.append("--").append(changesetBoundary).append("\n");
                rawData.append("Content-Type: application/http").append("\n");
                rawData.append("Content-Transfer-Encoding: binary").append("\n\n");
                rawData.append(this.getBatchOperationRequest(operation, index));
                rawData.append("\n");
                ++index;
            }
            rawData.append("--").append(changesetBoundary).append("--").append("\n");
        }
        rawData.append("--").append(batchBoundary).append("--");
        return rawData.toString();
    }

    @Override
    public void clearBatch() {
        this.batch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBatch() {
        if (this.batch == null) {
            throw new IllegalStateException("No batch is started.");
        }
        if (this.batch.isEmpty()) {
            throw new IllegalStateException("Batch does not have any operation.");
        }
        try {
            this.performBatch();
            Object var2_1 = null;
            this.clearBatch();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearBatch();
            throw throwable;
        }
    }

    @Override
    public void startBatch() {
        if (this.isInBatch()) {
            throw new IllegalArgumentException("A batch is already start. Only one batch can be active at a time.");
        }
        this.batch = new ArrayList<BatchOperation>();
    }

    @Override
    public boolean isInBatch() {
        return this.batch != null;
    }

    private String getBatchOperationRequest(BatchOperation op, int index) {
        Header[] headers;
        String path = op.getPath();
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        if ((headers = op.getHeaders()) == null) {
            headers = new Header[]{};
        }
        String requestUrl = this.getBaseUri() + this.urlEncode(path) + this.urlEncode(op.getQueryString());
        String requestBody = op.getRequestBody();
        if (requestBody == null) {
            requestBody = "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(op.getMethod() + " " + requestUrl + " HTTP/1.1\n");
        for (Header header : headers) {
            if (header.getName().equals("Content-Type") || header.getName().equals("Content-Length")) continue;
            buf.append(header.getName() + ":" + header.getValue() + "\n");
        }
        buf.append("Content-ID:" + ++index + "\n");
        if (!op.getMethod().equals("DELETE") && !op.getMethod().equals("GET")) {
            buf.append("Content-Type:application/atom+xml;type=entry\n");
            buf.append("Content-Length:" + requestBody.length() + "\n");
        }
        buf.append("\n");
        buf.append(requestBody);
        return buf.toString();
    }

    private String urlEncode(String url) {
        if (url == null) {
            return "";
        }
        return url.replaceAll(" ", "%20");
    }
}

