/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.dom4j.Document;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.HttpRequestAccessor;
import org.soyatec.windows.azure.blob.io.BlobMemoryStream;
import org.soyatec.windows.azure.blob.io.BlobStream;
import org.soyatec.windows.azure.error.StorageClientException;
import org.soyatec.windows.azure.error.StorageErrorCode;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.error.StorageExtendedErrorInformation;
import org.soyatec.windows.azure.error.StorageServerException;
import org.soyatec.windows.azure.error.WebException;
import org.soyatec.windows.azure.internal.HttpMerge;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.internal.StorageErrorCodeTranslator;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.TimeSpan;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.XmlUtil;

public class HttpUtilities {
    private static final int ErrorTextSizeLimit = 8192;

    public static HttpRequest createHttpRequestWithCommonHeaders(URI uri, String method, TimeSpan timeout) {
        HttpUriRequest request = HttpUtilities.createHttpRequest(uri, method);
        if (timeout != null) {
            request.addHeader("So-Timeout", Long.toString(timeout.toMilliseconds()));
        }
        if (!(request.getHeaders("Content-Length") != null && request.getHeaders("Content-Length").length > 0 || request.getMethod().equals("PUT") || request.getMethod().equals("POST"))) {
            request.addHeader("Content-Length", "0");
        }
        request.addHeader("x-ms-date", Utilities.getUTCTime());
        return request;
    }

    public static HttpRequest createServiceHttpRequest(URI uri, String method) {
        HttpUriRequest request = HttpUtilities.createHttpRequest(uri, method);
        request.addHeader("x-ms-version", "2009-10-01");
        return request;
    }

    public static void addMetadataHeaders(HttpRequest request, NameValueCollection metadata) {
        for (Object keyObj : metadata.keySet()) {
            String key = (String)keyObj;
            String headerName = "x-ms-meta-" + key;
            request.addHeader(headerName.toLowerCase(), metadata.getMultipleValuesAsString(key));
        }
    }

    public static HttpUriRequest createHttpRequest(URI uri, String method) {
        Object request;
        if (method.equals("GET")) {
            request = new HttpGet(uri);
        } else if (method.equals("POST")) {
            request = new HttpPost(uri);
        } else if (method.equals("DELETE")) {
            request = new HttpDelete(uri);
        } else if (method.equals("HEAD")) {
            request = new HttpHead(uri);
        } else if (method.equals("OPTIONS")) {
            request = new HttpOptions(uri);
        } else if (method.equals("PUT")) {
            request = new HttpPut(uri);
        } else if (method.equals("TRACE")) {
            request = new HttpTrace(uri);
        } else if (method.equals("MERGE")) {
            request = new HttpMerge(uri);
        } else {
            throw new IllegalArgumentException(MessageFormat.format("{0} is not a valid HTTP method.", method));
        }
        return request;
    }

    public static HttpClient getHttpsClient(SSLSocketFactory factory) throws Exception {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)factory, 443));
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, registry);
        return new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
    }

    public static HttpWebResponse getSSLReponse(HttpRequest request, SSLSocketFactory factory) throws Exception {
        HttpClient client = HttpUtilities.getHttpsClient(factory);
        return new HttpWebResponse(client.execute((HttpUriRequest)request));
    }

    public static HttpWebResponse getResponse(HttpRequest request) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams params = httpClient.getParams();
        try {
            Long parseLong = Long.parseLong(request.getLastHeader("So-Timeout").getValue());
            request.removeHeader(request.getLastHeader("So-Timeout"));
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)parseLong.intValue());
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)parseLong.intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (request instanceof HttpUriRequest) {
            return new HttpWebResponse(httpClient.execute((HttpUriRequest)request));
        }
        throw new IllegalArgumentException("Request is invalud");
    }

    public static void processUnexpectedStatusCode(HttpWebResponse response) throws StorageServerException {
        StorageExtendedErrorInformation detail = null;
        if (response.getStream() != null) {
            detail = new StorageExtendedErrorInformation();
            detail.setErrorBody(HttpUtilities.convertStreamToString(response.getStream()));
        }
        String exceptionMessage = response.getStatusDescription();
        if (detail != null) {
            exceptionMessage = exceptionMessage + "\r\n" + detail.getErrorBody();
        }
        throw new StorageServerException(StorageErrorCode.ServiceBadResponse, exceptionMessage, response.getStatusCode(), detail, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block11: {
            if (is == null) {
                return null;
            }
            BufferedReader reader = null;
            sb = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            Object var5_5 = null;
            try {
                is.close();
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    Object var5_6 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        String xmlContent = sb.toString();
        int pos = xmlContent.indexOf("?xml");
        if (pos > -1) {
            return "<" + xmlContent.substring(pos);
        }
        return xmlContent;
    }

    public static NameValueCollection parseQueryString(String query) {
        String[] params;
        NameValueCollection map = new NameValueCollection();
        if (query == null) {
            return map;
        }
        for (String param : params = query.split("&")) {
            if (!param.contains("=")) {
                throw new IllegalArgumentException(MessageFormat.format("Query string \"{0}\" is invalid.", param));
            }
            String[] nameValue = param.split("=");
            map.put(nameValue[0], nameValue[1]);
        }
        return map;
    }

    public static NameValueCollection parseHttpHeaders(HttpRequest request) {
        NameValueCollection map = new NameValueCollection();
        for (Header header : request.getAllHeaders()) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }

    public static String parseRequestContentType(HttpRequest request) {
        Header[] headers = request.getHeaders("Content-Type");
        if (headers != null) {
            for (Header header : headers) {
                if (header == null || Utilities.isNullOrEmpty(header.getValue())) continue;
                return header.getValue();
            }
        }
        return Utilities.emptyString();
    }

    public static StorageException translateWebException(Exception e) {
        if (e instanceof StorageException) {
            return (StorageException)e;
        }
        if (e instanceof WebException) {
            WebException we = (WebException)e;
            HttpWebResponse response = we.getResponse();
            if (response != null) {
                StorageExtendedErrorInformation extendedError = HttpUtilities.getExtendedErrorDetailsFromResponse(response.getStream(), response.getContentLength());
                StorageException translatedException = null;
                if (extendedError != null && (translatedException = HttpUtilities.translateExtendedError(extendedError, response.getStatusCode(), response.getStatusDescription(), e)) != null) {
                    return translatedException;
                }
                translatedException = HttpUtilities.translateFromHttpStatus(response.getStatusCode(), response.getStatusDescription(), extendedError, we);
                if (translatedException != null) {
                    return translatedException;
                }
            }
            switch (we.getStatus()) {
                case RequestCanceled: {
                    return new StorageServerException(StorageErrorCode.ServiceTimeout, "The server request did not complete within the specified timeout", 504, we);
                }
                case ConnectFailure: {
                    return new StorageServerException(StorageErrorCode.TransportError, "Connect to server failed", 424, we);
                }
            }
            return new StorageServerException(StorageErrorCode.ServiceInternalError, "The server encountered an unknown failure: " + e.getMessage(), 500, we);
        }
        return new StorageException(e);
    }

    private static StorageException translateFromHttpStatus(int statusCode, String statusDescription, StorageExtendedErrorInformation details, Exception inner) {
        switch (statusCode) {
            case 403: {
                return new StorageClientException(StorageErrorCode.AccessDenied, statusDescription, 403, details, inner);
            }
            case 404: 
            case 410: {
                return new StorageClientException(StorageErrorCode.ResourceNotFound, statusDescription, statusCode, details, inner);
            }
            case 400: {
                return new StorageClientException(StorageErrorCode.BadRequest, statusDescription, statusCode, details, inner);
            }
            case 304: 
            case 412: {
                return new StorageClientException(StorageErrorCode.BadRequest, statusDescription, statusCode, details, inner);
            }
            case 409: {
                return new StorageClientException(StorageErrorCode.ResourceAlreadyExists, statusDescription, statusCode, details, inner);
            }
            case 504: {
                return new StorageServerException(StorageErrorCode.ServiceTimeout, statusDescription, statusCode, details, inner);
            }
            case 416: {
                return new StorageClientException(StorageErrorCode.BadRequest, statusDescription, statusCode, details, inner);
            }
            case 500: {
                return new StorageServerException(StorageErrorCode.ServiceInternalError, statusDescription, statusCode, details, inner);
            }
            case 502: {
                return new StorageServerException(StorageErrorCode.BadGateway, statusDescription, statusCode, details, inner);
            }
        }
        return null;
    }

    private static StorageException translateExtendedError(StorageExtendedErrorInformation details, int statusCode, String statusDescription, Exception e) {
        StorageErrorCode errorCode = StorageErrorCodeTranslator.translateStorageErrorCodeString(details.getErrorCode());
        if (errorCode != StorageErrorCode.None) {
            return new StorageClientException(errorCode, statusDescription, statusCode, details, e);
        }
        errorCode = StorageErrorCodeTranslator.translateStorageErrorCodeString(details.getErrorCode());
        if (errorCode != StorageErrorCode.None) {
            return new StorageServerException(errorCode, statusDescription, statusCode, details, e);
        }
        return null;
    }

    private static StorageExtendedErrorInformation getExtendedErrorDetailsFromResponse(InputStream stream, long contentLength) {
        int bytesToRead = (int)Math.max(contentLength, 8192L);
        byte[] responseBuffer = new byte[bytesToRead];
        int bytesRead = HttpUtilities.copyStreamToBuffer(stream, responseBuffer, bytesToRead);
        return HttpUtilities.getErrorDetailsFromStream(new BlobMemoryStream(responseBuffer, 0, bytesRead));
    }

    private static StorageExtendedErrorInformation getErrorDetailsFromStream(BlobStream stream) {
        StorageExtendedErrorInformation extendedError = new StorageExtendedErrorInformation();
        try {
            Document doc = XmlUtil.parseXmlString(new String(stream.getBytes()));
            Element root = doc.getRootElement();
            extendedError.setErrorCode(root.elementText("Code"));
            extendedError.setErrorMessage(root.elementText("Message"));
            NameValueCollection details = new NameValueCollection();
            extendedError.setAdditionalDetails(details);
            for (Object o : root.elements()) {
                Element e = (Element)o;
                if (e.getName().equals("ExceptionDetails")) {
                    details.put("ExceptionMessage", e.elementText("ExceptionMessage"));
                    details.put("StackTrace", e.elementText("StackTrace"));
                    continue;
                }
                details.put(e.getName(), e.getText());
            }
        }
        catch (Exception e) {
            return null;
        }
        return extendedError;
    }

    private static int copyStreamToBuffer(InputStream stream, byte[] buffer, int bytesToRead) {
        int n = 0;
        int amountLeft = bytesToRead;
        do {
            try {
                n = stream.read(buffer, bytesToRead - amountLeft, amountLeft);
            }
            catch (IOException e) {
                Logger.error("", e);
                break;
            }
            amountLeft -= n;
        } while (n > 0);
        return bytesToRead - amountLeft;
    }

    public static URI createRequestUri(URI baseUri, boolean usePathStyleUris, String accountName, String containerName, String blobName, TimeSpan timeout, NameValueCollection queryParameters, ResourceUriComponents uriComponents) {
        return HttpUtilities.createRequestUri(baseUri, usePathStyleUris, accountName, containerName, blobName, timeout, queryParameters, uriComponents, null);
    }

    public static URI createRequestUri(URI baseUri, boolean usePathStyleUris, String accountName, String containerName, String blobName, TimeSpan timeout, NameValueCollection queryParameters, ResourceUriComponents uriComponents, String appendQuery) {
        URI uri = HttpRequestAccessor.constructResourceUri(baseUri, uriComponents, usePathStyleUris);
        if (queryParameters != null) {
            if (queryParameters.get("timeout") == null && timeout != null) {
                queryParameters.put("timeout", timeout.toSeconds());
            }
            StringBuilder sb = new StringBuilder();
            boolean firstParam = true;
            boolean appendBlockAtTail = false;
            for (Object key : queryParameters.keySet()) {
                String queryKey = (String)key;
                if (queryKey.equalsIgnoreCase("blockid")) {
                    appendBlockAtTail = true;
                    continue;
                }
                if (!firstParam) {
                    sb.append("&");
                }
                sb.append(Utilities.encode(queryKey));
                sb.append('=');
                sb.append(Utilities.encode(queryParameters.getSingleValue(queryKey)));
                firstParam = false;
            }
            if (appendBlockAtTail) {
                String queryKey = "blockid";
                sb.append("&");
                sb.append(Utilities.encode(queryKey));
                sb.append('=');
                sb.append(Utilities.encode(queryParameters.getSingleValue(queryKey)));
            }
            if (!Utilities.isNullOrEmpty(appendQuery)) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(appendQuery.replaceAll(" ", "%20"));
            }
            if (sb.length() > 0) {
                try {
                    return URIUtils.createURI((String)uri.getScheme(), (String)uri.getHost(), (int)uri.getPort(), (String)HttpUtilities.getNormalizePath(uri), (String)((uri.getQuery() == null ? Utilities.emptyString() : uri.getQuery()) + sb.toString()), (String)uri.getFragment());
                }
                catch (URISyntaxException e) {
                    Logger.error("", e);
                }
            }
            return uri;
        }
        return uri;
    }

    public static String getNormalizePath(URI uri) {
        if (Utilities.isNullOrEmpty(uri.getPath())) {
            return "/";
        }
        if (!uri.getPath().startsWith("/")) {
            return "/" + uri.getPath();
        }
        return uri.getPath();
    }

    public static URI removeQueryPart(URI uri) {
        try {
            return URIUtils.createURI((String)uri.getScheme(), (String)uri.getHost(), (int)uri.getPort(), (String)uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            Logger.error("Remove query part from uri failed.", e);
            return uri;
        }
    }
}

