/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util;

import java.util.concurrent.TimeUnit;

public class TimeSpan {
    private TimeUnit unit;
    private long duration;
    public static final TimeSpan ZERO = new TimeSpan(0L, TimeUnit.MILLISECONDS);

    TimeSpan(long value, TimeUnit unit) {
        this.unit = unit;
        this.duration = value;
    }

    public static TimeSpan fromSeconds(long value) {
        return new TimeSpan(value, TimeUnit.SECONDS);
    }

    public static TimeSpan fromMilliseconds(long value) {
        return new TimeSpan(value, TimeUnit.MILLISECONDS);
    }

    public long toMilliseconds() {
        return this.unit.toMillis(this.duration);
    }

    public long toSeconds() {
        return this.unit.toSeconds(this.duration);
    }

    public long compareTo(TimeSpan o) {
        return this.unit.toMillis(this.duration) - o.unit.toMillis(o.duration);
    }
}

