/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public class HttpsX509KeyManager
implements X509KeyManager {
    private final X509ExtendedKeyManager manager;
    private final String certAlias;
    private final PrivateKey privateKey;
    private final X509Certificate certificate;

    public HttpsX509KeyManager(X509ExtendedKeyManager x509ExtendedKeyManager, String certAlias, PrivateKey privateKey, X509Certificate cert) {
        this.manager = x509ExtendedKeyManager;
        this.certAlias = certAlias;
        this.privateKey = privateKey;
        this.certificate = cert;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.certAlias;
    }

    public String chooseEngineClientAlias(String[] arg0, Principal[] arg1, SSLEngine arg2) {
        return this.certAlias;
    }

    public String chooseEngineServerAlias(String arg0, Principal[] arg1, SSLEngine arg2) {
        return this.manager.chooseEngineServerAlias(arg0, arg1, arg2);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.manager.chooseServerAlias(keyType, issuers, socket);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return new X509Certificate[]{this.certificate};
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.manager.getClientAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        if (alias.equals(this.certAlias)) {
            return this.privateKey;
        }
        return this.manager.getPrivateKey(alias);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.manager.getServerAliases(keyType, issuers);
    }
}

