/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util.ssl;

import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTools {
    public static final String PASSWORD = "changeit";
    public static final String ALIAS = "cert";
    public static final String DNAME = "CN=soyatec, OU=soyatec.group, O=soyatec.inc, L=shenzhen, ST=guangdong, C=CN";
    public static final String CERTIFICATE_NAME = "azure.cer";
    public static final String KEYSTORE = ".keystore";
    public static final String TRUSTSTORE = ".trustcacerts";

    public static KeyPair generateKeys() throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyTools.generateKeys(2048);
    }

    public static KeyPair generateKeys(int keysize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA", "BC");
        keygen.initialize(keysize);
        KeyPair rsaKeys = keygen.generateKeyPair();
        return rsaKeys;
    }

    public static void generateSelfCertificate(String keystore, String password, String alias, String dname, int validDays) throws IOException, InterruptedException {
        KeyTools.prepareFolder(keystore);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("keytool");
        commands.add("-selfcert");
        commands.add("-genkey");
        commands.add("-keyalg");
        commands.add("RSA");
        commands.add("-keysize");
        commands.add("2048");
        commands.add("-alias");
        commands.add(alias);
        commands.add("-validity");
        commands.add("" + validDays);
        commands.add("-dname");
        commands.add("\"" + dname + "\"");
        commands.add("-keystore");
        commands.add(keystore);
        commands.add("-keypass");
        commands.add(password);
        commands.add("-storepass");
        commands.add(password);
        KeyTools.execCommand(commands);
    }

    private static void prepareFolder(String keystore) {
        File file = new File(keystore);
        if (file.exists()) {
            return;
        }
        try {
            File dir = file.getParentFile();
            dir.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void execCommand(List<String> commands) throws IOException, InterruptedException {
        String[] command = commands.toArray(new String[commands.size()]);
        Process exec = Runtime.getRuntime().exec(command);
        exec.waitFor();
    }

    public static void exportCertificate(String keystore, String password, String alias, String certFileName) throws IOException, InterruptedException {
        KeyTools.prepareFolder(certFileName);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("keytool");
        commands.add("-export");
        commands.add("-rfc");
        commands.add("-keystore");
        commands.add(keystore);
        commands.add("-storepass");
        commands.add(password);
        commands.add("-alias");
        commands.add(alias);
        commands.add("-file");
        commands.add(certFileName);
        KeyTools.execCommand(commands);
    }

    public static void importCertificateToTrustStore(String keystore, String password, String alias, String certFileName) throws IOException, InterruptedException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("keytool");
        commands.add("-import");
        commands.add("-trustcacerts");
        commands.add("-noprompt");
        commands.add("-keystore");
        commands.add(keystore);
        commands.add("-storepass");
        commands.add(password);
        commands.add("-alias");
        commands.add(alias);
        commands.add("-file");
        commands.add(certFileName);
        KeyTools.execCommand(commands);
    }

    public static void main(String[] args) {
        try {
            KeyTools.generateSelfCertificate("F:/Azure/keys/.keystore", PASSWORD, ALIAS, "CN=soyatec, OU=vg.group, O=soyatec.inc, L=shenzhen, ST=guangdong, C=CN", 7200);
            KeyTools.exportCertificate("F:/Azure/keys/.keystore", PASSWORD, ALIAS, "F:/Azure/keys/test.cer");
            KeyTools.importCertificateToTrustStore("F:/Azure/keys/.trustcacerts", PASSWORD, ALIAS, "F:/Azure/keys/test.cer");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

