/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util.xml;

import java.io.InputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.error.StorageErrorCode;
import org.soyatec.windows.azure.error.StorageServerException;
import org.soyatec.windows.azure.internal.constants.HttpStatusConstant;
import org.soyatec.windows.azure.management.AffinityGroup;
import org.soyatec.windows.azure.management.AffinityGroupProperties;
import org.soyatec.windows.azure.management.Certificate;
import org.soyatec.windows.azure.management.CurrentUpgradeDomainState;
import org.soyatec.windows.azure.management.Deployment;
import org.soyatec.windows.azure.management.HostedService;
import org.soyatec.windows.azure.management.HostedServiceProperties;
import org.soyatec.windows.azure.management.OperatingSystem;
import org.soyatec.windows.azure.management.OperationState;
import org.soyatec.windows.azure.management.OperationStatus;
import org.soyatec.windows.azure.management.RoleInstance;
import org.soyatec.windows.azure.management.StorageAccount;
import org.soyatec.windows.azure.management.StorageAccountProperties;
import org.soyatec.windows.azure.management.UpgradeStatus;
import org.soyatec.windows.azure.management.UpgradeType;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.AtomUtil;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathQueryHelper {
    private static final String XMLNS = "xmlns";
    private static final String ATOM_ENTRY_PATH = "//atom:entry";
    public static final String NextMarkerQuery = XPathQueryHelper.join("/", new String[]{"", "", "EnumerationResults", "NextMarker"});
    public static final String ContainerQuery = XPathQueryHelper.join("/", new String[]{"", "", "EnumerationResults", "Containers", "Container"});
    public static final String BlobQuery = XPathQueryHelper.join("/", new String[]{"", "", "EnumerationResults", "Blobs", "Blob"});
    public static final String PageRangeQuery = XPathQueryHelper.join("/", new String[]{"", "", "PageList", "PageRange"});
    public static final String BlockQuery = XPathQueryHelper.join("/", new String[]{"", "", "BlockList", "Block"});
    public static final String QueueListQuery = XPathQueryHelper.join("/", new String[]{"", "", "EnumerationResults", "Queues", "Queue"});
    public static final String MessagesListQuery = XPathQueryHelper.join("/", new String[]{"", "", "QueueMessagesList", "QueueMessage"});
    public static final String CommonPrefixQuery = XPathQueryHelper.join("/", new String[]{"", "", "EnumerationResults", "Blob", "BlobPrefix"});
    public static final String SignedIdentifierListQuery = XPathQueryHelper.join("/", new String[]{"", "", "SignedIdentifier"});
    public static final String HostServiceListQuery = XPathQueryHelper.globalQueryPath("HostedService");
    public static final String StorageServiceListQuery = XPathQueryHelper.globalQueryPath("StorageService");
    public static final String AffinifyGroupListQuery = XPathQueryHelper.globalQueryPath("AffinityGroup");
    public static final String RoleInstanceQuery = XPathQueryHelper.globalQueryPath("RoleInstance");
    public static final String OperationQuery = XPathQueryHelper.globalQueryPath("Operation");
    public static final String DeploymentQuery = XPathQueryHelper.globalQueryPath("Deployment");
    public static final String CertificateListQuery = XPathQueryHelper.globalQueryPath("Certificate");
    public static final String OperatingSystemQuery = XPathQueryHelper.globalQueryPath("OperatingSystem");

    private static String globalQueryPath(String elementName) {
        return XPathQueryHelper.join("/", new String[]{"", "", XPathQueryHelper.addXmlnsNameSpace(elementName)});
    }

    public static final String addXmlnsNameSpace(String query) {
        return XPathQueryHelper.join("", new String[]{XMLNS, ":", query});
    }

    private static String join(String delimiter, String[] source) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < source.length; ++i) {
            buffer.append(source[i]);
            if (i >= source.length - 1) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String loadSingleChildStringValue(Element node, String childName, boolean throwIfNotFound) {
        Element childNode = (Element)node.selectSingleNode(childName);
        if (childNode != null && childNode.hasContent()) {
            return childNode.node(0).getText();
        }
        if (!throwIfNotFound) {
            return null;
        }
        return null;
    }

    public static Timestamp loadSingleChildDateTimeValue(Element blobNode, String childName, boolean throwIfNotFound) {
        Element childNode = (Element)blobNode.selectSingleNode(childName);
        if (childNode != null && childNode.hasContent()) {
            try {
                Timestamp date = Utilities.tryGetDateTimeFromHttpString(childNode.getStringValue());
                return date;
            }
            catch (ParseException e) {
                throw new StorageServerException(StorageErrorCode.ServiceBadResponse, "Date time value returned from server " + childNode.getStringValue() + " can't be parsed.", HttpStatusConstant.DEFAULT_STATUS, null);
            }
        }
        if (!throwIfNotFound) {
            return null;
        }
        return null;
    }

    public static Long loadSingleChildLongValue(Element blobNode, String childName, boolean throwIfNotFound) throws StorageServerException {
        Element childNode = (Element)blobNode.selectSingleNode(childName);
        if (childNode != null && childNode.hasContent()) {
            try {
                return Long.parseLong(childNode.getStringValue());
            }
            catch (Exception e) {
                throw new StorageServerException(StorageErrorCode.ServiceBadResponse, "Reponse size field is not a valid long number." + childNode.getStringValue() + " can't be parsed.", HttpStatusConstant.DEFAULT_STATUS, null);
            }
        }
        if (!throwIfNotFound) {
            return null;
        }
        return null;
    }

    public static String loadTableNameFromTableEntry(Element element) {
        return element.element("content").element("properties").elementText("TableName");
    }

    public static String loadTableEntryPropertyValue(Element element, String propertyName) {
        if (Utilities.isNullOrEmpty(propertyName)) {
            throw new IllegalArgumentException("property name");
        }
        String value = XPathQueryHelper.loadTableEntryProperties(element).elementText(propertyName);
        return AtomUtil.unescapeXml(value);
    }

    public static String loadTableEntryValueFromAttribute(Element element, String propertyName) {
        if (Utilities.isNullOrEmpty(propertyName)) {
            throw new IllegalArgumentException("property name");
        }
        return element.attribute(propertyName).getValue();
    }

    public static Element loadTableEntryProperties(Element element) {
        return element.element("content").element("properties");
    }

    public static List parseEntryFromFeed(Document doc) {
        HashMap<String, String> xmlMap = new HashMap<String, String>();
        xmlMap.put("atom", "http://www.w3.org/2005/Atom");
        XPath x = doc.createXPath(ATOM_ENTRY_PATH);
        x.setNamespaceURIs(xmlMap);
        return x.selectNodes((Object)doc);
    }

    public static List serviceXmlSelected(Node doc, String path) {
        HashMap<String, String> xmlMap = new HashMap<String, String>();
        xmlMap.put(XMLNS, "http://schemas.microsoft.com/windowsazure");
        XPath x = doc.createXPath(path);
        x.setNamespaceURIs(xmlMap);
        return x.selectNodes((Object)doc);
    }

    public static Node serviceXmlSelectSingle(Node doc, String path) {
        HashMap<String, String> xmlMap = new HashMap<String, String>();
        xmlMap.put(XMLNS, "http://schemas.microsoft.com/windowsazure");
        XPath x = doc.createXPath(path);
        x.setNamespaceURIs(xmlMap);
        Node selectSingleNode = x.selectSingleNode((Object)doc);
        return selectSingleNode;
    }

    public static List<HostedService> parseHostServiceResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        List result = XPathQueryHelper.serviceXmlSelected((Node)load, HostServiceListQuery);
        if (result == null || result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HostedService> hss = new ArrayList<HostedService>();
        int n = result.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)result.get(i);
            String url = XPathQueryHelper.getStringValue((Node)element, "Url");
            String name = XPathQueryHelper.getStringValue((Node)element, "ServiceName");
            HostedService service = new HostedService(name);
            service.setUrl(url);
            hss.add(service);
        }
        return hss;
    }

    public static List<StorageAccount> parseStorageServiceResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        List result = XPathQueryHelper.serviceXmlSelected((Node)load, StorageServiceListQuery);
        if (result == null || result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StorageAccount> storageServiceList = new ArrayList<StorageAccount>();
        int n = result.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)result.get(i);
            String url = XPathQueryHelper.getStringValue((Node)element, "Url");
            String name = XPathQueryHelper.getStringValue((Node)element, "ServiceName");
            StorageAccount service = new StorageAccount(name);
            service.setUrl(url);
            storageServiceList.add(service);
        }
        return storageServiceList;
    }

    public static StorageAccountProperties parseStorageServicePropertiesResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        Element storageServiceElement = load.getRootElement();
        if (storageServiceElement == null) {
            return null;
        }
        Element element = (Element)XPathQueryHelper.serviceXmlSelectSingle((Node)storageServiceElement, XPathQueryHelper.addXmlnsNameSpace("StorageServiceProperties"));
        String description = XPathQueryHelper.getStringValue((Node)element, "Description");
        String label = XPathQueryHelper.getStringValue((Node)element, "Label");
        String location = XPathQueryHelper.getStringValue((Node)element, "Location");
        Node groupElement = XPathQueryHelper.serviceXmlSelectSingle((Node)element, XPathQueryHelper.addXmlnsNameSpace("AffinityGroup"));
        String group = groupElement == null ? null : groupElement.getStringValue();
        return new StorageAccountProperties(description, group, location, label);
    }

    public static StorageAccount parseStorageServiceKeysResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        Element storageServiceElement = load.getRootElement();
        if (storageServiceElement == null) {
            return null;
        }
        String url = XPathQueryHelper.getStringValue((Node)storageServiceElement, "Url");
        Element keyElement = (Element)XPathQueryHelper.serviceXmlSelectSingle((Node)storageServiceElement, XPathQueryHelper.addXmlnsNameSpace("StorageServiceKeys"));
        String primaryKey = XPathQueryHelper.getStringValue((Node)keyElement, "Primary");
        String secondaryKey = XPathQueryHelper.getStringValue((Node)keyElement, "Secondary");
        StorageAccount service = new StorageAccount();
        service.setUrl(url);
        service.setPrimaryKey(primaryKey);
        service.setSecondaryKey(secondaryKey);
        return service;
    }

    public static HostedServiceProperties parseHostedPropertiesResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        Element root = load.getRootElement();
        HostedServiceProperties result = new HostedServiceProperties();
        result.setUrl(XPathQueryHelper.getStringValue((Node)root, "Url"));
        Element element = (Element)XPathQueryHelper.serviceXmlSelectSingle((Node)root, XPathQueryHelper.addXmlnsNameSpace("HostedServiceProperties"));
        result.setDescription(XPathQueryHelper.getStringValue((Node)element, "Description"));
        result.setAffinityGroup(XPathQueryHelper.getStringValue((Node)element, "AffinityGroup"));
        result.setLocation(XPathQueryHelper.getStringValue((Node)element, "Location"));
        result.setLabel(XPathQueryHelper.getStringValue((Node)element, "Label", true));
        List deployments = XPathQueryHelper.serviceXmlSelected((Node)element, DeploymentQuery);
        if (deployments != null && !deployments.isEmpty()) {
            for (int i = 0; i < deployments.size(); ++i) {
                Element d = (Element)deployments.get(i);
                result.addDeployment(XPathQueryHelper.parseDeployment(d));
            }
        }
        return result;
    }

    private static String getStringValue(Node node, String query, boolean decodeBase64) {
        Node child = XPathQueryHelper.serviceXmlSelectSingle(node, XPathQueryHelper.addXmlnsNameSpace(query));
        if (child == null) {
            return "";
        }
        String value = child.getStringValue();
        if (decodeBase64) {
            return new String(Base64.decode(value));
        }
        return value;
    }

    private static String getStringValue(Node node, String query) {
        return XPathQueryHelper.getStringValue(node, query, false);
    }

    public static Deployment parseDeploymentResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        Element deploymentElement = load.getRootElement();
        if (deploymentElement == null) {
            return null;
        }
        return XPathQueryHelper.parseDeployment(deploymentElement);
    }

    private static Deployment parseDeployment(Element deploymentElement) {
        Deployment deployment = new Deployment();
        XPathQueryHelper.parseDeploymentAttributes(deploymentElement, deployment);
        XPathQueryHelper.parseDeploymentStatus(deploymentElement, deployment);
        XPathQueryHelper.parseRoleInstanceList(deploymentElement, deployment);
        return deployment;
    }

    private static void parseRoleInstanceList(Element storageServiceElement, Deployment deployment) {
        List roles = XPathQueryHelper.serviceXmlSelected((Node)storageServiceElement, RoleInstanceQuery);
        if (roles != null && !roles.isEmpty()) {
            for (Element roleInstanceElement : roles) {
                String roleName = XPathQueryHelper.getStringValue((Node)roleInstanceElement, "RoleName");
                String instanceName = XPathQueryHelper.getStringValue((Node)roleInstanceElement, "InstanceName");
                String instanceState = XPathQueryHelper.getStringValue((Node)roleInstanceElement, "InstanceStatus");
                RoleInstance roleInstance = new RoleInstance(roleName, instanceName, instanceState);
                deployment.addRoleInstance(roleInstance);
            }
        }
    }

    private static void parseDeploymentStatus(Element storageServiceElement, Deployment deployment) {
        Element upgradeStatusElement = (Element)XPathQueryHelper.serviceXmlSelectSingle((Node)storageServiceElement, XPathQueryHelper.addXmlnsNameSpace("UpgradeStatus"));
        if (upgradeStatusElement == null) {
            return;
        }
        String upgradeType = XPathQueryHelper.getStringValue((Node)upgradeStatusElement, "UpgradeType");
        String currentUpgradeDomainState = XPathQueryHelper.getStringValue((Node)upgradeStatusElement, "CurrentUpgradeDomainState");
        String currentUpgradeDomain = XPathQueryHelper.getStringValue((Node)upgradeStatusElement, "CurrentUpgradeDomain");
        UpgradeStatus upgradeStatus = new UpgradeStatus();
        upgradeStatus.setUpgradeType(UpgradeType.get(upgradeType));
        upgradeStatus.setCurrentUpgradeDomain(currentUpgradeDomain);
        upgradeStatus.setCurrentUpgradeDomainState(CurrentUpgradeDomainState.get(currentUpgradeDomainState));
        deployment.setUpgradeStatus(upgradeStatus);
    }

    private static void parseDeploymentAttributes(Element storageServiceElement, Deployment deployment) {
        String name = XPathQueryHelper.getStringValue((Node)storageServiceElement, "Name");
        deployment.setName(name);
        String label = XPathQueryHelper.getStringValue((Node)storageServiceElement, "Label");
        if (label != null) {
            deployment.setLabel(new String(Base64.decode(label)));
        }
        String slot = XPathQueryHelper.getStringValue((Node)storageServiceElement, "DeploymentSlot");
        deployment.setDeploymentSlot(slot);
        String url = XPathQueryHelper.getStringValue((Node)storageServiceElement, "Url");
        deployment.setUrl(url);
        String privateId = XPathQueryHelper.getStringValue((Node)storageServiceElement, "PrivateID");
        deployment.setPrivateId(privateId);
        String configuration = XPathQueryHelper.getStringValue((Node)storageServiceElement, "Configuration");
        System.out.println(configuration);
        if (configuration != null) {
            deployment.setConfiguration(new String(Base64.decode(configuration)));
        }
        String status = XPathQueryHelper.getStringValue((Node)storageServiceElement, "Status");
        deployment.setStatus(status);
    }

    public static List<AffinityGroup> parseAffinityGroupResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        List result = XPathQueryHelper.serviceXmlSelected((Node)load, AffinifyGroupListQuery);
        if (result == null || result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AffinityGroup> groupList = new ArrayList<AffinityGroup>();
        int n = result.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)result.get(i);
            String name = XPathQueryHelper.getStringValue((Node)element, "Name");
            String description = XPathQueryHelper.getStringValue((Node)element, "Description");
            String location = XPathQueryHelper.getStringValue((Node)element, "Location");
            AffinityGroup group = new AffinityGroup();
            group.setName(name);
            group.setDescription(description);
            group.setLocation(location);
            groupList.add(group);
        }
        return groupList;
    }

    public static OperationStatus parseOperationStatusResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        Element root = load.getRootElement();
        if (root == null) {
            return null;
        }
        Element element = (Element)XPathQueryHelper.serviceXmlSelectSingle((Node)root, OperationQuery);
        OperationStatus result = new OperationStatus();
        String id = XPathQueryHelper.getStringValue((Node)element, "ID");
        String status = XPathQueryHelper.getStringValue((Node)element, "Status");
        result.setRequestId(id);
        result.setStatus(OperationState.valueOf(status));
        try {
            String httpCode = XPathQueryHelper.getStringValue((Node)element, "HTTPCode");
            result.setHttpCode(httpCode);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Node errorElement = XPathQueryHelper.serviceXmlSelectSingle((Node)element, XPathQueryHelper.addXmlnsNameSpace("Error"));
            if (errorElement != null) {
                String httpErrorCode = XPathQueryHelper.getStringValue(errorElement, "Code");
                String httpErrorMessage = XPathQueryHelper.getStringValue(errorElement, "Message");
                result.setErrorCode(httpErrorCode);
                result.setErrorMessage(httpErrorMessage);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static AffinityGroupProperties parseAffinityGroupPropertiesResponse(InputStream stream) {
        List services;
        Document load = XmlUtil.load(stream);
        Element element = load.getRootElement();
        if (element == null) {
            return null;
        }
        AffinityGroupProperties result = new AffinityGroupProperties();
        String description = XPathQueryHelper.getStringValue((Node)element, "Description");
        result.setDescription(description);
        String location = XPathQueryHelper.getStringValue((Node)element, "Location");
        result.setLocation(location);
        List hosts = XPathQueryHelper.serviceXmlSelected((Node)load, HostServiceListQuery);
        if (hosts != null && !hosts.isEmpty()) {
            for (Object e : hosts) {
                result.addHostedService(XPathQueryHelper.getStringValue((Node)e, "Url"));
            }
        }
        if ((services = XPathQueryHelper.serviceXmlSelected((Node)load, StorageServiceListQuery)) != null && !services.isEmpty()) {
            for (Object e : services) {
                result.addHostedService(XPathQueryHelper.getStringValue((Node)e, "Url"));
            }
        }
        return result;
    }

    public static List<Certificate> parseCertificateResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        List result = XPathQueryHelper.serviceXmlSelected((Node)load, CertificateListQuery);
        if (result == null || result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        int n = result.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)result.get(i);
            Certificate cert = XPathQueryHelper.parseCertificate(element);
            list.add(cert);
        }
        return list;
    }

    public static Certificate parseCertificate(Element element) {
        Certificate cert = new Certificate();
        String certificateUrl = XPathQueryHelper.getStringValue((Node)element, "CertificateUrl");
        String algorithm = XPathQueryHelper.getStringValue((Node)element, "ThumbprintAlgorithm");
        String thumbprint = XPathQueryHelper.getStringValue((Node)element, "Thumbprint");
        String data = XPathQueryHelper.getStringValue((Node)element, "Data");
        cert.setCertificateUrl(certificateUrl);
        cert.setThumbprintAlgorithm(algorithm);
        cert.setThumbprint(thumbprint);
        cert.setData(Base64.decode(data));
        return cert;
    }

    public static List<OperatingSystem> parseOperatingSystemResponse(InputStream stream) {
        Document load = XmlUtil.load(stream);
        List result = XPathQueryHelper.serviceXmlSelected((Node)load, OperatingSystemQuery);
        if (result == null || result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<OperatingSystem> list = new ArrayList<OperatingSystem>();
        int n = result.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)result.get(i);
            OperatingSystem cert = XPathQueryHelper.parseOperatingSystem(element);
            list.add(cert);
        }
        return list;
    }

    private static OperatingSystem parseOperatingSystem(Element element) {
        OperatingSystem result = new OperatingSystem();
        String version = XPathQueryHelper.getStringValue((Node)element, "Version");
        String label = XPathQueryHelper.getStringValue((Node)element, "Label");
        boolean _default = "true".equalsIgnoreCase(XPathQueryHelper.getStringValue((Node)element, "IsDefault"));
        boolean active = "true".equalsIgnoreCase(XPathQueryHelper.getStringValue((Node)element, "IsActive"));
        result.setVersion(version);
        result.setLabel(label == null ? null : new String(Base64.decode(label)));
        result.setDefault(_default);
        result.setActive(active);
        return result;
    }
}

