/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util.xml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.soyatec.windows.azure.error.StorageErrorCode;
import org.soyatec.windows.azure.error.StorageServerException;
import org.soyatec.windows.azure.internal.constants.HttpStatusConstant;

public class XmlUtil {
    public static Document load(InputStream stream) throws StorageServerException {
        SAXReader reader = new SAXReader();
        try {
            return reader.read(stream);
        }
        catch (DocumentException e) {
            throw new StorageServerException(StorageErrorCode.ServiceBadResponse, "The result of a List operation could not be parsed", HttpStatusConstant.DEFAULT_STATUS, (Exception)((Object)e));
        }
    }

    public static Document load(InputStream stream, String parseMessage) throws StorageServerException {
        SAXReader reader = new SAXReader();
        try {
            return reader.read(stream);
        }
        catch (DocumentException e) {
            throw new StorageServerException(StorageErrorCode.ServiceBadResponse, parseMessage, HttpStatusConstant.DEFAULT_STATUS, (Exception)((Object)e));
        }
    }

    public static Document parseXmlString(String xmlContent) throws Exception {
        SAXReader reader = new SAXReader();
        return reader.read((Reader)new StringReader(xmlContent));
    }
}

