/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Status;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.ExtensionComparator;
import ch.cyberduck.ui.FileTypeComparator;
import ch.cyberduck.ui.FilenameComparator;
import ch.cyberduck.ui.GroupComparator;
import ch.cyberduck.ui.OwnerComparator;
import ch.cyberduck.ui.PermissionsComparator;
import ch.cyberduck.ui.SizeComparator;
import ch.cyberduck.ui.TimestampComparator;
import ch.cyberduck.ui.cocoa.AbstractTableDelegate;
import java.util.Comparator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPathTableDelegate
extends AbstractTableDelegate<Path> {
    private static Logger log = Logger.getLogger(AbstractTableDelegate.class);

    @Override
    public String tooltip(Path p) {
        return p.getAbsolute() + "\n" + Status.getSizeAsString((double)p.attributes().getSize()) + "\n" + DateFormatterFactory.instance().getLongFormat(p.attributes().getModificationDate());
    }

    @Override
    public Comparator<Path> getSortingComparator() {
        boolean ascending = this.isSortedAscending();
        String identifier = this.selectedColumnIdentifier();
        if (identifier.equals("ICON") || identifier.equals("KIND")) {
            return new FileTypeComparator(ascending);
        }
        if (identifier.equals("EXTENSION")) {
            return new ExtensionComparator(ascending);
        }
        if (identifier.equals("FILENAME")) {
            return new FilenameComparator(ascending);
        }
        if (identifier.equals("SIZE")) {
            return new SizeComparator(ascending);
        }
        if (identifier.equals("MODIFIED")) {
            return new TimestampComparator(ascending);
        }
        if (identifier.equals("OWNER")) {
            return new OwnerComparator(ascending);
        }
        if (identifier.equals("GROUP")) {
            return new GroupComparator(ascending);
        }
        if (identifier.equals("PERMISSIONS")) {
            return new PermissionsComparator(ascending);
        }
        log.error((Object)("Unknown column identifier:" + identifier));
        return new NullComparator();
    }
}

