/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.TableDelegate;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableDelegate<E>
extends ProxyController
implements TableDelegate<E> {
    private static Logger log = Logger.getLogger(AbstractTableDelegate.class);
    private NSTableColumn selectedColumn;
    private Boolean sortAscending;

    protected void setSelectedColumn(NSTableColumn selectedColumn) {
        this.selectedColumn = selectedColumn;
        Preferences.instance().setProperty("browser.sort.column", this.selectedColumnIdentifier());
    }

    protected String selectedColumnIdentifier() {
        if (null == this.selectedColumn) {
            return Preferences.instance().getProperty("browser.sort.column");
        }
        return this.selectedColumn.identifier();
    }

    public boolean isColumnRowEditable(NSTableColumn column, int row) {
        return false;
    }

    public boolean tableView_shouldSelectRow(NSTableView view, NSInteger row) {
        return true;
    }

    public boolean outlineView_shouldSelectItem(NSOutlineView view, NSObject item) {
        return true;
    }

    public boolean tableView_shouldEditTableColumn_row(NSTableView view, NSTableColumn c, NSInteger row) {
        return this.isColumnRowEditable(c, row.intValue());
    }

    public boolean outlineView_shouldEditTableColumn_item(NSOutlineView view, NSTableColumn c, NSObject item) {
        return this.isColumnRowEditable(c, -1);
    }

    public boolean selectionShouldChange() {
        return true;
    }

    public boolean selectionShouldChangeInTableView(NSTableView view) {
        return this.selectionShouldChange();
    }

    public boolean selectionShouldChangeInOutlineView(NSTableView view) {
        return this.selectionShouldChange();
    }

    public abstract void tableColumnClicked(NSTableView var1, NSTableColumn var2);

    public void outlineView_didClickTableColumn(NSOutlineView view, NSTableColumn tableColumn) {
        this.tableColumnClicked(view, tableColumn);
    }

    public void tableView_didClickTableColumn(NSOutlineView view, NSTableColumn tableColumn) {
        this.tableColumnClicked(view, tableColumn);
    }

    public abstract void tableRowDoubleClicked(ID var1);

    public void tableViewSelectionDidChange(NSNotification notification) {
        this.selectionDidChange(notification);
    }

    public void tableViewSelectionIsChanging(NSNotification notification) {
        this.selectionIsChanging(notification);
    }

    public void outlineViewSelectionDidChange(NSNotification notification) {
        this.selectionDidChange(notification);
    }

    public void outlineViewSelectionIsChanging(NSNotification notification) {
        this.selectionIsChanging(notification);
    }

    public abstract void selectionDidChange(NSNotification var1);

    public void selectionIsChanging(NSNotification notification) {
    }

    @Override
    public Comparator<E> getSortingComparator() {
        return new NullComparator();
    }

    public void setSortedAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
        Preferences.instance().setProperty("browser.sort.ascending", this.sortAscending.booleanValue());
    }

    @Override
    public boolean isSortedAscending() {
        if (null == this.sortAscending) {
            return Preferences.instance().getBoolean("browser.sort.ascending");
        }
        return this.sortAscending;
    }

    public boolean tableView_shouldTypeSelectForEvent_withCurrentSearchString(NSTableView tableView, NSEvent event, String searchString) {
        return this.isTypeSelectSupported();
    }

    protected abstract boolean isTypeSelectSupported();
}

