/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.HostKeyControllerFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.sftp.HostKeyController;
import ch.cyberduck.core.sftp.MemoryHostKeyVerifier;
import ch.cyberduck.ui.Controller;
import ch.cyberduck.ui.cocoa.AlertController;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.TransferController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.foundation.NSAutoreleasePool;
import ch.ethz.ssh2.KnownHosts;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class AlertHostKeyController
extends MemoryHostKeyVerifier {
    protected static Logger log = Logger.getLogger(AlertHostKeyController.class);
    private WindowController parent;
    private Local file;

    public static void register() {
        HostKeyControllerFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (HostKeyControllerFactory)new Factory());
    }

    public AlertHostKeyController(WindowController c) {
        this.parent = c;
    }

    protected KnownHosts getDatabase() {
        this.file = LocalFactory.createLocal((String)Preferences.instance().getProperty("ssh.knownhosts"));
        if (!this.file.exists()) {
            this.file.touch(true);
        }
        if (this.file.attributes().getPermission().isReadable()) {
            try {
                this.database = new KnownHosts(this.file.getAbsolute());
            }
            catch (IOException e) {
                log.error((Object)("Cannot read " + this.file.getAbsolute() + ":" + e.getMessage()));
            }
        }
        if (null == this.database) {
            return super.getDatabase();
        }
        return this.database;
    }

    protected boolean isHostKeyDatabaseWritable() {
        return this.file.attributes().getPermission().isWritable();
    }

    protected boolean isUnknownKeyAccepted(final String hostname, int port, final String serverHostKeyAlgorithm, final byte[] serverHostKey) throws ConnectionCanceledException {
        NSAlert alert = NSAlert.alert(MessageFormat.format(Locale.localizedString((String)"Unknown host key for {0}."), hostname), MessageFormat.format(Locale.localizedString((String)"The host is currently unknown to the system. The host key fingerprint is {0}."), KnownHosts.createHexFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey)), Locale.localizedString((String)"Allow"), Locale.localizedString((String)"Deny"), null);
        if (this.isHostKeyDatabaseWritable()) {
            alert.setShowsSuppressionButton(true);
            alert.suppressionButton().setTitle(Locale.localizedString((String)"Always"));
        }
        alert.setShowsHelp(true);
        AlertController c = new AlertController(this.parent, alert){

            public void callback(int returncode) {
                if (returncode == 1) {
                    AlertHostKeyController.this.allow(hostname, serverHostKeyAlgorithm, serverHostKey, this.alert.suppressionButton().state() == 1);
                } else {
                    log.warn((Object)"Cannot continue without a valid host key");
                }
            }

            protected void help() {
                StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
                site.append("/").append(Protocol.SFTP.getIdentifier());
                1.openUrl(site.toString());
            }
        };
        c.beginSheet();
        if (c.returnCode() == -1) {
            throw new ConnectionCanceledException();
        }
        return c.returnCode() == 1 || c.returnCode() == 0;
    }

    protected boolean isChangedKeyAccepted(final String hostname, int port, final String serverHostKeyAlgorithm, final byte[] serverHostKey) throws ConnectionCanceledException {
        NSAlert alert = NSAlert.alert(MessageFormat.format(Locale.localizedString((String)"Host key mismatch for {0}"), hostname), MessageFormat.format(Locale.localizedString((String)"The host key supplied is {0}."), KnownHosts.createHexFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey)), Locale.localizedString((String)"Allow"), Locale.localizedString((String)"Deny"), null);
        if (this.isHostKeyDatabaseWritable()) {
            alert.setShowsSuppressionButton(true);
            alert.suppressionButton().setTitle(Locale.localizedString((String)"Always"));
        }
        alert.setShowsHelp(true);
        AlertController c = new AlertController(this.parent, alert){

            public void callback(int returncode) {
                if (returncode == 1) {
                    AlertHostKeyController.this.allow(hostname, serverHostKeyAlgorithm, serverHostKey, this.alert.suppressionButton().state() == 1);
                } else {
                    log.warn((Object)"Cannot continue without a valid host key");
                }
            }

            protected void help() {
                StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
                site.append("/").append(Protocol.SFTP.getIdentifier());
                2.openUrl(site.toString());
            }
        };
        c.beginSheet();
        if (c.returnCode() == -1) {
            throw new ConnectionCanceledException();
        }
        return c.returnCode() == 1 || c.returnCode() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
        boolean bl;
        NSAutoreleasePool pool = NSAutoreleasePool.push();
        try {
            bl = super.verifyServerHostKey(hostname, port, serverHostKeyAlgorithm, serverHostKey);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            pool.drain();
            throw throwable;
        }
        pool.drain();
        return bl;
    }

    protected void save(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey) {
        try {
            KnownHosts.addHostkeyToFile((File)new File(this.file.getAbsolute()), (String[])new String[]{KnownHosts.createHashedHostname((String)hostname)}, (String)serverHostKeyAlgorithm, (byte[])serverHostKey);
        }
        catch (IOException ignore) {
            log.error((Object)ignore.getMessage());
        }
    }

    private static class Factory
    extends HostKeyControllerFactory {
        private Factory() {
        }

        protected HostKeyController create() {
            return new AlertHostKeyController(TransferController.instance());
        }

        public HostKeyController create(Controller c) {
            return new AlertHostKeyController((WindowController)c);
        }

        public HostKeyController create(Session s) {
            for (BrowserController c : MainController.getBrowsers()) {
                if (c.getSession() != s) continue;
                return this.create((Controller)c);
            }
            return this.create();
        }
    }
}

