/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.serializer.HostReaderFactory;
import ch.cyberduck.core.serializer.HostWriterFactory;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.AbstractController;
import ch.cyberduck.ui.cocoa.AttributeCache;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.HostPasteboard;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.ListDataSource;
import ch.cyberduck.ui.cocoa.TransferController;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSMutableDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public class BookmarkTableDataSource
extends ListDataSource {
    private static Logger log = Logger.getLogger(BookmarkTableDataSource.class);
    public static final String ICON_COLUMN = "ICON";
    public static final String BOOKMARK_COLUMN = "BOOKMARK";
    public static final String STATUS_COLUMN = "STATUS";
    protected static final String TYPEAHEAD_COLUMN = "TYPEAHEAD";
    protected BrowserController controller;
    private AbstractHostCollection source = AbstractHostCollection.empty();
    private CollectionListener<Host> listener;
    private HostFilter filter;
    private AbstractHostCollection filtered;
    private AttributeCache<Host> cache = new AttributeCache(Preferences.instance().getInteger("bookmark.model.cache.size"));

    public BookmarkTableDataSource(BrowserController controller, AbstractHostCollection source) {
        this.controller = controller;
        this.setSource(source);
    }

    public void setSource(AbstractHostCollection source) {
        this.source.removeListener(this.listener);
        this.source = source;
        this.listener = new CollectionListener<Host>(){
            private ScheduledFuture<?> delayed = null;

            public void collectionLoaded() {
                BookmarkTableDataSource.this.cache.clear();
                BookmarkTableDataSource.this.invoke((MainAction)new WindowMainAction(BookmarkTableDataSource.this.controller){

                    public void run() {
                        BookmarkTableDataSource.this.controller.reloadBookmarks();
                    }
                });
            }

            public void collectionItemAdded(Host item) {
                BookmarkTableDataSource.this.cache.remove(item);
                BookmarkTableDataSource.this.invoke((MainAction)new WindowMainAction(BookmarkTableDataSource.this.controller){

                    public void run() {
                        BookmarkTableDataSource.this.controller.reloadBookmarks();
                    }
                });
            }

            public void collectionItemRemoved(Host item) {
                BookmarkTableDataSource.this.cache.remove(item);
                BookmarkTableDataSource.this.invoke((MainAction)new WindowMainAction(BookmarkTableDataSource.this.controller){

                    public void run() {
                        BookmarkTableDataSource.this.controller.reloadBookmarks();
                    }
                });
            }

            public void collectionItemChanged(Host item) {
                BookmarkTableDataSource.this.cache.remove(item);
                if (null != this.delayed) {
                    this.delayed.cancel(false);
                }
                this.delayed = AbstractController.getTimerPool().schedule(new Runnable(){

                    public void run() {
                        BookmarkTableDataSource.this.controller.invoke((MainAction)new WindowMainAction(BookmarkTableDataSource.this.controller){

                            public void run() {
                                BookmarkTableDataSource.this.controller.reloadBookmarks();
                            }
                        });
                    }
                }, 1L, TimeUnit.SECONDS);
            }
        };
        this.source.addListener((CollectionListener)this.listener);
        this.setFilter(null);
        this.cache.clear();
    }

    protected void invalidate() {
        this.cache.clear();
        this.source.removeListener(this.listener);
        super.invalidate();
    }

    public void setFilter(HostFilter filter) {
        this.filter = filter;
        this.filtered = null;
    }

    protected AbstractHostCollection getSource() {
        if (null == this.filter) {
            return this.source;
        }
        if (null == this.filtered) {
            this.filtered = new AbstractHostCollection(){

                public String getName() {
                    return BookmarkTableDataSource.this.source.getName();
                }

                public boolean allowsAdd() {
                    return BookmarkTableDataSource.this.source.allowsAdd();
                }

                public boolean allowsDelete() {
                    return BookmarkTableDataSource.this.source.allowsDelete();
                }

                public boolean allowsEdit() {
                    return BookmarkTableDataSource.this.source.allowsEdit();
                }

                public void save() {
                    BookmarkTableDataSource.this.source.save();
                }

                public void load() {
                    BookmarkTableDataSource.this.source.load();
                }
            };
            for (Host bookmark : this.source) {
                if (!this.filter.accept(bookmark)) continue;
                this.filtered.add(bookmark);
            }
            this.filtered.addListener((CollectionListener)new CollectionListener<Host>(){

                public void collectionLoaded() {
                    BookmarkTableDataSource.this.source.collectionLoaded();
                }

                public void collectionItemAdded(Host item) {
                    BookmarkTableDataSource.this.source.add(item);
                }

                public void collectionItemRemoved(Host item) {
                    BookmarkTableDataSource.this.source.remove((Object)item);
                }

                public void collectionItemChanged(Host item) {
                    BookmarkTableDataSource.this.source.collectionItemChanged((Object)item);
                }
            });
        }
        return this.filtered;
    }

    public NSInteger numberOfRowsInTableView(NSTableView view) {
        return new NSInteger(this.getSource().size());
    }

    public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
        if (row.intValue() >= this.numberOfRowsInTableView(view).intValue()) {
            return null;
        }
        String identifier = tableColumn.identifier();
        Host host = (Host)this.getSource().get(row.intValue());
        NSObject cached = this.cache.get(host, identifier);
        if (null == cached) {
            if (identifier.equals(ICON_COLUMN)) {
                return IconCache.iconNamed(host.getProtocol().disk(), Preferences.instance().getInteger("bookmark.icon.size"));
            }
            if (identifier.equals(BOOKMARK_COLUMN)) {
                NSMutableDictionary dict = NSMutableDictionary.dictionaryWithDictionary((NSDictionary)host.getAsDictionary());
                dict.setObjectForKey(host.toURL() + Path.normalize((String)host.getDefaultPath()), "URL");
                String comment = this.getSource().getComment(host);
                if (StringUtils.isNotBlank((String)comment)) {
                    dict.setObjectForKey(comment, "Comment");
                }
                return this.cache.put(host, identifier, dict);
            }
            if (identifier.equals(STATUS_COLUMN)) {
                Session session;
                if (this.controller.hasSession() && host.equals((Object)(session = this.controller.getSession()).getHost())) {
                    if (session.isConnected()) {
                        return IconCache.iconNamed("statusGreen.tiff", 16);
                    }
                    if (session.isOpening()) {
                        return IconCache.iconNamed("statusYellow.tiff", 16);
                    }
                }
                return null;
            }
            if (identifier.equals(TYPEAHEAD_COLUMN)) {
                return this.cache.put(host, identifier, NSString.stringWithString(host.getNickname()));
            }
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return cached;
    }

    public boolean ignoreModifierKeysWhileDragging() {
        return false;
    }

    public NSUInteger tableView_validateDrop_proposedRow_proposedDropOperation(NSTableView view, NSDraggingInfo info, NSInteger row, NSUInteger operation) {
        NSPasteboard draggingPasteboard = info.draggingPasteboard();
        if (!this.getSource().allowsEdit()) {
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("NSStringPboardType")) != null) {
            String o = draggingPasteboard.stringForType("NSStringPboardType");
            if (o != null && ProtocolFactory.isURL((String)o)) {
                view.setDropRow(row, NSTableView.NSTableViewDropAbove);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null) {
            NSObject o = draggingPasteboard.propertyListForType("NSFilenamesPboardType");
            if (o != null) {
                NSArray elements = Rococoa.cast(o, NSArray.class);
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    String file = elements.objectAtIndex(new NSUInteger(i)).toString();
                    if (!file.endsWith(".duck")) continue;
                    view.setDropRow(row, NSTableView.NSTableViewDropAbove);
                    return NSDraggingInfo.NSDragOperationCopy;
                }
                view.setDropRow(row, NSTableView.NSTableViewDropOn);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null) {
            NSObject o = draggingPasteboard.propertyListForType("Apple URL pasteboard type");
            if (o != null) {
                NSArray elements = Rococoa.cast(o, NSArray.class);
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    if (!ProtocolFactory.isURL((String)elements.objectAtIndex(new NSUInteger(i)).toString())) continue;
                    view.setDropRow(row, NSTableView.NSTableViewDropAbove);
                    return NSDraggingInfo.NSDragOperationCopy;
                }
            }
            return NSDraggingInfo.NSDragOperationNone;
        }
        if (!HostPasteboard.getPasteboard().isEmpty()) {
            view.setDropRow(row, NSTableView.NSTableViewDropAbove);
            if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                return NSDraggingInfo.NSDragOperationCopy;
            }
            return NSDraggingInfo.NSDragOperationMove;
        }
        return NSDraggingInfo.NSDragOperationNone;
    }

    public boolean tableView_acceptDrop_row_dropOperation(NSTableView view, NSDraggingInfo info, NSInteger row, NSUInteger operation) {
        NSPasteboard draggingPasteboard = info.draggingPasteboard();
        log.debug((Object)("tableViewAcceptDrop:" + (Object)((Object)row)));
        view.deselectAll(null);
        AbstractHostCollection source = this.getSource();
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("NSStringPboardType")) != null) {
            String o = draggingPasteboard.stringForType("NSStringPboardType");
            if (null == o) {
                return false;
            }
            Host h = Host.parse((String)o);
            source.add(row.intValue(), h);
            view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), false);
            view.scrollRowToVisible(row);
            return true;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null) {
            UploadTransfer q;
            NSArray filesList = Rococoa.cast(draggingPasteboard.propertyListForType("NSFilenamesPboardType"), NSArray.class);
            Collection roots = new Collection();
            Session session = null;
            for (int i = 0; i < filesList.count().intValue(); ++i) {
                String filename = filesList.objectAtIndex(new NSUInteger(i)).toString();
                if (filename.endsWith(".duck")) {
                    source.add(row.intValue(), (Host)HostReaderFactory.instance().read(LocalFactory.createLocal((String)filename)));
                    view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), true);
                    view.scrollRowToVisible(row);
                    continue;
                }
                Host h = (Host)source.get(row.intValue());
                if (null == session) {
                    session = SessionFactory.createSession((Host)h);
                }
                roots.add(PathFactory.createPath((Session)session, (String)h.getDefaultPath(), (Local)LocalFactory.createLocal((String)filename)));
            }
            if (!roots.isEmpty() && (q = new UploadTransfer((List)roots)).numberOfRoots() > 0) {
                TransferController.instance().startTransfer((Transfer)q);
            }
            return true;
        }
        if (draggingPasteboard.availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null) {
            NSObject o = draggingPasteboard.propertyListForType("Apple URL pasteboard type");
            if (o != null) {
                NSArray elements = Rococoa.cast(o, NSArray.class);
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    String url = elements.objectAtIndex(new NSUInteger(i)).toString();
                    if (!StringUtils.isNotBlank((String)url)) continue;
                    Host h = Host.parse((String)url);
                    source.add(row.intValue(), h);
                    view.selectRowIndexes(NSIndexSet.indexSetWithIndex(row), true);
                    view.scrollRowToVisible(row);
                }
                return true;
            }
            return false;
        }
        if (!HostPasteboard.getPasteboard().isEmpty()) {
            if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                ArrayList<Host> duplicates = new ArrayList<Host>();
                Iterator i$ = HostPasteboard.getPasteboard().iterator();
                while (i$.hasNext()) {
                    Host bookmark = (Host)i$.next();
                    Host duplicate = new Host(bookmark.getAsDictionary());
                    duplicate.setUuid(null);
                    source.add(row.intValue(), duplicate);
                    duplicates.add(duplicate);
                }
                for (Host bookmark : duplicates) {
                    int index = source.indexOf((Object)bookmark);
                    view.selectRowIndexes(NSIndexSet.indexSetWithIndex(new NSInteger(index)), true);
                    view.scrollRowToVisible(new NSInteger(index));
                }
            } else {
                Host bookmark;
                int insert = row.intValue();
                Iterator i$ = HostPasteboard.getPasteboard().iterator();
                while (i$.hasNext()) {
                    bookmark = (Host)i$.next();
                    int previous = source.indexOf((Object)bookmark);
                    if (previous == insert) continue;
                    source.remove(previous);
                    int moved = previous < insert ? insert - 1 : insert;
                    source.add(moved, bookmark);
                }
                i$ = HostPasteboard.getPasteboard().iterator();
                while (i$.hasNext()) {
                    bookmark = (Host)i$.next();
                    int index = source.indexOf((Object)bookmark);
                    view.selectRowIndexes(NSIndexSet.indexSetWithIndex(new NSInteger(index)), true);
                    view.scrollRowToVisible(new NSInteger(index));
                }
            }
            return true;
        }
        return false;
    }

    public void draggedImage_endedAt_operation(NSImage image, NSPoint point, NSUInteger operation) {
        if (NSDraggingInfo.NSDragOperationDelete.intValue() == operation.intValue()) {
            this.controller.deleteBookmarkButtonClicked(null);
        }
        NSPasteboard.pasteboardWithName("Apple CFPasteboard drag").declareTypes_owner(null, null);
        HostPasteboard.getPasteboard().clear();
    }

    public NSUInteger draggingSourceOperationMaskForLocal(boolean local) {
        log.debug((Object)("draggingSourceOperationMaskForLocal:" + local));
        if (local) {
            return new NSUInteger(NSDraggingInfo.NSDragOperationMove.intValue() | NSDraggingInfo.NSDragOperationCopy.intValue());
        }
        return new NSUInteger(NSDraggingInfo.NSDragOperationCopy.intValue() | NSDraggingInfo.NSDragOperationDelete.intValue());
    }

    public boolean tableView_writeRowsWithIndexes_toPasteboard(NSTableView view, NSIndexSet rowIndexes, NSPasteboard pboard) {
        NSUInteger index = rowIndexes.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            HostPasteboard.getPasteboard().add(this.getSource().get(index.intValue()));
            index = rowIndexes.indexGreaterThanIndex(index);
        }
        NSEvent event = NSApplication.sharedApplication().currentEvent();
        if (event != null) {
            NSPoint dragPosition = view.convertPoint_fromView(event.locationInWindow(), null);
            NSRect imageRect = new NSRect(new NSPoint(dragPosition.x.doubleValue() - 16.0, dragPosition.y.doubleValue() - 16.0), new NSSize(32.0, 32.0));
            view.dragPromisedFilesOfTypes(NSArray.arrayWithObject("duck"), imageRect, this.id(), true, event);
            return true;
        }
        return false;
    }

    public NSArray namesOfPromisedFilesDroppedAtDestination(NSURL dropDestination) {
        log.debug((Object)("namesOfPromisedFilesDroppedAtDestination:" + dropDestination));
        NSMutableArray promisedDragNames = NSMutableArray.array();
        if (null != dropDestination) {
            HostPasteboard pasteboard = HostPasteboard.getPasteboard();
            Iterator i$ = pasteboard.iterator();
            while (i$.hasNext()) {
                Host promisedDragBookmark = (Host)i$.next();
                Local file = LocalFactory.createLocal((String)dropDestination.path(), (String)(promisedDragBookmark.getNickname(true) + ".duck"));
                HostWriterFactory.instance().write((Serializable)promisedDragBookmark, file);
                promisedDragNames.addObject(NSString.stringWithString(file.getName()));
            }
            pasteboard.clear();
        }
        return promisedDragNames;
    }
}

