/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Archive;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.ConnectionAdapter;
import ch.cyberduck.core.ConnectionListener;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.HiddenFilesPathFilter;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.KeychainFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.NullPathFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.RendezvousCollection;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.Speedometer;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferAdapter;
import ch.cyberduck.core.TransferListener;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.ssl.SSLSession;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.AbstractController;
import ch.cyberduck.ui.PathPasteboard;
import ch.cyberduck.ui.cocoa.AbstractPathTableDelegate;
import ch.cyberduck.ui.cocoa.AbstractTableDelegate;
import ch.cyberduck.ui.cocoa.BookmarkController;
import ch.cyberduck.ui.cocoa.BookmarkTableDataSource;
import ch.cyberduck.ui.cocoa.BrowserListViewModel;
import ch.cyberduck.ui.cocoa.BrowserOutlineViewModel;
import ch.cyberduck.ui.cocoa.BrowserTableDataSource;
import ch.cyberduck.ui.cocoa.CommandController;
import ch.cyberduck.ui.cocoa.ConnectionController;
import ch.cyberduck.ui.cocoa.CreateFileController;
import ch.cyberduck.ui.cocoa.CreateSymlinkController;
import ch.cyberduck.ui.cocoa.DuplicateFileController;
import ch.cyberduck.ui.cocoa.FolderController;
import ch.cyberduck.ui.cocoa.GotoController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.InfoController;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.SheetCallback;
import ch.cyberduck.ui.cocoa.SheetController;
import ch.cyberduck.ui.cocoa.TranscriptController;
import ch.cyberduck.ui.cocoa.TransferController;
import ch.cyberduck.ui.cocoa.TransferPromptController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.WindowListener;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSComboBox;
import ch.cyberduck.ui.cocoa.application.NSControl;
import ch.cyberduck.ui.cocoa.application.NSDrawer;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSImageCell;
import ch.cyberduck.ui.cocoa.application.NSLayoutManager;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSSavePanel;
import ch.cyberduck.ui.cocoa.application.NSSegmentedCell;
import ch.cyberduck.ui.cocoa.application.NSSegmentedControl;
import ch.cyberduck.ui.cocoa.application.NSTabView;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextFieldCell;
import ch.cyberduck.ui.cocoa.application.NSToolbar;
import ch.cyberduck.ui.cocoa.application.NSToolbarItem;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.delegate.ArchiveMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.CopyURLMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.EditMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.OpenURLMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.URLMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSAppleScript;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSRange;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.model.OutlinePathReference;
import ch.cyberduck.ui.cocoa.odb.Editor;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanel;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanelController;
import ch.cyberduck.ui.cocoa.quicklook.QuickLookFactory;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import ch.cyberduck.ui.cocoa.urlhandler.URLSchemeHandlerConfiguration;
import ch.cyberduck.ui.cocoa.view.BookmarkCell;
import ch.cyberduck.ui.cocoa.view.OutlineCell;
import ch.cyberduck.ui.growl.Growl;
import java.io.File;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserController
extends WindowController
implements NSToolbar.Delegate,
QLPreviewPanelController {
    private static Logger log = Logger.getLogger(BrowserController.class);
    private NSToolbar toolbar;
    private boolean showHiddenFiles;
    private PathFilter<Path> filenameFilter;
    private static final PathFilter<Path> NULL_FILTER = new NullPathFilter();
    private static final PathFilter<Path> HIDDEN_FILTER = new HiddenFilesPathFilter();
    private List<Path> selected;
    private TranscriptController transcript;
    private NSDrawer logDrawer;
    private NSButton donateButton;
    private static final int TAB_BOOKMARKS = 0;
    private static final int TAB_LIST_VIEW = 1;
    private static final int TAB_OUTLINE_VIEW = 2;
    private NSTabView browserTabView;
    private NSMenu editMenu;
    private EditMenuDelegate editMenuDelegate;
    private NSMenu urlMenu;
    private URLMenuDelegate urlMenuDelegate;
    private NSMenu openUrlMenu;
    private URLMenuDelegate openUrlMenuDelegate;
    private NSMenu archiveMenu;
    private ArchiveMenuDelegate archiveMenuDelegate;
    private NSButton bonjourButton;
    private NSButton historyButton;
    private NSButton bookmarkButton;
    private NSSegmentedControl bookmarkSwitchView;
    private static final int SWITCH_BOOKMARK_VIEW = 0;
    private NSSegmentedControl browserSwitchView;
    private static final int SWITCH_LIST_VIEW = 0;
    private static final int SWITCH_OUTLINE_VIEW = 1;
    final NSLayoutManager layoutManager;
    private BrowserOutlineViewModel browserOutlineModel;
    private NSOutlineView browserOutlineView;
    private AbstractBrowserTableDelegate<Path> browserOutlineViewDelegate;
    private BrowserListViewModel browserListModel;
    private NSTableView browserListView;
    private AbstractBrowserTableDelegate<Path> browserListViewDelegate;
    private final NSTextFieldCell outlineCellPrototype;
    private final NSImageCell imageCellPrototype;
    private final NSTextFieldCell textCellPrototype;
    private final NSTextFieldCell filenameCellPrototype;
    private final TableColumnFactory browserListColumnsFactory;
    private final TableColumnFactory browserOutlineColumnsFactory;
    private final TableColumnFactory bookmarkTableColumnFactory;
    private BookmarkTableDataSource bookmarkModel;
    private NSTableView bookmarkTable;
    private AbstractTableDelegate<Host> bookmarkTableDelegate;
    private NSPopUpButton actionPopupButton;
    private NSComboBox quickConnectPopup;
    private ProxyController quickConnectPopupModel;
    private NSTextField searchField;
    private NSButton editBookmarkButton;
    private NSButton addBookmarkButton;
    private NSButton deleteBookmarkButton;
    private static final int NAVIGATION_LEFT_SEGMENT_BUTTON = 0;
    private static final int NAVIGATION_RIGHT_SEGMENT_BUTTON = 1;
    private static final int NAVIGATION_UP_SEGMENT_BUTTON = 0;
    private NSSegmentedControl navigationButton;
    private NSSegmentedControl upButton;
    private Path workdir;
    private NSPopUpButton pathPopupButton;
    private NSPopUpButton encodingPopup;
    protected NSProgressIndicator statusSpinner;
    protected NSProgressIndicator browserSpinner;
    private NSTextField statusLabel;
    private NSButton securityLabel;
    private static String lastSelectedDownloadDirectory = null;
    private NSOpenPanel downloadToPanel;
    private NSSavePanel downloadAsPanel;
    private NSOpenPanel syncPanel;
    private static String lastSelectedUploadDirectory = null;
    private NSOpenPanel uploadPanel;
    private NSButton uploadPanelHiddenFilesCheckbox;
    private List<Path> backHistory;
    private List<Path> forwardHistory;
    private ConnectionListener listener;
    private String laststatus;
    private Session session;
    private static final String TOOLBAR_NEW_CONNECTION = "New Connection";
    private static final String TOOLBAR_BROWSER_VIEW = "Browser View";
    private static final String TOOLBAR_TRANSFERS = "Transfers";
    private static final String TOOLBAR_QUICK_CONNECT = "Quick Connect";
    private static final String TOOLBAR_TOOLS = "Tools";
    private static final String TOOLBAR_REFRESH = "Refresh";
    private static final String TOOLBAR_ENCODING = "Encoding";
    private static final String TOOLBAR_SYNCHRONIZE = "Synchronize";
    private static final String TOOLBAR_DOWNLOAD = "Download";
    private static final String TOOLBAR_UPLOAD = "Upload";
    private static final String TOOLBAR_EDIT = "Edit";
    private static final String TOOLBAR_DELETE = "Delete";
    private static final String TOOLBAR_NEW_FOLDER = "New Folder";
    private static final String TOOLBAR_NEW_BOOKMARK = "New Bookmark";
    private static final String TOOLBAR_GET_INFO = "Get Info";
    private static final String TOOLBAR_WEBVIEW = "Open";
    private static final String TOOLBAR_DISCONNECT = "Disconnect";
    private static final String TOOLBAR_TERMINAL = "Terminal";
    private static final String TOOLBAR_ARCHIVE = "Archive";
    private static final String TOOLBAR_QUICKLOOK = "Quick Look";
    private Map<String, NSToolbarItem> toolbarItems;
    private NSButton quicklookButton;

    public BrowserController() {
        if (Preferences.instance().getBoolean("browser.showHidden")) {
            this.filenameFilter = new NullPathFilter();
            this.showHiddenFiles = true;
        } else {
            this.filenameFilter = new HiddenFilesPathFilter();
            this.showHiddenFiles = false;
        }
        this.selected = Collections.emptyList();
        this.layoutManager = NSLayoutManager.layoutManager();
        this.outlineCellPrototype = OutlineCell.outlineCell();
        this.imageCellPrototype = NSImageCell.imageCell();
        this.textCellPrototype = NSTextFieldCell.textFieldCell();
        this.filenameCellPrototype = NSTextFieldCell.textFieldCell();
        this.browserListColumnsFactory = new TableColumnFactory();
        this.browserOutlineColumnsFactory = new TableColumnFactory();
        this.bookmarkTableColumnFactory = new TableColumnFactory();
        this.quickConnectPopupModel = new QuickConnectModel();
        this.backHistory = new ch.cyberduck.core.Collection();
        this.forwardHistory = new ch.cyberduck.core.Collection();
        this.listener = null;
        this.laststatus = null;
        this.toolbarItems = new HashMap<String, NSToolbarItem>();
        this.loadBundle();
    }

    @Override
    protected String getBundleName() {
        return "Browser";
    }

    public static void validateToolbarItems() {
        for (BrowserController controller : MainController.getBrowsers()) {
            controller.window().toolbar().validateVisibleItems();
        }
    }

    public static void updateBookmarkTableRowHeight() {
        for (BrowserController controller : MainController.getBrowsers()) {
            controller._updateBookmarkCell();
        }
    }

    public static void updateBrowserTableAttributes() {
        for (BrowserController controller : MainController.getBrowsers()) {
            controller._updateBrowserAttributes(controller.browserListView);
            controller._updateBrowserAttributes(controller.browserOutlineView);
        }
    }

    public static void updateBrowserTableColumns() {
        for (BrowserController controller : MainController.getBrowsers()) {
            controller._updateBrowserColumns(controller.browserListView);
            controller._updateBrowserColumns(controller.browserOutlineView);
        }
    }

    @Override
    public void awakeFromNib() {
        this._updateBrowserColumns(this.browserListView);
        this._updateBrowserColumns(this.browserOutlineView);
        if (Preferences.instance().getBoolean("browser.logDrawer.isOpen")) {
            this.logDrawer.open();
        }
        this.toolbar = NSToolbar.toolbarWithIdentifier("Cyberduck Toolbar");
        this.toolbar.setDelegate(this.id());
        this.toolbar.setAllowsUserCustomization(true);
        this.toolbar.setAutosavesConfiguration(true);
        this.window().setToolbar(this.toolbar);
        this.window().makeFirstResponder(this.quickConnectPopup);
        if (LicenseFactory.find().equals(LicenseFactory.EMPTY_LICENSE)) {
            this.addDonateWindowTitle();
        }
        this.toggleBookmarks(true);
        super.awakeFromNib();
    }

    protected Comparator<Path> getComparator() {
        return this.getSelectedBrowserDelegate().getSortingComparator();
    }

    protected PathFilter<Path> getFileFilter() {
        return this.filenameFilter;
    }

    protected void setPathFilter(final String search) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setPathFilter:" + search));
        }
        if (StringUtils.isBlank((String)search)) {
            this.searchField.setStringValue("");
            this.filenameFilter = this.isShowHiddenFiles() ? NULL_FILTER : HIDDEN_FILTER;
        } else {
            this.filenameFilter = new PathFilter<Path>(){

                public boolean accept(Path file) {
                    if (file.getName().toLowerCase().indexOf(search.toLowerCase()) != -1) {
                        return true;
                    }
                    if (file.attributes().isDirectory() && BrowserController.this.getSelectedBrowserView() == BrowserController.this.browserOutlineView) {
                        return file.isCached();
                    }
                    return false;
                }
            };
        }
    }

    public void setShowHiddenFiles(boolean showHidden) {
        if (showHidden) {
            this.filenameFilter = NULL_FILTER;
            this.showHiddenFiles = true;
        } else {
            this.filenameFilter = HIDDEN_FILTER;
            this.showHiddenFiles = false;
        }
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    private void getFocus() {
        NSControl view = this.getSelectedTabView() == 0 ? this.bookmarkTable : (this.isMounted() ? this.getSelectedBrowserView() : this.quickConnectPopup);
        this.updateStatusLabel();
        this.window().makeFirstResponder(view);
    }

    public void reloadData(boolean preserveSelection) {
        if (preserveSelection) {
            this.reloadData(this.getSelectedPaths());
        } else {
            this.reloadData(Collections.<Path>emptyList());
        }
    }

    protected void reloadData(List<Path> selected) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("reloadData:" + selected));
        }
        NSTableView browser = this.getSelectedBrowserView();
        browser.reloadData();
        this.deselectAll();
        if (!selected.isEmpty()) {
            for (Path path : selected) {
                this.selectRow(path.getReference(), true);
            }
        }
        this.updateStatusLabel();
        this.validateNavigationButtons();
    }

    private void selectRow(PathReference reference, boolean expand) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("selectRow:" + reference));
        }
        NSTableView browser = this.getSelectedBrowserView();
        int row = this.getSelectedBrowserModel().indexOf(browser, reference);
        if (log.isDebugEnabled()) {
            log.debug((Object)("selectRow:" + row));
        }
        if (-1 == row) {
            return;
        }
        NSInteger index = new NSInteger(row);
        browser.selectRowIndexes(NSIndexSet.indexSetWithIndex(index), expand);
        browser.scrollRowToVisible(index);
    }

    protected void setSelectedPaths(List<Path> selected) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setSelectedPaths:" + selected));
        }
        this.selected = selected;
    }

    protected Path getSelectedPath() {
        List<Path> selected = this.getSelectedPaths();
        if (selected.size() > 0) {
            return selected.get(0);
        }
        return null;
    }

    protected List<Path> getSelectedPaths() {
        return this.selected;
    }

    protected int getSelectionCount() {
        return this.getSelectedBrowserView().numberOfSelectedRows().intValue();
    }

    private void deselectAll() {
        log.debug((Object)"deselectAll");
        NSTableView browser = this.getSelectedBrowserView();
        if (null == browser) {
            return;
        }
        browser.deselectAll(null);
    }

    @Override
    public void setWindow(NSWindow window) {
        window.setTitle(Preferences.instance().getProperty("application.name"));
        window.setMiniwindowImage(IconCache.iconNamed("cyberduck-document.icns"));
        window.setMovableByWindowBackground(true);
        window.setDelegate(this.id());
        super.setWindow(window);
    }

    public void drawerWillOpen(NSNotification notification) {
        this.logDrawer.setContentSize(new NSSize(this.logDrawer.contentSize().width.doubleValue(), Preferences.instance().getDouble("browser.logDrawer.size.height")));
    }

    public void drawerDidOpen(NSNotification notification) {
        Preferences.instance().setProperty("browser.logDrawer.isOpen", true);
    }

    public void drawerWillClose(NSNotification notification) {
        Preferences.instance().setProperty("browser.logDrawer.size.height", this.logDrawer.contentSize().height.intValue());
    }

    public void drawerDidClose(NSNotification notification) {
        Preferences.instance().setProperty("browser.logDrawer.isOpen", false);
    }

    public void setLogDrawer(NSDrawer logDrawer) {
        this.logDrawer = logDrawer;
        this.transcript = new TranscriptController();
        this.logDrawer.setContentView(this.transcript.getLogView());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerWillOpen:"), "NSDrawerWillOpenNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerDidOpen:"), "NSDrawerDidOpenNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerWillClose:"), "NSDrawerWillCloseNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerDidClose:"), "NSDrawerDidCloseNotification", this.logDrawer);
    }

    public void setDonateButton(NSButton donateButton) {
        this.donateButton = donateButton;
        this.donateButton.setTitle(Locale.localizedString((String)"Get a donation key!", (String)"License"));
        this.donateButton.setAction(Foundation.selector("donateMenuClicked:"));
        this.donateButton.sizeToFit();
    }

    public NSButton getDonateButton() {
        return this.donateButton;
    }

    private void addDonateWindowTitle() {
        NSView view = this.window().contentView().superview();
        NSSize bounds = view.frame().size;
        NSSize size = this.donateButton.frame().size;
        this.donateButton.setFrame(new NSRect(new NSPoint(bounds.width.intValue() - size.width.intValue() - 40, bounds.height.intValue() - size.height.intValue() + 3), new NSSize(size.width.intValue(), size.height.intValue())));
        view.addSubview(this.donateButton);
    }

    public void removeDonateWindowTitle() {
        this.donateButton.removeFromSuperview();
    }

    private int getSelectedTabView() {
        return this.browserTabView.indexOfTabViewItem(this.browserTabView.selectedTabViewItem());
    }

    public void setBrowserTabView(NSTabView browserTabView) {
        this.browserTabView = browserTabView;
    }

    public NSTableView getSelectedBrowserView() {
        switch (this.browserSwitchView.selectedSegment()) {
            case 0: {
                return this.browserListView;
            }
            case 1: {
                return this.browserOutlineView;
            }
        }
        log.fatal((Object)"No selected brower view");
        return null;
    }

    public BrowserTableDataSource getSelectedBrowserModel() {
        switch (this.browserSwitchView.selectedSegment()) {
            case 0: {
                return this.browserListModel;
            }
            case 1: {
                return this.browserOutlineModel;
            }
        }
        log.fatal((Object)"No selected brower view");
        return null;
    }

    public AbstractBrowserTableDelegate<Path> getSelectedBrowserDelegate() {
        switch (this.browserSwitchView.selectedSegment()) {
            case 0: {
                return this.browserListViewDelegate;
            }
            case 1: {
                return this.browserOutlineViewDelegate;
            }
        }
        log.fatal((Object)"No selected brower view");
        return null;
    }

    public void setEditMenu(NSMenu editMenu) {
        this.editMenu = editMenu;
        this.editMenuDelegate = new EditMenuDelegate(){

            protected Local getSelectedFile() {
                return BrowserController.this.getSelectedFile();
            }

            protected ID getTarget() {
                return BrowserController.this.id();
            }
        };
        this.editMenu.setDelegate(this.editMenuDelegate.id());
    }

    protected Local getSelectedFile() {
        Path selected = this.getSelectedPath();
        if (null == selected) {
            return null;
        }
        if (selected.attributes().isFile()) {
            return selected.getLocal();
        }
        return null;
    }

    public void setUrlMenu(NSMenu urlMenu) {
        this.urlMenu = urlMenu;
        this.urlMenuDelegate = new CopyURLMenuDelegate(){

            @Override
            protected List<Path> getSelected() {
                List<Path> selected = BrowserController.this.getSelectedPaths();
                if (selected.isEmpty() && BrowserController.this.isMounted()) {
                    return Collections.singletonList(BrowserController.this.workdir());
                }
                return selected;
            }
        };
        this.urlMenu.setDelegate(this.urlMenuDelegate.id());
    }

    public void setOpenUrlMenu(NSMenu openUrlMenu) {
        this.openUrlMenu = openUrlMenu;
        this.openUrlMenuDelegate = new OpenURLMenuDelegate(){

            @Override
            protected List<Path> getSelected() {
                List<Path> selected = BrowserController.this.getSelectedPaths();
                if (selected.isEmpty() && BrowserController.this.isMounted()) {
                    return Collections.singletonList(BrowserController.this.workdir());
                }
                return selected;
            }
        };
        this.openUrlMenu.setDelegate(this.openUrlMenuDelegate.id());
    }

    public void setArchiveMenu(NSMenu archiveMenu) {
        this.archiveMenu = archiveMenu;
        this.archiveMenuDelegate = new ArchiveMenuDelegate();
        this.archiveMenu.setDelegate(this.archiveMenuDelegate.id());
    }

    public void setBonjourButton(NSButton bonjourButton) {
        this.bonjourButton = bonjourButton;
        NSImage img = IconCache.iconNamed("rendezvous.tiff", 16);
        img.setTemplate(false);
        this.bonjourButton.setImage(img);
        this.setRecessedBezelStyle(this.bonjourButton);
        this.bonjourButton.setTarget(this.id());
        this.bonjourButton.setAction(Foundation.selector("bookmarkButtonClicked:"));
    }

    public void setHistoryButton(NSButton historyButton) {
        this.historyButton = historyButton;
        NSImage img = IconCache.iconNamed("history.tiff", 16);
        img.setTemplate(false);
        this.historyButton.setImage(img);
        this.setRecessedBezelStyle(this.historyButton);
        this.historyButton.setTarget(this.id());
        this.historyButton.setAction(Foundation.selector("bookmarkButtonClicked:"));
    }

    public void setBookmarkButton(NSButton bookmarkButton) {
        this.bookmarkButton = bookmarkButton;
        NSImage img = IconCache.iconNamed("bookmarks.tiff", 16);
        img.setTemplate(false);
        this.bookmarkButton.setImage(img);
        this.setRecessedBezelStyle(this.bookmarkButton);
        this.bookmarkButton.setTarget(this.id());
        this.bookmarkButton.setAction(Foundation.selector("bookmarkButtonClicked:"));
        this.bookmarkButton.setState(1);
    }

    public void bookmarkButtonClicked(NSButton sender) {
        if (sender != this.bonjourButton) {
            this.bonjourButton.setState(0);
        }
        if (sender != this.historyButton) {
            this.historyButton.setState(0);
        }
        if (sender != this.bookmarkButton) {
            this.bookmarkButton.setState(0);
        }
        sender.setState(1);
        this.updateBookmarkSource();
    }

    private void setRecessedBezelStyle(NSButton b) {
        b.setBezelStyle(13);
        b.setButtonType(1);
        b.setImagePosition(2);
        b.setFont(NSFont.boldSystemFontOfSize(11.0));
        b.setShowsBorderOnlyWhileMouseInside(true);
    }

    private void updateBookmarkSource() {
        BookmarkCollection source = BookmarkCollection.defaultCollection();
        if (this.bonjourButton.state() == 1) {
            source = RendezvousCollection.defaultCollection();
        } else if (this.historyButton.state() == 1) {
            source = HistoryCollection.defaultCollection();
        }
        this.bookmarkModel.setSource((AbstractHostCollection)source);
        if (source.isLocked()) {
            this.browserSpinner.startAnimation(null);
        }
        source.addListener((CollectionListener)new AbstractCollectionListener<Host>(){

            public void collectionLoaded() {
                BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                    public void run() {
                        BrowserController.this.browserSpinner.stopAnimation(null);
                        BrowserController.this.bookmarkTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
                    }
                });
            }
        });
        if (!source.isLocked()) {
            this.browserSpinner.stopAnimation(null);
            this.bookmarkTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        }
        this.setBookmarkFilter(null);
        this.reloadBookmarks();
        this.getFocus();
    }

    public void reloadBookmarks() {
        this.bookmarkTable.reloadData();
        this.updateStatusLabel();
    }

    public void setBookmarkSwitchView(NSSegmentedControl bookmarkSwitchView) {
        this.bookmarkSwitchView = bookmarkSwitchView;
        this.bookmarkSwitchView.setSegmentCount(1);
        this.bookmarkSwitchView.setToolTip(Locale.localizedString((String)"Bookmarks"));
        NSImage image = IconCache.iconNamed("book.tiff");
        this.bookmarkSwitchView.setImage_forSegment(image, 0);
        NSSegmentedCell cell = Rococoa.cast(this.bookmarkSwitchView.cell(), NSSegmentedCell.class);
        cell.setTrackingMode(1);
        cell.setControlSize(0);
        this.bookmarkSwitchView.setTarget(this.id());
        this.bookmarkSwitchView.setAction(Foundation.selector("bookmarkSwitchClicked:"));
        this.bookmarkSwitchView.setSelectedSegment(0);
    }

    public void bookmarkSwitchClicked(ID sender) {
        this.toggleBookmarks(this.getSelectedTabView() != 0);
    }

    public void toggleBookmarks(boolean open) {
        log.debug((Object)("bookmarkSwitchClicked:" + open));
        this.bookmarkSwitchView.setSelected_forSegment(open, 0);
        if (open) {
            int row;
            this.browserTabView.selectTabViewItemAtIndex(0);
            this.updateBookmarkSource();
            if (this.isMounted() && (row = this.bookmarkModel.getSource().indexOf((Object)this.getSession().getHost())) != -1) {
                this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(new NSInteger(row)), false);
                this.bookmarkTable.scrollRowToVisible(new NSInteger(row));
            }
        } else {
            this.setBookmarkFilter(null);
            this.selectBrowser(Preferences.instance().getInteger("browser.view"));
        }
        this.getFocus();
        this.validateNavigationButtons();
    }

    public void setBrowserSwitchView(NSSegmentedControl browserSwitchView) {
        this.browserSwitchView = browserSwitchView;
        this.browserSwitchView.setSegmentCount(2);
        NSImage list = IconCache.iconNamed("list.tiff");
        list.setTemplate(true);
        this.browserSwitchView.setImage_forSegment(list, 0);
        NSImage outline = IconCache.iconNamed("outline.tiff");
        outline.setTemplate(true);
        this.browserSwitchView.setImage_forSegment(outline, 1);
        this.browserSwitchView.setTarget(this.id());
        this.browserSwitchView.setAction(Foundation.selector("browserSwitchButtonClicked:"));
        NSSegmentedCell cell = Rococoa.cast(this.browserSwitchView.cell(), NSSegmentedCell.class);
        cell.setTrackingMode(0);
        cell.setControlSize(0);
        this.browserSwitchView.setSelectedSegment(Preferences.instance().getInteger("browser.view"));
    }

    public void browserSwitchButtonClicked(NSSegmentedControl sender) {
        this.browserSwitchClicked(sender.selectedSegment(), this.getSelectedPaths());
    }

    public void browserSwitchMenuClicked(NSMenuItem sender) {
        this.browserSwitchView.setSelectedSegment(sender.tag());
        this.browserSwitchClicked(sender.tag(), this.getSelectedPaths());
    }

    private void browserSwitchClicked(int view, List<Path> selected) {
        this.toggleBookmarks(false);
        this.selectBrowser(view);
        this.setPathFilter(null);
        this.reloadData(selected);
        this.getFocus();
        Preferences.instance().setProperty("browser.view", view);
    }

    private void selectBrowser(int selected) {
        this.browserSwitchView.setSelectedSegment(selected);
        switch (selected) {
            case 0: {
                this.browserTabView.selectTabViewItemAtIndex(1);
                break;
            }
            case 1: {
                this.browserTabView.selectTabViewItemAtIndex(2);
            }
        }
    }

    @Override
    public boolean acceptsPreviewPanelControl(QLPreviewPanel panel) {
        log.debug((Object)"acceptsPreviewPanelControl");
        return true;
    }

    @Override
    public void beginPreviewPanelControl(QLPreviewPanel panel) {
        log.debug((Object)"beginPreviewPanelControl");
        QuickLookFactory.instance().willBeginQuickLook();
    }

    @Override
    public void endPreviewPanelControl(QLPreviewPanel panel) {
        log.debug((Object)"endPreviewPanelControl");
        QuickLookFactory.instance().didEndQuickLook();
    }

    public void setBrowserOutlineView(NSOutlineView view) {
        this.browserOutlineView = view;
        this.browserOutlineView.registerForDraggedTypes(NSArray.arrayWithObjects("Apple URL pasteboard type", "NSFilenamesPboardType", "Apple files promise pasteboard type"));
        this._updateBrowserAttributes(this.browserOutlineView);
        this.browserOutlineView.setAllowsMultipleSelection(true);
        this.browserOutlineView.setAllowsEmptySelection(true);
        this.browserOutlineView.setAllowsColumnResizing(true);
        this.browserOutlineView.setAllowsColumnSelection(false);
        this.browserOutlineView.setAllowsColumnReordering(true);
        this.browserOutlineView.setRowHeight(new CGFloat(this.layoutManager.defaultLineHeightForFont(NSFont.systemFontOfSize(Preferences.instance().getFloat("browser.font.size"))).intValue() + 2));
        this.browserOutlineModel = new BrowserOutlineViewModel(this);
        this.browserOutlineView.setDataSource(this.browserOutlineModel.id());
        this.browserOutlineViewDelegate = new AbstractBrowserOutlineViewDelegate<Path>(){

            @Override
            public void enterKeyPressed(ID sender) {
                if (Preferences.instance().getBoolean("browser.enterkey.rename")) {
                    if (BrowserController.this.browserOutlineView.numberOfSelectedRows().intValue() == 1) {
                        BrowserController.this.browserOutlineView.editRow(BrowserController.this.browserOutlineView.columnWithIdentifier("FILENAME"), BrowserController.this.browserOutlineView.selectedRow(), true);
                    }
                } else {
                    this.tableRowDoubleClicked(sender);
                }
            }

            @Override
            public void outlineView_willDisplayCell_forTableColumn_item(NSOutlineView view, NSTextFieldCell cell, NSTableColumn tableColumn, NSObject item) {
                if (null == item) {
                    return;
                }
                Path path = BrowserController.this.lookup(new OutlinePathReference(item));
                if (null == path) {
                    return;
                }
                if (tableColumn.identifier().equals("FILENAME")) {
                    cell.setEditable(BrowserController.this.getSession().isRenameSupported(path));
                    Rococoa.cast(cell, OutlineCell.class).setIcon(BrowserController.this.browserOutlineModel.iconForPath(path));
                }
                if (!BrowserController.this.isConnected() || !HIDDEN_FILTER.accept((AbstractPath)path)) {
                    cell.setTextColor(NSColor.disabledControlTextColor());
                } else {
                    cell.setTextColor(NSColor.controlTextColor());
                }
            }

            @Override
            public boolean outlineView_shouldExpandItem(NSOutlineView view, NSObject item) {
                NSEvent event = NSApplication.sharedApplication().currentEvent();
                if (event != null && 6 == event.type()) {
                    if (!Preferences.instance().getBoolean("browser.view.autoexpand")) {
                        log.debug((Object)"Returning false to #outlineViewShouldExpandItem while dragging because browser.view.autoexpand == false");
                        return false;
                    }
                    NSInteger draggingColumn = view.columnAtPoint(view.convertPoint_fromView(event.locationInWindow(), null));
                    if (draggingColumn.intValue() != 0) {
                        log.debug((Object)("Returning false to #outlineViewShouldExpandItem for column:" + (Object)((Object)draggingColumn)));
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void outlineViewItemDidExpand(NSNotification notification) {
                BrowserController.this.updateStatusLabel();
            }

            @Override
            public void outlineViewItemDidCollapse(NSNotification notification) {
                BrowserController.this.updateStatusLabel();
            }

            @Override
            protected boolean isTypeSelectSupported() {
                return true;
            }
        };
        this.browserOutlineView.setDelegate(this.browserOutlineViewDelegate.id());
        NSTableColumn c = this.browserOutlineColumnsFactory.create("FILENAME");
        c.headerCell().setStringValue(Locale.localizedString((String)"Filename"));
        c.setMinWidth(new CGFloat(100.0));
        c.setWidth(new CGFloat(250.0));
        c.setMaxWidth(new CGFloat(1000.0));
        c.setResizingMask(3);
        c.setDataCell(this.outlineCellPrototype);
        this.browserOutlineView.addTableColumn(c);
        this.browserOutlineView.setOutlineTableColumn(c);
    }

    public void setBrowserListView(NSTableView view) {
        this.browserListView = view;
        this.browserListView.registerForDraggedTypes(NSArray.arrayWithObjects("Apple URL pasteboard type", "NSFilenamesPboardType", "Apple files promise pasteboard type"));
        this._updateBrowserAttributes(this.browserListView);
        this.browserListView.setAllowsMultipleSelection(true);
        this.browserListView.setAllowsEmptySelection(true);
        this.browserListView.setAllowsColumnResizing(true);
        this.browserListView.setAllowsColumnSelection(false);
        this.browserListView.setAllowsColumnReordering(true);
        this.browserListView.setRowHeight(new CGFloat(this.layoutManager.defaultLineHeightForFont(NSFont.systemFontOfSize(Preferences.instance().getFloat("browser.font.size"))).intValue() + 2));
        this.browserListModel = new BrowserListViewModel(this);
        this.browserListView.setDataSource(this.browserListModel.id());
        this.browserListViewDelegate = new AbstractBrowserListViewDelegate<Path>(){

            @Override
            public void enterKeyPressed(ID sender) {
                if (Preferences.instance().getBoolean("browser.enterkey.rename")) {
                    if (BrowserController.this.browserListView.numberOfSelectedRows().intValue() == 1) {
                        BrowserController.this.browserListView.editRow(BrowserController.this.browserListView.columnWithIdentifier("FILENAME"), BrowserController.this.browserListView.selectedRow(), true);
                    }
                } else {
                    this.tableRowDoubleClicked(sender);
                }
            }

            @Override
            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSTextFieldCell cell, NSTableColumn tableColumn, NSInteger row) {
                String identifier = tableColumn.identifier();
                Path path = (Path)BrowserController.this.browserListModel.children(BrowserController.this.workdir()).get(row.intValue());
                if (identifier.equals("FILENAME")) {
                    cell.setEditable(BrowserController.this.getSession().isRenameSupported(path));
                }
                if (cell.isKindOfClass(Foundation.getClass(NSTextFieldCell.class.getSimpleName()))) {
                    if (!BrowserController.this.isConnected() || !HIDDEN_FILTER.accept((AbstractPath)path)) {
                        cell.setTextColor(NSColor.disabledControlTextColor());
                    } else {
                        cell.setTextColor(NSColor.controlTextColor());
                    }
                }
            }

            @Override
            protected boolean isTypeSelectSupported() {
                return true;
            }
        };
        this.browserListView.setDelegate(this.browserListViewDelegate.id());
        NSTableColumn c = this.browserListColumnsFactory.create("ICON");
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setDataCell(this.imageCellPrototype);
        c.dataCell().setAlignment(2);
        this.browserListView.addTableColumn(c);
        c = this.browserListColumnsFactory.create("FILENAME");
        c.headerCell().setStringValue(Locale.localizedString((String)"Filename"));
        c.setMinWidth(100.0);
        c.setWidth(250.0);
        c.setMaxWidth(1000.0);
        c.setResizingMask(3);
        c.setDataCell(this.filenameCellPrototype);
        this.browserListView.addTableColumn(c);
    }

    protected void _updateBrowserAttributes(NSTableView tableView) {
        tableView.setUsesAlternatingRowBackgroundColors(Preferences.instance().getBoolean("browser.alternatingRows"));
        if (Preferences.instance().getBoolean("browser.horizontalLines") && Preferences.instance().getBoolean("browser.verticalLines")) {
            tableView.setGridStyleMask(new NSUInteger(NSTableView.NSTableViewSolidHorizontalGridLineMask.intValue() | NSTableView.NSTableViewSolidVerticalGridLineMask.intValue()));
        } else if (Preferences.instance().getBoolean("browser.verticalLines")) {
            tableView.setGridStyleMask(NSTableView.NSTableViewSolidVerticalGridLineMask);
        } else if (Preferences.instance().getBoolean("browser.horizontalLines")) {
            tableView.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        } else {
            tableView.setGridStyleMask(NSTableView.NSTableViewGridNone);
        }
    }

    protected void _updateBookmarkCell() {
        int size = Preferences.instance().getInteger("bookmark.icon.size");
        double width = (double)size * 1.5;
        NSTableColumn c = this.bookmarkTable.tableColumnWithIdentifier("ICON");
        c.setMinWidth(width);
        c.setMaxWidth(width);
        c.setWidth(width);
        this.bookmarkTable.noteHeightOfRowsWithIndexesChanged(NSIndexSet.indexSetWithIndexesInRange(NSRange.NSMakeRange(new NSUInteger(0L), new NSUInteger(this.bookmarkTable.numberOfRows()))));
    }

    protected void _updateBrowserColumns(NSTableView table) {
        NSTableColumn c;
        table.removeTableColumn(table.tableColumnWithIdentifier("SIZE"));
        if (Preferences.instance().getBoolean("browser.columnSize")) {
            c = this.browserListColumnsFactory.create("SIZE");
            c.headerCell().setStringValue(Locale.localizedString((String)"Size"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(150.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("MODIFIED"));
        if (Preferences.instance().getBoolean("browser.columnModification")) {
            c = this.browserListColumnsFactory.create("MODIFIED");
            c.headerCell().setStringValue(Locale.localizedString((String)"Modified"));
            c.setMinWidth(100.0);
            c.setWidth(150.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("OWNER"));
        if (Preferences.instance().getBoolean("browser.columnOwner")) {
            c = this.browserListColumnsFactory.create("OWNER");
            c.headerCell().setStringValue(Locale.localizedString((String)"Owner"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("GROUP"));
        if (Preferences.instance().getBoolean("browser.columnGroup")) {
            c = this.browserListColumnsFactory.create("GROUP");
            c.headerCell().setStringValue(Locale.localizedString((String)"Group"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("PERMISSIONS"));
        if (Preferences.instance().getBoolean("browser.columnPermissions")) {
            c = this.browserListColumnsFactory.create("PERMISSIONS");
            c.headerCell().setStringValue(Locale.localizedString((String)"Permissions"));
            c.setMinWidth(100.0);
            c.setWidth(100.0);
            c.setMaxWidth(800.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("KIND"));
        if (Preferences.instance().getBoolean("browser.columnKind")) {
            c = this.browserListColumnsFactory.create("KIND");
            c.headerCell().setStringValue(Locale.localizedString((String)"Kind"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.removeTableColumn(table.tableColumnWithIdentifier("EXTENSION"));
        if (Preferences.instance().getBoolean("browser.columnExtension")) {
            c = this.browserListColumnsFactory.create("EXTENSION");
            c.headerCell().setStringValue(Locale.localizedString((String)"Extension"));
            c.setMinWidth(50.0);
            c.setWidth(80.0);
            c.setMaxWidth(500.0);
            c.setResizingMask(3);
            c.setDataCell(this.textCellPrototype);
            table.addTableColumn(c);
        }
        table.setIndicatorImage_inTableColumn(this.browserListViewDelegate.isSortedAscending() ? IconCache.iconNamed("NSAscendingSortIndicator") : IconCache.iconNamed("NSDescendingSortIndicator"), table.tableColumnWithIdentifier(Preferences.instance().getProperty("browser.sort.column")));
        table.setAutosaveTableColumns(true);
        table.sizeToFit();
        this.reloadData(false);
    }

    public void setBookmarkTable(NSTableView view) {
        this.bookmarkTable = view;
        this.bookmarkTable.setSelectionHighlightStyle(NSTableView.NSTableViewSelectionHighlightStyleSourceList);
        this.bookmarkModel = new BookmarkTableDataSource(this, (AbstractHostCollection)BookmarkCollection.defaultCollection());
        this.bookmarkTable.setDataSource(this.bookmarkModel.id());
        this.bookmarkTableDelegate = new AbstractTableDelegate<Host>(){

            @Override
            public String tooltip(Host bookmark) {
                return bookmark.toURL();
            }

            @Override
            public void tableRowDoubleClicked(ID sender) {
                BrowserController.this.connectBookmarkButtonClicked(sender);
            }

            @Override
            public void enterKeyPressed(ID sender) {
                this.tableRowDoubleClicked(sender);
            }

            @Override
            public void deleteKeyPressed(ID sender) {
                if (BrowserController.this.bookmarkModel.getSource().allowsDelete()) {
                    BrowserController.this.deleteBookmarkButtonClicked(sender);
                }
            }

            @Override
            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            @Override
            public void selectionDidChange(NSNotification notification) {
                BrowserController.this.addBookmarkButton.setEnabled(BrowserController.this.bookmarkModel.getSource().allowsAdd());
                int selected = BrowserController.this.bookmarkTable.numberOfSelectedRows().intValue();
                BrowserController.this.editBookmarkButton.setEnabled(BrowserController.this.bookmarkModel.getSource().allowsEdit() && selected == 1);
                BrowserController.this.deleteBookmarkButton.setEnabled(BrowserController.this.bookmarkModel.getSource().allowsDelete() && selected > 0);
            }

            public CGFloat tableView_heightOfRow(NSTableView view, NSInteger row) {
                int size = Preferences.instance().getInteger("bookmark.icon.size");
                if (16 == size) {
                    return new CGFloat(18.0);
                }
                if (32 == size) {
                    return new CGFloat(45.0);
                }
                return new CGFloat(70.0);
            }

            @Override
            public boolean isTypeSelectSupported() {
                return true;
            }

            public String tableView_typeSelectStringForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                return ((Host)BrowserController.this.bookmarkModel.getSource().get(row.intValue())).getNickname();
            }

            public boolean tableView_isGroupRow(NSTableView view, NSInteger row) {
                return false;
            }
        };
        this.bookmarkTable.setDelegate(this.bookmarkTableDelegate.id());
        this.bookmarkTable.registerForDraggedTypes(NSArray.arrayWithObjects("Apple URL pasteboard type", "NSStringPboardType", "NSFilenamesPboardType", "Apple files promise pasteboard type", "HostPBoardType"));
        NSTableColumn c = this.bookmarkTableColumnFactory.create("ICON");
        c.headerCell().setStringValue("");
        c.setResizingMask(0);
        c.setDataCell(this.imageCellPrototype);
        this.bookmarkTable.addTableColumn(c);
        c = this.bookmarkTableColumnFactory.create("BOOKMARK");
        c.headerCell().setStringValue(Locale.localizedString((String)"Bookmarks"));
        c.setMinWidth(150.0);
        c.setResizingMask(1);
        c.setDataCell(BookmarkCell.bookmarkCell());
        this.bookmarkTable.addTableColumn(c);
        c = this.bookmarkTableColumnFactory.create("STATUS");
        c.headerCell().setStringValue("");
        c.setMinWidth(40.0);
        c.setWidth(40.0);
        c.setMaxWidth(40.0);
        c.setResizingMask(1);
        c.setDataCell(this.imageCellPrototype);
        c.dataCell().setAlignment(2);
        this.bookmarkTable.addTableColumn(c);
        this._updateBookmarkCell();
        int size = Preferences.instance().getInteger("bookmark.icon.size");
        if (16 == size) {
            this.bookmarkTable.setRowHeight(new CGFloat(18.0));
        } else if (32 == size) {
            this.bookmarkTable.setRowHeight(new CGFloat(45.0));
        } else {
            this.bookmarkTable.setRowHeight(new CGFloat(70.0));
        }
        this.bookmarkTable.setUsesAlternatingRowBackgroundColors(Preferences.instance().getBoolean("browser.alternatingRows"));
        this.bookmarkTable.setGridStyleMask(NSTableView.NSTableViewGridNone);
        this.bookmarkTable.setAllowsMultipleSelection(true);
        this.bookmarkTable.setAllowsEmptySelection(true);
        this.bookmarkTable.setAllowsColumnResizing(false);
        this.bookmarkTable.setAllowsColumnSelection(false);
        this.bookmarkTable.setAllowsColumnReordering(false);
        this.bookmarkTable.sizeToFit();
    }

    public void setActionPopupButton(NSPopUpButton actionPopupButton) {
        this.actionPopupButton = actionPopupButton;
        this.actionPopupButton.setPullsDown(true);
        this.actionPopupButton.setAutoenablesItems(true);
        this.actionPopupButton.insertItemWithTitle_atIndex("", new NSInteger(0L));
        this.actionPopupButton.itemAtIndex(new NSInteger(0L)).setImage(IconCache.iconNamed("gear.tiff"));
    }

    public void setQuickConnectPopup(NSComboBox quickConnectPopup) {
        this.quickConnectPopup = quickConnectPopup;
        this.quickConnectPopup.setTarget(this.id());
        this.quickConnectPopup.setCompletes(true);
        this.quickConnectPopup.setAction(Foundation.selector("quickConnectSelectionChanged:"));
        this.quickConnectPopup.cell().setSendsActionOnEndEditing(false);
        this.quickConnectPopup.setUsesDataSource(true);
        this.quickConnectPopup.setDataSource(this.quickConnectPopupModel.id());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("quickConnectWillPopUp:"), "NSComboBoxWillPopUpNotification", this.quickConnectPopup);
        this.quickConnectWillPopUp(null);
    }

    public void quickConnectWillPopUp(NSNotification notification) {
        int size = BookmarkCollection.defaultCollection().size();
        this.quickConnectPopup.setNumberOfVisibleItems(size > 10 ? new NSInteger(10L) : new NSInteger(size));
    }

    public void quickConnectSelectionChanged(ID sender) {
        String input = this.quickConnectPopup.stringValue();
        if (StringUtils.isBlank((String)input)) {
            return;
        }
        input = input.trim();
        for (Host h : BookmarkCollection.defaultCollection()) {
            if (!h.getNickname().equals(input)) continue;
            this.mount(h);
            return;
        }
        this.mount(Host.parse((String)input));
    }

    public void setSearchField(NSTextField searchField) {
        this.searchField = searchField;
        this.searchField.setEnabled(false);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("searchFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.searchField);
    }

    public void searchButtonClicked(ID sender) {
        this.window().makeFirstResponder(this.searchField);
    }

    public void searchFieldTextDidChange(NSNotification notification) {
        if (this.getSelectedTabView() == 0) {
            this.setBookmarkFilter(this.searchField.stringValue());
        } else {
            this.setPathFilter(this.searchField.stringValue());
            this.reloadData(true);
        }
    }

    private void setBookmarkFilter(final String searchString) {
        if (StringUtils.isBlank((String)searchString)) {
            this.searchField.setStringValue("");
            this.bookmarkModel.setFilter(null);
        } else {
            this.bookmarkModel.setFilter(new HostFilter(){

                public boolean accept(Host host) {
                    return host.getNickname().toLowerCase().contains(searchString.toLowerCase()) || host.getHostname().toLowerCase().contains(searchString.toLowerCase());
                }
            });
        }
        this.reloadBookmarks();
    }

    public void connectBookmarkButtonClicked(ID sender) {
        if (this.bookmarkTable.numberOfSelectedRows().intValue() == 1) {
            Host selected = (Host)this.bookmarkModel.getSource().get(this.bookmarkTable.selectedRow().intValue());
            this.mount(selected);
        }
    }

    public void setEditBookmarkButton(NSButton editBookmarkButton) {
        this.editBookmarkButton = editBookmarkButton;
        this.editBookmarkButton.setEnabled(false);
        this.editBookmarkButton.setTarget(this.id());
        this.editBookmarkButton.setAction(Foundation.selector("editBookmarkButtonClicked:"));
    }

    public void editBookmarkButtonClicked(ID sender) {
        BookmarkController c = BookmarkController.Factory.create((Host)this.bookmarkModel.getSource().get(this.bookmarkTable.selectedRow().intValue()));
        c.window().makeKeyAndOrderFront(null);
    }

    public void duplicateBookmarkButtonClicked(ID sender) {
        Host selected = (Host)this.bookmarkModel.getSource().get(this.bookmarkTable.selectedRow().intValue());
        this.toggleBookmarks(true);
        Host duplicate = new Host(selected.getAsDictionary());
        duplicate.setUuid(null);
        this.addBookmark(duplicate);
    }

    public void setAddBookmarkButton(NSButton addBookmarkButton) {
        this.addBookmarkButton = addBookmarkButton;
        this.addBookmarkButton.setTarget(this.id());
        this.addBookmarkButton.setAction(Foundation.selector("addBookmarkButtonClicked:"));
    }

    public void addBookmarkButtonClicked(ID sender) {
        Host bookmark;
        if (this.isMounted()) {
            Path selected = this.getSelectedPath();
            if (null == selected || !selected.attributes().isDirectory()) {
                selected = this.workdir();
            }
            bookmark = new Host(this.session.getHost().getAsDictionary());
            bookmark.setUuid(null);
            bookmark.setDefaultPath(selected.getAbsolute());
        } else {
            bookmark = new Host(ProtocolFactory.forName((String)Preferences.instance().getProperty("connection.protocol.default")), Preferences.instance().getProperty("connection.hostname.default"), Preferences.instance().getInteger("connection.port.default"));
        }
        this.toggleBookmarks(true);
        this.addBookmark(bookmark);
    }

    public void addBookmark(Host item) {
        this.bookmarkModel.setFilter(null);
        this.bookmarkModel.getSource().add(item);
        int row = this.bookmarkModel.getSource().lastIndexOf((Object)item);
        NSInteger index = new NSInteger(row);
        this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(index), false);
        this.bookmarkTable.scrollRowToVisible(index);
        BookmarkController c = BookmarkController.Factory.create(item);
        c.window().makeKeyAndOrderFront(null);
    }

    public void setDeleteBookmarkButton(NSButton deleteBookmarkButton) {
        this.deleteBookmarkButton = deleteBookmarkButton;
        this.deleteBookmarkButton.setEnabled(false);
        this.deleteBookmarkButton.setTarget(this.id());
        this.deleteBookmarkButton.setAction(Foundation.selector("deleteBookmarkButtonClicked:"));
    }

    public void deleteBookmarkButtonClicked(ID sender) {
        NSIndexSet iterator = this.bookmarkTable.selectedRowIndexes();
        final ArrayList<Object> selected = new ArrayList<Object>();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            selected.add(this.bookmarkModel.getSource().get(index.intValue()));
            index = iterator.indexGreaterThanIndex(index);
        }
        StringBuilder alertText = new StringBuilder(Locale.localizedString((String)"Do you want to delete the selected bookmark?"));
        Iterator iter = selected.iterator();
        for (int i = 0; i < 10 && iter.hasNext(); ++i) {
            alertText.append("\n").append(Character.toString('\u2022')).append(" ").append(((Host)iter.next()).getNickname());
        }
        if (iter.hasNext()) {
            alertText.append("\n").append(Character.toString('\u2022')).append(" \u2026");
        }
        NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Delete Bookmark"), alertText.toString(), Locale.localizedString((String)TOOLBAR_DELETE), Locale.localizedString((String)"Cancel"), null);
        this.alert(alert, new SheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    BrowserController.this.bookmarkTable.deselectAll(null);
                    BrowserController.this.bookmarkModel.getSource().removeAll((Collection)selected);
                }
            }
        });
    }

    public void setNavigationButton(NSSegmentedControl navigationButton) {
        this.navigationButton = navigationButton;
        this.navigationButton.setTarget(this.id());
        this.navigationButton.setAction(Foundation.selector("navigationButtonClicked:"));
    }

    public void navigationButtonClicked(NSSegmentedControl sender) {
        switch (sender.selectedSegment()) {
            case 0: {
                this.backButtonClicked(sender);
                break;
            }
            case 1: {
                this.forwardButtonClicked(sender);
            }
        }
    }

    public void backButtonClicked(NSSegmentedControl sender) {
        Path selected = this.getPreviousPath();
        if (selected != null) {
            Path previous = this.workdir();
            if (previous.getParent().equals((Object)selected)) {
                this.setWorkdir(selected, previous);
            } else {
                this.setWorkdir(selected);
            }
        }
    }

    public void forwardButtonClicked(NSSegmentedControl sender) {
        Path selected = this.getForwardPath();
        if (selected != null) {
            this.setWorkdir(selected);
        }
    }

    public void setUpButton(NSSegmentedControl upButton) {
        this.upButton = upButton;
        this.upButton.setTarget(this.id());
        this.upButton.setAction(Foundation.selector("upButtonClicked:"));
    }

    public void upButtonClicked(ID sender) {
        Path previous = this.workdir();
        this.setWorkdir(previous.getParent(), previous);
    }

    public void setPathPopup(NSPopUpButton pathPopupButton) {
        this.pathPopupButton = pathPopupButton;
        this.pathPopupButton.setTarget(this.id());
        this.pathPopupButton.setAction(Foundation.selector("pathPopupSelectionChanged:"));
    }

    private void addPathToNavigation(Path p) {
        this.pathPopupButton.addItemWithTitle(p.getAbsolute());
        this.pathPopupButton.lastItem().setRepresentedObject(p.getAbsolute());
        this.pathPopupButton.lastItem().setImage(IconCache.instance().iconForPath(p, (Integer)16));
    }

    private void validateNavigationButtons() {
        if (!this.isMounted()) {
            this.pathPopupButton.removeAllItems();
        } else {
            this.pathPopupButton.removeAllItems();
            Path workdir = this.workdir();
            this.addPathToNavigation(workdir);
            Path p = workdir;
            while (!p.getParent().equals((Object)p)) {
                this.addPathToNavigation(p);
                p = p.getParent();
            }
            this.addPathToNavigation(p);
        }
        this.navigationButton.setEnabled_forSegment(this.isMounted() && this.getBackHistory().size() > 1, 0);
        this.navigationButton.setEnabled_forSegment(this.isMounted() && this.getForwardHistory().size() > 0, 1);
        this.upButton.setEnabled_forSegment(this.isMounted() && !this.workdir().isRoot(), 0);
        this.pathPopupButton.setEnabled(this.isMounted());
        boolean enabled = this.isMounted() || this.getSelectedTabView() == 0;
        this.searchField.setEnabled(enabled);
        if (!enabled) {
            this.searchField.setStringValue("");
        }
    }

    public void pathPopupSelectionChanged(NSPopUpButton sender) {
        String selected = sender.selectedItem().representedObject();
        Path previous = this.workdir();
        if (selected != null) {
            Path path = PathFactory.createPath((Session)this.session, (String)selected, (int)2);
            this.setWorkdir(path);
            if (previous.getParent().equals((Object)path)) {
                this.setWorkdir(path, previous);
            } else {
                this.setWorkdir(path);
            }
        }
    }

    public void setEncodingPopup(NSPopUpButton encodingPopup) {
        this.encodingPopup = encodingPopup;
        this.encodingPopup.setTarget(this.id());
        this.encodingPopup.setAction(Foundation.selector("encodingButtonClicked:"));
        this.encodingPopup.removeAllItems();
        this.encodingPopup.addItemsWithTitles(NSArray.arrayWithObjects(MainController.availableCharsets()));
        this.encodingPopup.selectItemWithTitle(Preferences.instance().getProperty("browser.charset.encoding"));
    }

    public void encodingButtonClicked(NSPopUpButton sender) {
        this.encodingChanged(sender.titleOfSelectedItem());
    }

    public void encodingMenuClicked(NSMenuItem sender) {
        this.encodingChanged(sender.title());
    }

    public void encodingChanged(final String encoding) {
        if (null == encoding) {
            return;
        }
        this.setEncoding(encoding);
        if (this.isMounted()) {
            if (this.session.getEncoding().equals(encoding)) {
                return;
            }
            this.background((BackgroundAction)new BrowserBackgroundAction(this){

                public void run() {
                    BrowserController.this.session.close();
                }

                public void cleanup() {
                    BrowserController.this.session.getHost().setEncoding(encoding);
                    BrowserController.this.reloadButtonClicked(null);
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Disconnecting {0}", (String)"Status"), BrowserController.this.session.getHost().getHostname());
                }
            });
        }
    }

    private void setEncoding(String encoding) {
        this.encodingPopup.selectItemWithTitle(encoding);
    }

    public void toggleLogDrawer(ID sender) {
        this.logDrawer.toggle(this.id());
    }

    public void setStatusSpinner(NSProgressIndicator statusSpinner) {
        this.statusSpinner = statusSpinner;
        this.statusSpinner.setDisplayedWhenStopped(false);
        this.statusSpinner.setIndeterminate(true);
    }

    public NSProgressIndicator getStatusSpinner() {
        return this.statusSpinner;
    }

    public void setBrowserSpinner(NSProgressIndicator browserSpinner) {
        this.browserSpinner = browserSpinner;
    }

    public NSProgressIndicator getBrowserSpinner() {
        return this.browserSpinner;
    }

    public void setStatusLabel(NSTextField statusLabel) {
        this.statusLabel = statusLabel;
    }

    public void updateStatusLabel() {
        BackgroundAction current;
        String label = this.getSelectedTabView() == 0 ? (Object)((Object)this.bookmarkTable.numberOfRows()) + " " + Locale.localizedString((String)"Bookmarks") : (null == (current = this.getActions().getCurrent()) ? (this.isConnected() ? MessageFormat.format(Locale.localizedString((String)"{0} Files"), String.valueOf((Object)this.getSelectedBrowserView().numberOfRows())) : Locale.localizedString((String)"Disconnected", (String)"Status")) : (StringUtils.isNotBlank((String)this.laststatus) ? this.laststatus : current.getActivity()));
        this.updateStatusLabel(label);
    }

    public void updateStatusLabel(String label) {
        if (StringUtils.isNotBlank((String)label)) {
            this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(label, TRUNCATE_MIDDLE_ATTRIBUTES));
        } else {
            this.statusLabel.setStringValue("");
        }
    }

    public void setSecurityLabel(NSButton securityLabel) {
        this.securityLabel = securityLabel;
        this.securityLabel.setEnabled(false);
        this.securityLabel.setTarget(this.id());
        this.securityLabel.setAction(Foundation.selector("securityLabelClicked:"));
    }

    public void securityLabelClicked(ID sender) {
        if (this.session instanceof SSLSession) {
            List certificates = ((SSLSession)this.session).getAcceptedIssuers();
            if (0 == certificates.size()) {
                log.warn((Object)"No accepted certificates found");
                return;
            }
            KeychainFactory.instance().displayCertificates(certificates.toArray(new X509Certificate[certificates.size()]));
        }
    }

    public void quicklookButtonClicked(ID sender) {
        if (QuickLookFactory.instance().isOpen()) {
            QuickLookFactory.instance().close();
        } else {
            AbstractBrowserTableDelegate<Path> delegate = this.getSelectedBrowserDelegate();
            ((AbstractBrowserTableDelegate)delegate).updateQuickLookSelection(this.getSelectedPaths());
        }
    }

    public void reloadButtonClicked(ID sender) {
        if (this.isMounted()) {
            List<Path> selected = this.getSelectedPaths();
            switch (this.browserSwitchView.selectedSegment()) {
                case 0: {
                    this.workdir().invalidate();
                    break;
                }
                case 1: {
                    this.workdir().invalidate();
                    for (int i = 0; i < this.browserOutlineView.numberOfRows().intValue(); ++i) {
                        Path item = this.lookup(new OutlinePathReference(this.browserOutlineView.itemAtRow(new NSInteger(i))));
                        if (null == item) continue;
                        item.invalidate();
                    }
                    break;
                }
            }
            this.reloadData(selected);
        }
    }

    public void newBrowserButtonClicked(ID sender) {
        Path selected = this.getSelectedPath();
        if (null == selected || !selected.attributes().isDirectory()) {
            selected = this.workdir();
        }
        BrowserController c = MainController.newDocument(true);
        Host host = new Host(this.getSession().getHost().getAsDictionary());
        host.setDefaultPath(selected.getAbsolute());
        c.mount(host);
    }

    protected void duplicatePath(Path source, Path destination, boolean edit) {
        this.duplicatePaths(Collections.singletonMap(source, destination), edit);
    }

    protected void duplicatePaths(Map<Path, Path> selected, final boolean edit) {
        final Map<Path, Path> normalized = this.checkHierarchy(selected);
        this.checkOverwrite(normalized.values(), (BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                Iterator sourcesIter = normalized.keySet().iterator();
                Iterator destinationsIter = normalized.values().iterator();
                while (sourcesIter.hasNext() && !this.isCanceled()) {
                    Path source = (Path)sourcesIter.next();
                    Path destination = (Path)destinationsIter.next();
                    source.copy((AbstractPath)destination);
                    if (BrowserController.this.isConnected()) continue;
                    break;
                }
            }

            public void cleanup() {
                for (Path duplicate : normalized.values()) {
                    if (edit) {
                        Editor editor = EditorFactory.createEditor(BrowserController.this, duplicate);
                        editor.open();
                    }
                    if (duplicate.getName().charAt(0) != '.') continue;
                    BrowserController.this.setShowHiddenFiles(true);
                }
                BrowserController.this.reloadData(new ArrayList<Path>(normalized.values()));
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Copying {0} to {1}", (String)"Status"), ((Path)normalized.keySet().iterator().next()).getName(), ((Path)normalized.values().iterator().next()).getName());
            }
        });
    }

    protected void renamePath(Path path, Path renamed) {
        this.renamePaths(Collections.singletonMap(path, renamed));
    }

    protected void renamePaths(Map<Path, Path> selected) {
        final Map<Path, Path> normalized = this.checkHierarchy(selected);
        this.checkMove(normalized.values(), (BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                Iterator originalIterator = normalized.keySet().iterator();
                Iterator renamedIterator = normalized.values().iterator();
                while (originalIterator.hasNext() && !this.isCanceled()) {
                    Path original = (Path)originalIterator.next();
                    Path renamed = (Path)renamedIterator.next();
                    original.rename((AbstractPath)renamed);
                    if (BrowserController.this.isConnected()) continue;
                    break;
                }
            }

            public void cleanup() {
                BrowserController.this.reloadData(new ArrayList<Path>(normalized.values()));
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Renaming {0} to {1}", (String)"Status"), ((Path)normalized.keySet().iterator().next()).getName(), ((Path)normalized.values().iterator().next()).getName());
            }
        });
    }

    private void checkOverwrite(Collection<Path> selected, final BackgroundAction action) {
        if (selected.size() > 0) {
            StringBuilder alertText = new StringBuilder(Locale.localizedString((String)"A file with the same name already exists. Do you want to replace the existing file?"));
            int i = 0;
            boolean shouldWarn = false;
            for (Path item : selected) {
                if (item.exists()) {
                    if (i < 10) {
                        alertText.append("\n").append(Character.toString('\u2022')).append(" ").append(item.getName());
                    }
                    shouldWarn = true;
                }
                ++i;
            }
            if (i >= 10) {
                alertText.append("\n" + Character.toString('\u2022') + " ...)");
            }
            if (shouldWarn) {
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Overwrite"), alertText.toString(), Locale.localizedString((String)"Overwrite"), Locale.localizedString((String)"Cancel"), null);
                this.alert(alert, new SheetCallback(){

                    public void callback(int returncode) {
                        if (returncode == 1) {
                            BrowserController.this.background(action);
                        }
                    }
                });
            } else {
                this.background(action);
            }
        }
    }

    private void checkMove(final Collection<Path> selected, final BackgroundAction action) {
        if (selected.size() > 0) {
            if (Preferences.instance().getBoolean("browser.confirmMove")) {
                StringBuilder alertText = new StringBuilder(Locale.localizedString((String)"Do you want to move the selected files?"));
                Iterator<Path> iter = selected.iterator();
                for (int i = 0; i < 10 && iter.hasNext(); ++i) {
                    Path item = iter.next();
                    alertText.append("\n" + Character.toString('\u2022') + " " + item.getName());
                }
                if (iter.hasNext()) {
                    alertText.append("\n" + Character.toString('\u2022') + " ...)");
                }
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Move"), alertText.toString(), Locale.localizedString((String)"Move"), Locale.localizedString((String)"Cancel"), null);
                this.alert(alert, new SheetCallback(){

                    public void callback(int returncode) {
                        if (returncode == 1) {
                            BrowserController.this.checkOverwrite(selected, action);
                        }
                    }
                });
            } else {
                this.checkOverwrite(selected, action);
            }
        }
    }

    protected Map<Path, Path> checkHierarchy(Map<Path, Path> selected) {
        HashMap<Path, Path> normalized = new HashMap<Path, Path>();
        Iterator<Path> sourcesIter = selected.keySet().iterator();
        Iterator<Path> destinationsIter = selected.values().iterator();
        while (sourcesIter.hasNext()) {
            Path f = sourcesIter.next();
            Path r = destinationsIter.next();
            boolean duplicate = false;
            Iterator normalizedIter = normalized.keySet().iterator();
            while (normalizedIter.hasNext()) {
                Path n = (Path)normalizedIter.next();
                if (f.isChild((AbstractPath)n)) {
                    duplicate = true;
                    break;
                }
                if (!n.isChild((AbstractPath)f)) continue;
                normalizedIter.remove();
            }
            if (duplicate) continue;
            normalized.put(f, r);
        }
        return normalized;
    }

    protected List<Path> checkHierarchy(List<Path> selected) {
        ch.cyberduck.core.Collection normalized = new ch.cyberduck.core.Collection();
        for (Path f : selected) {
            boolean duplicate = false;
            for (Path n : normalized) {
                if (!f.isChild((AbstractPath)n)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            normalized.add(f);
        }
        return normalized;
    }

    public void deletePath(Path file) {
        this.deletePaths(Collections.singletonList(file));
    }

    public void deletePaths(List<Path> selected) {
        final List<Path> normalized = this.checkHierarchy(selected);
        if (normalized.isEmpty()) {
            return;
        }
        StringBuilder alertText = new StringBuilder(Locale.localizedString((String)"Really delete the following files? This cannot be undone."));
        Iterator<Path> iter = normalized.iterator();
        for (int i = 0; i < 10 && iter.hasNext(); ++i) {
            alertText.append("\n").append(Character.toString('\u2022')).append(" ").append(iter.next().getName());
        }
        if (iter.hasNext()) {
            alertText.append("\n").append(Character.toString('\u2022')).append(" \u2026");
        }
        NSAlert alert = NSAlert.alert(Locale.localizedString((String)TOOLBAR_DELETE), alertText.toString(), Locale.localizedString((String)TOOLBAR_DELETE), Locale.localizedString((String)"Cancel"), null);
        this.alert(alert, new SheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    BrowserController.this.deletePathsImpl(normalized);
                }
            }
        });
    }

    private void deletePathsImpl(final List<Path> files) {
        this.background((BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                for (Path file : files) {
                    if (this.isCanceled()) break;
                    file.delete();
                    if (BrowserController.this.isConnected()) continue;
                    break;
                }
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Deleting {0}", (String)"Status"), "");
            }

            public void cleanup() {
                BrowserController.this.reloadData(false);
            }
        });
    }

    public void revertPath(final Path selected) {
        this.background((BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                if (this.isCanceled()) {
                    return;
                }
                selected.revert();
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Reverting {0}", (String)"Status"), selected.getName());
            }

            public void cleanup() {
                BrowserController.this.reloadData(false);
            }
        });
    }

    private boolean isEditable(Path selected) {
        if (this.getSession().getHost().getCredentials().isAnonymousLogin()) {
            return false;
        }
        if (selected.attributes().isFile()) {
            if (Preferences.instance().getBoolean("editor.kqueue.enable")) {
                return true;
            }
            return !selected.getBinaryFiletypePattern().matcher(selected.getName()).matches();
        }
        return false;
    }

    public void gotoButtonClicked(ID sender) {
        GotoController sheet = new GotoController(this);
        sheet.beginSheet();
    }

    public void createFileButtonClicked(ID sender) {
        CreateFileController sheet = new CreateFileController(this);
        ((SheetController)sheet).beginSheet();
    }

    public void createSymlinkButtonClicked(ID sender) {
        CreateSymlinkController sheet = new CreateSymlinkController(this);
        ((SheetController)sheet).beginSheet();
    }

    public void duplicateFileButtonClicked(ID sender) {
        DuplicateFileController sheet = new DuplicateFileController(this);
        ((SheetController)sheet).beginSheet();
    }

    public void createFolderButtonClicked(ID sender) {
        FolderController sheet = new FolderController(this);
        ((SheetController)sheet).beginSheet();
    }

    public void renameFileButtonClicked(ID sender) {
        NSTableView browser = this.getSelectedBrowserView();
        browser.editRow(browser.columnWithIdentifier("FILENAME"), browser.selectedRow(), true);
    }

    public void sendCustomCommandClicked(ID sender) {
        CommandController sheet = new CommandController((WindowController)this, this.session);
        sheet.beginSheet();
    }

    public void editMenuClicked(NSMenuItem sender) {
        for (Path selected : this.getSelectedPaths()) {
            Editor editor = EditorFactory.createEditor(this, sender.representedObject(), selected);
            editor.open();
        }
    }

    public void editButtonClicked(ID sender) {
        for (Path selected : this.getSelectedPaths()) {
            Editor editor = EditorFactory.createEditor(this, selected);
            editor.open();
        }
    }

    public void openBrowserButtonClicked(ID sender) {
        if (this.getSelectionCount() == 1) {
            BrowserController.openUrl(this.getSelectedPath().toHttpURL());
        } else {
            BrowserController.openUrl(this.workdir().toHttpURL());
        }
    }

    public void infoButtonClicked(ID sender) {
        if (this.getSelectionCount() > 0) {
            List<Path> selected = this.getSelectedPaths();
            InfoController c = InfoController.Factory.create(this, selected);
            c.window().makeKeyAndOrderFront(null);
        }
    }

    public void revertFileButtonClicked(ID sender) {
        this.revertPath(this.getSelectedPath());
    }

    public void deleteFileButtonClicked(ID sender) {
        this.deletePaths(this.getSelectedPaths());
    }

    public void downloadToButtonClicked(ID sender) {
        this.downloadToPanel = NSOpenPanel.openPanel();
        this.downloadToPanel.setCanChooseDirectories(true);
        this.downloadToPanel.setCanCreateDirectories(true);
        this.downloadToPanel.setCanChooseFiles(false);
        this.downloadToPanel.setAllowsMultipleSelection(false);
        this.downloadToPanel.setPrompt(Locale.localizedString((String)"Choose"));
        this.downloadToPanel.beginSheetForDirectory(lastSelectedDownloadDirectory, null, this.window, this.id(), Foundation.selector("downloadToPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void downloadToPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.close();
        if (returncode == 1) {
            Session session = this.getTransferSession();
            ch.cyberduck.core.Collection roots = new ch.cyberduck.core.Collection();
            Local downloadfolder = LocalFactory.createLocal((String)sheet.filename());
            this.download(this.getSelectedPaths(), downloadfolder);
        }
        lastSelectedDownloadDirectory = sheet.filename();
        this.downloadToPanel = null;
    }

    public void downloadAsButtonClicked(ID sender) {
        this.downloadAsPanel = NSSavePanel.savePanel();
        this.downloadAsPanel.setMessage(Locale.localizedString((String)"Download the selected file to\u2026"));
        this.downloadAsPanel.setNameFieldLabel(Locale.localizedString((String)"Download As:"));
        this.downloadAsPanel.setPrompt(Locale.localizedString((String)TOOLBAR_DOWNLOAD));
        this.downloadAsPanel.setCanCreateDirectories(true);
        this.downloadAsPanel.beginSheetForDirectory(null, this.getSelectedPath().getLocal().getDisplayName(), this.window, this.id(), Foundation.selector("downloadAsPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void downloadAsPanelDidEnd_returnCode_contextInfo(NSSavePanel sheet, int returncode, ID contextInfo) {
        String filename;
        sheet.close();
        if (returncode == 1 && (filename = sheet.filename()) != null) {
            Path selection = PathFactory.createPath((Session)this.getTransferSession(), (Object)this.getSelectedPath().getAsDictionary());
            selection.setLocal(LocalFactory.createLocal((String)filename));
            DownloadTransfer q = new DownloadTransfer(selection);
            this.transfer((Transfer)q);
        }
    }

    public void syncButtonClicked(ID sender) {
        Path selection = this.getSelectionCount() == 1 && this.getSelectedPath().attributes().isDirectory() ? this.getSelectedPath() : this.workdir();
        this.syncPanel = NSOpenPanel.openPanel();
        this.syncPanel.setCanChooseDirectories(selection.attributes().isDirectory());
        this.syncPanel.setCanChooseFiles(selection.attributes().isFile());
        this.syncPanel.setCanCreateDirectories(true);
        this.syncPanel.setAllowsMultipleSelection(false);
        this.syncPanel.setMessage(MessageFormat.format(Locale.localizedString((String)"Synchronize {0} with"), selection.getName()));
        this.syncPanel.setPrompt(Locale.localizedString((String)"Choose"));
        this.syncPanel.beginSheetForDirectory(this.getSession().getHost().getDownloadFolder().getAbsolute(), null, this.window, this.id(), Foundation.selector("syncPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void syncPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.close();
        if (returncode == 1 && sheet.filenames().count().intValue() > 0) {
            Path selected = this.getSelectionCount() == 1 && this.getSelectedPath().attributes().isDirectory() ? this.getSelectedPath() : this.workdir();
            Path root = PathFactory.createPath((Session)this.getTransferSession(true), (Object)selected.getAsDictionary());
            root.setLocal(LocalFactory.createLocal((String)sheet.filenames().lastObject().toString()));
            SyncTransfer q = new SyncTransfer(root);
            this.transfer((Transfer)q, selected);
        }
    }

    public void downloadButtonClicked(ID sender) {
        this.download(this.getSelectedPaths());
    }

    public void download(List<Path> downloads) {
        this.download(downloads, null);
    }

    public void download(List<Path> downloads, Local downloadfolder) {
        Session session = this.getTransferSession();
        ch.cyberduck.core.Collection roots = new ch.cyberduck.core.Collection();
        for (Path selected : downloads) {
            Path path = PathFactory.createPath((Session)session, (Object)selected.getAsDictionary());
            if (null == downloadfolder) {
                path.setLocal(null);
            } else {
                path.setLocal(LocalFactory.createLocal((Local)downloadfolder, (String)path.getName()));
            }
            roots.add(path);
        }
        DownloadTransfer transfer = new DownloadTransfer((List)roots);
        this.transfer((Transfer)transfer);
    }

    public void uploadButtonClicked(ID sender) {
        this.uploadPanel = NSOpenPanel.openPanel();
        this.uploadPanel.setCanChooseDirectories(true);
        this.uploadPanel.setCanCreateDirectories(false);
        this.uploadPanel.setCanChooseFiles(true);
        this.uploadPanel.setAllowsMultipleSelection(true);
        this.uploadPanel.setPrompt(Locale.localizedString((String)TOOLBAR_UPLOAD));
        if (this.uploadPanel.respondsToSelector(Foundation.selector("setShowsHiddenFiles:"))) {
            this.uploadPanelHiddenFilesCheckbox = NSButton.buttonWithFrame(new NSRect(0.0, 0.0));
            this.uploadPanelHiddenFilesCheckbox.setTitle(Locale.localizedString((String)"Show Hidden Files"));
            this.uploadPanelHiddenFilesCheckbox.setTarget(this.id());
            this.uploadPanelHiddenFilesCheckbox.setAction(Foundation.selector("uploadPanelSetShowHiddenFiles:"));
            this.uploadPanelHiddenFilesCheckbox.setButtonType(3);
            this.uploadPanelHiddenFilesCheckbox.setState(0);
            this.uploadPanelHiddenFilesCheckbox.sizeToFit();
            this.uploadPanel.setAccessoryView(this.uploadPanelHiddenFilesCheckbox);
        }
        this.uploadPanel.beginSheetForDirectory(lastSelectedUploadDirectory, null, this.window, this.id(), Foundation.selector("uploadPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void uploadPanelSetShowHiddenFiles(ID sender) {
        this.uploadPanel.setShowsHiddenFiles(this.uploadPanelHiddenFilesCheckbox.state() == 1);
    }

    public void uploadPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.close();
        if (returncode == 1) {
            NSObject next;
            Path destination = this.getSelectedPath();
            if (null == destination) {
                destination = this.workdir();
            } else if (!destination.attributes().isDirectory()) {
                destination = destination.getParent();
            }
            NSArray selected = sheet.filenames();
            NSEnumerator iterator = selected.objectEnumerator();
            Session session = this.getTransferSession();
            ch.cyberduck.core.Collection roots = new ch.cyberduck.core.Collection();
            while ((next = iterator.nextObject()) != null) {
                roots.add(PathFactory.createPath((Session)session, (String)destination.getAbsolute(), (Local)LocalFactory.createLocal((String)next.toString())));
            }
            UploadTransfer q = new UploadTransfer((List)roots);
            this.transfer((Transfer)q, destination);
        }
        lastSelectedUploadDirectory = new File(sheet.filename()).getParent();
        this.uploadPanel = null;
        this.uploadPanelHiddenFilesCheckbox = null;
    }

    protected Session getTransferSession() {
        return this.getTransferSession(false);
    }

    protected Session getTransferSession(boolean force) {
        if (!this.isMounted()) {
            return null;
        }
        if (!force && this.session.getMaxConnections() == 1) {
            return this.session;
        }
        Host h = new Host(this.session.getHost().getAsDictionary());
        h.getCredentials().setPassword(this.session.getHost().getCredentials().getPassword());
        h.getCredentials().setUseKeychain(false);
        return SessionFactory.createSession((Host)h);
    }

    protected void transfer(final Transfer transfer, final Path workdir) {
        TransferAdapter l = new TransferAdapter(){

            public void transferDidEnd() {
                if (BrowserController.this.isMounted()) {
                    workdir.invalidate();
                    if (!transfer.isCanceled()) {
                        BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                            public void run() {
                                BrowserController.this.reloadData(true);
                            }

                            public boolean isValid() {
                                return super.isValid() && BrowserController.this.isConnected();
                            }
                        });
                    }
                }
            }
        };
        transfer.addListener((TransferListener)l);
        this.addListener(new WindowListener((TransferListener)l){
            final /* synthetic */ TransferListener val$l;
            {
                this.val$l = transferListener;
            }

            public void windowWillClose() {
                transfer.removeListener(this.val$l);
            }
        });
        this.transfer(transfer);
    }

    protected void transfer(Transfer transfer) {
        this.transfer(transfer, transfer.getSession().getMaxConnections() == 1);
    }

    protected void transfer(Transfer transfer, boolean useBrowserConnection) {
        this.transfer(transfer, useBrowserConnection, TransferPromptController.create(this, transfer));
    }

    protected void transfer(Transfer transfer, TransferPrompt prompt) {
        this.transfer(transfer, transfer.getSession().getMaxConnections() == 1, prompt);
    }

    protected void transfer(final Transfer transfer, boolean useBrowserConnection, final TransferPrompt prompt) {
        if (useBrowserConnection) {
            TransferAdapter l = new TransferAdapter(){
                private Speedometer meter;
                private ScheduledFuture<?> progressTimer;
                {
                    this.meter = new Speedometer(transfer);
                }

                public void willTransferPath(Path path) {
                    this.meter.reset();
                    this.progressTimer = AbstractController.getTimerPool().scheduleAtFixedRate(new Runnable(){

                        public void run() {
                            BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                                public void run() {
                                    BrowserController.this.updateStatusLabel(meter.getProgress());
                                }
                            });
                        }
                    }, 0L, 500L, TimeUnit.MILLISECONDS);
                }

                public void didTransferPath(Path path) {
                    boolean canceled = false;
                    while (!canceled) {
                        canceled = this.progressTimer.cancel(false);
                    }
                    this.meter.reset();
                }

                public void bandwidthChanged(BandwidthThrottle bandwidth) {
                    this.meter.reset();
                }
            };
            transfer.addListener((TransferListener)l);
            this.addListener(new WindowListener((TransferListener)l){
                final /* synthetic */ TransferListener val$l;
                {
                    this.val$l = transferListener;
                }

                public void windowWillClose() {
                    transfer.removeListener(this.val$l);
                }
            });
            this.background((BackgroundAction)new BrowserBackgroundAction(this){

                public void run() {
                    TransferOptions options = new TransferOptions();
                    options.closeSession = false;
                    transfer.start(prompt, options);
                }

                public void cancel() {
                    transfer.cancel();
                    super.cancel();
                }

                public void cleanup() {
                    BrowserController.this.updateStatusLabel();
                }

                public String getActivity() {
                    return transfer.getName();
                }
            });
        } else {
            TransferController.instance().startTransfer(transfer);
        }
    }

    public void insideButtonClicked(ID sender) {
        Path selected = this.getSelectedPath();
        if (null == selected) {
            return;
        }
        if (selected.attributes().isDirectory()) {
            this.setWorkdir(selected);
        } else if (selected.attributes().isFile() || this.getSelectionCount() > 1) {
            if (Preferences.instance().getBoolean("browser.doubleclick.edit")) {
                this.editButtonClicked(null);
            } else {
                this.downloadButtonClicked(null);
            }
        }
    }

    public void connectButtonClicked(ID sender) {
        final ConnectionController controller = ConnectionController.instance(this);
        this.addListener(new WindowListener(){

            public void windowWillClose() {
                controller.invalidate();
            }
        });
        controller.beginSheet();
    }

    public void interruptButtonClicked(ID sender) {
        for (BackgroundAction action : (BackgroundAction[])this.getActions().toArray((Object[])new BackgroundAction[this.getActions().size()])) {
            action.cancel();
        }
        this.interrupt();
    }

    public void disconnectButtonClicked(ID sender) {
        if (this.isActivityRunning()) {
            this.interruptButtonClicked(sender);
        } else {
            this.disconnect();
        }
    }

    public void showHiddenFilesClicked(NSMenuItem sender) {
        if (sender.state() == 1) {
            this.setShowHiddenFiles(false);
            sender.setState(0);
        } else if (sender.state() == 0) {
            this.setShowHiddenFiles(true);
            sender.setState(1);
        }
        if (this.isMounted()) {
            this.reloadData(true);
        }
    }

    public boolean hasSession() {
        return this.session != null;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isMounted() {
        return this.hasSession() && this.workdir() != null;
    }

    public boolean isConnected() {
        if (this.isMounted()) {
            return this.session.isConnected();
        }
        return false;
    }

    public ID validRequestorForSendType_returnType(String sendType, String returnType) {
        log.debug((Object)("validRequestorForSendType_returnType:" + sendType + "," + returnType));
        if (StringUtils.isNotEmpty((String)sendType)) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)returnType) && "NSFilenamesPboardType".equals(sendType)) {
            return this.id();
        }
        return null;
    }

    public boolean readSelectionFromPasteboard(NSPasteboard pboard) {
        return this.upload(pboard);
    }

    public boolean writeSelectionToPasteboard_types(NSPasteboard pboard, NSArray types) {
        return false;
    }

    public void copy(ID sender) {
        PathPasteboard pasteboard = PathPasteboard.getPasteboard((Session)this.getSession());
        pasteboard.clear();
        pasteboard.setCopy(true);
        List<Path> selected = this.getSelectedPaths();
        for (Path p : selected) {
            pasteboard.add((Object)p);
        }
        NSPasteboard clipboard = NSPasteboard.generalPasteboard();
        if (selected.size() == 0) {
            selected = Collections.singletonList(this.workdir());
        }
        clipboard.declareTypes(NSArray.arrayWithObject(NSString.stringWithString("NSStringPboardType")), null);
        StringBuilder copy = new StringBuilder();
        for (Path p : selected) {
            copy.append(p.getAbsolute()).append("\n");
        }
        if (!clipboard.setStringForType(copy.toString(), "NSStringPboardType")) {
            log.error((Object)"Error writing to NSPasteboard.StringPboardType.");
        }
    }

    public void cut(ID sender) {
        PathPasteboard pasteboard = PathPasteboard.getPasteboard((Session)this.getSession());
        pasteboard.clear();
        pasteboard.setCut(true);
        for (Path selected : this.getSelectedPaths()) {
            pasteboard.add((Object)selected);
        }
        NSPasteboard clipboard = NSPasteboard.generalPasteboard();
        clipboard.declareTypes(NSArray.arrayWithObject(NSString.stringWithString("NSStringPboardType")), null);
        if (!clipboard.setStringForType(this.getSelectedPath().getAbsolute(), "NSStringPboardType")) {
            log.error((Object)"Error writing to NSPasteboard.StringPboardType.");
        }
    }

    public void paste(ID sender) {
        PathPasteboard pasteboard = PathPasteboard.getPasteboard((Session)this.getSession());
        if (pasteboard.isEmpty()) {
            NSPasteboard pboard = NSPasteboard.generalPasteboard();
            this.upload(pboard);
        } else {
            HashMap<Path, Path> files = new HashMap<Path, Path>();
            Path parent = this.workdir();
            if (this.getSelectionCount() == 1) {
                Path selected = this.getSelectedPath();
                parent = selected.attributes().isDirectory() ? selected : selected.getParent();
            }
            for (Path next : pasteboard) {
                Path current = PathFactory.createPath((Session)this.getSession(), (String)next.getAbsolute(), (int)next.attributes().getType());
                Path renamed = PathFactory.createPath((Session)this.getSession(), (String)parent.getAbsolute(), (String)current.getName(), (int)next.attributes().getType());
                files.put(current, renamed);
            }
            pasteboard.clear();
            if (pasteboard.isCut()) {
                this.renamePaths(files);
            }
            if (pasteboard.isCopy()) {
                this.duplicatePaths(files, false);
            }
        }
    }

    private boolean upload(NSPasteboard pboard) {
        NSObject o;
        if (!this.isMounted()) {
            return false;
        }
        if (pboard.availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null) {
            NSArray elements = Rococoa.cast(o, NSArray.class);
            Path workdir = this.workdir();
            Session session = this.getTransferSession();
            ch.cyberduck.core.Collection roots = new ch.cyberduck.core.Collection();
            for (int i = 0; i < elements.count().intValue(); ++i) {
                Path p = PathFactory.createPath((Session)session, (String)workdir.getAbsolute(), (Local)LocalFactory.createLocal((String)elements.objectAtIndex(new NSUInteger(i)).toString()));
                roots.add(p);
            }
            UploadTransfer q = new UploadTransfer((List)roots);
            if (q.numberOfRoots() > 0) {
                this.transfer((Transfer)q, workdir);
                return true;
            }
        }
        return false;
    }

    public void openTerminalButtonClicked(ID sender) {
        String app;
        Path selected;
        Host host = this.getSession().getHost();
        boolean identity = host.getCredentials().isPublicKeyAuthentication();
        String workdir = null;
        if (this.getSelectionCount() == 1 && (selected = this.getSelectedPath()).attributes().isDirectory()) {
            workdir = selected.getAbsolute();
        }
        if (null == workdir) {
            workdir = this.workdir().getAbsolute();
        }
        if (StringUtils.isEmpty((String)(app = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(Preferences.instance().getProperty("terminal.bundle.identifier"))))) {
            log.error((Object)("Application with bundle identifier " + Preferences.instance().getProperty("terminal.bundle.identifier") + " is not installed"));
            return;
        }
        String ssh = MessageFormat.format(Preferences.instance().getProperty("terminal.command.ssh"), identity ? "-i " + host.getCredentials().getIdentity().getAbsolute() : "", host.getCredentials().getUsername(), host.getHostname(), String.valueOf(host.getPort()), workdir);
        log.info((Object)("SSH Command:" + ssh));
        ssh = StringUtils.replace((String)ssh, (String)"\\", (String)"\\\\");
        ssh = StringUtils.replace((String)ssh, (String)"\"", (String)"\\\"");
        log.info((Object)("Escaped SSH Command for Applescript:" + ssh));
        String command = "tell application \"" + LocalFactory.createLocal((String)app).getDisplayName() + "\"" + "\n" + "activate" + "\n" + MessageFormat.format(Preferences.instance().getProperty("terminal.command"), ssh) + "\n" + "end tell";
        log.info((Object)("Excecuting AppleScript:" + command));
        NSAppleScript as = NSAppleScript.createWithSource(command);
        as.executeAndReturnError(null);
    }

    public void archiveMenuClicked(NSMenuItem sender) {
        Archive archive = Archive.forName((String)sender.representedObject());
        this.archiveClicked(archive);
    }

    public void archiveButtonClicked(NSToolbarItem sender) {
        this.archiveClicked(Archive.TARGZ);
    }

    private void archiveClicked(final Archive archive) {
        final List<Path> selected = this.getSelectedPaths();
        this.checkOverwrite(Collections.singletonList(archive.getArchive(selected)), (BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                BrowserController.this.session.archive(archive, selected);
            }

            public void cleanup() {
                BrowserController.this.reloadData(Collections.singletonList(archive.getArchive(selected)));
            }

            public String getActivity() {
                return archive.getCompressCommand(selected);
            }
        });
    }

    public void unarchiveButtonClicked(ID sender) {
        final ArrayList expanded = new ArrayList();
        for (final Path selected : this.getSelectedPaths()) {
            final Archive archive = Archive.forName((String)selected.getName());
            if (null == archive) continue;
            this.checkOverwrite(archive.getExpanded(Collections.singletonList(selected)), (BackgroundAction)new BrowserBackgroundAction(this){

                public void run() {
                    BrowserController.this.session.unarchive(archive, selected);
                }

                public void cleanup() {
                    expanded.addAll(archive.getExpanded(Collections.singletonList(selected)));
                    BrowserController.this.reloadData(expanded);
                }

                public String getActivity() {
                    return archive.getDecompressCommand(selected);
                }
            });
        }
    }

    public boolean isActivityRunning() {
        BackgroundAction current = this.getActions().getCurrent();
        return null != current;
    }

    public Path lookup(PathReference path) {
        if (this.isMounted()) {
            return (Path)this.getSession().cache().lookup(path);
        }
        return null;
    }

    protected Path workdir() {
        return this.workdir;
    }

    public void setWorkdir(Path directory) {
        this.setWorkdir(directory, Collections.<Path>emptyList());
    }

    public void setWorkdir(Path directory, Path selected) {
        this.setWorkdir(directory, Collections.singletonList(selected));
    }

    public void setWorkdir(final Path directory, final List<Path> selected) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setWorkdir:" + directory));
        }
        if (null == directory) {
            this.workdir = null;
            this.reloadData(false);
            return;
        }
        NSTableView browser = this.getSelectedBrowserView();
        this.window.endEditingFor(browser);
        this.background((BackgroundAction)new BrowserBackgroundAction(this){

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Listing directory {0}", (String)"Status"), directory.getName());
            }

            public void run() {
                AttributedList children;
                if (directory.isCached()) {
                    directory.children().attributes().setReadable(true);
                }
                if ((children = directory.children()).attributes().isReadable() || !children.isEmpty()) {
                    BrowserController.this.workdir = directory;
                    BrowserController.this.addPathToHistory(BrowserController.this.workdir());
                }
            }

            public void cleanup() {
                BrowserController.this.browserSwitchClicked(Preferences.instance().getInteger("browser.view"), selected);
            }
        });
    }

    public void addPathToHistory(Path p) {
        if (this.backHistory.size() > 0 && p.equals((Object)this.backHistory.get(this.backHistory.size() - 1))) {
            return;
        }
        this.backHistory.add(p);
    }

    public Path getPreviousPath() {
        int size = this.backHistory.size();
        if (size > 1) {
            this.forwardHistory.add(this.backHistory.get(size - 1));
            Path p = this.backHistory.get(size - 2);
            this.backHistory.remove(size - 1);
            this.backHistory.remove(size - 2);
            return p;
        }
        if (1 == size) {
            this.forwardHistory.add(this.backHistory.get(size - 1));
            return this.backHistory.get(size - 1);
        }
        return null;
    }

    public Path getForwardPath() {
        int size = this.forwardHistory.size();
        if (size > 0) {
            Path p = this.forwardHistory.get(size - 1);
            this.forwardHistory.remove(size - 1);
            return p;
        }
        return null;
    }

    public List<Path> getBackHistory() {
        return this.backHistory;
    }

    public void clearBackHistory() {
        this.backHistory.clear();
    }

    public List<Path> getForwardHistory() {
        return this.forwardHistory;
    }

    public void clearForwardHistory() {
        this.forwardHistory.clear();
    }

    private Session init(final Host host) {
        if (this.hasSession()) {
            PathPasteboard.getPasteboard((Session)this.session).delete();
            this.session.removeConnectionListener(this.listener);
        }
        this.session = SessionFactory.createSession((Host)host);
        this.setWorkdir(null);
        this.setEncoding(this.session.getEncoding());
        this.session.addProgressListener(new ProgressListener(){

            public void message(final String message) {
                BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                    public void run() {
                        BrowserController.this.laststatus = message;
                        BrowserController.this.updateStatusLabel(message);
                    }
                });
            }
        });
        this.listener = new ConnectionAdapter(){

            public void connectionWillOpen() {
                BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                    public void run() {
                        BrowserController.this.bookmarkTable.setNeedsDisplay();
                        BrowserController.this.window.setTitle(host.getNickname());
                        BrowserController.this.window.setRepresentedFilename("");
                    }
                });
            }

            public void connectionDidOpen() {
                BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                    public void run() {
                        BrowserController.this.bookmarkTable.setNeedsDisplay();
                        Growl.instance().notify("Connection opened", host.getHostname());
                        BrowserController.this.window.setRepresentedFilename(HistoryCollection.defaultCollection().getFile(host).getAbsolute());
                        if (Preferences.instance().getBoolean("browser.confirmDisconnect")) {
                            BrowserController.this.window.setDocumentEdited(true);
                        }
                        BrowserController.this.securityLabel.setImage(BrowserController.this.session.isSecure() ? IconCache.iconNamed("locked.tiff") : IconCache.iconNamed("unlocked.tiff"));
                        BrowserController.this.securityLabel.setEnabled(BrowserController.this.session instanceof SSLSession);
                    }
                });
            }

            public void connectionDidClose() {
                BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                    public void run() {
                        BrowserController.this.bookmarkTable.setNeedsDisplay();
                        if (!BrowserController.this.isMounted()) {
                            BrowserController.this.window.setTitle(Preferences.instance().getProperty("application.name"));
                            BrowserController.this.window.setRepresentedFilename("");
                        }
                        BrowserController.this.window.setDocumentEdited(false);
                        BrowserController.this.securityLabel.setImage(null);
                        BrowserController.this.securityLabel.setEnabled(false);
                        BrowserController.this.updateStatusLabel();
                    }
                });
            }
        };
        this.session.addConnectionListener(this.listener);
        this.transcript.clear();
        this.backHistory.clear();
        this.forwardHistory.clear();
        this.session.addTranscriptListener(new TranscriptListener(){

            public void log(final boolean request, final String message) {
                if (BrowserController.this.logDrawer.state() == 2) {
                    BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                        public void run() {
                            BrowserController.this.transcript.log(request, message);
                        }
                    });
                }
            }
        });
        return this.session;
    }

    public void mount(final Host host) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("mount:" + host));
        }
        this.unmount(new Runnable(){

            public void run() {
                final Session session = BrowserController.this.init(host);
                BrowserController.this.background((BackgroundAction)new BrowserBackgroundAction(BrowserController.this){
                    private Path mount;

                    public void run() {
                        this.mount = session.mount();
                    }

                    public void cleanup() {
                        BrowserController.this.browserListModel.clear();
                        BrowserController.this.browserOutlineModel.clear();
                        if (session.isConnected()) {
                            BrowserController.this.setWorkdir(this.mount);
                        } else {
                            log.warn((Object)("Mount failed:" + host));
                        }
                    }

                    public String getActivity() {
                        return MessageFormat.format(Locale.localizedString((String)"Mounting {0}", (String)"Status"), host.getHostname());
                    }
                });
            }
        });
    }

    public boolean unmount() {
        return this.unmount(new Runnable(){

            public void run() {
            }
        });
    }

    public boolean unmount(final Runnable disconnected) {
        return this.unmount(new SheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    BrowserController.this.unmountImpl(disconnected);
                }
            }
        }, disconnected);
    }

    public boolean unmount(final SheetCallback callback, Runnable disconnected) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("unmount:" + this.session));
        }
        if (this.isConnected() || this.isActivityRunning()) {
            if (Preferences.instance().getBoolean("browser.confirmDisconnect")) {
                final NSAlert alert = NSAlert.alert(MessageFormat.format(Locale.localizedString((String)"Disconnect from {0}"), this.session.getHost().getHostname()), Locale.localizedString((String)"The connection will be closed."), Locale.localizedString((String)TOOLBAR_DISCONNECT), Locale.localizedString((String)"Cancel"), null);
                alert.setShowsSuppressionButton(true);
                alert.suppressionButton().setTitle(Locale.localizedString((String)"Don't ask again", (String)"Configuration"));
                this.alert(alert, new SheetCallback(){

                    public void callback(int returncode) {
                        if (alert.suppressionButton().state() == 1) {
                            Preferences.instance().setProperty("browser.confirmDisconnect", false);
                        }
                        callback.callback(returncode);
                    }
                });
                return false;
            }
            this.unmountImpl(disconnected);
            return true;
        }
        disconnected.run();
        return true;
    }

    private void unmountImpl(final Runnable disconnected) {
        if (this.isActivityRunning()) {
            this.interrupt();
        }
        final Session session = this.getSession();
        this.background((BackgroundAction)new AbstractBackgroundAction(){

            public void run() {
                session.close();
            }

            public void cleanup() {
                session.cache().clear();
                session.getHost().getCredentials().setPassword(null);
                disconnected.run();
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Disconnecting {0}", (String)"Status"), session.getHost().getHostname());
            }
        });
    }

    private void interrupt() {
        if (this.hasSession()) {
            BackgroundAction current;
            if (this.isActivityRunning() && null != (current = this.getActions().getCurrent())) {
                current.cancel();
            }
            this.background((BackgroundAction)new BrowserBackgroundAction(this){
                private final Object lock;
                {
                    this.lock = new Object();
                }

                public void run() {
                    if (BrowserController.this.hasSession()) {
                        BrowserController.this.session.interrupt();
                    }
                }

                public void cleanup() {
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Disconnecting {0}", (String)"Status"), BrowserController.this.session.getHost().getHostname());
                }

                public int retry() {
                    return 0;
                }

                public Object lock() {
                    return this.lock;
                }
            });
        }
    }

    private void disconnect() {
        this.background((BackgroundAction)new BrowserBackgroundAction(this){

            public void run() {
                BrowserController.this.session.close();
            }

            public void cleanup() {
                if (Preferences.instance().getBoolean("browser.disconnect.showBookmarks")) {
                    BrowserController.this.toggleBookmarks(true);
                }
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Disconnecting {0}", (String)"Status"), BrowserController.this.session.getHost().getHostname());
            }
        });
    }

    public void printDocument(ID sender) {
        this.print(this.getSelectedBrowserView());
    }

    public static NSUInteger applicationShouldTerminate(final NSApplication app) {
        for (final BrowserController controller : MainController.getBrowsers()) {
            if (controller.unmount(new SheetCallback(){

                public void callback(int returncode) {
                    if (returncode == 1) {
                        controller.window().close();
                        if (NSApplication.NSTerminateNow.equals((Object)BrowserController.applicationShouldTerminate(app))) {
                            app.terminate(null);
                        }
                    }
                }
            }, new Runnable(){

                public void run() {
                }
            })) continue;
            return NSApplication.NSTerminateCancel;
        }
        return NSApplication.NSTerminateNow;
    }

    @Override
    public boolean windowShouldClose(final NSWindow sender) {
        return this.unmount(new Runnable(){

            public void run() {
                sender.close();
            }
        });
    }

    public boolean validateMenuItem(NSMenuItem item) {
        Selector action = item.action();
        if (action.equals((Object)Foundation.selector("paste:"))) {
            String title = "Paste {0}";
            item.setTitle(MessageFormat.format(Locale.localizedString((String)"Paste {0}"), "").trim());
            if (this.isMounted()) {
                PathPasteboard pasteboard = PathPasteboard.getPasteboard((Session)this.getSession());
                if (pasteboard.isEmpty()) {
                    NSObject o;
                    if (NSPasteboard.generalPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null && (o = NSPasteboard.generalPasteboard().propertyListForType("NSFilenamesPboardType")) != null) {
                        NSArray elements = Rococoa.cast(o, NSArray.class);
                        if (elements.count().intValue() == 1) {
                            item.setTitle(MessageFormat.format(Locale.localizedString((String)"Paste {0}"), "\"" + elements.objectAtIndex(new NSUInteger(0L)) + "\"").trim());
                        } else {
                            item.setTitle(MessageFormat.format(Locale.localizedString((String)"Paste {0}"), MessageFormat.format(Locale.localizedString((String)"{0} Files"), String.valueOf(elements.count().intValue()))).trim());
                        }
                    }
                } else if (pasteboard.size() == 1) {
                    item.setTitle(MessageFormat.format(Locale.localizedString((String)"Paste {0}"), "\"" + ((Path)pasteboard.get(0)).getName() + "\"").trim());
                } else {
                    item.setTitle(MessageFormat.format(Locale.localizedString((String)"Paste {0}"), MessageFormat.format(Locale.localizedString((String)"{0} Files"), String.valueOf(pasteboard.size()))).trim());
                }
            }
        } else if (action.equals((Object)Foundation.selector("cut:")) || action.equals((Object)Foundation.selector("copy:"))) {
            String title = null;
            if (action.equals((Object)Foundation.selector("cut:"))) {
                title = "Cut {0}";
            } else if (action.equals((Object)Foundation.selector("copy:"))) {
                title = "Copy {0}";
            }
            if (this.isMounted()) {
                int count = this.getSelectionCount();
                if (0 == count) {
                    item.setTitle(MessageFormat.format(Locale.localizedString((String)title), "").trim());
                } else if (1 == count) {
                    item.setTitle(MessageFormat.format(Locale.localizedString((String)title), "\"" + this.getSelectedPath().getName() + "\"").trim());
                } else {
                    item.setTitle(MessageFormat.format(Locale.localizedString((String)title), MessageFormat.format(Locale.localizedString((String)"{0} Files"), String.valueOf(this.getSelectionCount()))).trim());
                }
            } else {
                item.setTitle(MessageFormat.format(Locale.localizedString((String)title), "").trim());
            }
        } else if (action.equals((Object)Foundation.selector("showHiddenFilesClicked:"))) {
            item.setState(this.getFileFilter() instanceof NullPathFilter ? 1 : 0);
        } else if (action.equals((Object)Foundation.selector("encodingMenuClicked:"))) {
            if (this.isMounted()) {
                item.setState(this.session.getEncoding().equalsIgnoreCase(item.title()) ? 1 : 0);
            } else {
                item.setState(Preferences.instance().getProperty("browser.charset.encoding").equalsIgnoreCase(item.title()) ? 1 : 0);
            }
        } else if (action.equals((Object)Foundation.selector("browserSwitchMenuClicked:"))) {
            if (item.tag() == Preferences.instance().getInteger("browser.view")) {
                item.setState(1);
            } else {
                item.setState(0);
            }
        } else if (action.equals((Object)Foundation.selector("archiveMenuClicked:"))) {
            Archive archive = Archive.forName((String)item.representedObject());
            item.setTitle(archive.getTitle(this.getSelectedPaths()));
        } else if (action.equals((Object)Foundation.selector("quicklookButtonClicked:"))) {
            item.setKeyEquivalent(" ");
            item.setKeyEquivalentModifierMask(0);
        }
        return this.validateItem(action);
    }

    private boolean validateItem(Selector action) {
        if (action.equals((Object)Foundation.selector("cut:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("copy:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("paste:"))) {
            if (this.isMounted()) {
                PathPasteboard pasteboard = PathPasteboard.getPasteboard((Session)this.getSession());
                if (pasteboard.isEmpty()) {
                    NSObject o;
                    NSPasteboard pboard = NSPasteboard.generalPasteboard();
                    return pboard.availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("encodingMenuClicked:"))) {
            return !this.isActivityRunning();
        }
        if (action.equals((Object)Foundation.selector("connectBookmarkButtonClicked:"))) {
            return this.bookmarkTable.numberOfSelectedRows().intValue() == 1;
        }
        if (action.equals((Object)Foundation.selector("addBookmarkButtonClicked:"))) {
            return this.bookmarkModel.getSource().allowsAdd();
        }
        if (action.equals((Object)Foundation.selector("deleteBookmarkButtonClicked:"))) {
            return this.bookmarkModel.getSource().allowsDelete() && this.bookmarkTable.selectedRow().intValue() != -1;
        }
        if (action.equals((Object)Foundation.selector("duplicateBookmarkButtonClicked:"))) {
            return this.bookmarkModel.getSource().allowsEdit() && this.bookmarkTable.numberOfSelectedRows().intValue() == 1;
        }
        if (action.equals((Object)Foundation.selector("editBookmarkButtonClicked:"))) {
            return this.bookmarkModel.getSource().allowsEdit() && this.bookmarkTable.numberOfSelectedRows().intValue() == 1;
        }
        if (action.equals((Object)Foundation.selector("editButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() > 0) {
                for (Path selected : this.getSelectedPaths()) {
                    if (!this.isEditable(selected)) {
                        return false;
                    }
                    if (null != EditorFactory.defaultEditor(selected.getLocal())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("editMenuClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() > 0) {
                for (Path selected : this.getSelectedPaths()) {
                    if (this.isEditable(selected)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("searchButtonClicked:"))) {
            return this.isMounted() || this.getSelectedTabView() == 0;
        }
        if (action.equals((Object)Foundation.selector("quicklookButtonClicked:"))) {
            return this.isMounted() && QuickLookFactory.instance().isAvailable() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("openBrowserButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("sendCustomCommandClicked:"))) {
            return this.isMounted() && this.getSession().isSendCommandSupported();
        }
        if (action.equals((Object)Foundation.selector("gotoButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("infoButtonClicked:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("createFolderButtonClicked:"))) {
            return this.isMounted() && this.getSession().isCreateFolderSupported(this.workdir());
        }
        if (action.equals((Object)Foundation.selector("createFileButtonClicked:"))) {
            return this.isMounted() && this.getSession().isCreateFileSupported(this.workdir());
        }
        if (action.equals((Object)Foundation.selector("createSymlinkButtonClicked:"))) {
            return this.isMounted() && this.getSession().isCreateSymlinkSupported() && this.getSelectionCount() == 1;
        }
        if (action.equals((Object)Foundation.selector("duplicateFileButtonClicked:"))) {
            return this.isMounted() && this.getSelectionCount() == 1;
        }
        if (action.equals((Object)Foundation.selector("renameFileButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() == 1) {
                Path selected = this.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return this.getSession().isRenameSupported(selected);
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("deleteFileButtonClicked:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("revertFileButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() == 1) {
                return this.getSession().isRevertSupported();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("reloadButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("newBrowserButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("uploadButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("syncButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("downloadAsButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() == 1) {
                Path selected = this.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return !selected.attributes().isVolume();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("downloadToButtonClicked:")) || action.equals((Object)Foundation.selector("downloadButtonClicked:"))) {
            if (this.isMounted() && this.getSelectionCount() > 0) {
                Path selected = this.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return !selected.attributes().isVolume();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("insideButtonClicked:"))) {
            return this.isMounted() && this.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector("upButtonClicked:"))) {
            return this.isMounted() && !this.workdir().isRoot();
        }
        if (action.equals((Object)Foundation.selector("backButtonClicked:"))) {
            return this.isMounted() && this.getBackHistory().size() > 1;
        }
        if (action.equals((Object)Foundation.selector("forwardButtonClicked:"))) {
            return this.isMounted() && this.getForwardHistory().size() > 0;
        }
        if (action.equals((Object)Foundation.selector("printDocument:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("disconnectButtonClicked:"))) {
            if (!this.isConnected()) {
                return this.isActivityRunning();
            }
            return this.isConnected();
        }
        if (action.equals((Object)Foundation.selector("interruptButtonClicked:"))) {
            return this.isActivityRunning();
        }
        if (action.equals((Object)Foundation.selector("gotofolderButtonClicked:"))) {
            return this.isMounted();
        }
        if (action.equals((Object)Foundation.selector("openTerminalButtonClicked:"))) {
            return this.isMounted() && this.getSession() instanceof SFTPSession;
        }
        if (action.equals((Object)Foundation.selector("archiveButtonClicked:")) || action.equals((Object)Foundation.selector("archiveMenuClicked:"))) {
            if (this.isMounted()) {
                if (!this.getSession().isArchiveSupported()) {
                    return false;
                }
                if (this.getSelectionCount() > 0) {
                    for (Path selected : this.getSelectedPaths()) {
                        if (!selected.attributes().isFile() || !Archive.isArchive((String)selected.getName())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector("unarchiveButtonClicked:"))) {
            if (this.isMounted()) {
                if (!this.getSession().isUnarchiveSupported()) {
                    return false;
                }
                if (this.getSelectionCount() > 0) {
                    for (Path selected : this.getSelectedPaths()) {
                        if (selected.attributes().isDirectory()) {
                            return false;
                        }
                        if (Archive.isArchive((String)selected.getName())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateToolbarItem(NSToolbarItem item) {
        String identifier = item.itemIdentifier();
        if (identifier.equals(TOOLBAR_EDIT)) {
            String editor = null;
            Path selected = this.getSelectedPath();
            if (null != selected && this.isEditable(selected)) {
                editor = EditorFactory.defaultEditor(selected.getLocal());
            }
            if (null == editor) {
                item.setImage(IconCache.iconNamed("pencil.tiff"));
            } else {
                item.setImage(IconCache.instance().iconForApplication(editor, 32));
            }
        } else if (identifier.equals(TOOLBAR_DISCONNECT)) {
            if (this.isActivityRunning()) {
                item.setLabel(Locale.localizedString((String)"Stop"));
                item.setPaletteLabel(Locale.localizedString((String)"Stop"));
                item.setToolTip(Locale.localizedString((String)"Cancel current operation in progress"));
                item.setImage(IconCache.iconNamed("stop", 32));
            } else {
                item.setLabel(Locale.localizedString((String)TOOLBAR_DISCONNECT));
                item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_DISCONNECT));
                item.setToolTip(Locale.localizedString((String)"Disconnect from server"));
                item.setImage(IconCache.iconNamed("eject.tiff"));
            }
        } else if (identifier.equals(TOOLBAR_ARCHIVE)) {
            Path selected = this.getSelectedPath();
            if (null != selected) {
                if (Archive.isArchive((String)selected.getName())) {
                    item.setLabel(Locale.localizedString((String)"Unarchive", (String)TOOLBAR_ARCHIVE));
                    item.setPaletteLabel(Locale.localizedString((String)"Unarchive"));
                    item.setAction(Foundation.selector("unarchiveButtonClicked:"));
                } else {
                    item.setLabel(Locale.localizedString((String)TOOLBAR_ARCHIVE, (String)TOOLBAR_ARCHIVE));
                    item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_ARCHIVE));
                    item.setAction(Foundation.selector("archiveButtonClicked:"));
                }
            }
        } else if (identifier.equals(TOOLBAR_QUICKLOOK)) {
            // empty if block
        }
        return this.validateItem(item.action());
    }

    @Override
    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String itemIdentifier, boolean inserted) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar:" + itemIdentifier));
        }
        if (!this.toolbarItems.containsKey(itemIdentifier)) {
            this.toolbarItems.put(itemIdentifier, NSToolbarItem.itemWithIdentifier(itemIdentifier));
        }
        NSToolbarItem item = this.toolbarItems.get(itemIdentifier);
        if (itemIdentifier.equals(TOOLBAR_BROWSER_VIEW)) {
            item.setLabel(Locale.localizedString((String)"View"));
            item.setPaletteLabel(Locale.localizedString((String)"View"));
            item.setToolTip(Locale.localizedString((String)"Switch Browser View"));
            item.setView(this.browserSwitchView);
            NSMenuItem viewMenu = NSMenuItem.itemWithTitle(Locale.localizedString((String)"View"), null, "");
            NSMenu viewSubmenu = NSMenu.menu();
            viewSubmenu.addItemWithTitle_action_keyEquivalent(Locale.localizedString((String)"List"), Foundation.selector("browserSwitchMenuClicked:"), "");
            viewSubmenu.itemWithTitle(Locale.localizedString((String)"List")).setTag(0);
            viewSubmenu.addItemWithTitle_action_keyEquivalent(Locale.localizedString((String)"Outline"), Foundation.selector("browserSwitchMenuClicked:"), "");
            viewSubmenu.itemWithTitle(Locale.localizedString((String)"Outline")).setTag(1);
            viewMenu.setSubmenu(viewSubmenu);
            item.setMenuFormRepresentation(viewMenu);
            item.setMinSize(this.browserSwitchView.frame().size);
            item.setMaxSize(this.browserSwitchView.frame().size);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_NEW_CONNECTION)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_NEW_CONNECTION));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_NEW_CONNECTION));
            item.setToolTip(Locale.localizedString((String)"Connect to server"));
            item.setImage(IconCache.iconNamed("connect.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("connectButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_TRANSFERS)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_TRANSFERS));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_TRANSFERS));
            item.setToolTip(Locale.localizedString((String)"Show Transfers window"));
            item.setImage(IconCache.iconNamed("queue.tiff"));
            item.setAction(Foundation.selector("showTransferQueueClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_TOOLS)) {
            NSMenu toolSubmenu;
            NSMenuItem toolMenu;
            item.setLabel(Locale.localizedString((String)"Action"));
            item.setPaletteLabel(Locale.localizedString((String)"Action"));
            if (inserted || !Factory.VERSION_PLATFORM.matches("10\\.5.*")) {
                item.setView(this.actionPopupButton);
                toolMenu = NSMenuItem.itemWithTitle(Locale.localizedString((String)"Action"), null, "");
                toolSubmenu = NSMenu.menu();
                for (int i = 1; i < this.actionPopupButton.menu().numberOfItems().intValue(); ++i) {
                    NSMenuItem template = this.actionPopupButton.menu().itemAtIndex(new NSInteger(i));
                    toolSubmenu.addItem(NSMenuItem.itemWithTitle(template.title(), template.action(), template.keyEquivalent()));
                }
            } else {
                NSToolbarItem temporary = NSToolbarItem.itemWithIdentifier(itemIdentifier);
                temporary.setPaletteLabel(Locale.localizedString((String)"Action"));
                temporary.setImage(IconCache.iconNamed("advanced.tiff", 32));
                return temporary;
            }
            toolMenu.setSubmenu(toolSubmenu);
            item.setMenuFormRepresentation(toolMenu);
            item.setMinSize(this.actionPopupButton.frame().size);
            item.setMaxSize(this.actionPopupButton.frame().size);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_QUICK_CONNECT)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_QUICK_CONNECT));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_QUICK_CONNECT));
            item.setToolTip(Locale.localizedString((String)"Connect to server"));
            item.setView(this.quickConnectPopup);
            item.setMinSize(this.quickConnectPopup.frame().size);
            item.setMaxSize(this.quickConnectPopup.frame().size);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_ENCODING)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_ENCODING));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_ENCODING));
            item.setToolTip(Locale.localizedString((String)"Character Encoding"));
            item.setView(this.encodingPopup);
            NSMenuItem encodingMenu = NSMenuItem.itemWithTitle(Locale.localizedString((String)TOOLBAR_ENCODING), Foundation.selector("encodingMenuClicked:"), "");
            String[] charsets = MainController.availableCharsets();
            NSMenu charsetMenu = NSMenu.menu();
            for (String charset : charsets) {
                charsetMenu.addItemWithTitle_action_keyEquivalent(charset, Foundation.selector("encodingMenuClicked:"), "");
            }
            encodingMenu.setSubmenu(charsetMenu);
            item.setMenuFormRepresentation(encodingMenu);
            item.setMinSize(this.encodingPopup.frame().size);
            item.setMaxSize(this.encodingPopup.frame().size);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_REFRESH)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_REFRESH));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_REFRESH));
            item.setToolTip(Locale.localizedString((String)"Refresh directory listing"));
            item.setImage(IconCache.iconNamed("refresh.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("reloadButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_DOWNLOAD)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_DOWNLOAD));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_DOWNLOAD));
            item.setToolTip(Locale.localizedString((String)"Download file"));
            item.setImage(IconCache.iconNamed("download.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("downloadButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_UPLOAD)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_UPLOAD));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_UPLOAD));
            item.setToolTip(Locale.localizedString((String)"Upload local file to the remote host"));
            item.setImage(IconCache.iconNamed("upload.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("uploadButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_SYNCHRONIZE)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_SYNCHRONIZE));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_SYNCHRONIZE));
            item.setToolTip(Locale.localizedString((String)"Synchronize files"));
            item.setImage(IconCache.iconNamed("sync.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("syncButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_GET_INFO)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_GET_INFO));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_GET_INFO));
            item.setToolTip(Locale.localizedString((String)"Show file attributes"));
            item.setImage(IconCache.iconNamed("info.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("infoButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_WEBVIEW)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_WEBVIEW));
            item.setPaletteLabel(Locale.localizedString((String)"Open in Web Browser"));
            item.setToolTip(Locale.localizedString((String)"Open in Web Browser"));
            String browser = URLSchemeHandlerConfiguration.instance().getDefaultHandlerForURLScheme("http");
            if (null == browser) {
                item.setEnabled(false);
                item.setImage(IconCache.iconNamed("notfound.tiff"));
            } else {
                item.setImage(IconCache.instance().iconForApplication(browser, 32));
            }
            item.setTarget(this.id());
            item.setAction(Foundation.selector("openBrowserButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_EDIT)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_EDIT));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_EDIT));
            item.setToolTip(Locale.localizedString((String)"Edit file in external editor"));
            item.setImage(IconCache.iconNamed("pencil.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("editButtonClicked:"));
            NSMenuItem toolbarMenu = NSMenuItem.itemWithTitle(Locale.localizedString((String)TOOLBAR_EDIT), Foundation.selector("editButtonClicked:"), "");
            NSMenu editMenu = NSMenu.menu();
            editMenu.setAutoenablesItems(true);
            editMenu.setDelegate(this.editMenuDelegate.id());
            toolbarMenu.setSubmenu(editMenu);
            item.setMenuFormRepresentation(toolbarMenu);
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_DELETE)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_DELETE));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_DELETE));
            item.setToolTip(Locale.localizedString((String)"Delete file"));
            item.setImage(IconCache.iconNamed("delete.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("deleteFileButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_NEW_FOLDER)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_NEW_FOLDER));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_NEW_FOLDER));
            item.setToolTip(Locale.localizedString((String)"Create New Folder"));
            item.setImage(IconCache.iconNamed("newfolder.tiff", 32));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("createFolderButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_NEW_BOOKMARK)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_NEW_BOOKMARK));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_NEW_BOOKMARK));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_NEW_BOOKMARK));
            item.setImage(IconCache.iconNamed("bookmark", 32));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("addBookmarkButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_DISCONNECT)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_DISCONNECT));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_DISCONNECT));
            item.setToolTip(Locale.localizedString((String)"Disconnect from server"));
            item.setImage(IconCache.iconNamed("eject.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("disconnectButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_TERMINAL)) {
            String app = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(Preferences.instance().getProperty("terminal.bundle.identifier"));
            if (StringUtils.isEmpty((String)app)) {
                log.error((Object)("Application with bundle identifier " + Preferences.instance().getProperty("terminal.bundle.identifier") + " is not installed"));
            } else {
                Local terminal = LocalFactory.createLocal((String)app);
                item.setLabel(terminal.getDisplayName());
                item.setPaletteLabel(terminal.getDisplayName());
                item.setImage(IconCache.instance().iconForPath(terminal, (Integer)128));
            }
            item.setTarget(this.id());
            item.setAction(Foundation.selector("openTerminalButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_ARCHIVE)) {
            String t = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier("com.apple.archiveutility");
            item.setLabel(Locale.localizedString((String)TOOLBAR_ARCHIVE, (String)TOOLBAR_ARCHIVE));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_ARCHIVE, (String)TOOLBAR_ARCHIVE));
            item.setImage(IconCache.instance().iconForPath(LocalFactory.createLocal((String)t), (Integer)128));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("archiveButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_QUICKLOOK)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_QUICKLOOK));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_QUICKLOOK));
            if (QuickLookFactory.instance().isAvailable()) {
                this.quicklookButton = NSButton.buttonWithFrame(new NSRect(29.0, 23.0));
                this.quicklookButton.setBezelStyle(11);
                this.quicklookButton.setImage(IconCache.iconNamed("NSQuickLookTemplate"));
                this.quicklookButton.sizeToFit();
                this.quicklookButton.setTarget(this.id());
                this.quicklookButton.setAction(Foundation.selector("quicklookButtonClicked:"));
                item.setView(this.quicklookButton);
                item.setMinSize(this.quicklookButton.frame().size);
                item.setMaxSize(this.quicklookButton.frame().size);
            } else {
                item.setEnabled(false);
                item.setImage(IconCache.iconNamed("notfound.tiff"));
            }
            return item;
        }
        return null;
    }

    @Override
    public NSArray toolbarDefaultItemIdentifiers(NSToolbar toolbar) {
        return NSArray.arrayWithObjects(TOOLBAR_NEW_CONNECTION, "NSToolbarSeparatorItem", TOOLBAR_QUICK_CONNECT, TOOLBAR_TOOLS, "NSToolbarSeparatorItem", TOOLBAR_REFRESH, TOOLBAR_EDIT, "NSToolbarFlexibleSpaceItem", TOOLBAR_DISCONNECT);
    }

    @Override
    public NSArray toolbarAllowedItemIdentifiers(NSToolbar toolbar) {
        return NSArray.arrayWithObjects(TOOLBAR_NEW_CONNECTION, TOOLBAR_BROWSER_VIEW, TOOLBAR_TRANSFERS, TOOLBAR_QUICK_CONNECT, TOOLBAR_TOOLS, TOOLBAR_REFRESH, TOOLBAR_ENCODING, TOOLBAR_SYNCHRONIZE, TOOLBAR_DOWNLOAD, TOOLBAR_UPLOAD, TOOLBAR_EDIT, TOOLBAR_DELETE, TOOLBAR_NEW_FOLDER, TOOLBAR_NEW_BOOKMARK, TOOLBAR_GET_INFO, TOOLBAR_WEBVIEW, TOOLBAR_TERMINAL, TOOLBAR_ARCHIVE, TOOLBAR_QUICKLOOK, TOOLBAR_DISCONNECT, "NSToolbarCustomizeToolbarItem", "NSToolbarSpaceItem", "NSToolbarSeparatorItem", "NSToolbarFlexibleSpaceItem");
    }

    @Override
    public NSArray toolbarSelectableItemIdentifiers(NSToolbar toolbar) {
        return NSArray.array();
    }

    @Override
    protected void invalidate() {
        if (this.hasSession()) {
            this.session.removeConnectionListener(this.listener);
        }
        this.bookmarkTable.setDelegate(null);
        this.bookmarkTable.setDataSource(null);
        this.bookmarkModel.invalidate();
        this.browserListView.setDelegate(null);
        this.browserListView.setDataSource(null);
        this.browserListModel.invalidate();
        this.browserOutlineView.setDelegate(null);
        this.browserOutlineView.setDataSource(null);
        this.browserOutlineModel.invalidate();
        this.toolbar.setDelegate(null);
        this.toolbarItems.clear();
        this.browserListColumnsFactory.clear();
        this.browserOutlineColumnsFactory.clear();
        this.bookmarkTableColumnFactory.clear();
        this.quickConnectPopup.setDelegate(null);
        this.quickConnectPopup.setDataSource(null);
        this.archiveMenu.setDelegate(null);
        this.editMenu.setDelegate(null);
        super.invalidate();
    }

    private static class QuickConnectModel
    extends ProxyController
    implements NSComboBox.DataSource {
        private QuickConnectModel() {
        }

        public NSInteger numberOfItemsInComboBox(NSComboBox combo) {
            return new NSInteger(BookmarkCollection.defaultCollection().size());
        }

        public NSObject comboBox_objectValueForItemAtIndex(NSComboBox sender, NSInteger row) {
            return NSString.stringWithString(BookmarkCollection.defaultCollection().get(row.intValue()).getNickname());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        private TableColumnFactory() {
        }

        private NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractBrowserTableDelegate<E>
    extends AbstractPathTableDelegate {
        public AbstractBrowserTableDelegate() {
            BrowserController.this.addListener(new WindowListener(){

                public void windowWillClose() {
                    if (QuickLookFactory.instance().isAvailable() && QuickLookFactory.instance().isOpen()) {
                        QuickLookFactory.instance().close();
                    }
                }
            });
        }

        @Override
        public boolean isColumnRowEditable(NSTableColumn column, int row) {
            if (Preferences.instance().getBoolean("browser.editable")) {
                return column.identifier().equals("FILENAME");
            }
            return false;
        }

        @Override
        public void tableRowDoubleClicked(ID sender) {
            BrowserController.this.insideButtonClicked(sender);
        }

        public void spaceKeyPressed(ID sender) {
            if (QuickLookFactory.instance().isAvailable()) {
                if (QuickLookFactory.instance().isOpen()) {
                    QuickLookFactory.instance().close();
                } else {
                    this.updateQuickLookSelection(BrowserController.this.getSelectedPaths());
                }
            }
        }

        private void updateQuickLookSelection(List<Path> selected) {
            if (QuickLookFactory.instance().isAvailable()) {
                final ch.cyberduck.core.Collection downloads = new ch.cyberduck.core.Collection();
                for (Path path : selected) {
                    if (!path.attributes().isFile()) continue;
                    Local folder = LocalFactory.createLocal((File)new File(Preferences.instance().getProperty("tmp.dir"), path.getParent().getAbsolute()));
                    path.setLocal(LocalFactory.createLocal((Local)folder, (String)path.getName()));
                    downloads.add((Object)path);
                }
                if (downloads.size() > 0) {
                    this.background((BackgroundAction)new BrowserBackgroundAction(BrowserController.this){
                        final ch.cyberduck.core.Collection<Local> previews;
                        {
                            super(x0);
                            this.previews = new ch.cyberduck.core.Collection<Local>(){

                                public void collectionItemRemoved(Local o) {
                                    super.collectionItemRemoved((Object)o);
                                    o.delete(false);
                                }
                            };
                        }

                        public void run() {
                            DownloadTransfer transfer = new DownloadTransfer((List)downloads);
                            TransferOptions options = new TransferOptions();
                            options.closeSession = false;
                            transfer.start(new TransferPrompt(){

                                public TransferAction prompt() {
                                    return TransferAction.ACTION_RESUME;
                                }
                            }, options);
                            for (Path download : downloads) {
                                if (!download.getLocal().exists()) continue;
                                if (download.status().isComplete()) {
                                    this.previews.add((Object)download.getLocal());
                                    continue;
                                }
                                download.getLocal().delete(false);
                            }
                        }

                        public void cleanup() {
                            if (this.previews.isEmpty()) {
                                return;
                            }
                            if (this.isCanceled()) {
                                return;
                            }
                            QuickLookFactory.instance().select(this.previews);
                            QuickLookFactory.instance().open();
                            BrowserController.this.updateStatusLabel();
                            BrowserController.this.window().makeKeyWindow();
                        }

                        public String getActivity() {
                            return Locale.localizedString((String)BrowserController.TOOLBAR_QUICKLOOK, (String)"Status");
                        }
                    });
                }
            }
        }

        @Override
        public void deleteKeyPressed(ID sender) {
            BrowserController.this.deleteFileButtonClicked(sender);
        }

        @Override
        public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            List<Path> selected = BrowserController.this.getSelectedPaths();
            if (this.selectedColumnIdentifier().equals(tableColumn.identifier())) {
                this.setSortedAscending(!this.isSortedAscending());
            } else {
                this.setBrowserColumnSortingIndicator(null, this.selectedColumnIdentifier());
                this.setSelectedColumn(tableColumn);
            }
            this.setBrowserColumnSortingIndicator(this.isSortedAscending() ? IconCache.iconNamed("NSAscendingSortIndicator") : IconCache.iconNamed("NSDescendingSortIndicator"), tableColumn.identifier());
            BrowserController.this.reloadData(selected);
        }

        @Override
        public void selectionDidChange(NSNotification notification) {
            Path file;
            ArrayList<Path> selected = new ArrayList<Path>();
            NSIndexSet iterator = BrowserController.this.getSelectedBrowserView().selectedRowIndexes();
            NSUInteger index = iterator.firstIndex();
            while (!index.equals((Object)NSIndexSet.NSNotFound) && null != (file = this.pathAtRow(index.intValue()))) {
                selected.add(file);
                index = iterator.indexGreaterThanIndex(index);
            }
            BrowserController.this.setSelectedPaths(selected);
            if (QuickLookFactory.instance().isOpen()) {
                this.updateQuickLookSelection(BrowserController.this.selected);
            }
            if (Preferences.instance().getBoolean("browser.info.isInspector")) {
                InfoController c = InfoController.Factory.get(BrowserController.this);
                if (null == c) {
                    return;
                }
                c.setFiles(BrowserController.this.selected);
            }
        }

        protected abstract Path pathAtRow(int var1);

        protected abstract void setBrowserColumnSortingIndicator(NSImage var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractBrowserListViewDelegate<E>
    extends AbstractBrowserTableDelegate<E>
    implements NSTableView.Delegate {
        private AbstractBrowserListViewDelegate() {
        }

        public String tableView_toolTipForCell_rect_tableColumn_row_mouseLocation(NSTableView t, NSCell cell, ID rect, NSTableColumn c, NSInteger row, NSPoint mouseLocation) {
            return this.tooltip((Path)BrowserController.this.browserListModel.children(BrowserController.this.workdir()).get(row.intValue()));
        }

        @Override
        protected void setBrowserColumnSortingIndicator(NSImage image, String columnIdentifier) {
            BrowserController.this.browserListView.setIndicatorImage_inTableColumn(image, BrowserController.this.browserListView.tableColumnWithIdentifier(columnIdentifier));
        }

        @Override
        protected Path pathAtRow(int row) {
            AttributedList<Path> children = BrowserController.this.browserListModel.children(BrowserController.this.workdir());
            if (row < children.size()) {
                return (Path)children.get(row);
            }
            log.warn((Object)("No item at row:" + row));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractBrowserOutlineViewDelegate<E>
    extends AbstractBrowserTableDelegate<E>
    implements NSOutlineView.Delegate {
        private AbstractBrowserOutlineViewDelegate() {
        }

        public String outlineView_toolTipForCell_rect_tableColumn_item_mouseLocation(NSOutlineView t, NSCell cell, ID rect, NSTableColumn c, NSObject item, NSPoint mouseLocation) {
            return this.tooltip(BrowserController.this.lookup(new OutlinePathReference(item)));
        }

        @Override
        protected void setBrowserColumnSortingIndicator(NSImage image, String columnIdentifier) {
            BrowserController.this.browserOutlineView.setIndicatorImage_inTableColumn(image, BrowserController.this.browserOutlineView.tableColumnWithIdentifier(columnIdentifier));
        }

        @Override
        protected Path pathAtRow(int row) {
            if (row < BrowserController.this.browserOutlineView.numberOfRows().intValue()) {
                return BrowserController.this.lookup(new OutlinePathReference(BrowserController.this.browserOutlineView.itemAtRow(new NSInteger(row))));
            }
            log.warn((Object)("No item at row:" + row));
            return null;
        }
    }
}

