/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.BrowserTableDataSource;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class BrowserListViewModel
extends BrowserTableDataSource
implements NSTableView.DataSource {
    public BrowserListViewModel(BrowserController controller) {
        super(controller);
    }

    public NSInteger numberOfRowsInTableView(NSTableView view) {
        if (this.controller.isMounted()) {
            return new NSInteger(this.children(this.controller.workdir()).size());
        }
        return new NSInteger(0L);
    }

    public void tableView_setObjectValue_forTableColumn_row(NSTableView view, NSObject value, NSTableColumn tableColumn, NSInteger row) {
        super.setObjectValueForItem((Path)this.children(this.controller.workdir()).get(row.intValue()), value, tableColumn.identifier());
    }

    public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
        if (this.controller.isMounted()) {
            AttributedList<Path> children = this.children(this.controller.workdir());
            if (row.intValue() < children.size()) {
                return super.objectValueForItem((Path)children.get(row.intValue()), tableColumn.identifier());
            }
        }
        return null;
    }

    public NSUInteger tableView_validateDrop_proposedRow_proposedDropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        if (this.controller.isMounted()) {
            Path destination = this.controller.workdir();
            if (row.intValue() < this.numberOfRowsInTableView(view).intValue()) {
                Path p;
                int draggingColumn = view.columnAtPoint(draggingInfo.draggingLocation()).intValue();
                if ((-1 == draggingColumn || 0 == draggingColumn || 1 == draggingColumn) && row.intValue() != -1 && (p = (Path)this.children(this.controller.workdir()).get(row.intValue())).attributes().isDirectory()) {
                    destination = p;
                }
                return super.validateDrop(view, destination, row, draggingInfo);
            }
            return super.validateDrop(view, destination, row, draggingInfo);
        }
        return super.validateDrop(view, null, row, draggingInfo);
    }

    public boolean tableView_acceptDrop_row_dropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        if (this.controller.isMounted()) {
            Path destination = this.controller.workdir();
            if (row.intValue() != -1) {
                destination = (Path)this.children(this.controller.workdir()).get(row.intValue());
            }
            return super.acceptDrop(view, destination, draggingInfo);
        }
        return super.acceptDrop(view, null, draggingInfo);
    }

    public boolean tableView_writeRowsWithIndexes_toPasteboard(NSTableView view, NSIndexSet rowIndexes, NSPasteboard pboard) {
        if (this.controller.isMounted()) {
            NSMutableArray items = NSMutableArray.array();
            AttributedList<Path> children = this.children(this.controller.workdir());
            NSUInteger index = rowIndexes.firstIndex();
            while (!index.equals((Object)NSIndexSet.NSNotFound)) {
                items.addObject(NSString.stringWithString(((Path)children.get(index.intValue())).getAbsolute()));
                index = rowIndexes.indexGreaterThanIndex(index);
            }
            return super.writeItemsToPasteBoard(view, items, pboard);
        }
        return false;
    }

    public NSArray tableView_namesOfPromisedFilesDroppedAtDestination_forDraggedRowsWithIndexes(NSTableView view, NSURL dropDestination, NSIndexSet rowIndexes) {
        return this.namesOfPromisedFilesDroppedAtDestination(dropDestination);
    }
}

