/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.ui.PathPasteboard;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.BrowserTableDataSource;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSOutlineView;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.model.OutlinePathReference;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserOutlineViewModel
extends BrowserTableDataSource
implements NSOutlineView.DataSource {
    protected static Logger log = Logger.getLogger(BrowserOutlineViewModel.class);

    public BrowserOutlineViewModel(BrowserController controller) {
        super(controller);
    }

    @Override
    public int indexOf(NSTableView view, PathReference reference) {
        return ((NSOutlineView)view).rowForItem(((OutlinePathReference)reference).unique()).intValue();
    }

    protected AttributedList<Path> children(OutlinePathReference path) {
        Path lookup = this.controller.lookup(path);
        if (null == lookup) {
            return AttributedList.emptyList();
        }
        return super.children(lookup);
    }

    @Override
    public boolean outlineView_isItemExpandable(NSOutlineView view, NSObject item) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("outlineViewIsItemExpandable:" + item));
        }
        if (null == item) {
            return false;
        }
        Path path = this.controller.lookup(new OutlinePathReference(item));
        if (null == path) {
            return false;
        }
        return path.attributes().isDirectory();
    }

    @Override
    public NSInteger outlineView_numberOfChildrenOfItem(NSOutlineView view, NSObject item) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("outlineView_numberOfChildrenOfItem:" + item));
        }
        if (this.controller.isMounted()) {
            if (null == item) {
                return new NSInteger(this.children(this.controller.workdir()).size());
            }
            NSEvent event = NSApplication.sharedApplication().currentEvent();
            if (event != null) {
                log.debug((Object)("Event:" + event.type()));
                if (6 == event.type()) {
                    int draggingColumn = view.columnAtPoint(view.convertPoint_fromView(event.locationInWindow(), null)).intValue();
                    if (draggingColumn != 0) {
                        log.debug((Object)("Returning 0 to #outlineViewNumberOfChildrenOfItem for column:" + draggingColumn));
                        return new NSInteger(0L);
                    }
                    if (!Preferences.instance().getBoolean("browser.view.autoexpand")) {
                        log.debug((Object)"Returning 0 to #outlineViewNumberOfChildrenOfItem while dragging because browser.view.autoexpand == false");
                        return new NSInteger(0L);
                    }
                }
            }
            return new NSInteger(this.children(new OutlinePathReference(item)).size());
        }
        return new NSInteger(0L);
    }

    @Override
    public NSObject outlineView_child_ofItem(NSOutlineView outlineView, NSInteger index, NSObject item) {
        Path path;
        if (log.isDebugEnabled()) {
            log.debug((Object)("outlineView_child_ofItem:" + item));
        }
        if (null == (path = null == item ? this.controller.workdir() : this.controller.lookup(new OutlinePathReference(item)))) {
            return null;
        }
        AttributedList<Path> children = this.children(path);
        if (index.intValue() >= children.size()) {
            log.warn((Object)("Index " + (Object)((Object)index) + " out of bound for " + item));
            return null;
        }
        return (NSObject)((Path)children.get(index.intValue())).getReference().unique();
    }

    @Override
    public void outlineView_setObjectValue_forTableColumn_byItem(NSOutlineView outlineView, NSObject value, NSTableColumn tableColumn, NSObject item) {
        super.setObjectValueForItem(this.controller.lookup(new OutlinePathReference(item)), value, tableColumn.identifier());
    }

    @Override
    public NSObject outlineView_objectValueForTableColumn_byItem(NSOutlineView view, NSTableColumn tableColumn, NSObject item) {
        if (null == item) {
            return null;
        }
        return super.objectValueForItem(this.controller.lookup(new OutlinePathReference(item)), tableColumn.identifier());
    }

    @Override
    public NSUInteger outlineView_validateDrop_proposedItem_proposedChildIndex(NSOutlineView view, NSDraggingInfo draggingInfo, NSObject item, NSInteger row) {
        if (this.controller.isMounted()) {
            Path destination = null;
            if (null != item) {
                destination = this.controller.lookup(new OutlinePathReference(item));
            }
            if (null == destination) {
                view.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
                return super.validateDrop(view, this.controller.workdir(), row, draggingInfo);
            }
            int draggingColumn = view.columnAtPoint(draggingInfo.draggingLocation()).intValue();
            if ((-1 == draggingColumn || 0 == draggingColumn) && destination.attributes().isDirectory()) {
                view.setDropItem((NSObject)destination.getReference().unique(), NSOutlineView.NSOutlineViewDropOnItemIndex);
                return super.validateDrop(view, destination, row, draggingInfo);
            }
            for (Path next : PathPasteboard.getPasteboard((Session)this.controller.getSession())) {
                if (!destination.equals((Object)next)) continue;
                return NSDraggingInfo.NSDragOperationNone;
            }
            view.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
            return super.validateDrop(view, this.controller.workdir(), row, draggingInfo);
        }
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null) {
            view.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
        }
        return super.validateDrop(view, null, row, draggingInfo);
    }

    @Override
    public boolean outlineView_acceptDrop_item_childIndex(NSOutlineView outlineView, NSDraggingInfo info, NSObject item, NSInteger row) {
        Path destination = null;
        if (this.controller.isMounted()) {
            destination = null == item ? this.controller.workdir() : this.controller.lookup(new OutlinePathReference(item));
        }
        return super.acceptDrop(outlineView, destination, info);
    }

    @Override
    public NSArray outlineView_namesOfPromisedFilesDroppedAtDestination_forDraggedItems(NSURL dropDestination, NSArray items) {
        return this.namesOfPromisedFilesDroppedAtDestination(dropDestination);
    }

    @Override
    public boolean outlineView_writeItems_toPasteboard(NSOutlineView outlineView, NSArray items, NSPasteboard pboard) {
        return super.writeItemsToPasteBoard(outlineView, items, pboard);
    }
}

