/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.UploadTransfer;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.PathPasteboard;
import ch.cyberduck.ui.cocoa.AttributeCache;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSDraggingInfo;
import ch.cyberduck.ui.cocoa.application.NSDraggingSource;
import ch.cyberduck.ui.cocoa.application.NSEvent;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSPasteboard;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.model.OutlinePathReference;
import ch.cyberduck.ui.cocoa.odb.WatchEditor;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrowserTableDataSource
extends ProxyController
implements NSDraggingSource {
    protected static Logger log = Logger.getLogger(BrowserTableDataSource.class);
    public static final String ICON_COLUMN = "ICON";
    public static final String FILENAME_COLUMN = "FILENAME";
    public static final String SIZE_COLUMN = "SIZE";
    public static final String MODIFIED_COLUMN = "MODIFIED";
    public static final String OWNER_COLUMN = "OWNER";
    public static final String GROUP_COLUMN = "GROUP";
    public static final String PERMISSIONS_COLUMN = "PERMISSIONS";
    public static final String KIND_COLUMN = "KIND";
    public static final String EXTENSION_COLUMN = "EXTENSION";
    protected static final String LOCAL_COLUMN = "LOCAL";
    protected final List<Path> isLoadingListingInBackground = new Collection();
    protected BrowserController controller;
    private AttributeCache<Path> tableViewCache = new AttributeCache(Preferences.instance().getInteger("browser.model.cache.size"));

    public BrowserTableDataSource(BrowserController controller) {
        this.controller = controller;
    }

    protected void clear() {
        this.tableViewCache.clear();
    }

    @Override
    protected void invalidate() {
        this.clear();
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributedList<Path> children(final Path path) {
        List<Path> list = this.isLoadingListingInBackground;
        synchronized (list) {
            if (!this.isLoadingListingInBackground.contains(path)) {
                if (path.isCached()) {
                    return path.cache().get(path.getReference(), this.controller.getComparator(), this.controller.getFileFilter());
                }
                this.isLoadingListingInBackground.add(path);
                this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                    public void run() {
                        path.children();
                    }

                    public String getActivity() {
                        return MessageFormat.format(Locale.localizedString((String)"Listing directory {0}", (String)"Status"), path.getName());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void cleanup() {
                        List<Path> list = BrowserTableDataSource.this.isLoadingListingInBackground;
                        synchronized (list) {
                            BrowserTableDataSource.this.isLoadingListingInBackground.remove(path);
                            if (BrowserTableDataSource.this.isLoadingListingInBackground.isEmpty()) {
                                BrowserTableDataSource.this.tableViewCache.clear();
                                BrowserTableDataSource.this.controller.reloadData(true);
                            }
                        }
                        super.cleanup();
                    }
                });
            }
            return path.cache().get(path.getReference(), this.controller.getComparator(), this.controller.getFileFilter());
        }
    }

    public int indexOf(NSTableView view, PathReference reference) {
        return this.children(this.controller.workdir()).indexOf(reference);
    }

    protected void setObjectValueForItem(Path item, NSObject value, String identifier) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setObjectValueForItem:" + item.getAbsolute()));
        }
        if (identifier.equals(FILENAME_COLUMN) && StringUtils.isNotBlank((String)value.toString()) && !item.getName().equals(value.toString())) {
            Path renamed = PathFactory.createPath((Session)this.controller.getSession(), (String)item.getParent().getAbsolute(), (String)value.toString(), (int)item.attributes().getType());
            this.controller.renamePath(item, renamed);
        }
    }

    protected NSImage iconForPath(Path item) {
        return IconCache.instance().iconForPath(item, (Integer)16);
    }

    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached;
        if (null == item) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("objectValueForItem:" + item.getAbsolute()));
        }
        if (null == (cached = this.tableViewCache.get(item, identifier))) {
            if (identifier.equals(ICON_COLUMN)) {
                return this.tableViewCache.put(item, identifier, this.iconForPath(item));
            }
            if (identifier.equals(FILENAME_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.getDisplayName(), TableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(SIZE_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)item.attributes().getSize()), TableCellAttributes.browserFontRightAlignment()));
            }
            if (identifier.equals(MODIFIED_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(DateFormatterFactory.instance().getShortFormat(item.attributes().getModificationDate()), TableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(OWNER_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.attributes().getOwner(), TableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(GROUP_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.attributes().getGroup(), TableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(PERMISSIONS_COLUMN)) {
                Permission permission = item.attributes().getPermission();
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(permission.toString(), TableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(KIND_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.kind(), TableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(EXTENSION_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(item.attributes().isFile() ? (StringUtils.isNotBlank((String)item.getExtension()) ? item.getExtension() : Locale.localizedString((String)"None")) : Locale.localizedString((String)"None"), TableCellAttributes.browserFontLeftAlignment()));
            }
            if (identifier.equals(LOCAL_COLUMN)) {
                return this.tableViewCache.put(item, identifier, NSString.stringWithString(item.getLocal().getAbsolute()));
            }
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return cached;
    }

    @Override
    public boolean ignoreModifierKeysWhileDragging() {
        return false;
    }

    @Override
    public NSUInteger draggingSourceOperationMaskForLocal(boolean local) {
        log.debug((Object)("draggingSourceOperationMaskForLocal:" + local));
        if (local) {
            return new NSUInteger(NSDraggingInfo.NSDragOperationMove.intValue() | NSDraggingInfo.NSDragOperationCopy.intValue());
        }
        return new NSUInteger(NSDraggingInfo.NSDragOperationCopy.intValue() | NSDraggingInfo.NSDragOperationDelete.intValue());
    }

    public boolean acceptDrop(NSTableView view, Path destination, NSDraggingInfo info) {
        NSArray elements;
        NSObject o;
        log.debug((Object)("acceptDrop:" + destination));
        if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null && (o = info.draggingPasteboard().propertyListForType("Apple URL pasteboard type")) != null) {
            elements = Rococoa.cast(o, NSArray.class);
            for (int i = 0; i < elements.count().intValue(); ++i) {
                if (!ProtocolFactory.isURL((String)elements.objectAtIndex(new NSUInteger(i)).toString())) continue;
                this.controller.mount(Host.parse((String)elements.objectAtIndex(new NSUInteger(i)).toString()));
                return true;
            }
        }
        if (this.controller.isMounted()) {
            if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null) {
                o = info.draggingPasteboard().propertyListForType("NSFilenamesPboardType");
                if (o != null) {
                    elements = Rococoa.cast(o, NSArray.class);
                    Session session = this.controller.getTransferSession();
                    Collection roots = new Collection();
                    for (int i = 0; i < elements.count().intValue(); ++i) {
                        Path p = PathFactory.createPath((Session)session, (String)destination.getAbsolute(), (Local)LocalFactory.createLocal((String)elements.objectAtIndex(new NSUInteger(i)).toString()));
                        roots.add(p);
                    }
                    UploadTransfer q = new UploadTransfer((List)roots);
                    if (q.numberOfRoots() > 0) {
                        this.controller.transfer((Transfer)q, destination);
                    }
                    return true;
                }
                return false;
            }
            List pasteboards = PathPasteboard.allPasteboards();
            for (PathPasteboard pasteboard : pasteboards) {
                HashMap<Path, Path> files;
                boolean duplicate;
                if (pasteboard.isEmpty()) continue;
                boolean bl = duplicate = info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue();
                if (!pasteboard.getSession().equals((Object)this.controller.getSession())) {
                    duplicate = true;
                }
                if (duplicate) {
                    files = new HashMap<Path, Path>();
                    for (Path next : pasteboard) {
                        Path copy = PathFactory.createPath((Session)this.controller.getSession(), (String)destination.getAbsolute(), (String)next.getName(), (int)next.attributes().getType());
                        files.put(next, copy);
                    }
                    this.controller.duplicatePaths(files, false);
                } else {
                    files = new HashMap();
                    for (Path next : pasteboard.copy(this.controller.getSession())) {
                        Path renamed = PathFactory.createPath((Session)this.controller.getSession(), (String)destination.getAbsolute(), (String)next.getName(), (int)next.attributes().getType());
                        files.put(next, renamed);
                    }
                    this.controller.renamePaths(files);
                }
                pasteboard.clear();
            }
            return true;
        }
        return false;
    }

    public NSUInteger validateDrop(NSTableView view, Path destination, NSInteger row, NSDraggingInfo info) {
        if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("Apple URL pasteboard type")) != null) {
            NSObject o = info.draggingPasteboard().propertyListForType("Apple URL pasteboard type");
            if (o != null) {
                NSArray elements = Rococoa.cast(o, NSArray.class);
                for (int i = 0; i < elements.count().intValue(); ++i) {
                    if (ProtocolFactory.isURL((String)elements.objectAtIndex(new NSUInteger(i)).toString())) {
                        view.setDropRow(new NSInteger(-1L), NSTableView.NSTableViewDropOn);
                        return NSDraggingInfo.NSDragOperationCopy;
                    }
                    log.warn((Object)("Protocol not supported for URL:" + elements.objectAtIndex(new NSUInteger(i)).toString()));
                }
            }
            log.warn((Object)"URL dragging pasteboard is empty.");
        }
        if (this.controller.isMounted()) {
            if (null == destination) {
                log.warn((Object)"Dragging destination is null.");
                return NSDraggingInfo.NSDragOperationNone;
            }
            if (!this.controller.getSession().isCreateFileSupported(destination)) {
                return NSDraggingInfo.NSDragOperationNone;
            }
            if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject("NSFilenamesPboardType")) != null) {
                this.setDropRowAndDropOperation(view, destination, row);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            for (Path next : PathPasteboard.getPasteboard((Session)this.controller.getSession())) {
                if (destination.equals((Object)next)) {
                    return NSDraggingInfo.NSDragOperationNone;
                }
                if (next.attributes().isDirectory() && destination.isChild((AbstractPath)next)) {
                    return NSDraggingInfo.NSDragOperationNone;
                }
                if (!next.attributes().isFile() || !next.getParent().equals((Object)destination)) continue;
                return NSDraggingInfo.NSDragOperationNone;
            }
            log.debug((Object)("Operation Mask:" + info.draggingSourceOperationMask().intValue()));
            this.setDropRowAndDropOperation(view, destination, row);
            List pasteboards = PathPasteboard.allPasteboards();
            for (PathPasteboard pasteboard : pasteboards) {
                if (pasteboard.isEmpty()) continue;
                if (pasteboard.getSession().equals((Object)this.controller.getSession())) {
                    if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                        return NSDraggingInfo.NSDragOperationCopy;
                    }
                    return NSDraggingInfo.NSDragOperationMove;
                }
                return NSDraggingInfo.NSDragOperationCopy;
            }
        }
        return NSDraggingInfo.NSDragOperationNone;
    }

    private void setDropRowAndDropOperation(NSTableView view, Path destination, NSInteger row) {
        if (destination.equals((Object)this.controller.workdir())) {
            log.debug((Object)"setDropRowAndDropOperation:-1");
            view.setDropRow(new NSInteger(-1L), NSTableView.NSTableViewDropOn);
        } else if (destination.attributes().isDirectory()) {
            log.debug((Object)("setDropRowAndDropOperation:" + row.intValue()));
            view.setDropRow(row, NSTableView.NSTableViewDropOn);
        }
    }

    public boolean writeItemsToPasteBoard(NSTableView view, NSArray items, NSPasteboard pboard) {
        log.debug((Object)"writeItemsToPasteBoard");
        if (this.controller.isMounted() && items.count().intValue() > 0) {
            NSMutableArray fileTypes = NSMutableArray.array();
            PathPasteboard pasteboard = PathPasteboard.getPasteboard((Session)this.controller.getSession());
            for (int i = 0; i < items.count().intValue(); ++i) {
                Path path = this.controller.lookup(new OutlinePathReference(items.objectAtIndex(new NSUInteger(i))));
                if (null == path) continue;
                if (path.attributes().isFile()) {
                    if (StringUtils.isNotEmpty((String)path.getExtension())) {
                        fileTypes.addObject(NSString.stringWithString(path.getExtension()));
                    } else {
                        fileTypes.addObject(NSString.stringWithString("NSFileTypeRegular"));
                    }
                } else if (path.attributes().isDirectory()) {
                    fileTypes.addObject(NSString.stringWithString("'fldr'"));
                } else {
                    fileTypes.addObject(NSString.stringWithString("NSFileTypeUnknown"));
                }
                pasteboard.add((Object)path);
            }
            NSEvent event = NSApplication.sharedApplication().currentEvent();
            if (event != null) {
                NSPoint dragPosition = view.convertPoint_fromView(event.locationInWindow(), null);
                NSRect imageRect = new NSRect(new NSPoint(dragPosition.x.doubleValue() - 16.0, dragPosition.y.doubleValue() - 16.0), new NSSize(32.0, 32.0));
                view.dragPromisedFilesOfTypes(fileTypes, imageRect, this.id(), true, event);
                return true;
            }
        }
        return false;
    }

    @Override
    public void draggedImage_beganAt(NSImage image, NSPoint point) {
        log.trace((Object)("draggedImage_beganAt:" + (Object)((Object)point)));
    }

    @Override
    public void draggedImage_endedAt_operation(NSImage image, NSPoint point, NSUInteger operation) {
        log.trace((Object)("draggedImage_endedAt_operation:" + (Object)((Object)operation)));
        PathPasteboard pasteboard = PathPasteboard.getPasteboard((Session)this.controller.getSession());
        if (NSDraggingInfo.NSDragOperationDelete.intValue() == operation.intValue()) {
            this.controller.deletePaths((List<Path>)pasteboard);
        }
        pasteboard.clear();
    }

    @Override
    public void draggedImage_movedTo(NSImage image, NSPoint point) {
        log.trace((Object)("draggedImage_movedTo:" + (Object)((Object)point)));
    }

    @Override
    public NSArray namesOfPromisedFilesDroppedAtDestination(NSURL url) {
        log.debug((Object)("namesOfPromisedFilesDroppedAtDestination:" + url));
        NSMutableArray promisedDragNames = NSMutableArray.array();
        if (null != url) {
            Local destination = LocalFactory.createLocal((String)url.path());
            PathPasteboard pasteboard = PathPasteboard.getPasteboard((Session)this.controller.getSession());
            for (Path p : pasteboard) {
                p.setLocal(LocalFactory.createLocal((Local)destination, (String)p.getName()));
                promisedDragNames.addObject(NSString.stringWithString(p.getLocal().getName()));
            }
            if (pasteboard.size() == 1) {
                if (((Path)pasteboard.get(0)).attributes().isFile()) {
                    ((Path)pasteboard.get(0)).getLocal().touch();
                }
                if (((Path)pasteboard.get(0)).attributes().isDirectory()) {
                    ((Path)pasteboard.get(0)).getLocal().mkdir();
                }
            }
            final boolean dock = destination.equals((Object)LocalFactory.createLocal((String)"~/Library/Caches/TemporaryItems"));
            DownloadTransfer transfer = new DownloadTransfer(pasteboard.copy(this.controller.getTransferSession())){

                protected void fireDidTransferPath(Path path) {
                    if (dock) {
                        WatchEditor editor = new WatchEditor(BrowserTableDataSource.this.controller, path);
                        editor.watch();
                    }
                    super.fireDidTransferPath(path);
                }
            };
            if (dock) {
                this.controller.transfer((Transfer)transfer, new TransferPrompt(){

                    public TransferAction prompt() {
                        return TransferAction.ACTION_OVERWRITE;
                    }
                });
            } else {
                this.controller.transfer((Transfer)transfer);
            }
            pasteboard.clear();
        }
        return promisedDragNames;
    }
}

