/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.BundleController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.SheetController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSLayoutManager;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSRange;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class CommandController
extends SheetController
implements TranscriptListener,
NSLayoutManager.Delegate {
    private static Logger log = Logger.getLogger(CommandController.class);
    private NSTextField inputField;
    private NSTextView responseField;
    private NSProgressIndicator progress;
    private NSImageView image;
    private Session session;

    public void setInputField(NSTextField inputField) {
        this.inputField = inputField;
    }

    public void setResponseField(NSTextView responseField) {
        this.responseField = responseField;
        this.responseField.setEditable(false);
        this.responseField.setSelectable(true);
        this.responseField.setUsesFontPanel(false);
        this.responseField.setRichText(false);
        this.responseField.layoutManager().setDelegate(this.id());
    }

    public void setProgress(NSProgressIndicator progress) {
        this.progress = progress;
        this.progress.setDisplayedWhenStopped(false);
    }

    public void setImage(NSImageView image) {
        this.image = image;
        this.image.setImage(IconCache.instance().iconForApplication("com.apple.Terminal", 128));
    }

    public void layoutManager_didCompleteLayoutForTextContainer_atEnd(NSLayoutManager layoutManager, NSObject textContainer, boolean finished) {
        if (finished && this.responseField.window().isVisible()) {
            this.responseField.scrollRangeToVisible(NSRange.NSMakeRange(this.responseField.textStorage().length(), new NSUInteger(0L)));
        }
    }

    public CommandController(WindowController parent, Session session) {
        super(parent);
        this.session = session;
        this.session.addTranscriptListener((TranscriptListener)this);
    }

    protected String getBundleName() {
        return "Command";
    }

    public void sendButtonClicked(final NSButton sender) {
        final String command = this.inputField.stringValue();
        if (StringUtils.isNotBlank((String)command)) {
            this.progress.startAnimation(null);
            sender.setEnabled(false);
            this.parent.background((BackgroundAction)new BrowserBackgroundAction((BrowserController)this.parent){
                boolean close;

                public void run() {
                    try {
                        CommandController.this.session.sendCommand(command);
                    }
                    catch (FTPException e) {
                    }
                    catch (IOException e) {
                        log.warn((Object)e.getMessage());
                    }
                }

                public void cleanup() {
                    CommandController.this.progress.stopAnimation(null);
                    sender.setEnabled(true);
                    if (this.close) {
                        CommandController.this.closeSheet(sender);
                    }
                }

                public String getActivity() {
                    return command;
                }
            });
        }
    }

    public void log(boolean request, final String message) {
        this.invoke((MainAction)new WindowMainAction(this){

            public void run() {
                CommandController.this.responseField.textStorage().replaceCharactersInRange_withAttributedString(NSRange.NSMakeRange(CommandController.this.responseField.textStorage().length(), new NSUInteger(0L)), NSAttributedString.attributedStringWithAttributes(message + "\n", BundleController.FIXED_WITH_FONT_ATTRIBUTES));
            }
        });
    }

    protected boolean validateInput() {
        return true;
    }

    public void callback(int returncode) {
    }

    protected void invalidate() {
        this.session.removeTranscriptListener((TranscriptListener)this);
        this.responseField.layoutManager().setDelegate(null);
        super.invalidate();
    }
}

